package info.gongqi.got.tool;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

import info.gongqi.got.util.FromToMapping;
import info.gongqi.got.util.GOTMessageDialog;

public class FileTypeSelect extends Dialog {

	protected String result = "";
	protected Shell shell;
	private String checks;
	
	private Button FILE_TYPE_JPG,FILE_TYPE_PNG,FILE_TYPE_GIF,FILE_TYPE_DOC,FILE_TYPE_XLS,FILE_TYPE_XLSX,FILE_TYPE_PPT,FILE_TYPE_MPP,
	FILE_TYPE_PDF,FILE_TYPE_ZIP,FILE_TYPE_XML,FILE_TYPE_TXT,FILE_TYPE_MP3,FILE_TYPE_MP4,FILE_TYPE_CSV,FILE_TYPE_DWG,FILE_TYPE_VISIO;
	
	private List<Button> buttons = new ArrayList<Button>();
	private Button button_All;
	/**
	 * Create the dialog.
	 * @param parent
	 * @param style
	 */
	public FileTypeSelect(Shell parent, int style, String checkedStr) {
		super(parent, style);
		setText("文件类型");
		checks = checkedStr;
	}

	/**
	 * Open the dialog.
	 * @return the result
	 */
	public String open() {
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return result;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shell = new Shell(getParent(), getStyle());
		shell.setSize(354, 224);
		shell.setText("文件类型");
		
        Monitor monitor = shell.getMonitor();  
        Rectangle bounds = monitor.getBounds ();
        Rectangle rect = shell.getBounds ();
        int x = bounds.x + (bounds.width - rect.width) / 2;  
        int y = bounds.y + (bounds.height - rect.height) / 2;
        shell.setLocation (x, y);
        
    	GOTMessageDialog.shells.add(shell);
    	
    	FILE_TYPE_JPG = new Button(shell, SWT.CHECK);
    	FILE_TYPE_JPG.setBounds(10, 10, 98, 17);
    	FILE_TYPE_JPG.setText("FILE_TYPE_JPG");
    	buttons.add(FILE_TYPE_JPG);
    	
    	FILE_TYPE_DOC = new Button(shell, SWT.CHECK);
    	FILE_TYPE_DOC.setText("FILE_TYPE_DOC");
    	FILE_TYPE_DOC.setBounds(10, 33, 107, 17);
    	buttons.add(FILE_TYPE_DOC);
    	
    	FILE_TYPE_PPT = new Button(shell, SWT.CHECK);
    	FILE_TYPE_PPT.setText("FILE_TYPE_PPT");
    	FILE_TYPE_PPT.setBounds(10, 56, 98, 17);
    	buttons.add(FILE_TYPE_PPT);
    	
    	FILE_TYPE_ZIP = new Button(shell, SWT.CHECK);
    	FILE_TYPE_ZIP.setText("FILE_TYPE_ZIP");
    	FILE_TYPE_ZIP.setBounds(10, 79, 98, 17);
    	buttons.add(FILE_TYPE_ZIP);
    	
    	FILE_TYPE_MP3 = new Button(shell, SWT.CHECK);
    	FILE_TYPE_MP3.setText("FILE_TYPE_MP3");
    	FILE_TYPE_MP3.setBounds(10, 102, 107, 17);
    	buttons.add(FILE_TYPE_MP3);
    	
    	FILE_TYPE_DWG = new Button(shell, SWT.CHECK);
    	FILE_TYPE_DWG.setText("FILE_TYPE_DWG");
    	FILE_TYPE_DWG.setBounds(10, 123, 98, 17);
    	buttons.add(FILE_TYPE_DWG);
    	
    	FILE_TYPE_PNG = new Button(shell, SWT.CHECK);
    	FILE_TYPE_PNG.setText("FILE_TYPE_PNG");
    	FILE_TYPE_PNG.setBounds(123, 10, 107, 17);
    	buttons.add(FILE_TYPE_PNG);
    	
    	FILE_TYPE_XLS = new Button(shell, SWT.CHECK);
    	FILE_TYPE_XLS.setText("FILE_TYPE_XLS");
    	FILE_TYPE_XLS.setBounds(123, 33, 98, 17);
    	buttons.add(FILE_TYPE_XLS);
    	
    	FILE_TYPE_MPP = new Button(shell, SWT.CHECK);
    	FILE_TYPE_MPP.setText("FILE_TYPE_MPP");
    	FILE_TYPE_MPP.setBounds(123, 56, 107, 17);
    	buttons.add(FILE_TYPE_MPP);
    	
    	FILE_TYPE_XML = new Button(shell, SWT.CHECK);
    	FILE_TYPE_XML.setText("FILE_TYPE_XML");
    	FILE_TYPE_XML.setBounds(123, 79, 98, 17);
    	buttons.add(FILE_TYPE_XML);
    	
    	FILE_TYPE_MP4 = new Button(shell, SWT.CHECK);
    	FILE_TYPE_MP4.setText("FILE_TYPE_MP4");
    	FILE_TYPE_MP4.setBounds(123, 102, 107, 17);
    	buttons.add(FILE_TYPE_MP4);
    	
    	FILE_TYPE_VISIO = new Button(shell, SWT.CHECK);
    	FILE_TYPE_VISIO.setText("FILE_TYPE_VISIO");
    	FILE_TYPE_VISIO.setBounds(123, 123, 113, 17);
    	buttons.add(FILE_TYPE_VISIO);
    	
    	FILE_TYPE_GIF = new Button(shell, SWT.CHECK);
    	FILE_TYPE_GIF.setText("FILE_TYPE_GIF");
    	FILE_TYPE_GIF.setBounds(236, 10, 98, 17);
    	buttons.add(FILE_TYPE_GIF);
    	
    	FILE_TYPE_XLSX = new Button(shell, SWT.CHECK);
    	FILE_TYPE_XLSX.setText("FILE_TYPE_XLSX");
    	FILE_TYPE_XLSX.setBounds(236, 33, 98, 17);
    	buttons.add(FILE_TYPE_XLSX);
    	
    	FILE_TYPE_PDF = new Button(shell, SWT.CHECK);
    	FILE_TYPE_PDF.setText("FILE_TYPE_PDF");
    	FILE_TYPE_PDF.setBounds(236, 56, 102, 17);
    	buttons.add(FILE_TYPE_PDF);
    	
    	FILE_TYPE_TXT = new Button(shell, SWT.CHECK);
    	FILE_TYPE_TXT.setText("FILE_TYPE_TXT");
    	FILE_TYPE_TXT.setBounds(236, 79, 98, 17);
    	buttons.add(FILE_TYPE_TXT);
    	
    	FILE_TYPE_CSV = new Button(shell, SWT.CHECK);
    	FILE_TYPE_CSV.setText("FILE_TYPE_CSV");
    	FILE_TYPE_CSV.setBounds(236, 102, 102, 17);
    	buttons.add(FILE_TYPE_CSV);
    	
    	Button Confirm = new Button(shell, SWT.NONE);
    	Confirm.addSelectionListener(new SelectionAdapter() {
    		@Override
    		public void widgetSelected(SelectionEvent e) {
    			if(button_All.getSelection()){
    				result = "*";
    			}else{
        			for (Button button : buttons) {
    					if(button.getSelection()){
    						String val = FromToMapping.AttachmentFileTypeMap.get(button.getText());
    						result += result.equals("") ? val : "," + val;
    					}
    				}
    			}
    			shell.close();
    		}
    	});
    	Confirm.setBounds(28, 158, 80, 27);
    	Confirm.setText("确定");
    	
    	Button cancel = new Button(shell, SWT.NONE);
    	cancel.addSelectionListener(new SelectionAdapter() {
    		@Override
    		public void widgetSelected(SelectionEvent e) {
    			shell.close();
    		}
    	});
    	cancel.setText("取消");
    	cancel.setBounds(219, 158, 80, 27);
    	
    	button_All = new Button(shell, SWT.CHECK);
    	button_All.addSelectionListener(new SelectionAdapter() {
    		@Override
    		public void widgetSelected(SelectionEvent e) {
    			if(button_All.getSelection()){
        			for (Button button : buttons) {
        				button.setSelection(false);
        				button.setEnabled(false);
    				}
    			}else{
        			for (Button button : buttons) {
        				button.setEnabled(true);
    				}
    			}

    			
    		}
    	});
    	button_All.setText("*");
    	button_All.setBounds(236, 123, 86, 17);
    	setChecked();
	}
	
	private void setChecked(){
		if(checks != null){
			String[] str = checks.split(",");
			for (String value : str) {
				doChecked(value);
			}
		}
	}
	
	private void doChecked(String value){
		switch (value) {
		case "image/jpeg":
			FILE_TYPE_JPG.setSelection(true);
			break;
		case "image/jp2":
			FILE_TYPE_JPG.setSelection(true);
			break;
		case "image/png":
			FILE_TYPE_PNG.setSelection(true);
			break;
		case "image/gif":
			FILE_TYPE_GIF.setSelection(true);
			break;
		case "application/msword":
			FILE_TYPE_DOC.setSelection(true);
			break;
		case "application/vnd.ms-excel":
			FILE_TYPE_XLS.setSelection(true);
			break;
		case "application/vnd.ms-excels"://TODO
			FILE_TYPE_XLSX.setSelection(true);
			break;
		case "application/vnd.ms-powerpoint":
			FILE_TYPE_PPT.setSelection(true);
			break;
		case "application/vnd.ms-project":
			FILE_TYPE_MPP.setSelection(true);
			break;
		case "application/pdf":
			FILE_TYPE_PDF.setSelection(true);
			break;
		case "aplication/zip":
			FILE_TYPE_ZIP.setSelection(true);
			break;
		case "text/xml":
			FILE_TYPE_XML.setSelection(true);
			break;
		case "application/xml":
			FILE_TYPE_XML.setSelection(true);
			break;
		case "text/plain":
			FILE_TYPE_TXT.setSelection(true);
			break;
		case "audio/mpeg":
			FILE_TYPE_MP3.setSelection(true);
			break;
		case "audio/mp4":
			FILE_TYPE_MP4.setSelection(true);
			break;
		case "video/mp4":
			FILE_TYPE_MP4.setSelection(true);
			break;
		case "text/csv":
			FILE_TYPE_CSV.setSelection(true);
			break;
		case "image/vnd.dwg":
			FILE_TYPE_DWG.setSelection(true);
			break;
		case "application/vnd.visio":
			FILE_TYPE_VISIO.setSelection(true);
			break;
		case "*":
			button_All.setSelection(true);
			break;
		default:
			break;
		}
		
	}
}
