package info.gongqi.got.tool;

import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.ui.TreeUi;
import info.gongqi.got.util.GOTMessageDialog;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.swt.SWTResourceManager;

import client.gongqi.designer.got.node.NodeGOT;

public class EnterNodeResetFormDataSource extends Dialog {

	protected Object result;
	protected Shell shell;

	private List<Element> xml;
	private Tree tree;
	private Label info;
	private Element dataSource;
	
	/**
	 * Create the dialog.
	 * 
	 * @param parent
	 * @param style
	 */
	public EnterNodeResetFormDataSource(Shell parent, int style, List<Element> elements, Element element) {
		super(parent, style);
		setText("ref");
		this.xml = elements;
		this.dataSource = element;
	}

	/**
	 * Open the dialog.
	 * 
	 * @return the result
	 */
	public Object open() {
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return result;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shell = new Shell(getParent(), getStyle());
		shell.setSize(850, 500);
		shell.setText("重置关联节点名称");
		shell.setImage(SWTResourceManager.getImage(EnterNodeResetFormDataSource.class, "/resources/nodeicons/EnumItem.png"));
		
		Monitor monitor = shell.getMonitor();
		Rectangle bounds = monitor.getBounds();
		Rectangle rect = shell.getBounds();
		int x = bounds.x + (bounds.width - rect.width) / 2;
		int y = bounds.y + (bounds.height - rect.height) / 2;
		shell.setLocation(x, y);
		shell.setLayout(new FormLayout());
		tree = new Tree(shell, SWT.V_SCROLL | SWT.WRAP | SWT.BORDER | SWT.CLOSE | SWT.CHECK | SWT.MULTI);
		TreeColumn name1 = new TreeColumn(tree, SWT.CENTER);
		name1.setWidth(500);
		name1.setText("【类型】名称");
		
		TreeColumn name2 = new TreeColumn(tree, SWT.CENTER);
		name2.setWidth(200);
		name2.setText("父节点【类型】名称");
		
		TreeColumn name3 = new TreeColumn(tree, SWT.CENTER);
		name3.setWidth(80);
		name3.setText("比对结果");
		tree.setHeaderVisible(true);
		Display.getDefault().syncExec(new Runnable() {
			@Override
			public void run() {
				buildTree(xml, tree, null);
			}
		});
		
        FormData fd_table = new FormData();
        fd_table.top = new FormAttachment(0, 0);
        fd_table.bottom = new FormAttachment(100, -27);
        fd_table.left = new FormAttachment(0, 0);
        fd_table.right = new FormAttachment(100, 0);
        tree.setLayoutData(fd_table);
		
        Button button = new Button(shell, SWT.FLAT);
        button.setText("  确定  ");
        FormData fd_button = new FormData();
        fd_button.top = new FormAttachment(tree, 2);
        fd_button.bottom = new FormAttachment(100,-2);
        fd_button.right = new FormAttachment(100, -2);
        button.setLayoutData(fd_button);
        button.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				int all = doBus();
				if(all > 0){
					GOTMessageDialog.info("修改成功" + all + "条");
					shell.close();
				}else{
					GOTMessageDialog.info("没有需要修改的FormItem");
				}
			}
        	
		});
        
        Button button_calcel = new Button(shell, SWT.FLAT);
        button_calcel.setText("  取消 ");
        fd_button = new FormData();
        fd_button.top = new FormAttachment(tree, 2);
        fd_button.bottom = new FormAttachment(100,-2);
        fd_button.left = new FormAttachment(0, 2);
        button_calcel.setLayoutData(fd_button);
        button_calcel.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				shell.close();
			}
        	
		});
        
        info = new Label(shell, SWT.NONE);
        FormData fd_info = new FormData();
        fd_info.top = new FormAttachment(tree, 2);
        fd_info.bottom = new FormAttachment(100,-2);
        fd_info.left = new FormAttachment(0, 2);
        fd_info.right = new FormAttachment(90, 0);
        info.setLayoutData(fd_info);
        
        tree.addListener(SWT.CHECK, new Listener() {
            public void handleEvent(Event event) {
            	Point point = new Point(event.x, event.y);
            	TreeItem treeItem = tree.getItem(point);
            	if(treeItem == null){
            		event.doit = false;
            		return;
            	}
                boolean check = treeItem.getChecked();
                setChildChecked(check, treeItem);
            }
        });
        
		GOTMessageDialog.shells.add(shell);
	}
	
	@SuppressWarnings("unchecked")
	private void buildTree(List<Element> elements, Tree treeParent, TreeItem parentItem) {
		for (Element element : elements) {
			buildTree(element, treeParent, parentItem);
		}
	}
	
	@SuppressWarnings("unchecked")
	private void buildTree(Element elementTar, Tree treeParent, TreeItem parentItem) {
		TreeItem trtmNewTreeitem = null;
		if(parentItem != null){
			trtmNewTreeitem = new TreeItem(parentItem, SWT.NONE);
			if(parentItem.getParentItem() == null){
				parentItem.setExpanded(true);
			}
		}else{
			trtmNewTreeitem = new TreeItem(treeParent, SWT.NONE);
			trtmNewTreeitem.setExpanded(true);
		}
		String text = "[" + elementTar.attributeValue("type") + "]" + elementTar.attributeValue("name");
		trtmNewTreeitem.setData(elementTar);
		trtmNewTreeitem.setText(text);
		trtmNewTreeitem.setImage(extendsChainTreeIconFunc(elementTar));
		String label2 = checkName(elementTar) ? "一致" : "不一致";
		if(label2.equals("不一致")){
			trtmNewTreeitem.setChecked(true);
		}
		
		if(elementTar.getParent() != null){
			String text_parent = "[" + elementTar.getParent().attributeValue("type") + "]" + elementTar.getParent().attributeValue("name");
			trtmNewTreeitem.setText(1, text_parent);
		}
		
		trtmNewTreeitem.setText(2, label2);
	}

	
	private void setChildChecked(boolean check, TreeItem treeItem){
		TreeItem[] treeItems = treeItem.getItems();
		for (TreeItem treeItem2 : treeItems) {
			treeItem2.setChecked(check);
			setChildChecked(check, treeItem2);
		}
	}
	
	private Image extendsChainTreeIconFunc(Element item){
		String imgPath = "/resources/nodeicons/Default.png";
		return SWTResourceManager.getImage(EnterNodeResetFormDataSource.class, imgPath);
	}
	
	private int doBus(){
		int i = 0;
		TreeItem[] treeItems = tree.getItems();
		for (TreeItem treeItem : treeItems) {
			if(treeItem.getChecked()){
				items.add(treeItem);
			}
		}
		for (TreeItem treeItem : items) {
			if(treeItem.getText(2).equals("不一致")){
				Element element = (Element) treeItem.getData();
				String xpath = "./Properties/Property[@refentityid]";
				Element pp = (Element) element.selectSingleNode(xpath);
				String refentityid = pp.attributeValue("refentityid");
				String refinnerid = pp.attributeValue("refinnerid");
//				String table
				xpath = "//FormDataSourceFields/FormDataSourceField/Properties/Property[@refentityid='" + refentityid + "' and @refinnerid='" + refinnerid + "']" ;
				Element data_source_item = (Element) dataSource.selectSingleNode(xpath);
				if(data_source_item != null){
					String name = dataSource.attributeValue("name");
					if(element.attributeValue("type").equals("StringEditor") || element.attributeValue("type").equals("LongEditor") ||
							element.attributeValue("type").equals("DecimalEditor") || element.attributeValue("type").equals("DateEditor")
							|| element.attributeValue("type").equals("TimeEditor") || element.attributeValue("type").equals("EnumEditor")
							|| element.attributeValue("type").equals("BooleanEditor")){
						name = name + "_" + data_source_item.getParent().getParent().attributeValue("name");
					}
					TreeItem treeItem_tar = FormDataSyn.getTreeItrmByElement(element, null);
					for (TreeUi ui : FormDataSyn.treeUis) {
						String id = treeItem_tar.getData("id").toString();
						TreeItem tar = ui.itemsMap.get(id);
						if(tar != null){
							String result = "";
							if(element.getName().equals("FormItem")){
								result = element.attributeValue("type") + "::" + name;
							}else{
								result = name;
							}
							tar.setText(result);
						}
						
					}
					element.addAttribute("name", name);
				}
				GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(element));
				TreeItem entityItem = FormDataSyn.getTreeItrmByElement(NodeGOT.getEntity(element), null);
				for (TreeUi ui : FormDataSyn.treeUis) {
					String id = entityItem.getData("id").toString();
					TreeItem tar = ui.itemsMap.get(id);
					if(tar != null){
						FormDataSyn.setUnSave(tar);
					}
				}
				i ++;
			}
		}
		return i;
	}
	
	
	public List<TreeItem> items = new ArrayList<TreeItem>();
	
	private boolean checkName(Element element){
		String dataSource_name = dataSource.attributeValue("name");
		String item_name = element.attributeValue("name");
		if(!item_name.startsWith(dataSource_name)){
			return false;
		}
		String xpath = "";
		if(element.attributeValue("type").equals("StringEditor") || element.attributeValue("type").equals("LongEditor") ||
				element.attributeValue("type").equals("DecimalEditor") || element.attributeValue("type").equals("DateEditor")
				|| element.attributeValue("type").equals("TimeEditor") || element.attributeValue("type").equals("EnumEditor") 
				|| element.attributeValue("type").equals("BooleanEditor")){
			String tar_name = item_name.replace(dataSource_name + "_", "");
			if(tar_name.contains("_")){//这里维度字段要把下划线改成点
				tar_name = tar_name.replace("_", ".");
			}
			xpath = "./FormDataSourceFields/FormDataSourceField[@name='"+ tar_name +"']";
			List<?> list = dataSource.selectNodes(xpath);
			if(list.isEmpty()){
				return false;
			}
		}
		return true;
	}
}
