package info.gongqi.got.tool;

import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.ui.LoadXML;
import info.gongqi.got.ui.TreeUi;
import info.gongqi.got.util.GOTMessageDialog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.dom4j.Element;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.swt.SWTResourceManager;

public class EnterNodeReset extends Dialog {

	protected Object result;
	protected Shell shell;

	private Element xml;
	private Tree tree;
	private Label info;

	/**
	 * Create the dialog.
	 * 
	 * @param parent
	 * @param style
	 */
	public EnterNodeReset(Shell parent, int style, Element element) {
		super(parent, style);
		setText("ref");
		xml = element;
	}

	/**
	 * Open the dialog.
	 * 
	 * @return the result
	 */
	public Object open() {
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return result;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shell = new Shell(getParent(), getStyle());
		shell.setSize(500, 320);
		shell.setText("提示");
		shell.setImage(SWTResourceManager.getImage(EnterNodeReset.class, "/resources/nodeicons/EnumItem.png"));
		
		Monitor monitor = shell.getMonitor();
		Rectangle bounds = monitor.getBounds();
		Rectangle rect = shell.getBounds();
		int x = bounds.x + (bounds.width - rect.width) / 2;
		int y = bounds.y + (bounds.height - rect.height) / 2;
		shell.setLocation(x, y);
		shell.setLayout(new FormLayout());
		tree = new Tree(shell, SWT.V_SCROLL | SWT.WRAP | SWT.BORDER | SWT.CLOSE | SWT.CHECK | SWT.MULTI);
		TreeColumn name1 = new TreeColumn(tree, SWT.RIGHT);
		name1.setWidth(350);
		TreeColumn name2 = new TreeColumn(tree, SWT.RIGHT);
		name2.setWidth(100);
		
		Display.getDefault().syncExec(new Runnable() {
			@Override
			public void run() {
				if(!xml.getName().equals("tempRoot")){
					List<Element> elements = xml.elements();
					Collections.sort(elements, new Comparator<Element>() {
						@Override
						public int compare(Element o1, Element o2) {
							return o1.attributeValue("nodeType").compareToIgnoreCase(o2.attributeValue("nodeType"));
						}
					});
					xml.setContent(elements);
				}
				buildTree(xml, tree, null);
			}
		});
		
        FormData fd_table = new FormData();
        fd_table.top = new FormAttachment(0, 0);
        fd_table.bottom = new FormAttachment(100, -27);
        fd_table.left = new FormAttachment(0, 0);
        fd_table.right = new FormAttachment(100, 0);
        tree.setLayoutData(fd_table);
		
        Button button = new Button(shell, SWT.FLAT);
        button.setText("  确定  ");
        FormData fd_button = new FormData();
        fd_button.top = new FormAttachment(tree, 2);
        fd_button.bottom = new FormAttachment(100,-2);
        fd_button.right = new FormAttachment(100, -2);
        button.setLayoutData(fd_button);
        button.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				int all = doBus();
				if(all > 0){
					GOTMessageDialog.info("修改成功" + all + "条");
					shell.close();
				}else{
					GOTMessageDialog.info("没有需要修改的Form");
				}

			}
        	
		});
        
        Button button_calcel = new Button(shell, SWT.FLAT);
        button_calcel.setText("  取消 ");
        fd_button = new FormData();
        fd_button.top = new FormAttachment(tree, 2);
        fd_button.bottom = new FormAttachment(100,-2);
        fd_button.left = new FormAttachment(0, 2);
//        fd_button.right = new FormAttachment(10, 0);
        button_calcel.setLayoutData(fd_button);
        button_calcel.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				shell.close();
			}
        	
		});
        
        info = new Label(shell, SWT.NONE);
        FormData fd_info = new FormData();
        fd_info.top = new FormAttachment(tree, 2);
        fd_info.bottom = new FormAttachment(100,-2);
        fd_info.left = new FormAttachment(0, 2);
        fd_info.right = new FormAttachment(90, 0);
        info.setLayoutData(fd_info);
        
        
        tree.addListener(SWT.Selection, new Listener() {
            public void handleEvent(Event event) {
                TreeItem trtmNewTreeitem = (TreeItem) event.item;
                //此处的element不需要从map中取
                Element element = (Element) trtmNewTreeitem.getData();
                String title = getAttrChain(element, "relation");
                shell.setText(title);
               
                
            }
        });

        tree.addListener(SWT.CHECK, new Listener() {
            public void handleEvent(Event event) {
//                TreeItem trtmNewTreeitem = (TreeItem) event.item;
            	Point point = new Point(event.x, event.y);
            	TreeItem treeItem = tree.getItem(point);
            	if(treeItem == null){
            		event.doit = false;
            		return;
            	}
                //此处的element不需要从map中取
//                Element element = (Element) trtmNewTreeitem.getData();
                boolean check = treeItem.getChecked();
                setChildChecked(check, treeItem);
            }
        });
        
		GOTMessageDialog.shells.add(shell);
	}

	public String orgName = "";
	
	@SuppressWarnings("unchecked")
	private void buildTree(Element elementTar, Tree treeParent, TreeItem parentItem) {
		TreeItem trtmNewTreeitem = null;
		if(parentItem != null){
			trtmNewTreeitem = new TreeItem(parentItem, SWT.NONE);
			if(parentItem.getParentItem() == null){
				parentItem.setExpanded(true);
			}
		}else{
			trtmNewTreeitem = new TreeItem(treeParent, SWT.NONE);
			trtmNewTreeitem.setExpanded(true);
		}
		String text = "";
		text = extendsChainTreeLabelFunc(elementTar);
		trtmNewTreeitem.setData(elementTar);
		trtmNewTreeitem.setText(text);
		trtmNewTreeitem.setImage(extendsChainTreeIconFunc(elementTar));
		String label = elementTar.attributeValue("name");
		label = LoadXML.fmt(label);
		if(parentItem == null){
			orgName = label;
		}else{
			String label2 = label.equals(orgName) ? "名称一致" : "名称不一致";
			trtmNewTreeitem.setText(1, label2);
			if(!label.equals(orgName)){
				trtmNewTreeitem.setChecked(true);
			}
		}

		List<Element> elements = elementTar.elements();
		for (Element element : elements) {
			buildTree(element, null, trtmNewTreeitem);
		}
	}

	private String extendsChainTreeLabelFunc(Element item) {
		String label = item.attributeValue("name");
		label = LoadXML.fmt(label);
		
		if (item.attribute("nodeType") != null) {
			String _nodeType = item.attributeValue("nodeType");
			if (_nodeType != null)
				label = "[" + _nodeType + "]" + label;
		}
		return label;
	}
	
/*	private void setTreeItemTest1(TreeItem trtmNewTreeitem, Element element){
		if(element.attribute("nodeType") != null && "FormDataSource".equals(element.attributeValue("nodeType"))){
			String entityId = element.attributeValue("entityId");
			String innerId = element.attributeValue("innerId");
			Element datasource = GotXmlDto.getInstance().getCurrentElement(innerId, entityId);
			if(datasource != null){
				String name = datasource.attributeValue("name");
				trtmNewTreeitem.setText(1, name);
			}
		}
	}*/

	private void setChildChecked(boolean check, TreeItem treeItem){
		TreeItem[] treeItems = treeItem.getItems();
		for (TreeItem treeItem2 : treeItems) {
			treeItem2.setChecked(check);
			setChildChecked(check, treeItem2);
		}
		
		
	}
	
	@SuppressWarnings("unchecked")
	public String getAttrChain(Element node, String... args) {
		if (node == null)
			return "";
		
		String entityId = node.attributeValue("entityId");
		String innerId = node.attributeValue("innerId");
		String str = "entityId:" + entityId + ",innerId:" + innerId;
		Map<String, Integer> type = new HashMap<String, Integer>();
		typeMap(node, type);
		
		String msg = "";
		for (String key : type.keySet()) {
			msg += key + "[" + type.get(key) + "] " ;
		}
		info.setText(msg);
		return str;
	}
	
	private void typeMap(Element node, Map<String, Integer> type){
		List<Element> elements = node.elements();
		for (Element element : elements) {
			String nodeType = element.attributeValue("nodeType");
			if(type.containsKey(nodeType)){
				int num = type.get(nodeType);
				num++;
				type.put(nodeType, num);
			}else{
				type.put(nodeType, 1);
			}
			typeMap(element, type);
		}
	}
	
	private Image extendsChainTreeIconFunc(Element item){
		String nodeName = item.attributeValue("nodeType");
		String iconClassName = nodeName;
		String imgPath = "/resources/nodeicons/" + iconClassName + ".png";
		Image image = SWTResourceManager.getImage(EnterNodeReset.class, imgPath);
		if(image == null){
			imgPath = "/resources/nodeicons/Default.png";
			image = SWTResourceManager.getImage(EnterNodeReset.class, imgPath);
		}
		return image;
	}
	
	
	private int doBus(){
		int i = 0;
		TreeItem[] treeItems = tree.getItems();
		for (TreeItem treeItem : treeItems) {
			getCheckedTreeItem(treeItem);
		}
		for (TreeItem treeItem : items) {
			if(treeItem.getText(1).equals("名称不一致")){
				Element element = (Element) treeItem.getData();
				String entityId = element.attributeValue("entityId");
				String innerId = element.attributeValue("innerId");
				Element formEle = GotXmlDto.getInstance().currentEntityByTypeAndId("Forms", entityId);
				Element dataSource = (Element) formEle.selectSingleNode("//FormDataSource[@id='" + innerId + "']");
				TreeItem item = FormDataSyn.getTreeItrmByElement(dataSource, null);
				for (TreeUi ui : FormDataSyn.treeUis) {
					String id = item.getData("id").toString();
					TreeItem tar = ui.itemsMap.get(id);
					if(tar != null){
						tar.setText(orgName);
					}
				}
				dataSource.addAttribute("name", orgName);
				
				String xpath = "//FormItem/Properties/Property[@innerid='" + innerId + "']";
				List<Element> elements = formEle.selectNodes(xpath);
				for (Element itemEle : elements) {
					itemEle.element("Value").setText(orgName);
				}
				
				GotXmlDto.getInstance().updateEntityElement(formEle);
				TreeItem entityItem = FormDataSyn.getTreeItrmByElement(formEle, null);
				for (TreeUi ui : FormDataSyn.treeUis) {
					String id = entityItem.getData("id").toString();
					TreeItem tar = ui.itemsMap.get(id);
					if(tar != null){
						FormDataSyn.setUnSave(tar);
					}
				}
				i++;
			}
		}
		return i;
	}
	
	public List<TreeItem> items = new ArrayList<TreeItem>();
	
	private void getCheckedTreeItem(TreeItem treeItem){
		TreeItem[] treeItems = treeItem.getItems();
		for (TreeItem treeItem2 : treeItems) {
			if(treeItem2.getChecked()){
				items.add(treeItem2);
			}
			getCheckedTreeItem(treeItem2);
		}
	}
}
