package info.gongqi.got.tool;

import info.gongqi.got.util.GOTMessageDialog;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.alibaba.fastjson.JSONObject;

public class DisplayStyleDialog extends Dialog {

	protected String result = "";
	protected Shell shell;
	private Text text, text_class;

	private String jsonStr;
	/**
	 * Create the dialog.
	 * @param parent
	 * @param style
	 */
	public DisplayStyleDialog(Shell parent, int style, String orgText) {
		super(parent, style);
		setText("css属性");
		jsonStr = orgText;
	}

	/**
	 * Open the dialog.
	 * @return the result
	 */
	public String open() {
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return result;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shell = new Shell(getParent(), getStyle());
		shell.setSize(430, 150);
		shell.setText(getText());
		
        Monitor monitor = shell.getMonitor();  
        Rectangle bounds = monitor.getBounds ();
        Rectangle rect = shell.getBounds ();
        int x = bounds.x + (bounds.width - rect.width) / 2;  
        int y = bounds.y + (bounds.height - rect.height) / 2;  
        shell.setLocation (x, y);
        shell.setLayout(new FormLayout());
        
        JSONObject jsonObject = new JSONObject();
        if(jsonStr != null && !jsonStr.equals("") && jsonStr.startsWith("{")){
        	jsonObject = JSONObject.parseObject(jsonStr);
        }
        
		Label label_color = new Label(shell, SWT.NONE);
		FormData fd_btn = new FormData();
		fd_btn.top = new FormAttachment(0, 5);
		fd_btn.left = new FormAttachment(0, 5);
		fd_btn.right = new FormAttachment(0, 60);
		label_color.setText("颜色:");
		label_color.setLayoutData(fd_btn);
		
		text = new Text(shell, SWT.BORDER);
		fd_btn = new FormData();
		fd_btn.top = new FormAttachment(0, 3);
		fd_btn.left = new FormAttachment(label_color, 5);
		fd_btn.right = new FormAttachment(label_color, 300, SWT.RIGHT);
		text.setLayoutData(fd_btn);
		if(jsonObject.getString("color") != null){
			text.setText(jsonObject.getString("color"));
		}
		Button button_color = new Button(shell, SWT.NONE);
		button_color.setText("浏览");
		fd_btn = new FormData();
		fd_btn.top = new FormAttachment(0, 1);
		fd_btn.left = new FormAttachment(text, 5);
		button_color.setLayoutData(fd_btn);
		button_color.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				ColorDialog colorDialog = new ColorDialog(shell);
				final RGB rgb = colorDialog.open();
				if(rgb == null){
					return;
				}
				String hex = String.format("#%02X%02X%02X", rgb.red, rgb.green, rgb.blue);
				text.setText(hex);
			}
			
		});
		
		Label label_class = new Label(shell, SWT.NONE);
		fd_btn = new FormData();
		fd_btn.top = new FormAttachment(label_color, 15);
		fd_btn.left = new FormAttachment(0, 5);
		fd_btn.right = new FormAttachment(0, 60);
		label_class.setText("样式:");
		label_class.setLayoutData(fd_btn);
		
		text_class = new Text(shell, SWT.BORDER);
		fd_btn = new FormData();
		fd_btn.top = new FormAttachment(label_color, 13);
		fd_btn.left = new FormAttachment(label_class, 5);
		fd_btn.right = new FormAttachment(label_class, 300, SWT.RIGHT);
		text_class.setLayoutData(fd_btn);
		if(jsonObject.getString("class") != null){
			text_class.setText(jsonObject.getString("class"));
		}
		
		Button button_cofirm = new Button(shell, SWT.NONE);
		button_cofirm.setText("确定");
		fd_btn = new FormData();
		fd_btn.top = new FormAttachment(label_class, 10);
		fd_btn.left = new FormAttachment(40, 0);
		button_cofirm.setLayoutData(fd_btn);
		button_cofirm.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				JSONObject jsonObject = new JSONObject();
				if(StringUtils.isNotBlank(text.getText())){
					jsonObject.put("color", text.getText());
				}
				
				if(StringUtils.isNotBlank(text_class.getText())){
					jsonObject.put("class", text_class.getText());
				}
				if(!jsonObject.isEmpty()){
					result = jsonObject.toJSONString();
				}
				shell.close();
			}
		});
		
		Button button_cancel = new Button(shell, SWT.NONE);
		button_cancel.setText("取消");
		fd_btn = new FormData();
		fd_btn.top = new FormAttachment(label_class, 10);
		fd_btn.left = new FormAttachment(button_cofirm, 20);
		button_cancel.setLayoutData(fd_btn);
		button_cancel.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				shell.close();
			}
		});
		
		GOTMessageDialog.shells.add(shell);
	}
}
