package info.gongqi.got.model;

import gongqi.erp.gotmodel.core.EntityType;
import info.gongqi.got.tool.GotLayerAndUserDialog;
import info.gongqi.got.ui.ConfigComposite;
import info.gongqi.got.ui.LoadXML;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.util.GOTUtil;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.swt.widgets.TreeItem;

import client.gongqi.designer.toolsgot.GOTXMLHelper;

public class GotXmlDto {
	
	private static GotXmlDto gotXmlhelp;

	private Map<String, Map<String, String>> gotMap = new LinkedHashMap<String, Map<String,String>>();
	
	private static String gotXML= "<GOT><DataDictionary><Enums/><DataTypes/><Tables/></DataDictionary><Menus/><MenuItems/><Forms/><Reports/><Classes/></GOT>";
	
//	private TreeItem currentTreeItem;
	private Map<EntityType, Map<String, String>> enttiys;
	
	private Map<String, Map<String, String>> entityIdAndName = new HashMap<>();
	
	private GotXmlDto() {
		
	}
	
	public static GotXmlDto getInstance(){
		if(gotXmlhelp == null){
			gotXmlhelp = new GotXmlDto();
		}
		return gotXmlhelp;
	}
	
	/**
	 * 初始化
	 */
	public void init(){
		gotMap.clear();
		entityIdAndName.clear();
		enttiys = LoadXmlCore.gotServices.getGOTEnttiys();
		gotMap.put("Enums",  new LinkedHashMap<>(enttiys.get(EntityType.Enum)));
		gotMap.put("DataTypes",  new LinkedHashMap<>(enttiys.get(EntityType.DataType)));
		gotMap.put("Tables",  new LinkedHashMap<>(enttiys.get(EntityType.Table)));
		
		gotMap.put("Menus",  new LinkedHashMap<>(enttiys.get(EntityType.Menu)));
		gotMap.put("MenuItems",  new LinkedHashMap<>(enttiys.get(EntityType.MenuItem)));
		gotMap.put("Forms",  new LinkedHashMap<>(enttiys.get(EntityType.Form)));
		gotMap.put("Reports",  new LinkedHashMap<>(enttiys.get(EntityType.Report)));
		gotMap.put("Classes",  new LinkedHashMap<>(enttiys.get(EntityType.Class)));
	}
	
	/**
	 * 只添加当前层的map
	 * @param tarMaps
	 * @return
	 */
	public  Map<String, String> addMaps(Map<String, String> tarMaps, List<String> list){
		Map<String, String> map = new LinkedHashMap<>();
		for (String xml : tarMaps.keySet()) {
			Element element = GOTXMLHelper.createElementByXMLString(tarMaps.get(xml));
			if(checkElement(element, list)){
				map.put(xml, tarMaps.get(xml));
			}
		}
		return map;
	}
	
	/**
	 * 层级显示
	 * @param node
	 * @param list
	 * @return
	 */
	private boolean checkElement(Element node, List<String> list){
		String id = node.attributeValue("id");
		String modifiedLayer = node.attributeValue("modifiedLayer");
		
		if(!shouLayer(modifiedLayer, list)){
			return false;
		}
		
		if("app".equals(GotLayerAndUserDialog.layer)){
			if("ext".equals(modifiedLayer)){
				return false;
			}
			
			if(id.contains(".") && !id.startsWith(GotLayerAndUserDialog.solution)){
				return false;
			}
		}else if("ext".equals(GotLayerAndUserDialog.layer)){
			if("ext".equals(modifiedLayer) || "app".equals(modifiedLayer)){
				if(id.contains(".") && !id.startsWith(GotLayerAndUserDialog.solution)){
					return false;
				}
			}
		}
		return true;
	}
	
	/**
	 * 判断显示层级
	 * @param layer
	 * @param list
	 * @return
	 */
	private boolean shouLayer(String layer, List<String> list){
		int currentIndex = list.indexOf(GotLayerAndUserDialog.layer);
		int tarIndex = list.indexOf(layer);
		if(tarIndex <= currentIndex && currentIndex != -1){
			return true;
		}
		return false;
	}
	
	/**
	 * 获取全局XML
	 * @return
	 */
	public Element getGotXMl(){
		Document document = null;
		try {
			document = DocumentHelper.parseText(gotXML);
		} catch (DocumentException e) {
			e.printStackTrace();
			return null;
		}
		Element root = document.getRootElement();
		Element DataDictionary = root.element("DataDictionary");
		if(DataDictionary != null){
			ConfigComposite.progressBar.setShellText("正在加载Enums");
			addNode(DataDictionary.element("Enums"), gotMap.get("Enums"));
			ConfigComposite.progressBar.setShellText("正在加载DataTypes");
			addNode(DataDictionary.element("DataTypes"), gotMap.get("DataTypes"));
			ConfigComposite.progressBar.setShellText("正在加载Tables");
			addNode(DataDictionary.element("Tables"), gotMap.get("Tables"));
		}

		addNode(root.element("Menus"), gotMap.get("Menus"));

		addNode(root.element("MenuItems"), gotMap.get("MenuItems"));

		addNode(root.element("Forms"), gotMap.get("Forms"));

		addNode(root.element("Reports"), gotMap.get("Reports"));

		addNode(root.element("Classes"), gotMap.get("Classes"));
		
		return root;
	}
	
	
	public List<Element> getGotXMl(String path){
		Document document = null;
		try {
			document = DocumentHelper.parseText(gotXML);
		} catch (DocumentException e) {
			e.printStackTrace();
			return null;
		}
		
		//此处解析path，精确查找范围
/*		String attr = "";
		String attr2 = "";
		if(path.contains("[")){
			if(path.contains("and")){
				attr = path.split("and")[0];
				attr = attr.substring(path.indexOf("[") + 1);
				attr2 = path.split("and")[1];
			}else{
				attr = path.substring(path.indexOf("[") + 1, path.indexOf("]"));
			}
			
			if(StringUtils.isNotBlank(attr)){
				attr = attr.replace("@", "");
				attr = attr.replace(" ", "");
				attr = attr.replace("'", "\"");
				attr = attr.replace("[", "");
			}
			if(StringUtils.isNotBlank(attr2)){
				attr2 = attr2.replace("@", "");
				attr2 = attr2.replace(" ", "");
				attr2 = attr2.replace("'", "\"");
				attr2 = attr2.replace("]", "");
			}
		}*/

		Element root = document.getRootElement();
		if(path.contains("DataDictionary")){
			Element DataDictionary = root.element("DataDictionary");
			if(DataDictionary != null){
				if(path.contains("Enums")){
				}else if(path.contains("Enums")){
/*					if(StringUtils.isNotBlank(attr)){
						addNodeByAttr(DataDictionary.element("Enums"), gotMap.get("Enums"), attr, attr2);
					}else{
						addNode(DataDictionary.element("Enums"), gotMap.get("Enums"));
					}*/
					addNode(DataDictionary.element("Enums"), gotMap.get("Enums"));
				}else if(path.contains("DataTypes")){
/*					if(StringUtils.isNotBlank(attr)){
						addNodeByAttr(DataDictionary.element("DataTypes"), gotMap.get("DataTypes"), attr, attr2);
					}else{
						addNode(DataDictionary.element("DataTypes"), gotMap.get("DataTypes"));
					}*/
					addNode(DataDictionary.element("DataTypes"), gotMap.get("DataTypes"));
				}else if(path.contains("Tables")){
/*					if(StringUtils.isNotBlank(attr)){
						addNodeByAttr(DataDictionary.element("Tables"), gotMap.get("Tables"), attr, attr2);
					}else{
						addNode(DataDictionary.element("Tables"), gotMap.get("Tables"));
					}*/
					addNode(DataDictionary.element("Tables"), gotMap.get("Tables"));
				}
			}
		}else if(path.contains("Menus")){
/*			if(StringUtils.isNotBlank(attr)){
				addNodeByAttr(root.element("Menus"), gotMap.get("Menus"), attr, attr2);
			}else{
				addNode(root.element("Menus"), gotMap.get("Menus"));
			}*/
			addNode(root.element("Menus"), gotMap.get("Menus"));
		}else if(path.contains("MenuItems")){
/*			if(StringUtils.isNotBlank(attr)){
				addNodeByAttr(root.element("MenuItems"), gotMap.get("MenuItems"), attr, attr2);
			}else{
				addNode(root.element("MenuItems"), gotMap.get("MenuItems"));
			}*/
			addNode(root.element("MenuItems"), gotMap.get("MenuItems"));
		}else if(path.contains("Forms")){
/*			if(StringUtils.isNotBlank(attr)){
				addNodeByAttr(root.element("Forms"), gotMap.get("Forms"), attr, attr2);
			}else{
				addNode(root.element("Forms"), gotMap.get("Forms"));
			}*/
			addNode(root.element("Forms"), gotMap.get("Forms"));
		}else if(path.contains("Reports")){
/*			if(StringUtils.isNotBlank(attr)){
				addNodeByAttr(root.element("Reports"), gotMap.get("Reports"), attr, attr2);
			}else{
				addNode(root.element("Reports"), gotMap.get("Reports"));
			}*/
			addNode(root.element("Reports"), gotMap.get("Reports"));
		}else if(path.contains("Classes")){
/*			if(StringUtils.isNotBlank(attr)){
				addNodeByAttr(root.element("Classes"), gotMap.get("Classes"), attr, attr2);
			}else{
				addNode(root.element("Classes"), gotMap.get("Classes"));
			}*/
			addNode(root.element("Classes"), gotMap.get("Classes"));
		}
		
		return root.selectNodes(path);
	}
	
	
	private void addNode(Element node, Map<String, String> maps){
		Map<String, String> idAndName = new HashMap<>();
		for (String key : maps.keySet()) {
			String xml = maps.get(key);
			Document document = xml(xml);
			Element root = document.getRootElement();
			if(!LoadXML.nodeShowRule(root)){
				continue;
			}
			
			idAndName.put(root.attributeValue("id"), root.attributeValue("name"));
			node.add(root.detach());
		}
		entityIdAndName.put(node.getName(), idAndName);
		//添加子节点完成后排序
		orderByNode(node);
	}
	
	public void orderByNode(Element node){
		List<Element> elements = node.elements();
		//默认按@name字母顺序排序
		Collections.sort(elements, new Comparator<Element>() {

			@Override
			public int compare(Element o1, Element o2) {
				if (GOTUtil.button_pre) {//显示应用前缀
					return o1.attributeValue("name").compareToIgnoreCase(o2.attributeValue("name"));
				} else {
					return LoadXML.fmt(o1.attributeValue("name")).compareToIgnoreCase(LoadXML.fmt(o2.attributeValue("name")));
				}
			}
		});
		
		if ("Menus".equals(node.getName())) {
			final List<String> menuOrders = LoadXmlCore.gotServices.getMenuOrder();
			if (menuOrders.size() > 0) {				
				Collections.sort(elements, new Comparator<Element>() {
					
					@Override
					public int compare(Element o1, Element o2) {
						int o1Index = menuOrders.indexOf(o1.attributeValue("id"));
						int o2Index = menuOrders.indexOf(o2.attributeValue("id"));
						if (o1Index == -1) {
							return 1;
						} else if (o2Index == -1){
							return 1;
						} else {
							return o1Index - o2Index;
						}
					}
				});
			}
		}
		node.setContent(elements);
	}
	
/*	private void addNodeByAttr(Element node, Map<String, String> maps, String attr1, String attr2){
		if(StringUtils.isNotBlank(attr2)){
			for (String key : maps.keySet()) {
				String xml = maps.get(key);
				if(xml.contains(attr1) && xml.contains(attr2)){
					Document document = xml(xml);
					Element root = document.getRootElement();
					node.add(root.detach());
				}
			}
		}else{
			for (String key : maps.keySet()) {
				String xml = maps.get(key);
				if(xml.contains(attr1)){
					Document document = xml(xml);
					Element root = document.getRootElement();
					node.add(root.detach());
				}
			}
		}
	}*/
	
	
	private Document xml(String xml){
		Document document = null;
		try {
			document = DocumentHelper.parseText(xml);
		} catch (DocumentException e) {
			
			e.printStackTrace();
		}
		return document;
	}

	/**
	 * 恢复节点
	 * @param entityId 
	 * @param entityType 不需要s
	 */
	public void resEntity(String entityId, String entityType){
		String xml = "";
		if(entityType.equals("Enum")){
			xml = enttiys.get(EntityType.Enum).get(entityId);
			gotMap.get("Enums").put(entityId, xml);
		}else if(entityType.equals("DataType")){
			xml = enttiys.get(EntityType.DataType).get(entityId);
			gotMap.get("DataTypes").put(entityId, xml);
		}else if(entityType.equals("Table")){
			xml = enttiys.get(EntityType.Table).get(entityId);
			gotMap.get("Tables").put(entityId, xml);
		}else if(entityType.equals("Menu")){
			xml = enttiys.get(EntityType.Menu).get(entityId);
			gotMap.get("Menus").put(entityId, xml);
		}else if(entityType.equals("MenuItem")){
			xml = enttiys.get(EntityType.MenuItem).get(entityId);
			gotMap.get("MenuItems").put(entityId, xml);
		}else if(entityType.equals("Form")){
			xml = enttiys.get(EntityType.Form).get(entityId);
			gotMap.get("Forms").put(entityId, xml);
		}else if(entityType.equals("Report")){
			xml = enttiys.get(EntityType.Report).get(entityId);
			gotMap.get("Reports").put(entityId, xml);
		}else if(entityType.equals("Class")){
			xml = enttiys.get(EntityType.Class).get(entityId);
			gotMap.get("Classes").put(entityId, xml);
		}
	}
	
	/**
	 * 根据类型和id获取当前节点
	 * @param entityType 加不加s都可以
	 * @param entytyId 实体节点id
	 * @return
	 */
	public Element currentEntityByTypeAndId(String entityType, String entytyId){
		if(entityType == null || entityType.equals("")){
			return null;
		}
		if(entityType.equals("Enum") || entityType.equals("Enums")){
			String xml = gotMap.get("Enums").get(entytyId);
			if(xml == null){
				return null;
			}else{
				return GOTXMLHelper.createElementByXMLString(xml);
			}
			
		}else if(entityType.equals("DataType") || entityType.equals("DataTypes")){
			String xml = gotMap.get("DataTypes").get(entytyId);
			if(xml == null){
				return null;
			}else{
				return GOTXMLHelper.createElementByXMLString(xml);
			}
		}else if(entityType.equals("Table") || entityType.equals("Tables")){
			String xml = gotMap.get("Tables").get(entytyId);
			if(xml == null){
				return null;
			}else{
				return GOTXMLHelper.createElementByXMLString(xml);
			}
		}else if(entityType.equals("Menu") || entityType.equals("Menus")){
			String xml = gotMap.get("Menus").get(entytyId);
			if(xml == null){
				return null;
			}else{
				return GOTXMLHelper.createElementByXMLString(xml);
			}
		}else if(entityType.equals("MenuItem") || entityType.equals("MenuItems")){
			String xml = gotMap.get("MenuItems").get(entytyId);
			if(xml == null){
				return null;
			}else{
				return GOTXMLHelper.createElementByXMLString(xml);
			}
		}else if(entityType.equals("Form") || entityType.equals("Forms")){
			String xml = gotMap.get("Forms").get(entytyId);
			if(xml == null){
				return null;
			}else{
				return GOTXMLHelper.createElementByXMLString(xml);
			}
		}else if(entityType.equals("Report") || entityType.equals("Reports")){
			String xml = gotMap.get("Reports").get(entytyId);
			if(xml == null){
				return null;
			}else{
				return GOTXMLHelper.createElementByXMLString(xml);
			}
		}else if(entityType.equals("Class") || entityType.equals("Classes")){
			String xml = gotMap.get("Classes").get(entytyId);
			if(xml == null){
				return null;
			}else{
				return GOTXMLHelper.createElementByXMLString(xml);
			}
		}
		return null;
	}
	
	public String getServiceEntity(String entityType){
		return getServiceEntityElement(entityType).asXML();
	}
	
	/**
	 * 获取服务端的节点
	 * @param entityType 需要加s
	 * @return
	 */
	public Element getServiceEntityElement(String entityType){
		if(entityType.equals("Enums")){
			Element root = GOTXMLHelper.createElement("Enums");
			addNode(root, enttiys.get(EntityType.Enum));
			return root;
			
		}else if(entityType.equals("Tables")){
			Element root = GOTXMLHelper.createElement("Tables");
			addNode(root, enttiys.get(EntityType.Table));
			return root;
		}else if(entityType.equals("DataTypes")){
			Element root = GOTXMLHelper.createElement("DataTypes");
			addNode(root, enttiys.get(EntityType.DataType));
			return root;
		}else if(entityType.equals("Menus")){
			Element root = GOTXMLHelper.createElement("Menus");
			addNode(root, enttiys.get(EntityType.Menu));
			return root;
		}else if(entityType.equals("MenuItems")){
			Element root = GOTXMLHelper.createElement("MenuItems");
			addNode(root, enttiys.get(EntityType.MenuItem));
			return root;
		}else if(entityType.equals("Forms")){
			Element root = GOTXMLHelper.createElement("Forms");
			addNode(root, enttiys.get(EntityType.Form));
			return root;
		}else if(entityType.equals("Reports")){
			Element root = GOTXMLHelper.createElement("Reports");
			addNode(root, enttiys.get(EntityType.Report));
			return root;
		}else if(entityType.equals("Classes")){
			Element root = GOTXMLHelper.createElement("Classes");
			addNode(root, enttiys.get(EntityType.Class));
			return root;
		}
		return null;
	}
	
	/**
	 * 获取客户端的节点
	 * @param entityType 需要加s
	 * @return
	 */
	public Element getCurrentElements(String entityType){
		if(entityType.equals("Enums")){
			Element root = GOTXMLHelper.createElement("Enums");
			addNode(root, gotMap.get("Enums"));
			return root;
		}else if(entityType.equals("Tables")){
			Element root = GOTXMLHelper.createElement("Tables");
			addNode(root, gotMap.get("Tables"));
			return root;
		}else if(entityType.equals("DataTypes")){
			Element root = GOTXMLHelper.createElement("DataTypes");
			addNode(root, gotMap.get("DataTypes"));
			return root;
		}else if(entityType.equals("Menus")){
			Element root = GOTXMLHelper.createElement("Menus");
			addNode(root, gotMap.get("Menus"));
			return root;
		}else if(entityType.equals("MenuItems")){
			Element root = GOTXMLHelper.createElement("MenuItems");
			addNode(root, gotMap.get("MenuItems"));
			return root;
		}else if(entityType.equals("Forms")){
			Element root = GOTXMLHelper.createElement("Forms");
			addNode(root, gotMap.get("Forms"));
			return root;
		}else if(entityType.equals("Reports")){
			Element root = GOTXMLHelper.createElement("Reports");
			addNode(root, gotMap.get("Reports"));
			return root;
		}else if(entityType.equals("Classs") || entityType.equals("Classes")){
			Element root = GOTXMLHelper.createElement("Classes");
			addNode(root, gotMap.get("Classes"));
			return root;
		}
		return null;
	}
	
	/**
	 * 获取父级节点
	 * @param names 节点名称
	 * @return
	 */
/*	public Element getParentElement(String names){
		Element element = getCurrentEntytyElementPort(names);
		if(element != null){
			return element;
		}
		TreeItem pareItem = this.currentTreeItem.getParentItem();
		element = getCurrentElement(pareItem);
		return element;
	}*/
	
	
	
	/**
	 * 获取当前的s节点
	 * @param entityType 需要加s
	 * @return
	 */
	public List<Element> currentElements(String entityType){
		return getCurrentElements(entityType).elements();
	}
	
	/**
	 * 根据属性获取list
	 * @param entityType 需要加s
	 * @param attr 属性名称
	 * @param value 属性值
	 * @return
	 */
	public List<Element> currentElements(String entityType, String attr, String value){
		List<Element> elements = new ArrayList<Element>();
		if(attr.equals("name")){
			Map<String, String> map = entityIdAndName.get(entityType);
			if(map.containsValue(value)){
				for (String key : map.keySet()) {
					if(map.get(key).equals(value)){
						elements.add(currentEntityByTypeAndId(entityType, key));
						return elements;
					}
				}
			}
			
		}
		List<Element> all = getCurrentElements(entityType).elements();
		for (Element element : all) {
			if(element.attribute(attr) != null && value.equals(element.attributeValue(attr))){
				elements.add(element);
			}
		}

		return elements;
	}
	
	/**
	 * 根据实体节点id来获取element
	 * @param elementId 
	 * @param entityId
	 * @return
	 */
	public Element getCurrentElement(Object elementId, Object entityId){
		if(elementId == null || entityId == null){
			return null;
		}
		if(entityId.equals(elementId)){
			return getEntity(entityId.toString());
		}else{
			Element entityEle = getEntity(entityId.toString());
			String xpath = "//@id";
			List<Element> elements = entityEle.selectNodes(xpath);
			for (Element element : elements) {
				if(element.attributeValue("id").equals(elementId)){
					return element;
				}
			}
			return null;
		}
	}
	
	public Element getEntity(String entityId){
		for (String key : gotMap.keySet()) {
			Map<String, String> map = gotMap.get(key);
			if(map.containsKey(entityId)){
				String xml = map.get(entityId);
				return GOTXMLHelper.createElementByXMLString(xml);
			}
		}
		return null;
	}
	
	/**
	 * 根据实体节点id来获取element
	 * @return
	 */
	public Element getCurrentElement(TreeItem treeItem){
		if(treeItem == null || treeItem.isDisposed()){
			return null;
		}
		String elementId = treeItem.getData("elementId") == null ? null : treeItem.getData("elementId").toString();
		String elementEntityId = treeItem.getData("elementEntityId") == null ? null : treeItem.getData("elementEntityId").toString();
	    String elementName = treeItem.getData("elementName").toString();
	    
	    if(elementEntityId == null){
	    	return getCurrentEntytyElementPort(elementName);
	    }
	    
		if(elementEntityId.equals(elementId)){
			return getEntity(elementEntityId.toString());
		}else{
			Element entityEle = getEntity(elementEntityId.toString());
			if(entityEle == null){
				return null;
			}
			if(elementId != null){
				String xpath = "//"+elementName+"[@id='" + elementId + "']";
				List<Element> elements = entityEle.selectNodes(xpath);
				for (Element element : elements) {
					if(element.attributeValue("id").equals(elementId)){
						return element;
					}
				}
			}else{
				String xpath = "//"+elementName;
				List<Element> elements = entityEle.selectNodes(xpath);
				for (Element element : elements) {
					TreeItem parent = treeItem.getParentItem();
					Element parentParent = element.getParent();
					while (parent.getData("elementId") == null) {
						parent = parent.getParentItem();
						parentParent = parentParent.getParent();
					}
					if(parent.getData("elementId").toString().equals(parentParent.attributeValue("id"))){
						return element;
					}
				}
			}

			return null;
		}
	}
	
	/**
	 * 根据实体节点id来获取element
	 * @return
	 */
	public Element getCurrentEntityElement(TreeItem treeItem){
		if(treeItem == null ){
			return null;
		}
		String elementEntityId = treeItem.getData("elementEntityId") == null ? null : treeItem.getData("elementEntityId").toString();
	    if(elementEntityId == null){
	    	return null;
	    }
	    return getEntity(elementEntityId.toString());
	}
	
	/**
	 * 获取客户端的部分节点
	 * @param entityType 需要加s
	 * @return
	 */
	private Element getCurrentEntytyElementPort(String entityType){
		if(entityType.equals("Enums")){
			Element root = GOTXMLHelper.createElement("Enums");
			return root;
			
		}else if(entityType.equals("Tables")){
			Element root = GOTXMLHelper.createElement("Tables");
			return root;
		}else if(entityType.equals("DataTypes")){
			Element root = GOTXMLHelper.createElement("DataTypes");
			return root;
		}else if(entityType.equals("Menus")){
			Element root = GOTXMLHelper.createElement("Menus");
			return root;
		}else if(entityType.equals("MenuItems")){
			Element root = GOTXMLHelper.createElement("MenuItems");
			return root;
		}else if(entityType.equals("Forms")){
			Element root = GOTXMLHelper.createElement("Forms");
			return root;
		}else if(entityType.equals("Reports")){
			Element root = GOTXMLHelper.createElement("Reports");
			return root;
		}else if(entityType.equals("Classes")){
			Element root = GOTXMLHelper.createElement("Classes");
			return root;
		}else if(entityType.equals("GOT")){
			Element root = GOTXMLHelper.createElement("GOT");
			return root;
		}else if(entityType.equals("DataDictionary")){
			Element root = GOTXMLHelper.createElement("DataDictionary");
			return root;
		}
		return null;
	}
	
	/**
	 * 根据实体节点更新map中的xml
	 * @param element
	 */
	public void updateEntityElement(Element element){
		String entityId = element.attributeValue("id");
		if(entityId != null){
			for (String key : gotMap.keySet()) {
				Map<String, String> map = gotMap.get(key);
				if(map.containsKey(entityId)){
					map.put(entityId, element.asXML());
					gotMap.put(key, map);
					String names = element.getName();
					names = names.equals("Class") ? names + "es": names + "s";
					entityIdAndName.get(names).put(entityId, element.attributeValue("name"));
					return;
				}
			}
		}else{
			String name = element.getName();
			if(gotMap.containsKey(name)){
				updataElement(name, element);
			}else if(name.equals("DataDictionary")){
				List<Element> elements = element.elements();
				for (Element element2 : elements) {
					updataElement(name, element2);
				}
			}
		}

	}
	
	private void updataElement(String name, Element element){
		gotMap.remove(name);
		Map<String, String> map = new HashMap<>();
		List<Element> elements = element.elements();
		for (Element entity : elements) {
			String id = entity.attributeValue("id");
			map.put(id, entity.asXML());
			String names = element.getName();
			names = names.equals("Class") ? names + "es": names + "s";
			if(entityIdAndName.containsKey(names)){
				entityIdAndName.get(names).put(id, element.attributeValue("name"));
			}
		}
		gotMap.put(name, map);
	}
	/**
	 * 根据实体节点新增
	 * @param element
	 */
	public void addEntityElement(Element element){
		String entityId = element.attributeValue("id");
		String name = element.getName();
		if(name.equals("Class")){
			name += "es";
		}else{
			name += "s";
		}
		Map<String, String> temps = gotMap.get(name);
		temps.put(entityId, element.asXML());
		gotMap.put(name, temps);
		entityIdAndName.get(name).put(entityId, element.attributeValue("name"));
	}
	
	/**
	 * 根据实体节点
	 * @param element
	 */
	public void deleteEntityElement(Element element){
		String entityId = element.attributeValue("id");
		String name = element.getName();
		
		if(name.equals("Class")){
			name += "es";
		}else{
			name += "s";
		}
		
		Map<String, String> temps = gotMap.get(name);
		temps.remove(entityId, element.asXML());
		gotMap.put(name, temps);
		entityIdAndName.get(name).remove(entityId);
	}
	
	/**
	 * 设置未保存信息
	 * @return
	 */
	public String getUnsaveText(){
		String text = "";
		Map<String, Integer> valueMap = new HashMap<>();
		for (String key : gotMap.keySet()) {
			Map<String, String> map = gotMap.get(key);
			for (String entityKey : map.keySet()) {
				String xml = map.get(entityKey);
				if(xml.contains("saved=\"0\"")){
					Element element = GOTXMLHelper.createElementByXMLString(xml);
					String entityName = element.getName();
					if(valueMap.containsKey(entityName)){
						int num = valueMap.get(entityName);
						if(num > 0){
							num ++;
						}
						valueMap.put(entityName, num);
					}else{
						valueMap.put(entityName, 1);
					}
				}
			}
		}
		for (String entityName : valueMap.keySet()) {
			if(valueMap.get(entityName) > 0){
				text += entityName + "[" + valueMap.get(entityName) + "]";
			}
		}
		return text;
	}

	/**
	 * 检查唯一名称
	 * @param type 不需要加s
	 * @param enyityId 实体节点id
	 * @param name
	 * @return
	 */
	public boolean checkUniqueName(String type, String enyityId, String name){
		type = type.equals("Class") ? type + "es" : type + "s";
		Map<String, String> map = entityIdAndName.get(type);
		if(!map.containsValue(name)){
			return true;
		}else{
			for (String key : map.keySet()) {
				if(!key.equals(enyityId) && map.get(key).equals(name)){
					return false;
				}
			}
		}
		return true;
	}
	
	/**
	 * 获取名称列表
	 * @param type 不需要加s
	 * @param enyityId 实体节点id
	 * @return
	 */
	public List<String> typesNameList(String type, String enyityId){
		type = type.equals("Class") ? type + "es" : type + "s";
		List<String> names = new ArrayList<>();
		Map<String, String> map = entityIdAndName.get(type);
		for (String key : map.keySet()) {
			if(!key.equals(enyityId)){
				names.add(map.get(key));
			}
		}
		return names;
	}
	
	public String getEntityNameById(String type, String entityId){
		type = type.equals("Class") ? type + "es" : type + "s";
		Map<String, String> map = entityIdAndName.get(type);
		if(map.containsKey(entityId)){
			return map.get(entityId);
		}
		return "";
	}
}
