package got.actions;

import info.gongqi.got.util.GOTMessageDialog;

import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.keys.IBindingService;

import gongqi.gdt.designer.plugin.GOTPlugin;

//IPartListener监听器
public class PerspectiveListener implements IPerspectiveListener , IPartListener, IStartup{

	private static Logger log = Logger.getLogger(PerspectiveListener.class);
	
	private PerspectiveListener listener ;
	
	@Override
	public void earlyStartup() {
		log.debug("earlyStartup2");
		// 添加监听
		Display.getDefault().asyncExec(new Runnable() {
			
			public void run() {
				try {
					//PlatformUI.getWorkbench().showPerspective("org.eclipse.jdt.ui.JavaPerspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
					listener = new PerspectiveListener();
					IWorkbenchPage plat = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
					plat.addPartListener( listener); 
					PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener(listener);
//					Activator.bear.openConsole();
					String id = plat.getPerspective().getId();
					if(id.equals("got.actions.GOTPerspectives")){
						try {
							plat.showView("got.actions.MainViewGreatBear");
							plat.showView(IConsoleConstants.ID_CONSOLE_VIEW);
							plat.setPartState(plat.getActivePartReference(), IWorkbenchPage.STATE_RESTORED );
						} catch (PartInitException e) {
							e.printStackTrace();
						}
					}
				} catch (Exception e) {
					e.printStackTrace();
				} 
			} 
		});
	}

	@Override
	public void partActivated(IWorkbenchPart part) {
		
	}

	@Override
	public void partBroughtToTop(IWorkbenchPart part) {
		
	}

	@Override
	public void partClosed(IWorkbenchPart part) {

	}

	@Override
	public void partDeactivated(IWorkbenchPart part) {
		
	}

	@Override
	public void partOpened(IWorkbenchPart part) {
		
	}
	
	@Override
	public void perspectiveActivated(IWorkbenchPage page,
			IPerspectiveDescriptor perspective) {
		log.debug("perspectiveActivated");
		if(page == null){
			return;
		}
		String id = page.getPerspective().getId();
//		page.setPartState(page.getActivePartReference(), IWorkbenchPage.STATE_RESTORED );
		if(id.equals("got.actions.GOTPerspectives")){
			try {
				page.showView("got.actions.MainViewGreatBear");
				page.showView(IConsoleConstants.ID_CONSOLE_VIEW);
				page.setPartState(page.getActivePartReference(), IWorkbenchPage.STATE_RESTORED );
				
			} catch (PartInitException e) {
				e.printStackTrace();
			}
			((IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class)).setKeyFilterEnabled(false);
			GOTMessageDialog.showShells();
//			Thread.currentThread().setContextClassLoader(GOTServiceImpl.class.getClassLoader());
			if(System.getProperty("javax.xml.transform.TransformerFactory") == null){
				System.setProperty("javax.xml.transform.TransformerFactory", "net.sf.saxon.TransformerFactoryImpl");
			}
		}else {
//			Thread.currentThread().setContextClassLoader(DefaultClassLoader.class.getClassLoader());
			((IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class)).setKeyFilterEnabled(true);
			GOTMessageDialog.hideShells();
			if(System.getProperty("javax.xml.transform.TransformerFactory") != null && System.getProperty("javax.xml.transform.TransformerFactory").equals("net.sf.saxon.TransformerFactoryImpl")){
				System.clearProperty("javax.xml.transform.TransformerFactory");
			}
		}
	}

	@Override
	public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
		
	}

}
