package gongqi.gdt.designer.plugin;

import org.apache.log4j.Logger;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.keys.IBindingService;

import info.gongqi.got.util.GOTMessageDialog;

class PerspectiveListener implements IPerspectiveListener {

	private static Logger log = Logger.getLogger(PerspectiveListener.class);
	
	@Override
	public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
		if(page == null){
			return;
		}
		
		log.debug(this.getClass().getName() + " perspectiveActivated");
		
		if(GOTPerspective.ID.equals(page.getPerspective().getId())){
			try {
				page.showView(GOTView.ID);
				page.showView(IConsoleConstants.ID_CONSOLE_VIEW);
				page.setPartState(page.getActivePartReference(), IWorkbenchPage.STATE_RESTORED);
			} catch (PartInitException e) {
				log.warn("显示GOT视图错误", e);
			}
			
			((IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class)).setKeyFilterEnabled(false);
			
			GOTMessageDialog.showShells();
			
//			if(System.getProperty("javax.xml.transform.TransformerFactory") == null){
//				System.setProperty("javax.xml.transform.TransformerFactory", "net.sf.saxon.TransformerFactoryImpl");
//			}
		} else {
			((IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class)).setKeyFilterEnabled(true);
			
			GOTMessageDialog.hideShells();
			
//			if(System.getProperty("javax.xml.transform.TransformerFactory") != null && System.getProperty("javax.xml.transform.TransformerFactory").equals("net.sf.saxon.TransformerFactoryImpl")){
//				System.clearProperty("javax.xml.transform.TransformerFactory");
//			}
		}
	}

	@Override
	public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {

	}

}
