package gongqi.gdt.designer.plugin;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class DesignerConsoleFactory implements IConsoleFactory {

	private static final String DESIGNER_CONSOLE_NAME = "GongqiDesigner";
	
	static  MessageConsole designerConsole;
	
	static MessageConsoleStream designerConsoleStream;
	
	@Override
	public void openConsole() {
		showConsole();
		
	}

	public static void showConsole(){
		IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
		if (designerConsole == null) {
			ImageDescriptor imageDescriptor = ImageDescriptor.createFromImage(
					new Image(Display.getCurrent(), 
							DesignerConsoleFactory.class.getResourceAsStream("/icons/logo_small.png")));
			designerConsole = new MessageConsole(DESIGNER_CONSOLE_NAME, imageDescriptor);
			designerConsoleStream = designerConsole.newMessageStream();
//			designerConsoleStream.setEncoding("UTF-8");
			consoleManager.addConsoles(new IConsole[]{designerConsole});
			consoleManager.addConsoleListener(new IConsoleListener() {
				
				@Override
				public void consolesRemoved(IConsole[] consoles) {
					if (consoles == null || consoles.length == 0) {
						return;
					}
					for (IConsole console : consoles) {
						if (!DESIGNER_CONSOLE_NAME.equals(console.getName())) {
							continue;
						}
						designerConsole = null;
						designerConsoleStream = null;
					}
				}
				
				@Override
				public void consolesAdded(IConsole[] consoles) {
					
				}
			});
		}
		
		consoleManager.showConsoleView(designerConsole);
	}
	
}
