package gongqi.erp.gotmodel.clientcache;

import gongqi.designer.got.GOTManager;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.exception.ERPException;
import gongqi.erp.framework.exception.ERPExceptionType;
import gongqi.erp.gotmodel.core.GOTHelper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.dom4j.Element;

public class EnumSourceHelper {
	
	public static List<Object> getDataSourceByTableField(Element tableField)
	{
		Element sourcePro = GOTHelper.getProperty(tableField,"Source"); 
		Element extendsPro = GOTHelper.getProperty(tableField,"Extends"); 
		
		if(null == extendsPro.attribute("refentityid"))
			return getDataSourceByRegular(tableField);
		
		if("Enum".equals(sourcePro.elementText("Value")))
		{				
			return getDataSourceByEnum(extendsPro); 	
		}
		else
		{
			return getDataSourceByDataType(extendsPro);
		}
	}
	
	public static List<Object> getDataSourceByReportField(Element reportField)
	{
		Element sourcePro = GOTHelper.getProperty(reportField,"Source"); 
		Element extendsPro = GOTHelper.getProperty(reportField,"Extends"); 
		
		if(null == extendsPro.attribute("refentityid"))
			return getDataSourceByRegular(reportField);
		
		if("Enum".equals(sourcePro.elementText("Value")))
		{				
			return getDataSourceByEnum(extendsPro); 	
		}
		else
		{
			return getDataSourceByDataType(extendsPro);
		}
	}
	
	private static Element getArrayItemByName(Element dataType,String itemName)
	{
		Element list = (Element)dataType.selectSingleNode(String.format("DataTypeArray/DataTypeArrayItem[@name='%s']",itemName));
		return list;
	}
	
	public static List<Object> getDataSourceByDataSource(Element extendsPro)
	{
		if(null == extendsPro.attribute("refentityid"))
			return new ArrayList<Object>();
		String tableId = extendsPro.attributeValue("refentityid");
		String tableFieldId = extendsPro.attributeValue("refinnerid");
		Element table = getEntity("Table", tableId);
		Element tableField = (Element)table.selectSingleNode(String.format("TableFields/TableField[@id='%s']",tableFieldId));
		
		if("Component".equals(tableField.attributeValue("type")))
		{
			Element textendsPro = GOTHelper.getProperty(tableField, "Extends");
			if(null == textendsPro.attributeValue("refentityid"))
				throw new ERPException(
						ERPExceptionType.WARN, 
						"GOT错误:Component类型的TableField没有正确关联到一个对应的DataType");
			String cdataTypeId = textendsPro.attributeValue("refentityid");
			Element cdataType = getEntity("DataType", cdataTypeId)/*GOT.getDataType(cdataTypeId)*/;
			String value = extendsPro.elementText("Value");
			String arrayItemName = value.split("[.]")[1];
			Element arrayItem = getArrayItemByName(cdataType,arrayItemName);
			Element refDataTypePro = GOTHelper.getProperty(arrayItem,"RefDataType");
			
			if(null == refDataTypePro.attribute("refentityid"))
				throw new ERPException(
						ERPExceptionType.WARN, 
						"GOT错误:" + cdataType.attributeValue("name") + "." + arrayItemName + "没有关联到DataType");
			
			return getDataSourceByDataType(refDataTypePro);
		}
		else
		{
			return getDataSourceByTableField(tableField);
		}
	}
	
	
	public static List<Object> getDataSourceByEnum(Object extendsPro)
	{
		String enumId = null;
		if(extendsPro instanceof Element)
		{
			if(null == ((Element)extendsPro).attribute("refentityid"))
				return new ArrayList<Object>();
			enumId = ((Element)extendsPro).attributeValue("refentityid");
		}
		else
		{
			enumId = (String)extendsPro;
		}
		Element entityEnum = getEntity("Enum", enumId)/*GOT.getEnum(enumId)*/;
		List<Object> result = new ArrayList<Object>();
		String label = null;
		String value = null;
		@SuppressWarnings("unchecked")
		List<Element> items = entityEnum.elements("EnumItem");
		for (Element item : items) 
		{
			label = GOTHelper.getPropertyValue(item, "Label");
			value = GOTHelper.getPropertyValue(item, "Value");
			Map<String,String> mitem = new HashMap<String, String>();
			mitem.put("label", label);
			mitem.put("value",value);
			result.add(mitem);
		}
		return result ;
	}
	
	public static List<Object> getDataSourceByDataType(Object extendsPro)
	{
		String refentityid=null;
		if(extendsPro instanceof Element)
		{
			if(null == ((Element)extendsPro).attribute("refentityid"))
				return new ArrayList<Object>();
			refentityid = ((Element)extendsPro).attributeValue("refentityid");
		}
		else
		{
			refentityid = (String)extendsPro;
		}
		Element dataType = getEntity("DataType", refentityid)/*GOT.getDataType(refentityid)*/;
		Element extendsPro_dataType = GOTHelper.getProperty(dataType,"Extends"); 
		Element sourcePro = null;
		while(null != extendsPro_dataType.attribute("refentityid"))
		{
			sourcePro = GOTHelper.getProperty(dataType, "Source");
			if("Enum".equals(sourcePro.elementText("Value")))
			{
				return getDataSourceByEnum(extendsPro_dataType);
			}
			dataType = getEntity("refentityid", extendsPro_dataType.attributeValue("refentityid"))/*GOT.getDataType(extendsPro_dataType.attributeValue("refentityid"))*/;
			extendsPro_dataType = GOTHelper.getProperty(dataType,"Extends"); 
		}
		
		return getDataSourceByRegular(dataType);
	}
	
	public static List<Object> getDataSourceByRegular(Element node)
	{
		Element regularPro = GOTHelper.getProperty(node, "Regular");
		if(regularPro == null)
			return null;
		
		String regular = regularPro.elementText("Value");
		List<Object> result = new ArrayList<Object>();
		String value = null;
		String label = null;
		
		if(regular != "")
		{
			String[] array = regular.split("[|]");
			String item;
			for (int i = 0; i < array.length; i++) {
				item = array[i];
				if(item.indexOf(":")>-1)
				{
					String[] itemarray = item.split("[:]");
					value = itemarray[0];
					label = itemarray[1];
				}
				else
				{
					value = item;
					label = item;
				}
				
				Map<String,String> itemo = new HashMap<String, String>();
				itemo.put("label", label);
				itemo.put("value", value);
				
				result.add(itemo);
			}
				
		}
		
		return result;
	}
	
	
	public static Element getEntity(String entityType, String entityId){
		return ObjectContainer.getInstance(GOTManager.class).getEntity(entityId);
	}
	
}
