package client.gongqi.designer.toolsgot;

import gongqi.erp.gotmodel.clientcache.GOTFinalValueHelper;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;

import client.gongqi.designer.got.node.NodeType;

import com.alibaba.fastjson.JSONObject;

public class GOTHelper {

	public static Boolean isEnumDefault(Element item){
		if(item != null){
			String qname = item.getName();
			String type = item.attributeValue("type");
			
			if((type.equals("Enum") && qname.equals("TableField"))
				||(type.equals("EnumEditor") && qname.equals("FormItem"))
				||(type.equals("Enum") && qname.equals("ReportField")))
				return true;
		}
		return false;
	}
	
	public static List<String> getDataSourceByTableField(Element tableField){
		Element sourcePro = gongqi.designer.utils.GOTHelper.getProperty(tableField,"Source"); 
		Element extendsPro = gongqi.designer.utils.GOTHelper.getProperty(tableField,"Extends"); 
		if(extendsPro.attribute("refentityid") == null )
			return getDataSourceByRegular(tableField);
		
		if(sourcePro.elementText("Value").equals("Enum")){				
			return getDataSourceByEnum(extendsPro); 	
		}else{
			return getDataSourceByDataType(extendsPro);
		}
	}
	
	public static List<String> getDataSourceByRegular(Element node){
		Element regularPro = gongqi.designer.utils.GOTHelper.getProperty(node,"Regular");
		
		if(regularPro == null)
			return null;
		
		String regular = regularPro.elementText("Value");
		
		List<String> collection = new ArrayList<>();
		
		String value;
		
		String label;
		
		if(!regular.equals("")){
			String[] array = regular.split("|");
			for (String item : array){
				if(item.indexOf(":") > -1){
					value = item.split(":")[0];
					label = item.split(":")[1];
				}else{
					value = item;
					label = item;
				}
				JSONObject jsonObject = new JSONObject();
				jsonObject.put("label", label);
				jsonObject.put("value", value);
				collection.add(jsonObject.toJSONString());
			}
		}
		return collection;
	}
	
	@SuppressWarnings("unchecked")
	public static List<String> getDataSourceByEnum(Element extendsPro){
		if(extendsPro.attribute("refentityid") == null)
			return new ArrayList<>();
		String enumId = extendsPro.attributeValue("refentityid");
		
		Element entityEnum = getEnum(enumId);
		
		List<String> collection = new ArrayList<>();
		if(entityEnum == null)
			return new ArrayList<>();
		
		String label;
		
		String value;
		List<Element> elements = entityEnum.elements("EnumItem");
		for (Element item : elements){
			label = GOTHelp.getPPAttValue(item, "Name", "Label");
			value = GOTHelp.getPPAttValue(item, "Name", "Value");
			JSONObject jsonObject = new JSONObject();
			jsonObject.put("label", label);
			jsonObject.put("value", value);
			collection.add(jsonObject.toJSONString());
		}
		
		return collection ;
	}
	
	@SuppressWarnings("unchecked")
	public static Element getEnum(String _id){
		Element element = GotXmlDto.getInstance().currentEntityByTypeAndId("Enum", _id);
		return element;
	}
	
	public static List<String> getDataSourceByDataType(Element extendsPro){
		if(extendsPro.attribute("refentityid") == null)
			return new ArrayList<>();
		
		Element dataType = getDataType(extendsPro.attributeValue("refentityid"));
		
		extendsPro = gongqi.designer.utils.GOTHelper.getProperty(dataType,"Extends"); 
		
		List<Element> sourcePro;
		while(extendsPro.attribute("refentityid") != null ){
			sourcePro = GOTHelp.getPPAttElementList(dataType, "Name", "Source");
			if(sourcePro.size() == 0)
				throw new Error("从EnumEditor到DataType的继承链上存在非Enum类型的DataType");
			
			if(sourcePro.get(0).elementText("Value").equals("Enum")){
				return getDataSourceByEnum(extendsPro);
			}
			dataType = getDataType(extendsPro.attributeValue("refentityid"));
			
			extendsPro = gongqi.designer.utils.GOTHelper.getProperty(dataType,"Extends"); 
		}
		
		return getDataSourceByRegular(dataType);
	}
	
	@SuppressWarnings("unchecked")
	public static Element getDataType(String _id){
		Element element = GotXmlDto.getInstance().currentEntityByTypeAndId("DataType", _id);
		return element;
	}
	
	private static Boolean hasProperty(Element reportField, String property){
		List<Element> pro = GOTHelp.getDDDAttElementList(reportField, "Name", property);
		if(pro.size() > 0)
			return true;
		else
			return false;
	}
	
	private static String getPropertyValue(Element item, String property){
		return gongqi.designer.utils.GOTHelper.getPropertyValue(item,property);
	}
	
	public static Element getProperty(Element xml, String property){
		List<Element> list = GOTHelp.getPPAttElementList(xml, "Name", property);
		if(list.size() != 1)
			return null;
		return list.get(0);
	}
	
	@SuppressWarnings("unchecked")
	public static Element getTable(String _id){
		Element element = GotXmlDto.getInstance().currentEntityByTypeAndId("Table", _id);
		return element;
	}
	
	public static Element getMenuItem(String _id){
		Element element = GotXmlDto.getInstance().currentEntityByTypeAndId("MenuItem", _id);
		return element;
	}
	
	public static Element getMenu(String _id){
		Element element = GotXmlDto.getInstance().currentEntityByTypeAndId("Menu", _id);
		return element;
	}
	
	public static Element getReport(String _id){
		Element element = GotXmlDto.getInstance().currentEntityByTypeAndId("Report", _id);
		return element;
	}
	
	public static Element getForm(String _id){
		Element element = GotXmlDto.getInstance().currentEntityByTypeAndId("Form", _id);
		return element;
	}
	
	
	@SuppressWarnings("unchecked")
	public static String getReprotFinalValue(Element item, String property){
		String nodeName = item.getName();
		if(nodeName.equals("ReportField")){
			if(property.equals("Extends") || property.equals("Source"))
				return getPropertyValue(item,property);
			
			Boolean hasProperty = hasProperty(item, property);
			if(hasProperty){
				String value= getPropertyValue(item, property);
				if(!value.equals(""))
					return value;
			}
			Element entity = null;
			Element extendsPro = getProperty(item,"Extends");
			if(extendsPro.attribute("refentityid") != null){
				String refId = extendsPro.attributeValue("refentityid");
				if(refId != null && refId.indexOf(".") != -1){
					int lastIndex = refId.lastIndexOf(".");
					refId = refId.substring(lastIndex+1);
				}
				if(refId.substring(0,2).equals("20")){
					entity = getDataType(refId);
				}else{
					entity = getEnum(refId);
				} 
				
				return GOTFinalValueHelper.getFinalValue(entity,property);
			}
			
			if(property.equals("Label"))
				return item.attributeValue("name");
			
			return "";		
			
		}
		
		if(nodeName.equals("ReportQuery")){
			return getPropertyValue(item,property);
		}
		
		if(nodeName.equals("Report")){
			String label = getPropertyValue(item,property);
			if(label.equals("") && property.equals("Label"))
				return item.attributeValue("name");
			return label;
		}
		Element table = null;
		if(nodeName.equals("Query") && property.equals("Title")){
			String value = getPropertyValue(item,property);
			if(value.equals("")){
				List<Element> queryTable = item.elements("QueryTable");
				if(queryTable.size() == 0)
					return item.attributeValue("name");
				Element extendsPro = getProperty(queryTable.get(0),"Table");
				if(extendsPro.attribute("refentityid") != null){
					table = getTable(extendsPro.attributeValue("refentityid"));
				}
				if(table != null){
					value = GOTFinalValueHelper.getFinalValue(table,"Label");
					if(value.equals("")){
						value = item.attributeValue("name");
					}
						
				}
			}
			return value;
		}
		return "";
	}
	
	public static Element getEntity(String id, String type){
		if(type == null)
			type = getEntityTypeById(id);
		
		switch(type){
			case "Enum":
				return GOTHelper.getEnum(id);
			case "DataType":
				return GOTHelper.getDataType(id);
			case "Table":
				return GOTHelper.getTable(id);
			case "MenuItem":
				return GOTHelper.getMenuItem(id);
			case "Menu":
				return GOTHelper.getMenu(id);
			case "Form":
				return GOTHelper.getForm(id);
			case "Report":
				return GOTHelper.getReport(id);
			default :
				throw new Error("非法的Entity Type");
		}
	}
	
	public static String getEntityTypeById(String entityId){
		if(entityId != null && entityId.indexOf(".") != -1){
			int lastIndex = entityId.lastIndexOf(".");
			entityId = entityId.substring(lastIndex+1);
		}
		String c = entityId.substring(0,2);
		if(c.equals("10"))
			return NodeType.ENUM;
		if(c.equals("20"))
			return NodeType.DATATYPE;
		if(c.equals("30"))
			return NodeType.TABLE;
		if(c.equals("40"))
			return NodeType.FORM;
		if(c.equals("50"))
			return NodeType.MENUITEM;
		if(c.equals("60"))
			return NodeType.MENU;
		if(c.equals("70"))
			return NodeType.MAP;
		if(c.equals("80"))
			return NodeType.QUERY;
		if(c.equals("90"))
			return NodeType.REPORT;
		return null;
	}
	
}
