package client.gongqi.designer.resolvergot;

import java.util.HashMap;
import java.util.Map;

import org.dom4j.Element;

public class ResolverNodeFactory {

	//作用类似于Map
	private static Map<String, ResolverNode> rNodeList = new HashMap<String, ResolverNode>();
	
	public ResolverNodeFactory(){
	}
	
	//根据一个XML节点创建一个解析器节点
	public static ResolverNode getRNodeByItem(Element node){
		String name = node.getName();
		String type = node.attributeValue("type") ;
		return getRNode(name, type);
	}
	
	//根据名字和类型创建一个解析器节点
	public static ResolverNode getRNode(String name, String type){
		if(rNodeList.get(name+"_"+type) == null){
			rNodeList.put(name+"_"+type, new ResolverNode(name,type));
		}
		return rNodeList.get(name+"_"+type);
	}
}
