package client.gongqi.designer.resolvergot;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;

import info.gongqi.got.util.GOTMessageDialog;

public class ResolverNode {

	
	private Element resolver;
	//解析器节点的XML
	private Element node;
	//其继承的解析器节点
	private ResolverNode extendsNode;
	//节点的Info信息
	private Element info;
	//节点的ContextMenu即右键菜单信息
	private Element cm;
	//节点的Attr属性信息
	private Element atts;
	//节点的Property属性信息
	private Element ps;
	
	@SuppressWarnings("unchecked")
	public ResolverNode(String resolverName, String type){
		this.resolver = ResolverUi.getResolver();
		if(this.resolver != null){
			Attribute attribute = this.resolver.attribute("name");
			if(resolverName.equals(attribute.getValue())){
				this.node = this.resolver;
			}else{
				//查询整个解析器XML的所有node节点 找到符合以下条件的：1.name属性==resolverName Info子节点的Type节点内容==type 其NodeType节点内容！="ref"
				List<Element> elements = new ArrayList<>();
				List<Element> list = resolver.selectNodes(".//node[@name='" + resolverName+ "']");

				for (Element element : list) {
					if(element.element("Info") != null  && !"ref".equals(element.element("Info").elementText("NodeType"))){
						String  el_type = element.element("Info").elementText("Type");
						if((StringUtils.isBlank(type) && StringUtils.isBlank(el_type)) || el_type.equals(type)){
							elements.add(element);
						}
					}
					
				}
				
				if(elements.size() > 1){
					GOTMessageDialog.alert(">0");
				}else if(elements.size() == 1){
					//把找到的这个节点 赋值给node属性变量
					this.node = elements.get(0);
				}
			}
		}

		if(this.node!=null){
			//依次赋值
			this.info = this.node.element("Info");
			this.cm = this.node.element("ContextMenu");
			this.atts = this.node.element("Attributes");
			this.ps = this.node.element("Properties");
			
			String str = this.info.elementText("Extends");
			if(str.equals("")){
				this.extendsNode = null;
			}else{
				//作为可被继承的node，必须不存在type，事实上画面上也没有地方定义
				//创建其继承的节点的解析器节点
				this.extendsNode = ResolverNodeFactory.getRNode(str, "");
			}
		}
	}
	
	public static ResolverNode getNode(Element item){
		String name = item.getName();
		String type = item.attributeValue("type") != null ? item.attributeValue("type") : "" ;
		return ResolverNodeFactory.getRNode(name,type);
	}

	public Element getNode(){
		return this.node;
	}
	
	public String getInfoValue(String name){
		if(info == null){
			return "";
		}
		String str = info.element(name) == null ? "" : info.element(name).getText();
		
		if(!name.equals("Type") && !name.equals("NodeType")){
			if(str.equals("") && this.extendsNode!=null){
				str = this.extendsNode.getInfoValue(name);
			}
		}

		return str;
	}
	
	public String getContextMenuValue(String name){
		if(cm == null){
			return "N";
		}
		String str;
		str = cm.element(name).getText();
		if(str.equals("") && this.extendsNode!=null){
			str = this.extendsNode.getContextMenuValue(name);
		}
		return str;
	}
	
	public String getAttributeValue(String name, String field){
		return this.getAttributeOrPropertyValue(name, field, "Attribute");
	}
	
	public String getPropertyValue(String name, String field){
		return this.getAttributeOrPropertyValue(name, field, "Property");
	}
	
	private String getAttributeOrPropertyValue(String name, String field, String type){
		Element _node = this.getAttributeOrProperty(name, type);
		if(_node!=null){
			//elements表示寻找第一级子节点 限定名为field
			@SuppressWarnings("unchecked")
			List<Element> list = _node.elements(field);
			if(list.size() == 1){
				//这些很细节的地方到底是返回了什么需要通过调试断点看一下 然后再翻译成对应dom4j或者别的java XML包方法
				return list.get(0).getText();
			}else{
				return null;
			}
		}else{
			return null;
		}
	}
	
	@SuppressWarnings("unchecked")
	private List<Object> getExtendsProOrAttrNode(String name, String type){
		Element _node;
		List<Element> list = new ArrayList<>();
		List<Object> array = new ArrayList<>();
		Boolean isThis = false;
		if(type.equals("Attribute")){
			//XMLList表示一个XML的集合 它涵盖了XML 即XML也是XMLList 但是XMLList不是XML dom4j中估计无此概念 
			//从解析器的整体结构看来 此处只有一个Name节点 所以它就是个XML 这种地方有很多 转换时应特别注意
			String xpath = "Attribute/Name";
			list = atts.selectNodes(xpath);
		}else if(type.equals("Property")){
			if(ps.element("Property") != null){
				String xpath = "Property/Name";
				list = ps.selectNodes(xpath);
			}
		}else{
			return null;
		}
		
		for (Element e : list) {
			if(e.getText().equals(name)){
				_node = e.getParent();
				array.add(0, _node.createCopy());
				array.add(1, this);
				isThis = true ;
				break;
			}
		}
		
		if(isThis){
			return array ;
		}else{
			if(this.extendsNode !=null){
				return this.extendsNode.getExtendsProOrAttrNode(name,type) ;
			}else{
				return null;
			}
		}
	}
	
	private Element getAttributeOrProperty(String name, String type){
		List<Object> array = this.getExtendsProOrAttrNode(name,type) ;
		
		if(array == null || array.size() == 0){
			return null;
		}
		
		Element _node = (Element) array.get(0);
		ResolverNode rNode = (ResolverNode) array.get(1);
		
		if(rNode.extendsNode != null){
			@SuppressWarnings("unchecked")
			List<Element> childList = _node.elements();
			for(Element e : childList){
				if(e.getText().equals("")){
					_node.element(e.getName()).setText(rNode.extendsNode.getExtendsNodeValue(name,e.getName(),type));
				}
			}
		}
		
		return _node;
	}
	
	@SuppressWarnings({"unchecked" })
	private String getExtendsNodeValue(String name,String childName,String type){
		Element _node = null;
		List<Element> list = new ArrayList<>();
		
		if(type.equals("Attribute")){
			if(atts.element("Attribute") != null){
				String xpath = "Attribute/Name";
				list = atts.selectNodes(xpath);
			}
		}else if(type.equals("Property")){
			if(ps.element("Property") != null){
				String xpath = "Property/Name";
				list = ps.selectNodes(xpath);
			}
			
		}else{
			return null;
		}
		
		for(Element e : list){
			if(e.getText().equals(name)){
				_node = e.getParent();
				break;
			}
		}
		
		//此处_node可能为空
		
		if(_node == null){
			if(extendsNode != null)
				return this.extendsNode.getExtendsNodeValue(name,childName,type);
			else
				return "";
		}
		
		List<Element> childList = _node.elements();
		
		for(Element e : childList){
			if(e.getName().equals(childName)){
				if(!e.getText().equals("")){
					return e.getText();
				}else{
					if(this.extendsNode != null){
						return this.extendsNode.getExtendsNodeValue(name,e.getName(),type);
					}
				}
				return "";
			}
		}
		return "" ;
	}
	
	public List<Element> getAttributes(){
		List<Element> array = new ArrayList<>(); 
		return this.getAttributesOrProperties(array, "Attribute");
	}
	
	public List<Element> getProperties(){
		List<Element> array = new ArrayList<>(); 
		return this.getAttributesOrProperties(array, "Property");
	}
	
	@SuppressWarnings("unchecked")
	private List<Element> getAttributesOrProperties(List<Element> array, String type){
		if(this.extendsNode != null){
			array = this.extendsNode.getAttributesOrProperties(array, type);	
		}
		
		List<Element> list = null;
		if(type.equals("Attribute")){
			list = this.atts.elements(type);
		}else if(type.equals("Property")){
			list = this.ps.elements(type);
		}else{
			GOTMessageDialog.alert("参数不正确");
		}
		for(Element child : list){	
			array.add(child.createCopy());
			array = this.itemFilterSame(array);
		}
		return array ;
	}
	
	private List<Element> itemFilterSame(List<Element> array){
		if(array.size() <= 1){
			return array;
		}
		
		Element newItem = (Element) array.get(array.size() - 1);
		int i = 0;
		Element arrayItem;
		
		for(i = 0 ; i < array.size()-1 ; i++){
			arrayItem = (Element) array.get(i);
			if(arrayItem.elementText("Name").equals(newItem.elementText("Name"))){
				//覆盖属性并且去除该元素
				@SuppressWarnings("unchecked")
				List<Element>  newItems = newItem.elements();
				for(Element child : newItems){
					if(!child.getText().equals("")){
						if(arrayItem.element(child.getName()) != null ){
							arrayItem.element(child.getName()).setText(child.getText());
						}else{
							arrayItem.addElement(child.getName(), child.getText());
						}
						
					}
				}
				array.remove(array.size() -1);
				break;
			}
		}
		
		return array ;
	}
}
