package client.gongqi.designer.got.validate;

import java.util.List;

import org.dom4j.Attribute;
import org.dom4j.Element;

import info.gongqi.got.tool.GOTHelp;

public class ResolverValidator implements IValidator{

	@Override
	public List<Object> validateResolver(Element item, String url) {
		return null;
	}

	public ResolverValidator(){
		
	}
	
	public Boolean matchPropertyRedundant(Element property, List<Element> rProperties){
		String name = property.elementText("Name");
		if(name.equals("CreatedDate") || name.equals("CreatedTime") ||name.equals("CreatedBy")
		 ||name.equals("ModifiedDate") ||name.equals("ModifiedTime") || name.equals("ModifiedBy")){
			return false;
		}
			
		for (Element rProperty : rProperties){
			if(name.equals(rProperty.elementText("Name"))) {
				return false;		
			}
		}
		return true;
	}
	
	public Boolean matchAttrRedundant(Attribute attr, List<Element> rAttrs){
		for (Element rAttr : rAttrs){
			if(attr.getName().equals(rAttr.elementText("Name"))){
				return false;		
			}
		}
		return true;
	}
	
	public Boolean matchAttrLack(Element rAttr, List<Attribute> rAttrs){	
		for (Attribute attr : rAttrs){
			if(attr.getName().equals(rAttr.elementText("Name"))){
				return false;		
			}
		}
		
		return true;
	}
	
	public Boolean matchPropertyLack(Element rProperty, List<Element> properties){	
		for(Element property : properties){
			if(property.elementText("Name").equals(rProperty.elementText("Name"))){
				return false;		
			}
		}
		return true;
	}
	
	@SuppressWarnings("unchecked")
	public String matchDTB(Element entity){
		List<Element> properties = entity.element("Properties").elements("Property");
		int i = properties.size() - 1;
		String result = "";
		Element property;
		String[] dtb = {"ModifiedBy","ModifiedTime","ModifiedDate","CreatedBy","CreatedTime","CreatedDate"};
			
		for(int j= 0;j<6;j++){
			property = properties.get(i);
			if(!property.elementText("Name").equals(dtb[j])){
				result = "DTB错误:期望" + dtb[j] + "非" + property.elementText("Name");
				break;
			}
			i --;
		}
		
		return result;
	}
	
	public String matchATTRFieldGroup(Element formItem){
		List<Element> fieldGroupPro = GOTHelp.getPPAttElementList(formItem, "Name", "FieldGroup");
		List<Element> componentPro = GOTHelp.getPPAttElementList(formItem, "Name", "Component");
		String value;
		String result = "";
		if(fieldGroupPro.size()>0){
			value = fieldGroupPro.get(0).elementText("Value");
			if( !"".equals(value)){
				if(fieldGroupPro.get(0).attribute("refentityid") == null){
					result = "/Properties/Property/FieldGroup:没有@refentityid或者@refinnerid"; 
				}
			}
		}
		
		if(componentPro.size()>0){
			value = componentPro.get(0).elementText("Value");
			if(!"".equals(value)){
				if(componentPro.get(0).attribute("refentityid") == null)
					result = "/Properties/Property/Component:没有@refentityid或者@refinnerid";
			}
		}
		
		return result;
	}
	
	//在数量匹配的前提下 判断顺序
	protected Boolean isSequenceMatch(List<Element> properties, List<Element>rProperties){
		int proNum = rProperties.size();
		Boolean flag = true;
		for(int i = 0; i<proNum; i++){
			if(!properties.get(i).elementText("Name").equals(rProperties.get(i).elementText("Name"))){
				flag = false;
				break;
			}
		}
		return flag;
	}
	
	protected Element getEntity(Element item){
		if(item.attribute("version") != null)
			return item;
		while(item.getParent()!=null){
			item = item.getParent();
			if(item.attribute("version") != null)
				break;
		}
		return item;
	}
}
