package client.gongqi.designer.got.validate;

import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.tool.LayerInfo;
import info.gongqi.got.tool.LayerInfoSoultion;
import info.gongqi.got.tool.MergeCleanAllTable;
import info.gongqi.got.tool.MergeMatchingTips;
import info.gongqi.got.tool.MergeSaveAll;
import info.gongqi.got.tool.TreeOperationInfo;
import info.gongqi.got.ui.ConfigComposite;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.util.GOTMessageDialog;

import java.util.List;

import org.dom4j.Element;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

import client.gongqi.designer.toolsgot.GOTHelper;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import client.gongqi.designer.toolsgot.Macros;

public class DoMerge {

	public static ValidateROpr validator;
	
	/**
	 * 匹配提示
	 */
	public static void doMatchingTips(Button btn){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		if(FormDataSyn.currentTreeUi == null){
			return;
		}
		Tree tree = FormDataSyn.currentTreeUi.getTree();
		TreeItem[] items = tree.getSelection();
		if(items.length > 0){
			Element item = null;
			String elementEntityId = items[0].getData("elementEntityId") == null ? null : items[0].getData("elementEntityId").toString();
			if(elementEntityId == null){
				item = GotXmlDto.getInstance().getCurrentElements(items[0].getData("elementName").toString());
			}else{
				item = GotXmlDto.getInstance().getCurrentElement(items[0]);
			}
			if(item == null){
				GOTMessageDialog.alert("不支持选中的节点");
				return;
			}
			String url = getNodePosition(tree, item);
			validator = new ValidateROprPrompt(new UIComponent(btn), "");
			MergeMatchingTips matchingTips = new MergeMatchingTips(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE);
			matchingTips.open(item, url, 0, false, validator);
			
		}
	}
	
	/**
	 * 匹配
	 */
	public static void doMatching(Button btn){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		if(FormDataSyn.currentTreeUi == null){
			return;
		}
		Tree tree = FormDataSyn.currentTreeUi.getTree();
		TreeItem[] items = tree.getSelection();
		if(items.length > 0){
			Element item = null;
			String elementEntityId = items[0].getData("elementEntityId") == null ? null : items[0].getData("elementEntityId").toString();
			if(elementEntityId == null){
				item = GotXmlDto.getInstance().getCurrentElements(items[0].getData("elementName").toString());
			}else{
				item = GotXmlDto.getInstance().getCurrentElement(items[0]);
			}
			if(item == null){
				GOTMessageDialog.alert("不支持选中的节点");
				return;
			}
			String url = getNodePosition(tree, item);
			validator = null;
			validator = new ValidateROprModify(new UIComponent(btn), "");
			MergeMatchingTips matchingTips = new MergeMatchingTips(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE);
			matchingTips.open(item, url, 0, false, validator);

		}
	}
	
	/**
	 * 顺序提示
	 */
	public static void doOrderByTips(Button btn){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		if(FormDataSyn.currentTreeUi == null){
			return;
		}
		Tree tree = FormDataSyn.currentTreeUi.getTree();
		TreeItem[] items = tree.getSelection();
		if(items.length > 0){
			Element item = null;
			String elementEntityId = items[0].getData("elementEntityId") == null ? null : items[0].getData("elementEntityId").toString();
			if(elementEntityId == null){
				item = GotXmlDto.getInstance().getCurrentElements(items[0].getData("elementName").toString());
			}else{
				item = GotXmlDto.getInstance().getCurrentElement(items[0]);
			}
			if(item == null){
				GOTMessageDialog.alert("不支持选中的节点");
				return;
			}
			String url = getNodePosition(tree, item);
			validator = new ValidateROprSequence(new UIComponent(btn), "");
			MergeMatchingTips matchingTips = new MergeMatchingTips(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE);
			matchingTips.open(item, url, 0, false, validator);

		}
	}
	
	/**
	 * 顺序调整
	 */
	public static void doOrderBy(Button btn){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		if(FormDataSyn.currentTreeUi == null){
			return;
		}
		Tree tree = FormDataSyn.currentTreeUi.getTree();
		TreeItem[] items = tree.getSelection();
		if(items.length > 0){
			Element item = null;
			String elementEntityId = items[0].getData("elementEntityId") == null ? null : items[0].getData("elementEntityId").toString();
			if(elementEntityId == null){
				item = GotXmlDto.getInstance().getCurrentElements(items[0].getData("elementName").toString());
			}else{
				item = GotXmlDto.getInstance().getCurrentElement(items[0]);
			}
			if(item == null){
				GOTMessageDialog.alert("不支持选中的节点");
				return;
			}
			String url = getNodePosition(tree, item);
			validator = new ValidateROprSort(new UIComponent(btn), "");
			MergeMatchingTips matchingTips = new MergeMatchingTips(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE);
			matchingTips.open(item, url, 0, false, validator);

		}
	}
	
	/**
	 * 验证property
	 */
	public static void doCheckProperty(Button btn){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		if(FormDataSyn.currentTreeUi == null){
			return;
		}
		Tree tree = FormDataSyn.currentTreeUi.getTree();
		TreeItem[] items = tree.getSelection();
		if(items.length > 0){
			Element item = null;
			String elementEntityId = items[0].getData("elementEntityId") == null ? null : items[0].getData("elementEntityId").toString();
			if(elementEntityId == null){
				item = GotXmlDto.getInstance().getCurrentElements(items[0].getData("elementName").toString());
			}else{
				item = GotXmlDto.getInstance().getCurrentElement(items[0]);
			}
			if(item == null){
				GOTMessageDialog.alert("不支持选中的节点");
				return;
			}
			String url = getNodePosition(tree, item);
			validator = new ValidateROprValue(new UIComponent(btn), "");
			MergeMatchingTips matchingTips = new MergeMatchingTips(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE);
			matchingTips.open(item, url, 0, false, validator);

		}
	}
	
	/**
	 * 验证Attr
	 */
	public static void doCheckAttr(Button btn){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		if(FormDataSyn.currentTreeUi == null){
			return;
		}
		Tree tree = FormDataSyn.currentTreeUi.getTree();
		TreeItem[] items = tree.getSelection();
		if(items.length > 0){
			Element item = null;
			String elementEntityId = items[0].getData("elementEntityId") == null ? null : items[0].getData("elementEntityId").toString();
			if(elementEntityId == null){
				item = GotXmlDto.getInstance().getCurrentElements(items[0].getData("elementName").toString());
			}else{
				item = GotXmlDto.getInstance().getCurrentElement(items[0]);
			}
			if(item == null){
				GOTMessageDialog.alert("不支持选中的节点");
				return;
			}
			String url = getNodePosition(tree, item);
			validator = new ValidateROprAttr(new UIComponent(btn), "");
			MergeMatchingTips matchingTips = new MergeMatchingTips(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE);
			matchingTips.open(item, url, 0, false, validator);
		}
	}
	
	/**
	 * 保存所有
	 */
	public static void doSaveAll(){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		MergeSaveAll mergeSaveAll = new MergeSaveAll(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE);
		mergeSaveAll.open("all");
	}
	
	/**
	 * 日志打印
	 */
	public static void refGOTPrint(){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		String result = "";
		try {
			result = LoadXmlCore.gotServices.printRefGOT();
		} catch (Exception e) {
			e.printStackTrace();
			GOTMessageDialog.alert(e);
		}
		GOTMessageDialog.showXmlInfo(result, "日志打印");
	}
	
	/**
	 * 清除多余表
	 */
	@SuppressWarnings("unchecked")
	public static void cleanSplithTable(){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		Object result = null;
		try {
			result = LoadXmlCore.databaseServices.cleanSplithTable();
		} catch (Exception e) {
			e.printStackTrace();
			GOTMessageDialog.alert(e);
			return;
		}
		List<String> list = (List<String>) result;
		String str = "清理多余表：" + list.size() + "个" + "\n";
		for (String tabl:  list){
			str += "\n" + tabl;
		}
		GOTMessageDialog.showXmlInfo(str, "清理多余表");
	}
	
	/**
	 * 清除多余字段索引
	 */
	public static void cleanFieldAndIndex(){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		if(FormDataSyn.currentTreeUi == null){
			return;
		}
		Tree tree = FormDataSyn.currentTreeUi.getTree();
		TreeItem[] items = tree.getSelection();
		if(items.length > 0){
			Element selectedItem = GotXmlDto.getInstance().getCurrentElement(items[0]);
			if(selectedItem != null && selectedItem.getName().equals("Table")){
				try {
					LoadXmlCore.databaseServices.cleanSplithColumnIndex(selectedItem.attributeValue("name"));
				} catch (Exception e) {
					e.printStackTrace();
					GOTMessageDialog.alert(e);
					return;
				}
				GOTMessageDialog.info("执行成功");
			}else{
				GOTMessageDialog.alert("请选中table");
			}
		}
	}
	
	public static void modifyDim(){
		GOTMessageDialog.showModifyDim();
	}
	
	/**
	 * 处理所有table变更
	 */
	public static void checkAllTable(){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		if(FormDataSyn.currentTreeUi == null){
			return;
		}
		Tree tree = FormDataSyn.currentTreeUi.getTree();
		TreeItem[] items = tree.getSelection();
		if(items.length > 0){
			MergeCleanAllTable allTable = new MergeCleanAllTable(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE);
			allTable.open(true);
		}
	}
	
	/**
	 * 处理选中table变更
	 */
	public static void checkSelectTable(){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		if(FormDataSyn.currentTreeUi == null){
			return;
		}
		Tree tree = FormDataSyn.currentTreeUi.getTree();
		TreeItem[] items = tree.getSelection();
		if(items.length > 0){
			Element selectedItem = GotXmlDto.getInstance().getCurrentElement(items[0]);
			if(selectedItem != null && selectedItem.getName().equals("Table")){
				MergeCleanAllTable allTable = new MergeCleanAllTable(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE);
				allTable.open(false);
			}else{
				GOTMessageDialog.alert("请选择已保存的Table");
			}
		}
		
	}
	
	/**
	 * 保存变更的Form
	 */
	public static void saveModifiedForm(){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		MergeSaveAll mergeSaveAll = new MergeSaveAll(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE);
		mergeSaveAll.open("Form");
	}
	
	/**
	 * 检查FormDataSourceField利用率
	 */
	public static void checkFormDataSourceFieldRate(){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		if(FormDataSyn.currentTreeUi == null){
			return;
		}
		Tree tree = FormDataSyn.currentTreeUi.getTree();
		TreeItem[] items = tree.getSelection();
		String result = "";
		if(items.length > 0){
			for (TreeItem treeItem : items) {
				Element xml = GotXmlDto.getInstance().getCurrentElement(treeItem);
				String qname = xml.getName();
				if(qname.equals("Form")){
					result += checkFormDataSourceFieldRateByForm(xml);
				}else if(qname.equals("Forms")){
					result += checkFormDataSourceFieldRateByForms(xml);
				}else if(qname.equals("FormDataSources")){
					result += checkFormDataSourceFieldRateByFormDataSources(xml);
				}else if(qname.equals("FormDataSource")){
					result += checkFormDataSourceFieldRateByFormDataSource(xml);
				}else if(qname.equals("FormDataSourceFields")){
					result += checkFormDataSourceFieldRateByFormDataSourceFields(xml);
				}else if(qname.equals("FormDataSourceField")){
					result += checkFormDataSourceFieldRateByFormDataSourceField(xml);
				}
			}
		}
		if(!result.equals("")){
			GOTMessageDialog.info(result);
		}
	}
	
	/**
	 * 
	 */
	public static void getCurrentLayer(){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		LayerInfo info = new LayerInfo(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE, "getCurrentLayer");
		info.open();
	}
	
	/**
	 * 
	 */
	public static void createLayer(){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		LayerInfo info = new LayerInfo(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE, "createLayer");
		info.open();
	}
	
	/**
	 * 
	 */
	public static void recycleLayer(){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		LayerInfo info = new LayerInfo(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE, "recycleLayer");
		info.open();
	}
	
	/**
	 * 
	 */
	public static void packLayer(){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		LayerInfo info = new LayerInfo(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE, "packLayer");
		info.open();
	}
	
	
	/**
	 * 模块导入
	 */
	public static void moduleImport(){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		LayerInfo info = new LayerInfo(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE, "moduleImport");
		info.open();
	}
	
	/**
	 * 模块导出
	 */
	public static void moduleExport(){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		LayerInfo info = new LayerInfo(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE, "moduleExport");
		info.open();
	}
	
	/**
	 * 模块删除
	 */
	public static void moduleDelete(){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		LayerInfo info = new LayerInfo(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE, "moduleDelete");
		info.open();
	}
	
	/**
	 * 打包方案
	 */
	public static void packSolution(){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		LayerInfoSoultion info = new LayerInfoSoultion(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE, "packSolution");
		info.open();
	}
	
	/**
	 * 创建方案
	 */
	public static void createSolution(){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		LayerInfoSoultion info = new LayerInfoSoultion(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE, "createSolution");
		info.open();
	}
	
	/**
	 * 打包方案扩展包
	 */
	public static void packSolutionExtension(){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		LayerInfoSoultion info = new LayerInfoSoultion(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE, "packSolutionExtension");
		info.open();
	}
	
	/**
	 * 创建方案扩展包
	 */
	public static void createSolutionExtension(){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		LayerInfoSoultion info = new LayerInfoSoultion(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE, "createSolutionExtension");
		info.open();
	}
	
	/**
	 * 重置选中Enum中EnumItem的值
	 */
	@SuppressWarnings("unchecked")
	public static void resetEnum(){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		boolean changed = false;
		Tree tree = FormDataSyn.currentTreeUi.getTree();
		TreeItem[] items = tree.getSelection();
		for (TreeItem selectedItem : items){
			Element xml = GotXmlDto.getInstance().getCurrentElement(selectedItem);
			if(xml.getName().equals("Enum")){
				List<Element> enumItems = xml.elements("EnumItem");
				int i = 0;
				Boolean adjust = false;
				for(Element enumItem : enumItems){
					String value =gongqi.designer.utils.GOTHelper.getPropertyValue(enumItem,"Value");
					if(value.equals(String.valueOf(i))){
						i++;	
					}else{
						adjust = true;
						break;
					}
				}
				
				if(adjust){
					int j = 0;
					xml.addAttribute("saved", "0");
					changed = true;
					for (Element enumItem : enumItems){
						Element valuePro = GOTHelper.getProperty(enumItem,"Value");
						if(valuePro.element("Value") == null){
							valuePro.addElement("Value");
						}
						valuePro.element("Value").setText(String.valueOf(j));
						j++;
					}
					GotXmlDto.getInstance().updateEntityElement(xml);
					FormDataSyn.setUnSave(selectedItem);
				}
			}
		}
		
		if(changed){
			GOTMessageDialog.info("已做调整");
		}else{
			GOTMessageDialog.alert("不需调整");
		}
	}
	
	/**
	 * 同步字段顺序
	 */
	public static void synchronizeColumnOrder(){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		Tree tree = FormDataSyn.treeUis.get(0).getTree();
		TreeItem[] items = tree.getSelection();
		if(items.length == 0){
			GOTMessageDialog.alert("请选中Table");
		}else{
			Element selectedItem = GotXmlDto.getInstance().getCurrentElement(items[0]);
			if(selectedItem.getName().equals("Table")){
				byte[] bytes = null;
				try {
					bytes = LoadXmlCore.gotServices.synchronizeColumnOrder(selectedItem.attributeValue("name"));
				} catch (Exception e) {
					e.printStackTrace();
					GOTMessageDialog.alert(e);
				}
				String result = new String(bytes);
				rpc_synchronizeColumnOrder(result, items[0]);
			}else{
				GOTMessageDialog.alert("请选中Table");
			}
		}
	}
	
	@SuppressWarnings("unchecked")
	private static void rpc_synchronizeColumnOrder(String result, TreeItem treeItem){
		if(FormDataSyn.treeUis.isEmpty()){
			return;
		}
		result = "<rootTemp>" + result + "</rootTemp>";
		Element xmlParent = GOTXMLHelper.createElementByXMLString(result);
		List<Element> list =  xmlParent.elements();
		String nodeId ;
		int total = list.size();
		String his = "";
		String info = "";
		
		Element node = null;
		int j;
		int k;
		for(j=0; j<total; j++){
			Element xml = list.get(j);
			if(xml.attribute("id") != null){
				String strId = xml.attributeValue("id");	
				for(k=j+1; k<total; k++){
					Element xmlCompare = list.get(k);
					if(xmlCompare.attribute("id") != null ){
						if(xmlCompare.attributeValue("id").equals(strId)){
							xml.addAttribute("del", "true");
							break;
						}
					}
				}
			}
		}
		
		for(Element r : list){
			if(r.attribute("del") != null)
				continue;
			
			if(r.getName().equals("Error")){
				info += r.getText() + "\n保存失败，应执行右键恢复，以防数据丢失\n" ;
				continue ;
			}
			
			if(his.indexOf(r.attributeValue("id")) != -1){
				continue ;
			}
			his += "$" + r.attributeValue("id");
			
			nodeId = r.attributeValue("id") ;
			String qname = r.getName();
			node = getGOTNodeByQname(qname,nodeId);
			
			if(node == null){
				GOTMessageDialog.alert("不存在id为"+nodeId+"的节点，应新建");
				continue ;
			}
			
			TreeItem item = FormDataSyn.getTreeItrmByElement(node, null);
			if(item != null){
				if("0".equals(r.attributeValue("saved"))){
					node.remove(r.attribute("saved"));
				}
				Element parent = node.getParent();
				GOTHelp.insertChildBefore(parent, node, r);
				parent.remove(node);
				//这里重构关联的树节点
				FormDataSyn.restore(item, r,false);
			}
			
			info += r.attributeValue("name") + ":" + r.getName() + "  已修改 OK\n";
		}
		ConfigComposite.configComposite.set_text_op_info(Macros.INFO_OPR_SUCCESS);
		TreeOperationInfo.addInfo( "同步字段顺序" + Macros.INFO_OPR_SUCCESS);
		if(list.size() > 1){
			TreeOperationInfo.addInfo("同步字段顺序" + info);
			FormDataSyn.setSaved(treeItem);
		}else if(list.size()==1){
			Element error = list.get(0);
			if(error.getName().equals("Error")){
				TreeOperationInfo.addErrorInfo(info);
			}else{
				FormDataSyn.setSaved(treeItem);
			}
		}else{
			GOTMessageDialog.alert("返回list.length()<1，异常");
		}
		
	}
	
	private static Element getGOTNodeByQname(String qname, String nodeId){
//		String xpath = "";
		if(qname.equals("Form")){
//			xpath = "Forms/Form[@id='" + nodeId + "']";
//			return (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
			return GotXmlDto.getInstance().currentEntityByTypeAndId("Form", nodeId);
		}else if(qname.equals("Table")){
//			xpath = "DataDictionary/Tables/Table[@id='" + nodeId + "']";
//			return (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
			return GotXmlDto.getInstance().currentEntityByTypeAndId("Table", nodeId);
		}else if(qname.equals("DataType")){
//			xpath = "DataDictionary/DataTypes/DataType[@id='" + nodeId + "']";
//			return (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
			return GotXmlDto.getInstance().currentEntityByTypeAndId("DataType", nodeId);
		}else if(qname.equals("MenuItem")){
//			xpath = "MenuItems/MenuItem[@id='" + nodeId + "']";
//			return (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
			return GotXmlDto.getInstance().currentEntityByTypeAndId("MenuItem", nodeId);
		}else if(qname.equals("Menu")){
//			xpath = "Menus/Menu[@id='" + nodeId + "']";
//			return (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
			return GotXmlDto.getInstance().currentEntityByTypeAndId("Menu", nodeId);
		}else if(qname.equals("Enum")){
//			xpath = "DataDictionary/Enums/Enum[@id='" + nodeId + "']";
//			return (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
			return GotXmlDto.getInstance().currentEntityByTypeAndId("Enum", nodeId);
		}else if(qname.equals("Report")){	
//			xpath = "Reports/Report[@id='" + nodeId + "']";
//			return (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
			return GotXmlDto.getInstance().currentEntityByTypeAndId("Report", nodeId);
		}else if(qname.equals("Map")){
//			xpath = "DataDictionary/Maps/Map[@id='" + nodeId + "']";
//			return (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
			return GotXmlDto.getInstance().currentEntityByTypeAndId("Map", nodeId);
		}
		return null;
	}
	
	@SuppressWarnings("unchecked")
	private static String checkFormDataSourceFieldRateByForms(Element forms){
		String result = "";
		List<Element> elements = forms.elements("Form");
		for (Element form : elements){
			result += checkFormDataSourceFieldRateByForm(form);
		}
		return result;
	}
	
	private static String checkFormDataSourceFieldRateByForm(Element form){
		String result = "";
		Element datasources = form.element("FormDataSources");
		if(datasources != null){
			result += checkFormDataSourceFieldRateByFormDataSources(datasources);	
		}
		return result;
	}
	
	@SuppressWarnings("unchecked")
	private static String checkFormDataSourceFieldRateByFormDataSources(Element formdatasources){
		String result = "";
		List<Element> elements = formdatasources.elements("FormDataSource");
		for(Element formdatasource : elements){
			result+=checkFormDataSourceFieldRateByFormDataSource(formdatasource);
		}
		return result;
	}
	
	private static String checkFormDataSourceFieldRateByFormDataSource(Element formdatasource){
		String result = "";
		Element datasourcefields = formdatasource.element("FormDataSourceFields");
		if(datasourcefields != null){
			result += checkFormDataSourceFieldRateByFormDataSourceFields(datasourcefields);
		}
		return result;
	}
	
	@SuppressWarnings("unchecked")
	private static String checkFormDataSourceFieldRateByFormDataSourceFields(Element formdatasourcefields){
		String result = "";
		List<Element> elements = formdatasourcefields.elements("FormDataSourceField");
		for (Element formdatasourcefield : elements){
			result += checkFormDataSourceFieldRateByFormDataSourceField(formdatasourcefield);
		}
		return result;
	}
	
	@SuppressWarnings("unchecked")
	private static String checkFormDataSourceFieldRateByFormDataSourceField(Element formdatasourcefield){
		String result = "";
		Element formdatasource = formdatasourcefield.getParent().getParent();
		Element form = formdatasource.getParent().getParent();
		Element formDesign = form.element("FormDesign");
		Element fieldPro = GOTHelper.getProperty(formdatasourcefield,"Field");
		String _refentityid = fieldPro.attributeValue("refentityid");
		String _refinnerid = fieldPro.attributeValue("refinnerid");
		String xpath = ".//FormItem/Properties/Property[@refentityid='" + _refentityid + "' and @refinnerid='" + _refinnerid + "']";
		List<Element> properties = formDesign.selectNodes(xpath);
		result = formdatasource.attributeValue("name")+"."+ formdatasourcefield.attributeValue("name")+"\t被使用\t"+properties.size()+ "\t次\n";
		return result;
	}
	
	private static String getNodePosition(Tree tree, Element node){
		Element tmp = null;
		if(node == null){
			tmp = GotXmlDto.getInstance().getCurrentElement(tree.getSelection()[0]);
		}else{
			tmp = node;
		}
		String info = "";
		
		while(tmp!=null){
			String s = tmp.attribute("name") != null ? tmp.attributeValue("name") : tmp.getName();
			info = "/" + s + info;
			tmp = tmp.getParent();
		}
		return info;
	}
}
