package client.gongqi.designer.got.node.table;

import org.dom4j.Element;

import client.gongqi.designer.got.node.Inner;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;
import info.gongqi.got.util.GOTMessageDialog;

public class TableIndex extends Inner{

	public TableIndex(){
		super();
	}
	
	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node; 
		
		if(src.getName().equals("TableField")){
			String type = "";
			if("AutoLookup".equals(this.xml.attributeValue("type")))
				type = "AutoLookup";
			
			node = super.doAccpDragNew("TableIndexItem",type);
			this.doAccpDragNewAfer(src,node);
			return node;
		}else{
			GOTMessageDialog.alert("TableIndex 不允许非TableField的拖拽放置");
		}
		return null ;
	}
	
	private void doAccpDragNewAfer(Element src, NodeGOT node){
		String fieldName = src.attributeValue("name") ;
		
		GOTXMLHelper.setProperty(node.xml,"Field",fieldName,true);
	}
	
	public String getAccpDragNewInsertBase(){
		return "self";
	}
	
	@Override
	public String validateAccpDragNew(Element srcItem){
		if(!srcItem.getName().equals("TableField")){
			return "excepted a TableField Node in same Entity";	
		}
		
		return "true";
	}
	
	public String allowEdit(){
		String result = super.allowEdit();
		if(result.equals("true")){
			String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
			if(!this.xml.attributeValue("createdLayer").equals(lay))
				result = "该节点为下层创建,不允许编辑";
		}
		return result;
	}
	
	@Override
	public Boolean validateNewName(String newName){
		if(validateNewNameString.toLowerCase().contains(newName.toLowerCase())){
			return false;
		}
		
		return super.validateNewName(newName);
	}
}
