package client.gongqi.designer.got.node.table;

import org.dom4j.Element;
import org.eclipse.swt.events.MouseEvent;

import client.gongqi.designer.got.node.Branch;
import client.gongqi.designer.got.node.NodeFactory;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;

public class TableFields extends Branch{

	public TableFields(){
		super();
	}
	
	@Override
	public Boolean isSibling(Element srcItem){
		if(srcItem.getParent() == null){
			return false;
		}
		
		if(srcItem.getParent().asXML().equals(this.xml.asXML()))
			return true;
		return false;
	}
	
	@Override
	public String validateAccpDragMove(Element srcItem,MouseEvent event){
		return "down";
	}
	
	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node; 
		if(src.getName().equals("Enum")){
			node = super.doAccpDragNew("TableField","Enum");
			this.doAccpDragNewAfer(src,node.xml);
			return node;
		}else if(src.getName().equals("DataType")){
			//新建一个TableField 类型是该DataType的@type 设置好继承属性 并且返回这个node
			node = super.doAccpDragNew("TableField",src.attributeValue("type"));
			this.doAccpDragNewAfer(src,node.xml);
			return node;
		}else if(src.getName().equals("TableField")){
			Element srcTableField = src.createCopy();
			String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
			srcTableField.addAttribute("createdLayer", lay);
			srcTableField.addAttribute("modifiedLayer", lay);
			//FilterField置空
			GOTXMLHelper.setProperty(srcTableField,"FilterField", "", true);
			node = NodeFactory.getNode(srcTableField);
			return node;
		}
		return null;
	}
	
	private void doAccpDragNewAfer(Element src, Element node){
		String extendName = src.attributeValue("name");
		
		GOTXMLHelper.setProperty(node,"Extends",extendName,true);
		
		if(node.attributeValue("type").equals("Enum")){
			if(src.getName().equals("Enum")){
				GOTXMLHelper.setProperty(node,"Source","Enum",true);
			}else{
				GOTXMLHelper.setProperty(node,"Source","DataType",true);
			}
		}else{		
			if(node.attributeValue("type").equals("String")){
				GOTXMLHelper.setPropertyByQName(node,"StringSize",src,"StringSize");
			}else{
				if(node.attributeValue("type").equals("Decimal")){
					GOTXMLHelper.setPropertyByQName(node,"NumOfDecimals",src,"NumOfDecimals");
				}
			}
		}
	}
	
	@Override
	public String getAccpDragNewInsertBase(){
		return "self";
	}
	
}
