package client.gongqi.designer.got.node.query;

import java.util.List;

import org.dom4j.Element;

import client.gongqi.designer.got.node.Inner;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;

public class QueryTable extends Inner{

	public QueryTable(){
		super();
	}
	
	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node; 
		if(src.getName().equals("Table")){
			node = super.doAccpDragNew("QueryTable", "");
			this.doAccpDragNewAfter(src,node.xml);
			return node;
		}
		
		return null ;
	}
	
	private void doAccpDragNewAfter(Element src, Element node){
		String fieldName = src.attributeValue("name");
		GOTXMLHelper.setProperty(node,"Table",fieldName,true);	
	}
	
	@Override
	public String getAccpDragNewInsertBase(){
		return "parent";
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void doAfterPropertyModified(Element property, String...args){
		super.doAfterPropertyModified(property,args);
		if(property.elementText("Name").equals("Table")){
			String table = property.elementText("Value");
			String xpath = "./Table[@name='" + table +"']/Properties/Property/Name";
			List<Element> elements = GotXmlDto.getInstance().getCurrentElements("Tables").selectNodes(xpath);
			for (Element element : elements) {
				if(element.getText().equals("Label")){
					String label = element.elementText("Value");
					GOTHelp.getPPAttElement(this.xml, "Name", "Label").element("Value").setText(label);
					return ;
				}
			}

		}
	}
	
	@Override
	public void doAfterDragDroped(){
		this.doAfterPropertyModified(GOTHelp.getPPAttElement(this.xml, "Name", "Table"));
	}
}
