package client.gongqi.designer.got.node.query;

import java.util.List;

import org.dom4j.Element;

import client.gongqi.designer.got.node.Inner;
import info.gongqi.got.tool.GOTHelp;

public class QueryRelationItem extends Inner{

	public QueryRelationItem(){
		super();
	}
	
	@Override
	public void doAfterPropertyModified(Element property, String...args){
		String origValue = args[0];
		List<Element> fieldPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Field");
		List<Element> fieldValuePro = GOTHelp.getPPAttElementList(this.xml, "Name", "FieldValue");
		List<Element> relatedFieldPro = GOTHelp.getPPAttElementList(this.xml, "Name", "RelatedField");
		List<Element> relatedValuePro = GOTHelp.getPPAttElementList(this.xml, "Name", "RelatedValue");
		
		String fieldProValue = fieldPro.get(0).elementText("Value");
		String fieldValueProValue = fieldValuePro.get(0).elementText("Value");
		String relatedFieldProValue = relatedFieldPro.get(0).elementText("Value");
		String relatedValueProValue = relatedValuePro.get(0).elementText("Value");
		
		
		if(!fieldProValue.equals("") && fieldValueProValue.equals("")  && relatedFieldProValue.equals("") && relatedValueProValue.equals("")){
			super.doAfterPropertyModified(property,args);
			return ;
		}
		
		if(!fieldProValue.equals("") && !fieldValueProValue.equals("")  && relatedFieldProValue.equals("") && relatedValueProValue.equals("")){
			super.doAfterPropertyModified(property,args);
			return ;
		}
		
		if(!fieldProValue.equals("") && fieldValueProValue.equals("")  && !relatedFieldProValue.equals("") && relatedValueProValue.equals("")){
			super.doAfterPropertyModified(property,args);
			return ;
		}
		
		if(fieldProValue.equals("") && fieldValueProValue.equals("")  && !relatedFieldProValue.equals("") && relatedValueProValue.equals("")){
			super.doAfterPropertyModified(property,args);
			return ;
		}
		
		if(fieldProValue.equals("") && fieldValueProValue.equals("")  && relatedFieldProValue.equals("") && relatedValueProValue.equals("")){
			super.doAfterPropertyModified(property,args);
			return ;
		}
		
		if(fieldProValue.equals("") && fieldValueProValue.equals("")  && !relatedFieldProValue.equals("") && !relatedValueProValue.equals("")){
			super.doAfterPropertyModified(property,args);
			return ;
		}
		
		property.element("Value").setText(origValue);
	}
	
	@Override
	protected void doPropertyTrigger(Element property){
		Element queryTable = this.xml.getParent().getParent();
		Element relatedTable = queryTable.getParent().getParent();
		List<Element> fieldPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Field");
		List<Element> relatedFieldPro = GOTHelp.getPPAttElementList(this.xml, "Name", "RelatedField");
		List<Element> fieldValue = GOTHelp.getPPAttElementList(this.xml, "Name", "FieldValue");
		List<Element> relatedFieldValue = GOTHelp.getPPAttElementList(this.xml, "Name", "RelatedValue");
		if(relatedFieldPro.get(0).elementText("Value").equals("") && fieldPro.get(0).elementText("Value").equals(""))
			return ;
		if(relatedFieldPro.get(0).elementText("Value").equals("")){
			String name = GOTHelp.getPPAttValue(queryTable, "Name", "Alias") + "."+ fieldPro.get(0).elementText("Value")+"="+"'"+ fieldValue.get(0).elementText("Value")+"'";
			this.xml.addAttribute("name", name);
		}else if(fieldPro.get(0).elementText("Value").equals("")){
			String name = GOTHelp.getPPAttValue(queryTable, "Name", "Alias") + "."+ relatedFieldPro.get(0).elementText("Value")+"="+"'"+ relatedFieldValue.get(0).elementText("Value")+"'";
			this.xml.addAttribute("name", name);
		}else{
			String name = GOTHelp.getPPAttValue(queryTable, "Name", "Alias")  + "."+ fieldPro.get(0).elementText("Value")+"=" +GOTHelp.getPPAttValue(relatedTable, "Name", "Alias")+"."+ relatedFieldPro.get(0).elementText("Value");
			this.xml.addAttribute("name", name);
		}
		
	}
	
}
