package client.gongqi.designer.got.node.query;

import java.util.List;

import org.dom4j.Element;

import client.gongqi.designer.got.node.Entity;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import info.gongqi.got.tool.GOTHelp;

public class Query extends Entity{

	public Query(){
		super();
	}
	
	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node; 
		if(src.getName().equals("Table")){
			//新建一个MenuRefMenu 设置好属性 返回
			node = super.doAccpDragNew("QueryTable", "");
			this.doAccpDragNewAfter(src,node.xml);
			return node;
		}
		return null ;
	}
	
	private void doAccpDragNewAfter(Element src, Element node){
		String fieldName = src.attributeValue("name");
		GOTXMLHelper.setProperty(node,"Table",fieldName,true);	
	}
	
	@Override
	public String getAccpDragNewInsertBase(){
		return "self";
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected String validateProperties(Element nodeBeValidated){
		String result = super.validateProperties(nodeBeValidated);
		if(!result.equals("true"))
			return result;
		List<Element> queryRelationItems = this.xml.selectNodes(".//QueryRelationItem");
		for (Element queryRelationItem : queryRelationItems){
			List<Element> fieldPro = GOTHelp.getPPAttElementList(queryRelationItem, "Name", "Field");
			List<Element> fieldValuePro = GOTHelp.getPPAttElementList(queryRelationItem, "Name", "FieldValue");
			List<Element> relatedFieldPro = GOTHelp.getPPAttElementList(queryRelationItem, "Name", "RelatedField");
			List<Element> relatedValuePro = GOTHelp.getPPAttElementList(queryRelationItem, "Name", "RelatedValue") ;
			
			String fieldProValue = fieldPro.get(0).elementText("Value");
			String fieldValueProValue = fieldValuePro.get(0).elementText("Value");
			String relatedFieldProValue = relatedFieldPro.get(0).elementText("Value");
			String relatedValueProValue = relatedValuePro.get(0).elementText("Value");
			
			if(fieldProValue.equals("") && fieldValueProValue.equals("") &&
				relatedFieldProValue.equals("") && relatedValueProValue.equals(""))
				
				return "false:" + queryRelationItem.attributeValue("name") + "-->properties is not valid";
		}
		List<Element> elements = this.xml.selectNodes(".//QueryRelation");
		for (Element queryRelation : elements){
			String joinMode = GOTXMLHelper.getPropertyValue(queryRelation,"JoinMode");
			Element queryTable;
			if(joinMode.equals("ExistJoin") || joinMode.equals("NotExistJoin") ){
				queryTable = queryRelation.getParent();
				if(queryTable.getParent().getName().equals("QueryJoins") ){
					if(!GOTXMLHelper.getPropertyValue(queryTable,"Output").equals("false"))
						return "false:" + queryRelation.attributeValue("name") + "--> property output expects value false";
					List<Element> joins = queryTable.elements("QueryJoins");
					if(joins.get(0).elements().size()>0)
						return "false:" + queryRelation.attributeValue("name") + "-->when its joinMode is not innerJoin,it should not be exist join";				
				}
			}
		}
		
		return "true";
	}
	
	
}
