package client.gongqi.designer.got.node.menuitem;

import gongqi.designer.utils.GOTHelper;
import gongqi.erp.gotmodel.core.EntityType;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.util.GOTMessageDialog;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;

import client.gongqi.designer.got.node.Entity;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import client.gongqi.designer.toolsgot.Macros;

public class MenuItem extends Entity{

	public MenuItem(){
		super();
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public List<String> getPropertyItemEditorArray(String propertyName, String fixedRegular, Element fixedBaseXML){
		if(propertyName.equals("RefObject")){
			List<String> array = new ArrayList<>();
			List<Element> sourceTypePro = GOTHelp.getPPAttElementList(this.xml, "Name", "SourceType");
			List<Element> forms = new ArrayList<>();
			if(sourceTypePro.get(0).attributeValue("Value").equals("Form")){
//				forms = NodeGOT.gotXML.element("Forms").elements("Form");	
				forms = GotXmlDto.getInstance().currentElements("Forms");
			}/*else if(sourceTypePro.get(0).attributeValue("Value").equals("Report")){
				forms = NodeGOT.gotXML.element("Reports").elements("Report");	
			}else if(sourceTypePro.get(0).attributeValue("Value").equals("Html")){
				return null;
			}*/
			
			for (Element form : forms){
				array.add(form.attributeValue("name"));
			}
			return array;
			
		}else{
			return super.getPropertyItemEditorArray(propertyName, "", null);
		}
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void doAfterPropertyModified(Element property, String...args){
		List<Element> sourceTypePro = GOTHelp.getPPAttElementList(this.xml, "Name", "SourceType");
		if(property.elementText("Name").equals("Source")){
			String source = sourceTypePro.get(0).elementText("Value");
			String formName = property.elementText("Value");
			List<Element> form = null ;
			if(source.equals("Form")){
//				String xpath = "Forms/Form[@name='" + formName + "']";
//				form = NodeGOT.gotXML.selectNodes(xpath);
				form = GotXmlDto.getInstance().currentElements("Forms", "name", formName);
			}else if(source.equals("Report")){
//				String xpath = "Reports/Report[@name='" + formName + "']";
//				form = NodeGOT.gotXML.selectNodes(xpath);
				form = GotXmlDto.getInstance().currentElements("Reports", "name", formName);
			}
			
			if(form != null && form.size() > 0){
				property.addAttribute("refentityid", form.get(0).attributeValue("id"));
			}else if(property.attribute("refentityid") != null ){
				property.remove(property.attribute("refentityid"));
			}
		}
	
		super.doAfterPropertyModified(property,args);
	}
	
	@Override
	protected void doPropertyTrigger(Element property){
		super.doPropertyTrigger(property);
		if(property.elementText("Name").equals("Source")){
			Element sourcePro = GOTHelper.getProperty(xml,"SourceType");
			String source = sourcePro.elementText("Value");
			if(source.equals("Form")){
				this.xml.addAttribute("name", property.elementText("Value"));
			}else if(!source.equals("Html")){
				this.xml.addAttribute("name", source + "_" +property.elementText("Value"));
			}
		}
		this.setEntityUniqueName();
	}
	
	@SuppressWarnings("unchecked")
	private void setEntityUniqueName(){
		Element outer = this.xml.getParent();
		String origName = this.xml.attributeValue("name");
		String newName = origName;
		int i = 1;
		String xpath = "MenuItem[@name='" + newName + "']";
		if(checkParentNodes(outer)){
			outer = GotXmlDto.getInstance().getCurrentElements("MenuItems");
		}
		List<Element> elements = outer.selectNodes(xpath);
		while(elements.size() - i >0){
			newName = origName + i ;
			this.xml.addAttribute("name", newName);
			i++;
		}
		this.xml.addAttribute("name", newName);
	}
	
	@Override
	public void doAfterDragDroped(){
		List<Element> refObjectPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Source");
		this.doAfterPropertyModified(refObjectPro.get(0));
		String id = "";
		try {
			id = LoadXmlCore.gotServices.getEntityId(EntityType.MenuItem);
		} catch (Exception e) {
			e.printStackTrace();
			GOTMessageDialog.alert(e);
		}
		this.xml.addAttribute("id", id);
		
	}
	
	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node; 
		node = super.doAccpDragNew("MenuItem", "");
		this.doAccpDragNewAfter(src,node.xml);
		return node;

	}
	
	private void doAccpDragNewAfter(Element src, Element node){
		String srcName = src.getName();
		GOTXMLHelper.setProperty(node,"SourceType",srcName,true);
		GOTXMLHelper.setProperty(node,"Source", src.attributeValue("name"), true);	
	}
	
	@Override
	public String getAccpDragNewInsertBase(){
		return "parent";
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected String validateProperties(Element nodeBeValidated){
		Element property = GOTHelper.getProperty(nodeBeValidated,"Source");
		if(property.attribute("refentityid") != null ){
			Element sourcePro = GOTHelper.getProperty(nodeBeValidated,"SourceType");
			String source = sourcePro.elementText("Value");
			
			String entityId = property.attributeValue("refentityid");
			Element entities = null;
//			String xpath = "";
			if(source.equals("Form")){
//				xpath = "Forms/Form[@id='" + entityId + "']";
//				entities = NodeGOT.gotXML.selectNodes(xpath);
				entities = GotXmlDto.getInstance().currentEntityByTypeAndId("Form", entityId);
			}/*else if(source.equals("Report")){
				xpath = "Reports/Report[@id='" + entityId + "']";
				entities = NodeGOT.gotXML.selectNodes(xpath);
			}else if(source.equals("Class")){
				xpath = "Classes/Class[@id='" + entityId + "']";
				entities = NodeGOT.gotXML.selectNodes(xpath);
			}*/
			
			if(entities == null)
				return "RefObject 关联无效";
			if(source.equals("Form")){
				String subForm = GOTHelp.getPPAttValue(entities, "Name", "FormType");
				if("SubForm".equals(subForm)){
					return "SubForm属性为true的Form，不能保存为MenuItem";
				}
			}
		}
		return Macros.INFO_TRUE;
		
	}
	
	@Override
	public String validateAccpDragNew(Element srcItem){
		
		if(srcItem != null)
		{
			String qName = srcItem.getName();
			if("Form".equals(qName))
			{
				String formType = GOTHelper.getPropertyValue(srcItem, "FormType");
				if("Lookup".equals(formType))
				{
					return "FormType属性为Lookup的Form不允许被拖动到MenuItem";
				}
			}
		}
		
		return "true";
	}
	
}
