package client.gongqi.designer.got.node.menu;

import org.dom4j.Element;
import org.eclipse.swt.events.MouseEvent;

import client.gongqi.designer.got.node.Inner;
import client.gongqi.designer.got.node.NodeFactory;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;

public class MenuSeperator extends Inner{

	public MenuSeperator(){
		super();
	}
	
	@Override
	public Boolean isSibling(Element srcItem){
		if(srcItem.getParent() == null || this.xml.getParent() == null){
			return false;
		}
		if(srcItem.getParent().asXML().equals(this.xml.getParent().asXML()) && srcItem.getName().equals(this.xml.getName()))
			return true;
		return false;
	}
	
	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node; 
		if(src.getName().equals("Menu")){
			//新建一个MenuRefMenu 设置好属性 返回
			node = super.doAccpDragNew("MenuRefMenu", "");
			this.doAccpDragNewAfter(src,node.xml);
			return node;
		}else if(src.getName().equals("MenuItem")){
			node = super.doAccpDragNew("MenuRefMenuItem", "");
			this.doAccpDragNewAfter(src,node.xml);
			return node ;
		}else{
			Element srcXML = src.createCopy();
			String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
			srcXML.addAttribute("createdLayer", lay);
			srcXML.addAttribute("modifiedLayer", lay);
			node = NodeFactory.getNode(srcXML);
			return node;
		}
	}
	
	@Override
	public String validateAccpDragNew(Element srcItem){
		if(srcItem.getName().equals("Menu")){

		}
		return "true";
	}
	
	private void doAccpDragNewAfter(Element src, Element node){
		String fieldName = src.attributeValue("name");
		
		if(node.getName().equals("MenuRefMenu")){
			GOTXMLHelper.setProperty(node,"Menu",fieldName,true);
		}else if(node.getName().equals("MenuRefMenuItem")){
			GOTXMLHelper.setProperty(node,"MenuItem",fieldName,true);
		}
		
	}
	
	@Override
	public String getAccpDragNewInsertBase(){
		return "parent";
	}
	
	@Override
	public String moveType(Element srcItem, MouseEvent event){
		if(srcItem.getName().equals("MenuSub") || srcItem.getName().equals("MenuSeperator")){
			return "switch";
		}
		return "false";
	}
	
	@Override
	protected Boolean isNameValid(String name){
		String reg = "/^[-]{5,30}$/";
		return reg.matches(reg);
	}
	
}
