package client.gongqi.designer.got.node.menu;

import java.util.Arrays;
import java.util.List;

import org.dom4j.Element;
import org.eclipse.swt.events.MouseEvent;

import client.gongqi.designer.got.node.Entity;
import client.gongqi.designer.got.node.NodeFactory;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import client.gongqi.designer.toolsgot.Macros;
import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;

public class Menu extends Entity{

	public Menu(){
		super();
	}
	
	@Override
	public Boolean isSibling(Element srcItem){
		if(srcItem.getParent() == null && this.xml.getParent() == null && srcItem.getName().equals("Menu") && this.xml.getName().equals("Menu")){
			return true;
		}
		
		if(srcItem.getParent() != null && srcItem.getParent().asXML().equals(this.xml.asXML()))
			return true;

		
		return false;
	}
	
	@Override
	public String validateAccpDragMove(Element srcItem,MouseEvent event){
		if(srcItem.getName().equals("Menu") && this.xml.getName().equals("Menu")){
			return "true";
		}
		return "down";
	}
	
	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node;
		if(src.getName().equals("Menu")){
			node = super.doAccpDragNew("Menu", "");
			this.doAccpDragNewAfter(src,node.xml);
			return node;
		}else if(src.getName().equals("MenuItem")){
			node = super.doAccpDragNew("MenuRefMenuItem", "");
			this.doAccpDragNewAfter(src,node.xml);
			return node ;
			
		}else{
			String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
			Element srcXML = src.createCopy();
			srcXML.addAttribute("createdLayer", lay);
			srcXML.addAttribute("modifiedLayer", lay);
			node = NodeFactory.getNode(srcXML);
			return node;
		}
		
	}
	
	@Override
	public String validateAccpDragNew(Element srcItem){
		return "true";
	}
	
	private void doAccpDragNewAfter(Element src, Element node){
		String fieldName = src.attributeValue("name");
		if(node.getName().equals("MenuRefMenu")){
			GOTXMLHelper.setProperty(node,"Menu",fieldName,true);
		}else if(node.getName().equals("MenuRefMenuItem")){
			GOTXMLHelper.setProperty(node,"MenuItem",fieldName,true);
		}
		
	}
	
	@Override
	public String getAccpDragNewInsertBase(){
		return "self";
	}
	
	@Override
	public String moveType(Element srcItem, MouseEvent event){
		if(srcItem.getName().equals("MenuRefMenuItem") || srcItem.getName().equals("MenuSub")
			||srcItem.getName().equals("MenuSeperator")||srcItem.getName().equals("MenuRefMenu")){
			if(NodeGOT.getEntity(srcItem) != this.xml)
				return "false";
			return "append";
		}
//		else if(srcItem.getName().equals("Menu")){
//			return "switch";
//		}
		
		return "false";
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected String validateOther(){
		return "true";
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected String validateProperties(Element nodeBeValidated){
		return  super.validateProperties(nodeBeValidated);
	}
	
	@Override
	public String validateDelete() {
		return super.validateDelete();
	}
	
}
