package client.gongqi.designer.got.node.map;

import java.util.List;

import org.dom4j.Element;

import client.gongqi.designer.got.node.Inner;
import client.gongqi.designer.got.node.NodeFactory;
import client.gongqi.designer.got.node.NodeGOT;
import info.gongqi.got.tool.GOTHelp;

public class MapRelation extends Inner{

	public MapRelation(){
		super();
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void doAfterInsert(){
		super.doAfterInsert() ;
		
		Element entityXML = NodeGOT.getEntity(xml);
		List<Element> tablePro = GOTHelp.getPPAttElementList(entityXML, "Name", "Table");
		
		if(tablePro.get(0).elementText("Value").equals("")){
			List<Element> mapFieldList = NodeGOT.getEntity(this.xml).element("MapFields").elements("MapField") ;
			
			NodeGOT node;
			
			Element proField ;
			
			for(Element field : mapFieldList){
				node = NodeFactory.createNode("MapRelationItem","","");
				this.xml.add(node.xml.detach());
				node.doAfterInsert() ;
				proField = GOTHelp.getPPAttElement(node.xml, "Name", "Field");
				proField.element("Value").setText(field.attributeValue("name"));
				node.doAfterPropertyModified(proField);
				
			}
		}
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void  doAfterPropertyModified(Element property, String...args){
		super.doAfterPropertyModified(property,args);
		
		String origValue = args[0];
		
		//第一次设置时 不删除 因为是自动跟随的节点 以后设置时 删除
		Element entityXML = NodeGOT.getEntity(xml);
		List<Element> tablePro = GOTHelp.getPPAttElementList(entityXML, "Name", "Table");
		
		if(origValue.equals("") && tablePro.get(0).elementText("Value").equals(""))
			return ;
		
		List<Element> itemList = this.xml.elements("MapRelationItem") ; 
	
		int length = itemList.size();
		
		for(int i = 0 ; i<length ; i++){
			itemList.remove(0);
		}
		
		NodeGOT node;
		Element proField;
		List<Element> mapFieldList = NodeGOT.getEntity(this.xml).element("MapFields").elements("MapField") ;
		for(Element field : mapFieldList){
			node = NodeFactory.createNode("MapRelationItem","","");
			this.xml.add(node.xml.detach());
			node.doAfterInsert() ;
			proField = GOTHelp.getPPAttElement(node.xml, "Name", "Field");
			proField.element("Value").setText(field.attributeValue("name"));
			node.doAfterPropertyModified(proField);
			
		}
	}
	
	
}
