package client.gongqi.designer.got.node.gotenum;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;

import client.gongqi.designer.got.node.Entity;
import client.gongqi.designer.toolsgot.Macros;
import gongqi.designer.utils.GOTHelper;

public class Enum extends Entity{

	private static String javaKeys = "abstract boolean break byte case catch char class continue default do double else extends false final"+
	"finally float for if implements import instanceof int interface long native new null package private protected public return short static" +
	"super switch synchronized this throw throws transient try true void volatile while abstractmethoderror appendable charsquence comparable iterable readable runnable boolean byte character class classloader compiler enum float inheritablethreadlocal integer long math number object package process processbuilder runtime runtimepermission securitymanager short stacktraceelement strictmath string stringbuilder stirngbuffer system thread threadlocal throwable void arithmeticexception arrayindexoutofboundsexception arraystoreexception classcastexception classnotfoundexception clonenotsupportedexception exception enumconstantnotpresentexception illegalacessexception illegalargumentexception illegalmonitorstateexception"
	+" illegalthreadstateexception indexoutofboundsexception instantiationexception interruptedexception negativearraysizeexception nosuchfieldexception nosuchmethodexception nullpointerexception numberformatexception runtimeexception securityexception stringindexoutofboundsexception typenotpresentexception unsupportedoperationexception abstractmethoderror assertionerror classcircularityerror classformaterror error";

	@SuppressWarnings("unchecked")
	@Override
	protected String validateOther(){
		List<Element> enumItems = this.xml.elements("EnumItem");
		for(Element enumItem : enumItems){
			String _name = enumItem.attributeValue("name");
			if(javaKeys.contains(_name.toLowerCase().trim()))
				return "false:" + _name + "为关键字";
			String label = GOTHelper.getPropertyValue(enumItem, "Label");
			if(label == null || label.equals(""))
				return "false:请为名为"+ enumItem.attributeValue("name") + "的EnumItem的Label属性指定一个值";
			List<String> values = new ArrayList<>();
			for(Element enumItem2 : enumItems){
				if(enumItem != enumItem2){
					String value = GOTHelper.getPropertyValue(enumItem2, "Value");
					values.add(value);
				}
			}
			
			if(values.indexOf(label) != -1){
				return "false:Label属性的值不能与其他EnumItem的Value相同";
			}
		}
		
		return Macros.INFO_TRUE;
	}
}
