package client.gongqi.designer.got.node.form;

import gongqi.designer.utils.GOTHelper;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;

import java.util.List;

import org.dom4j.Element;

import client.gongqi.designer.resolvergot.ResolverNode;

public class FormItemHelper {

	public static String getFormItemTypeByType(String type){
		if(type.equals("Component")){
			return "FieldGroup";
		}else{
			return type + "Editor";
		}
	}
	
	public static String getFetchFinalValue(String dataTypeId, String proName){
//		String xpath = "DataDictionary/DataTypes/DataType[@id='" +dataTypeId + "']" ;
//		Element dataType = (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
		Element dataType = GotXmlDto.getInstance().currentEntityByTypeAndId("DataType", dataTypeId);
		if(dataType == null)
			return "";
		List<Element> property = GOTHelp.getPPAttElementList(dataType, "Name", proName);
		if(property.size()==0)
			throw new Error("getFetchFinalValue propertyName error");
		if(!property.get(0).elementText("Value").equals(""))
			return property.get(0).elementText("Value");
		Element extendsPro = GOTHelper.getProperty(dataType,"Extends");
		if(extendsPro.attribute("refentityid") != null)
			return getFetchFinalValue(extendsPro.attributeValue("refentityid"),proName);
		else
			return "";
	}
	
	public static Boolean doSpecialPro(Element spro){
		Boolean flag = false;
		if(spro.elementText("Name").equals("AllowEdit")){
			flag = true;
			if(spro.elementText("Value").equals("")){
				spro.element("Value").setText("true");
			}
		}else if(spro.elementText("Name").equals("Visible")){
			flag = true;
			if(spro.elementText("Value").equals("")){
				spro.element("Value").setText("true");
			}
		}else if(spro.elementText("Name").equals("NotNull")){
			flag = true;
			if(spro.elementText("Value").equals("")){
				spro.element("Value").setText("true");
			}
		}
		
		return flag;
	}
	
	@SuppressWarnings({ "unchecked", "null" })
	public static void clearIfExtends(Element item, ResolverNode rNode){
		List<Element> elements = item.element("Properties").elements("Property");
		for (Element property : elements){
			if(property.elementText("Name").equals("CreatedDate"))
				break;
			if("ifExtends".equals(rNode.getPropertyValue(property.elementText("Name"), "Nonblank")))
				property.element("Value").setText("");	
			if("fetch".equals(rNode.getPropertyValue(property.elementText("Name"),"Nonblank"))){
				List<Element> extendsPro = GOTHelp.getPPAttElementList(item, "Name", "Extends"); 
				if(extendsPro != null || extendsPro.size()==0)
					throw new Error("fetch不被关联到Extends");
				if(extendsPro.get(0).attribute("refentityid") != null){
					property.element("Value").setText(getFetchFinalValue(extendsPro.get(0).attributeValue("refentityid"),property.elementText("Name")));
				}
			}
		}
	}
	
	public FormItemHelper(){
		
	}
}
