package client.gongqi.designer.got.node.form;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

import client.gongqi.designer.got.node.NodeFactory;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.resolvergot.ResolverNode;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import gongqi.designer.utils.GOTHelper;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;

public class FormItemDragController implements IFormItemDragController{
	
	private static IFormItemDragController instance;
	public static IFormItemDragController getInstance(){
		if(instance == null)
			instance = new FormItemDragController();
		return instance;
	}

	@SuppressWarnings("unchecked")
	@Override
	public void doAccpDragNewAfter(Element src, NodeGOT node) {
		Element nodeXML = node.xml;
		String extendName = src.attributeValue("name");
		
		if(src.getName().equals("Enum")){
			GOTXMLHelper.setProperty(nodeXML,"Extends",extendName,true);
			GOTHelp.getPPAttElement(nodeXML, "Name", "Extends").addAttribute("refentityid", src.attributeValue("id"));
			GOTXMLHelper.setProperty(nodeXML,"Source","Enum",true);
			//Enum 去掉前缀
			String exName = src.attributeValue("name");
			if(exName.contains(".")){
				String[] name = exName.split("\\.");
				exName = name[name.length - 1];
			}
			nodeXML.addAttribute("name", exName);
			doIfExtendsForDrag(nodeXML,node.rNode, src.attributeValue("id"));
		}else if(src.getName().equals("DataType")){
			if(nodeXML.attributeValue("type").equals("FieldGroup")){
				GOTHelp.getPPAttElement(nodeXML, "Name", "Component").addAttribute("refentityid", src.attributeValue("id"));
				GOTHelp.getPPAttElement(nodeXML, "Name", "Component").element("Value").setText(extendName);;
				nodeXML.addAttribute("editOnCreate", "true");
			}else{
				GOTXMLHelper.setProperty(nodeXML,"Extends",extendName,true);
				GOTHelp.getPPAttElement(nodeXML, "Name", "Extends").addAttribute("refentityid", src.attributeValue("id"));
				if(nodeXML.attributeValue("type").equals("EnumEditor")){
					GOTXMLHelper.setProperty(nodeXML,"Source","DataType",true);
				}
				doIfExtendsForDrag(nodeXML, node.rNode, src.attributeValue("id"));
			}
			//DataType 去掉前缀
			String exName = src.attributeValue("name");
			if(exName.contains(".")){
				String[] name = exName.split("\\.");
				exName = name[name.length - 1];
			}
			nodeXML.addAttribute("name", exName);
			if(nodeXML.attributeValue("type").equals("Component") || nodeXML.attributeValue("type").equals("FieldGroup")){
				List<Element> elements = src.element("DataTypeArray").elements("DataTypeArrayItem");
				for (Element arrayItem : elements){
					List<Element> refDataTypePro = GOTHelp.getPPAttElementList(arrayItem, "Name", "RefDataType");
//					String xpath = "DataDictionary/DataTypes/DataType[@id='" + refDataTypePro.get(0).attributeValue("refentityid") + "']";
//					List<Element> refDataType = NodeGOT.gotXML.selectNodes(xpath);
					Element refDataType = GotXmlDto.getInstance().currentEntityByTypeAndId("DataType", refDataTypePro.get(0).attributeValue("refentityid"));
					String type = FormItemHelper.getFormItemTypeByType(refDataType.attributeValue("type"));
					NodeGOT subNode = NodeFactory.createNode("FormItem", type, "");
					if(type.equals("EnumEditor")){
						GOTXMLHelper.setProperty(subNode.xml,"Source","DataType",true);
					}
					List<Element> extendsPro = GOTHelp.getPPAttElementList(subNode.xml, "Name", "Extends");
					extendsPro.get(0).addAttribute("refentityid", refDataType.attributeValue("id"));
					extendsPro.get(0).element("Value").setText(refDataType.attributeValue("name"));
					subNode.xml.addAttribute("name", src.attributeValue("name") +"_"+ arrayItem.attributeValue("name"));
					doIfExtendsForDrag(subNode.xml,subNode.rNode, refDataType.attributeValue("id"));
					nodeXML.add(subNode.xml.detach());
				}
			}
		}else if(src.getName().equals("FormDataSourceField")){
			Element dataSource = src.getParent().getParent();
			GOTXMLHelper.setProperty(nodeXML, "DataSource", dataSource.attributeValue("name"), true);
			GOTHelp.getPPAttElement(nodeXML, "Name", "DataSource").addAttribute("innerid", dataSource.attributeValue("id"));
			String name = dataSource.attributeValue("name") +"_"+ src.attributeValue("name").replace(".","_");
			Element DataSourceTypeElement = GOTHelp.getPPAttElement(dataSource, "Name", "DataSourceType");
			if("Aggregate".equals(DataSourceTypeElement.elementText("Value"))){//如果是聚合表
				Element AggregateTypeFile = GOTHelp.getPPAttElement(src, "Name", "AggregateType");
				String AggValue = AggregateTypeFile.elementText("Value");
				if(StringUtils.isNotBlank(AggValue)){//字段的聚合属性
					name = dataSource.attributeValue("name") + "_Aggregate" + "_" + AggValue  + "_" + src.attributeValue("name");
				}
			}
			nodeXML.addAttribute("name", name);
			List<Element> fieldPro = GOTHelp.getPPAttElementList(src, "Name", "Field");
			if(nodeXML.attributeValue("type").equals("FieldGroup")){
				List<Element> componentPro = GOTHelp.getPPAttElementList(nodeXML, "Name", "Component");
				componentPro.get(0).addAttribute("refentityid", fieldPro.get(0).attributeValue("refentityid"));
				componentPro.get(0).addAttribute("refinnerid", fieldPro.get(0).attributeValue("refinnerid"));
				componentPro.get(0).element("Value").setText(src.attributeValue("name"));
				Element visiblePro = GOTHelper.getProperty(nodeXML,"Visible");
				Element allowEditPro = GOTHelper.getProperty(nodeXML,"AllowEdit");
				visiblePro.element("Value").setText("");
				allowEditPro.element("Value").setText("");
				FormItemHelper.clearIfExtends(nodeXML,node.rNode);
			}
			List<Element> subfieldPro;
			List<Element> subDataSourcePro ;
			List<Element> extendsPro ;
			if(src.attributeValue("type").equals("Component")){
				List<Element> elements = dataSource.element("FormDataSourceFields").elements("FormDataSourceField");
				for(Element dataSourceField : elements){
					subfieldPro = GOTHelp.getPPAttElementList(dataSourceField, "Name", "Field");
					if(subfieldPro.get(0).attributeValue("refinnerid").equals(fieldPro.get(0).attributeValue("refinnerid")) && (subfieldPro.get(0) != fieldPro.get(0))){
						NodeGOT subNode = NodeFactory.createNode("FormItem",FormItemHelper.getFormItemTypeByType(dataSourceField.attributeValue("type")),"");
						extendsPro = GOTHelp.getPPAttElementList(subNode.xml, "Name", "Extends");
						subDataSourcePro = GOTHelp.getPPAttElementList(subNode.xml, "Name", "DataSource");
						subDataSourcePro.get(0).addAttribute("innerid", dataSource.attributeValue("id"));
						subDataSourcePro.get(0).element("Value").setText(dataSource.attributeValue("name"));
						
						extendsPro.get(0).addAttribute("refentityid", fieldPro.get(0).attributeValue("refentityid"));
						extendsPro.get(0).addAttribute("refinnerid", fieldPro.get(0).attributeValue("refinnerid"));
						extendsPro.get(0).element("Value").setText(dataSourceField.attributeValue("name"));
						FormItemHelper.clearIfExtends(subNode.xml, subNode.rNode);
						subNode.xml.addAttribute("name", dataSource.attributeValue("name")+ "_"+ dataSourceField.attributeValue("name").replace(".","_"));
						nodeXML.add(subNode.xml.detach());
					}
				}
			}else{
				GOTXMLHelper.setProperty(nodeXML,"Extends",extendName,true);
				GOTHelp.getPPAttElement(nodeXML, "Name", "Extends").addAttribute("refentityid", fieldPro.get(0).attributeValue("refentityid"));
				GOTHelp.getPPAttElement(nodeXML, "Name", "Extends").addAttribute("refinnerid", fieldPro.get(0).attributeValue("refinnerid"));
				FormItemHelper.clearIfExtends(nodeXML,node.rNode);
			}
		}else if(src.getName().equals("MenuItem")){
			String tar = src.attributeValue("name");
			GOTHelp.getPPAttElement(nodeXML, "Name", "MenuItem").element("Value").setText(tar);
		}
		
	}

	@SuppressWarnings("unchecked")
	@Override
	public void doAccpDragNewAfterForFormDataSourceFieldGroup(Element src, NodeGOT node) {
		Element dataSource = src.getParent().getParent();
		GOTXMLHelper.setProperty(node.xml,"DataSource",dataSource.attributeValue("name"),true);
		node.xml.addAttribute("name", dataSource.attributeValue("name") +"_"+ src.attributeValue("name"));
		GOTHelp.getPPAttElement(node.xml, "Name", "DataSource").addAttribute("innerid", dataSource.attributeValue("id"));
		GOTHelp.getPPAttElement(node.xml, "Name", "DataSource").element("Value").setText(dataSource.attributeValue("name"));
		
		List<Element> property = GOTHelp.getPPAttElementList(node.xml, "Name", "FieldGroup");
		property.get(0).element("Value").setText(src.attributeValue("name"));
		
		List<Element> dataSourceFieldGroupFieldGroupPro = GOTHelp.getPPAttElementList(src, "Name", "FieldGroup");
//		String xpath = "DataDictionary/Tables/Table[@id='" + dataSourceFieldGroupFieldGroupPro.get(0).attributeValue("refentityid") + "']";
//		List<Element> table = NodeGOT.gotXML.selectNodes(xpath);
		Element table = GotXmlDto.getInstance().currentEntityByTypeAndId("Table", dataSourceFieldGroupFieldGroupPro.get(0).attributeValue("refentityid"));
		String xpath = "TableFieldGroups/TableFieldGroup[@id='" + dataSourceFieldGroupFieldGroupPro.get(0).attributeValue("refinnerid") + "']";
		List<Element> tableFieldGroup = table.selectNodes(xpath);		
		property.get(0).addAttribute("refentityid", table.attributeValue("id"));
		property.get(0).addAttribute("refinnerid", tableFieldGroup.get(0).attributeValue("id"));
		
		List<Element> tableField ;
		List<Element> extendsPro ;
		List<Element> dataSourcePro ;
		Element dataType ;
		String type;
		NodeGOT subNode;
		List<Element> refDataTypePro ;
		Element refDataType ;
		List<Element> elements = tableFieldGroup.get(0).elements("TableFieldGroupItem");
		for(Element tableFieldGroupItem : elements){
			xpath = "TableFields/TableField[@id=" + GOTHelp.getPPAttElement(tableFieldGroupItem, "Name", "Field").attributeValue("innerid") + "]";
			tableField = table.selectNodes(xpath);
			extendsPro = GOTHelp.getPPAttElementList(tableField.get(0), "Name", "Extends");
			
			if(tableField.get(0).attributeValue("type").equals("Component")){
				if(extendsPro.get(0).attribute("refentityid") == null)
					continue;
//				xpath = "DataDictionary/DataTypes/DataType[@id='" + extendsPro.get(0).attributeValue("refentityid") + "']";
//				dataType = NodeGOT.gotXML.selectNodes(xpath);
				dataType = GotXmlDto.getInstance().currentEntityByTypeAndId("DataType", extendsPro.get(0).attributeValue("refentityid"));
				List<Element> elements2 = dataType.element("DataTypeArray").elements("DataTypeArrayItem");
				for(Element arrayItem : elements2){
					refDataTypePro = GOTHelp.getPPAttElementList(arrayItem, "Name", "RefDataType");
//					xpath = "DataDictionary/DataTypes/DataType[@id='" + refDataTypePro.get(0).attributeValue("refentityid") + "']";
//					refDataType = NodeGOT.gotXML.selectNodes(xpath);
					refDataType = GotXmlDto.getInstance().currentEntityByTypeAndId("DataType", refDataTypePro.get(0).attributeValue("refentityid"));
					type = FormItemHelper.getFormItemTypeByType(refDataType.attributeValue("type"));
					subNode = NodeFactory.createNode("FormItem",type,"");
					extendsPro = GOTHelp.getPPAttElementList(subNode.xml, "Name", "Extends");
					dataSourcePro = GOTHelp.getPPAttElementList(subNode.xml, "Name", "DataSource");
					
					extendsPro.get(0).addAttribute("refentityid", table.attributeValue("id"));
					extendsPro.get(0).addAttribute("refinnerid", tableField.get(0).attributeValue("id"));
					extendsPro.get(0).element("Value").setText(tableField.get(0).attributeValue("name") + "." + arrayItem.attributeValue("name"));
					
					FormItemHelper.clearIfExtends(subNode.xml,subNode.rNode);
					
					subNode.xml.addAttribute("name", dataSource.attributeValue("name")+"_"+extendsPro.get(0).elementText("Value").replace(".","_"));
					dataSourcePro.get(0).addAttribute("innerid", dataSource.attributeValue("id"));
					dataSourcePro.get(0).element("Value").setText(dataSource.attributeValue("name"));
					node.xml.add(subNode.xml.detach());
				}
				
			}else{
				type = FormItemHelper.getFormItemTypeByType(tableField.get(0).attributeValue("type"));
				
				subNode = NodeFactory.createNode("FormItem",type,"");
				extendsPro = GOTHelp.getPPAttElementList(subNode.xml, "Name", "Extends");
				dataSourcePro = GOTHelp.getPPAttElementList(subNode.xml, "Name", "DataSource");
				extendsPro.get(0).addAttribute("refentityid", table.attributeValue("id"));
				extendsPro.get(0).addAttribute("refinnerid", tableField.get(0).attributeValue("id"));
				extendsPro.get(0).element("Value").setText(tableField.get(0).attributeValue("name"));
				dataSourcePro.get(0).addAttribute("innerid", dataSource.attributeValue("id"));
				dataSourcePro.get(0).element("Value").setText(dataSource.attributeValue("name"));
				FormItemHelper.clearIfExtends(subNode.xml,subNode.rNode);
				subNode.xml.addAttribute("name", dataSource.attributeValue("name")+"_"+extendsPro.get(0).elementText("Value"));
				node.xml.add(subNode.xml.detach());
			}
		}
	}

	@SuppressWarnings("unchecked")
	private void doIfExtendsForDrag(Element item, ResolverNode _rNode, String refentityId){
		List<Element> elements = item.element("Properties").elements("Property");
		for (Element property : elements){
			if(property.elementText("Name").equals("CreatedDate"))
				break;
			if(FormItemHelper.doSpecialPro(property))
				continue;
			if(_rNode.getPropertyValue(property.elementText("Name"),"Nonblank").equals("ifExtends"))
				property.element("Value").setText("");
			if(_rNode.getPropertyValue(property.elementText("Name"),"Nonblank").equals("fetch")){
				property.element("Value").setText(FormItemHelper.getFetchFinalValue(refentityId,property.elementText("Name")));
			}
		}
	}
	
	public FormItemDragController(){
	}
}
