package client.gongqi.designer.got.node.datatype;

import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GotLayerAndUserDialog;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;

import client.gongqi.designer.got.node.Branch;

public class DataTypeRelation extends Branch{
	
		//ZSG 判断某个节点是否应该在下拉列表中 总体规则：visible fixVisible 是否当前层 下层看不到上层
		//APP内看不到旁边
		private boolean isContainsDropList(Element element)
		{
			Attribute attribute = element.attribute("fixVisible");
			if(attribute != null)
			{
				if(attribute.getValue().equals("false"))
				{
					return false;
				}
			}
			
			Attribute att = element.attribute("visible");
			if(att != null)
			{
				if(att.getValue().equals("false"))
				{
					String createLayer = element.attributeValue("createdLayer");
					if(!createLayer.equals(ObjectContainer.getInstance(LayerService.class).getCurrentLayer()))
					{
						return false;
					}
				}
			}
			String modifiedLayer = element.attributeValue("modifiedLayer");
			String id = element.attributeValue("id");
			if("app".equals(GotLayerAndUserDialog.layer))
			{
				if("ext".equals(modifiedLayer))
				{
					return false;
				}
				
				if(id.contains(".") && !id.startsWith(GotLayerAndUserDialog.solution))
				{
					return false;
				}
			}
			else if("ext".equals(GotLayerAndUserDialog.layer))
			{
				if("ext".equals(modifiedLayer) || "app".equals(modifiedLayer))
				{
					if(id.contains(".") && !id.startsWith(GotLayerAndUserDialog.solution))
					{
						return false;
					}
				}
			}
			
			return true;
		}
		
		//ZSG 属性下拉的时候判断是否在下拉列表 并返回给控件数据源
		private List<String> filterDropArray(List<Element> elements)
		{
			List<String> array = new ArrayList<>();
			
			array.add("");
			
			for(Element element : elements)
			{
				if(this.isContainsDropList(element))
					array.add(element.attributeValue("name"));
			}
			return array;
		}
		
		@SuppressWarnings("unchecked")
		private List<String> getMenuItemArray()
		{
//			String xpath = "MenuItems/MenuItem";
//			List<Element> elements = NodeGOT.gotXML.selectNodes(xpath);
			List<Element> elements = GotXmlDto.getInstance().currentElements("MenuItems");
			return this.filterDropArray(elements);
			
		}
		
		@SuppressWarnings("unchecked")
		@Override
		public List<String> getPropertyItemEditorArray(String propertyName, 
				String fixedRegular, Element fixedBaseXML) {
			if ("RefMenuItem".equals(propertyName)) {				
				return this.getMenuItemArray();
			} else if("Table".equals(propertyName)){
//				List<Element> tableEleents = NodeGOT.gotXML.selectNodes("./DataDictionary/Tables/Table");
				List<Element> tableEleents = GotXmlDto.getInstance().currentElements("Tables");
				return this.filterDropArray(tableEleents);
			} else if ("Field".equals(propertyName) || "FilterField".equals(propertyName)){
				Element tableProperty = (Element) fixedBaseXML.selectSingleNode(
						"./Properties/Property/Name[text()='Table']/..");
				if (tableProperty.attribute("refentityid") != null && 
						StringUtils.isNotBlank(tableProperty.attributeValue("refentityid"))) {
//					Element tableElement = (Element) NodeGOT.gotXML.selectSingleNode(String.format("./DataDictionary/Tables/Table[@id='%s']", 
//							tableProperty.attributeValue("refentityid")));
					Element tableElement = (Element) GotXmlDto.getInstance().currentEntityByTypeAndId("Table", tableProperty.attributeValue("refentityid"));
					List<Element> tableFieldElements = tableElement.selectNodes("./TableFields/TableField[@type='String']");
					return this.filterDropArray(tableFieldElements);
				}
			}
			
			return super.getPropertyItemEditorArray(propertyName, fixedRegular, fixedBaseXML);
		}
	
	
}
