package client.gongqi.designer.got.node.datatype;

import gongqi.designer.services.LayerService;
import gongqi.designer.utils.GOTHelper;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.gotmodel.core.EntityType;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.util.GOTMessageDialog;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Attribute;
import org.dom4j.Element;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;

import client.gongqi.designer.got.node.Entity;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import client.gongqi.designer.toolsgot.Macros;

public class DataType extends Entity{

	@Override
	public List<String> getPropertyItemEditorArray(String propertyName, String fixedRegular, Element fixedBaseXML){
		if(this.xml.attributeValue("type").equals("Enum") && propertyName.equals("Extends")){
//			String xpath = "";
			if(GOTHelp.getPPAttValue(xml, "Name", "Source").equals("Enum")){
//				xpath = "DataDictionary/Enums";
//				Element element = (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
				List<Element> elements =GotXmlDto.getInstance().currentElements("Enums");
				return super.getPropertyItemEditorArray(propertyName,"Enum", elements.get(0));
			}else{
//				xpath = "DataDictionary/DataTypes";
//				Element element = (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
				List<Element> elements =GotXmlDto.getInstance().currentElements("DataTypes");
				return super.getPropertyItemEditorArray(propertyName, "DataType[@type='Enum' and @saved!='0']", elements.get(0));
			}
		}else{
			return super.getPropertyItemEditorArray(propertyName, "", null);
		}
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void doAfterPropertyModified(Element property, String...args){
		String origValue = args[0];
		if(property.elementText("Name").equals("Source")){
			List<Element> extendsPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Extends");
			if(!extendsPro.get(0).elementText("Value").equals("")){
				extendsPro.get(0).element("Value").setText("");
				super.doAfterPropertyModified(extendsPro.get(0), args);
				return ;
			}
		}
		
		if(property.elementText("Name").equals("Extends") && this.xml.attributeValue("type").equals("Enum")){
			if(!property.elementText("Value").equals("")){	
				List<Element> sourcePro = GOTHelp.getPPAttElementList(this.xml, "Name", "Source");
				String sourceType = sourcePro.get(0).elementText("Value");
				String sourceName = property.elementText("Value");
				String refentityId;
				if(sourceType.equals("Enum")){
//					String xpath = "DataDictionary/Enums/Enum[@name='" + sourceName + "']";
//					Element element = (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
					List<Element> elements = GotXmlDto.getInstance().currentElements("Enums", "name", sourceName);
					Element element = elements.get(0);
					refentityId = element.attributeValue("id");
				}else{
//					String xpath = "DataDictionary/DataTypes/DataType[@name='" + sourceName + "']";
//					Element element = (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
					List<Element> elements = GotXmlDto.getInstance().currentElements("DataTypes", "name", sourceName);
					Element element = elements.get(0);
					refentityId = element.attributeValue("id");
				}
				property.attribute("refentityid").setValue(refentityId);
				
				if(this.isDeadLock(refentityId, refentityId)){
					GOTMessageDialog.alert("存在非法继承");
					property.element("Value").setText(origValue);
					List<Attribute> attributes = new ArrayList<>();
					attributes.addAll(property.attributes());
					for (Attribute attribute : attributes) {
						property.remove(attribute);
					}
					return ;
				}	
			}else{
				List<Attribute> attributes = new ArrayList<>();
				attributes.addAll(property.attributes());
				for (Attribute attribute : attributes) {
					property.remove(attribute);
				}
				return ;
			}
			super.doAfterPropertyModified(property,args);
			
		}else{
			this.setUnsaved();
			this.addRelation(property);
			if(property.attribute("refentityid") != null ){
				String refentityId = property.attributeValue("refentityid"); 
				if(this.isDeadLock(refentityId,refentityId)){
					GOTMessageDialog.alert("存在非法继承");
					property.element("Value").setText(origValue);
					List<Attribute> attributes = new ArrayList<>();
					attributes.addAll(property.attributes());
					for (Attribute attribute : attributes) {
						property.remove(attribute);
					}
					return ;
				}
			}
			this.doIfExtendsAndFecth(property);
			this.doPropertyTrigger(property);
		}

	}
	
	@SuppressWarnings("unchecked")
	private Boolean isDeadLock(String srcId, String extendsId){
		Element itemList = GotXmlDto.getInstance().currentEntityByTypeAndId("DataType", extendsId);
		if(itemList == null)
			return false;
		
		Element item = itemList;
		Element loopExtendsPro = GOTHelp.getPPAttElement(item, "Name", "Extends");
		if(loopExtendsPro.attribute("refentityid") == null ){
			return false;
		}
		String loopId = loopExtendsPro.attributeValue("refentityid");
		if(loopId.equals(srcId)){
			return true;
		}
		return isDeadLock(srcId,loopId);
	}
	
	@Override
	protected Boolean isIfExtendsRelated(String proName){
		if(proName != null){
			if(proName.equals("Extends"))
				return true;
			return false;
		}
			
		List<Element> extendsPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Extends");
		if(extendsPro.get(0).attribute("refentityid") == null )
			return true;
		
		return false;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected String validateOther(){
		String result = super.validateOther();
		String type = this.xml.attributeValue("type");
		if(result.equals("true") && type.equals("String")){
			List<Element> elements = this.xml.selectNodes("/DataTypeRelation");
			if(elements == null || elements.isEmpty()){
				return result;
			}
			Element relation = elements.get(0);

			Element tablePro = GOTHelper.getProperty(relation, "Table");
			List<Element> relationItems = relation.elements("DataTypeRelationItem");
			if(tablePro.attribute("refentityid") != null){
				Boolean hasNormal = false;
				Element fieldPro;
				String fieldId;
				String tableId = tablePro.attributeValue("refentityid");
				for(Element item : relationItems){
					if(item.attributeValue("type").equals("Normal") && !hasNormal)
						hasNormal = true;
					fieldPro = GOTHelper.getProperty(item,"Field");
					fieldId = fieldPro.attributeValue("refentityid");
					if(tableId != fieldId){
						return Macros.INFO_FALSE + ":RelationItem 与 Relation 关联不匹配";
					}
				}
				
				if(!hasNormal)
					result = Macros.INFO_FALSE + ":至少要有一个Normal类型的DataTypeRelationItem";
			}else{
				if(relationItems.size() > 0)
					result = Macros.INFO_FALSE + ":多出DataTypeRelationItem";
			}
		}else if(result.equals("true") && type == "Component"){
			List<Element> arrayItems = this.xml.selectNodes("/DataTypeArray/DataTypeArrayItem");
			if(arrayItems.size()==0){
				return Macros.INFO_FALSE + ":至少要有一个DataTypeArrayItem";
			}
			
			for (Element arrayItem : arrayItems){
				String _name = arrayItem.attributeValue("name");
				if(_name.indexOf("_")!=-1){
					return Macros.INFO_FALSE + ":DataTypeArrayItem的名字中不能含有下划线_";
				}
			}
		}
		
		return result;
	}
	
	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node;
		if(src.getName().equals("TableField")){
			node = super.doAccpDragNew("DataType", src.attributeValue("type"));
			this.doAccpDragNewAfer(src, node.xml);
			return node;
		}
		return null;
	}
	
	@SuppressWarnings("unused")
	private void doAccpDragNewAfer(Element src, Element node){
		Element stringSizePro = GOTHelper.getProperty(src, "StringSize");
		Element targetPro;
		if(stringSizePro != null){
			targetPro = GOTHelper.getProperty(node,"StringSize");
			GOTXMLHelper.setProperty(node,"StringSize", stringSizePro.elementText("Value"), true);
		}
		
		Element numOfDecimalsPro = GOTHelper.getProperty(src,"NumOfDecimals");
		if(numOfDecimalsPro != null){
			targetPro = GOTHelper.getProperty(node,"NumOfDecimals");
			GOTXMLHelper.setProperty(node,"NumOfDecimals",numOfDecimalsPro.elementText("Value"), true);
		}
		
		Element displayLengthProSrc = GOTHelper.getProperty(src,"DisplayLength");
		if(displayLengthProSrc != null){
			targetPro = GOTHelper.getProperty(node, "DisplayLength");
			GOTXMLHelper.setProperty(node,"DisplayLength",displayLengthProSrc.elementText("Value"), displayLengthProSrc.elementText("Value").equals("")?false:true);
		}
		
		Element labelPro = GOTHelper.getProperty(src,"Label");
		if(labelPro != null){
			targetPro = GOTHelper.getProperty(node,"Label");
			GOTXMLHelper.setProperty(node,"Label",labelPro.elementText("Value"), labelPro.elementText("Value").equals("")?false:true);
		}
		
		node.addAttribute("name", src.attributeValue("name"));
		
		if(src.attributeValue("type").equals("String")){
			MessageBox messageBox = new MessageBox(GOTMessageDialog.shell, SWT.YES|SWT.NO);
			messageBox.setText("提示");
			messageBox.setMessage("是否自动加入主表关联");
			int result = messageBox.open();
			addMainTableHandler(result, src, node);
		}
	}
	
	private void addMainTableHandler(int event, Element src, Element node){
		if(event == SWT.YES){
			Element relation = node.element("DataTypeRelation");
			if(relation == null){
				relation = GOTXMLHelper.dataTypeRelationXML.createCopy();
				String currentLayer = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
				relation.addAttribute("createdLayer", currentLayer);
				relation.addAttribute("modifiedLayer", currentLayer);
				node.add(relation.detach());
			}
			if(relation != null){
				Element tablePro = GOTHelper.getProperty(relation, "Table");
				Element srcEntity = NodeGOT.getEntity(src);
				if(tablePro != null){
					tablePro.element("Value").setText(srcEntity.attributeValue("name"));
					tablePro.addAttribute("refentityid", srcEntity.attributeValue("id"));
				}
				
				Element fieldPro = GOTHelper.getProperty(relation, "Field");
				fieldPro.addAttribute("refentityid", srcEntity.attributeValue("id"));
				fieldPro.addAttribute("refinnerid", src.attributeValue("id"));
				fieldPro.element("Value").setText(src.attributeValue("name"));
				
				/*NodeGOT relationItemNode = NodeFactory.createNode("DataTypeRelationItem","Normal","");
				Element rinXML = relationItemNode.xml;
				rinXML.addAttribute("id", "1");
				node.addAttribute("nextInnerId", "2");
				Element fieldPro = GOTHelper.getProperty(rinXML, "Field");
				fieldPro.addAttribute("refentityid", srcEntity.attributeValue("id"));
				fieldPro.addAttribute("refinnerid", src.attributeValue("id"));
				fieldPro.element("Value").setText(src.attributeValue("name"));
				String _name = "this==" + srcEntity.attributeValue("name") + "." + src.attributeValue("name");
				rinXML.addAttribute("name", _name);
				relation.add(rinXML.detach());*/
				
			}
		}
		
	}
	
	@Override
	public String getAccpDragNewInsertBase(){
		return "parent";
	}
	
	@Override
	public String validateAccpDragNew(Element srcItem){
		if(srcItem.getName().equals("TableField")){
			Element extendsPro = GOTHelper.getProperty(srcItem, "Extends");
			if(extendsPro.attribute("refentityid") != null )
				return "TableField节点已存在继承关系";
		}
		
		String type = srcItem.attributeValue("type");
		if(type.equals("Enum") || type.equals("Component"))
			return "当前类型不支持拖动产生DataType";
		
		return "true";
	}
	
	@Override
	public void doAfterDragDroped(){
		String id = "";
		try {
			id = LoadXmlCore.gotServices.getEntityId(EntityType.DataType);
		} catch (Exception e) {
			e.printStackTrace();
			GOTMessageDialog.alert(e);
		}
		this.xml.addAttribute("id", id);
	}
	
}
