package client.gongqi.designer.got.node;

import org.dom4j.Element;

import client.gongqi.designer.resolvergot.ResolverNode;
import client.gongqi.designer.resolvergot.ResolverNodeFactory;

public class NodeFactory {

	public NodeFactory(){
		
	}
	
	private static NodeGOT initNode(String className, String type){
		ResolverNode rNode = ResolverNodeFactory.getRNode(className, type);
		String packageName = "client.gongqi.designer.got.node.";
		String entityName = "";
		Element rXml = rNode.getNode();
		while(rXml!=null){
			if(rXml.attributeValue("name").equals("GOT")){
				packageName = "client.gongqi.designer.got.node";
				entityName = "";
				break;					
			}else if(rXml.element("Info").elementText("NodeType").equals("entity")){
				entityName = rXml.attributeValue("name");
				break;
			}else{
				rXml = rXml.getParent();
			}
		}
		
		if(packageName.equals("client.gongqi.designer.got.node.") && entityName.equals("Class")){
			entityName = "Classes";
			className = "Class2";
		}
		
		//enum在java中是关键字，不能用于包名，这里改成gotenum
		if(entityName.toLowerCase().equals("enum")){
			entityName = "gotenum";
		}
		
		String clsName = packageName + entityName.toLowerCase() + "." + className;
		NodeGOT node = null;
		try {
			Class<?> cls = Class.forName(clsName);
			node = (NodeGOT)cls.newInstance();
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}
		node.rNode = rNode;
		return node;
	}
	
	
	public static NodeGOT createNode(String className, String type, String id){
		NodeGOT node = initNode(className, type);
		node.createXml(id);
		return node;
	}

	public static NodeGOT getNode(Element item){
		NodeGOT node = initNode(item.getName(), item.attributeValue("type"));
		node.xml = item;
		return node;
	}
}

