package client.gongqi.designer.got.node;

import gongqi.designer.utils.GOTHelper;

import org.dom4j.Element;

import client.gongqi.designer.toolsgot.GOTXMLHelper;

public class MenuItems extends Outer{
	
	public MenuItems(){
		super();
	}

	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node = super.doAccpDragNew("MenuItem", "");
		this.doAccpDragNewAfter(src,node.xml);
		return node;
	}
	
	private void doAccpDragNewAfter(Element src, Element node){
		String srcName = src.getName();
		GOTXMLHelper.setProperty(node,"SourceType",srcName,true);
		GOTXMLHelper.setProperty(node,"Source", src.attributeValue("name"), true);
	}
	
	@Override
	public String getAccpDragNewInsertBase(){
		return "self";
	}
	
	@Override
	public String validateAccpDragNew(Element srcItem){
		
		if(srcItem != null)
		{
			String qName = srcItem.getName();
			if("Form".equals(qName))
			{
				String formType = GOTHelper.getPropertyValue(srcItem, "FormType");
				if("Lookup".equals(formType))
				{
					return "FormType属性为Lookup的Form不允许被拖动到MenuItem";
				}
			}
		}
		
		return "true";
	}
}
