package client.gongqi.designer.got.node;

import gongqi.erp.gotmodel.core.EntityType;
import gongqi.erp.gotmodel.core.GOTHelper;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.util.GOTMessageDialog;

import org.dom4j.Element;

public class Forms extends Outer{
	
	public Forms(){
		super();
	}

	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node;
		if(src.getName().equals("Table")){
			node = super.doAccpDragNew("Form", "");
			this.doAccpDragNewAfer(src,node.xml);
			return node;
		}
		
		return null;
	}
	
	private void doAccpDragNewAfer(Element src, Element node){
		node.attribute("name").setValue(src.attributeValue("name"));
		NodeGOT ds = NodeFactory.createNode("FormDataSource","","");
		Element dss = node.element("FormDataSources");
		Element tablePro = GOTHelper.getProperty(ds.xml,"Table");
		tablePro.element("Value").setText(src.attributeValue("name"));
		tablePro.addAttribute("refentityid", src.attributeValue("id"));
		dss.add(ds.xml.detach());
	}
	
	@Override
	public String getAccpDragNewInsertBase(){
		return "self";
	}
	
	@SuppressWarnings("unused")
	@Override
    public void doAfterDragDroped(){
		Element ds = this.xml.element("FormDataSources").element("FormDataSource");
		Element formDesign = this.xml.element("FormDesign");
		ds.attribute("id").setValue("1");
		if(ds != null){
			Element tablePro = GOTHelper.getProperty(ds,"Table");
			NodeGOT dsNode = NodeFactory.getNode(ds);
			dsNode.doAfterPropertyModified(tablePro);
		}
		String id = "";
		try {
			id = LoadXmlCore.gotServices.getEntityId(EntityType.Form);
		} catch (Exception e) {
			e.printStackTrace();
			GOTMessageDialog.alert(e);
		}
		this.xml.addAttribute("id", id);
	}
}
