/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.tool;

import gongqi.erp.framework.core.LayerDefination;
import gongqi.erp.framework.core.LayerDefinationManager;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinition;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinitionManager;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinition;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinitionManager;
import gongqi.erp.framework.core.solution.SolutionDefinition;
import gongqi.erp.framework.core.solution.SolutionDefinitionManager;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.erp.gotmodel.core.GOTLocator;
import gongqi.gdt.designer.utils.SWTUtils;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.util.GOTMessageDialog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xwpf.usermodel.BreakClear;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblLayoutType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVerticalJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblLayoutType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVerticalJc;

public class ExportDictionary
extends Dialog {
    public Shell shell;
    protected Object result;
    private Button NeedEnumDetail;
    private Button NeedDefaultFile;
    private Button NeedLayerInfo;
    private Label ExportType;
    private Label ExportConfig;
    private Label ExportConfig1;
    private Label ExportConfig2;
    private Button AsExcel;
    private Button AsWord;
    private Button confirm;
    private int line = 1;
    private CellStyle cellStyle;
    private CellStyle leftStyle;
    private CellStyle cellHead;
    private Map<String, Element> tableEntitys;
    private Map<String, Element> enumEntitys;
    private Map<String, Element> dateTypeEntitys;

    public ExportDictionary(Shell parent, int style) {
        super(parent, style);
        this.setText("\u5bfc\u51fa\u6570\u636e\u5b57\u5178");
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.setSize(SWTUtils.zoom(300), SWTUtils.zoom(220));
        this.shell.setText(this.getText());
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setLocation(SWTUtils.zoom(400), SWTUtils.zoom(300));
        this.ExportConfig = new Label((Composite)this.shell, 0);
        this.ExportConfig.setText("\u5bfc\u51fa\u679a\u4e3e\u9879: ");
        FormData formdata = new FormData();
        formdata.left = new FormAttachment(0, SWTUtils.zoom(20));
        formdata.top = new FormAttachment(0, SWTUtils.zoom(10));
        this.ExportConfig.setLayoutData((Object)formdata);
        this.NeedEnumDetail = new Button((Composite)this.shell, 32);
        formdata = new FormData();
        formdata.left = new FormAttachment((Control)this.ExportConfig, SWTUtils.zoom(10), 131072);
        formdata.top = new FormAttachment((Control)this.ExportConfig, 0, 128);
        this.NeedEnumDetail.setLayoutData((Object)formdata);
        this.NeedEnumDetail.setSelection(true);
        this.ExportConfig1 = new Label((Composite)this.shell, 0);
        this.ExportConfig1.setText("\u663e\u793a\u5c42\u4fe1\u606f:  ");
        formdata = new FormData();
        formdata.right = new FormAttachment((Control)this.ExportConfig, 0, 131072);
        formdata.top = new FormAttachment((Control)this.ExportConfig, SWTUtils.zoom(15), 1024);
        this.ExportConfig1.setLayoutData((Object)formdata);
        this.NeedLayerInfo = new Button((Composite)this.shell, 32);
        formdata = new FormData();
        formdata.left = new FormAttachment((Control)this.ExportConfig1, SWTUtils.zoom(10), 131072);
        formdata.top = new FormAttachment((Control)this.ExportConfig1, 0, 128);
        this.NeedLayerInfo.setLayoutData((Object)formdata);
        this.NeedLayerInfo.setSelection(true);
        this.ExportConfig2 = new Label((Composite)this.shell, 0);
        this.ExportConfig2.setText("RecordCM: ");
        formdata = new FormData();
        formdata.right = new FormAttachment((Control)this.ExportConfig1, 0, 131072);
        formdata.top = new FormAttachment((Control)this.ExportConfig1, SWTUtils.zoom(15), 1024);
        this.ExportConfig2.setLayoutData((Object)formdata);
        this.NeedDefaultFile = new Button((Composite)this.shell, 32);
        formdata = new FormData();
        formdata.left = new FormAttachment((Control)this.ExportConfig2, SWTUtils.zoom(10), 131072);
        formdata.top = new FormAttachment((Control)this.ExportConfig2, 0, 128);
        this.NeedDefaultFile.setLayoutData((Object)formdata);
        this.NeedDefaultFile.setSelection(true);
        this.ExportType = new Label((Composite)this.shell, 0);
        this.ExportType.setText("\u6587\u4ef6\u683c\u5f0f: ");
        formdata = new FormData();
        formdata.right = new FormAttachment((Control)this.ExportConfig2, 0, 131072);
        formdata.top = new FormAttachment((Control)this.ExportConfig2, SWTUtils.zoom(15), 1024);
        this.ExportType.setLayoutData((Object)formdata);
        this.AsExcel = new Button((Composite)this.shell, 32);
        this.AsExcel.setText("Excel");
        formdata = new FormData();
        formdata.left = new FormAttachment((Control)this.ExportType, SWTUtils.zoom(10), 131072);
        formdata.top = new FormAttachment((Control)this.ExportType, 0, 128);
        this.AsExcel.setLayoutData((Object)formdata);
        this.AsWord = new Button((Composite)this.shell, 32);
        this.AsWord.setText("Word");
        formdata = new FormData();
        formdata.left = new FormAttachment((Control)this.AsExcel, SWTUtils.zoom(20), 131072);
        formdata.top = new FormAttachment((Control)this.AsExcel, 0, 128);
        this.AsWord.setLayoutData((Object)formdata);
        this.confirm = new Button((Composite)this.shell, 0x800000);
        this.confirm.setText("\u786e\u5b9a");
        formdata = new FormData(SWTUtils.zoom(75), SWTUtils.zoom(32));
        formdata.bottom = new FormAttachment(100, SWTUtils.zoom(-10));
        formdata.left = new FormAttachment(0, SWTUtils.zoom(40));
        this.confirm.setLayoutData((Object)formdata);
        this.confirm.setEnabled(false);
        Button cancel = new Button((Composite)this.shell, 0x800000);
        cancel.setText("\u53d6\u6d88");
        formdata = new FormData(SWTUtils.zoom(75), SWTUtils.zoom(32));
        formdata.top = new FormAttachment((Control)this.confirm, 0, 128);
        formdata.right = new FormAttachment(100, SWTUtils.zoom(-40));
        cancel.setLayoutData((Object)formdata);
        this.AsExcel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!ExportDictionary.this.AsExcel.getSelection() && !ExportDictionary.this.AsWord.getSelection()) {
                    ExportDictionary.this.confirm.setEnabled(false);
                } else {
                    ExportDictionary.this.AsWord.setSelection(false);
                    ExportDictionary.this.confirm.setEnabled(true);
                }
            }
        });
        this.AsWord.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!ExportDictionary.this.AsExcel.getSelection() && !ExportDictionary.this.AsWord.getSelection()) {
                    ExportDictionary.this.confirm.setEnabled(false);
                } else {
                    ExportDictionary.this.AsExcel.setSelection(false);
                    ExportDictionary.this.confirm.setEnabled(true);
                }
            }
        });
        this.confirm.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog dialog = new FileDialog(ExportDictionary.this.shell, 8192);
                dialog.setFileName(String.format("\u6570\u636e\u5b57\u5178_%s.%s", new SimpleDateFormat("yyyyMMdd").format(new Date()), ExportDictionary.this.AsExcel.getSelection() ? "xls" : (ExportDictionary.this.AsWord.getSelection() ? "docx" : "")));
                String path = dialog.open();
                if (StringUtils.isNotBlank((String)path)) {
                    try {
                        if (ExportDictionary.this.AsExcel.getSelection()) {
                            ExportDictionary.this.exportAsExcel(path);
                        }
                        if (ExportDictionary.this.AsWord.getSelection()) {
                            ExportDictionary.this.exportAsWord(path);
                        }
                        GOTMessageDialog.info("\u5b8c\u6210\u5bfc\u51fa");
                        ExportDictionary.this.shell.dispose();
                    }
                    catch (IOException iOException) {
                        GOTMessageDialog.alert("\u5bfc\u51fa\u5931\u8d25");
                    }
                    catch (DocumentException documentException) {
                        GOTMessageDialog.alert("\u5bfc\u51fa\u5931\u8d25");
                    }
                }
            }
        });
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ExportDictionary.this.shell.dispose();
            }
        });
    }

    public void init() throws DocumentException {
        Element value;
        Document document;
        this.line = 1;
        this.tableEntitys = new HashMap<String, Element>();
        this.enumEntitys = new HashMap<String, Element>();
        this.dateTypeEntitys = new HashMap<String, Element>();
        Map tableMaps = ((GOTLocator)ObjectContainer.getInstance(GOTLocator.class)).getEntityDocumentMap(EntityType.Table);
        Map enumMaps = ((GOTLocator)ObjectContainer.getInstance(GOTLocator.class)).getEntityDocumentMap(EntityType.Enum);
        Map dataTypeMaps = ((GOTLocator)ObjectContainer.getInstance(GOTLocator.class)).getEntityDocumentMap(EntityType.DataType);
        for (String key : tableMaps.keySet()) {
            document = DocumentHelper.parseText((String)((String)tableMaps.get(key)));
            value = document.getRootElement();
            this.tableEntitys.put(key, value);
        }
        for (String key : enumMaps.keySet()) {
            document = DocumentHelper.parseText((String)((String)enumMaps.get(key)));
            value = document.getRootElement();
            this.enumEntitys.put(key, value);
        }
        for (String key : dataTypeMaps.keySet()) {
            document = DocumentHelper.parseText((String)((String)dataTypeMaps.get(key)));
            value = document.getRootElement();
            this.dateTypeEntitys.put(key, value);
        }
    }

    public void exportAsExcel(String path) throws IOException, DocumentException {
        HSSFRow row;
        this.init();
        String filePath = path;
        File file = new File(filePath);
        FileOutputStream outputStream = new FileOutputStream(file);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFFont font = workbook.getFontAt((short)0);
        font.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        HSSFSheet sheet = workbook.createSheet("\u6570\u636e\u5b57\u5178");
        sheet.setDefaultRowHeight((short)400);
        this.cellStyle = workbook.createCellStyle();
        this.cellStyle.setAlignment((short)2);
        this.cellStyle.setVerticalAlignment((short)1);
        this.cellStyle.setBorderBottom((short)1);
        this.cellStyle.setBorderLeft((short)1);
        this.cellStyle.setBorderTop((short)1);
        this.cellStyle.setBorderRight((short)1);
        this.cellHead = workbook.createCellStyle();
        this.cellHead.setAlignment((short)2);
        this.cellHead.setVerticalAlignment((short)1);
        this.cellHead.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        this.cellHead.setFillPattern((short)1);
        this.cellHead.setBorderBottom((short)1);
        this.cellHead.setBorderLeft((short)1);
        this.cellHead.setBorderTop((short)1);
        this.cellHead.setBorderRight((short)1);
        HSSFFont font2 = workbook.createFont();
        font2.setBold(true);
        font2.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        this.cellHead.setFont((Font)font2);
        this.leftStyle = workbook.createCellStyle();
        this.leftStyle.setAlignment((short)1);
        this.leftStyle.setVerticalAlignment((short)1);
        this.leftStyle.setBorderBottom((short)1);
        this.leftStyle.setBorderLeft((short)1);
        this.leftStyle.setBorderTop((short)1);
        this.leftStyle.setBorderRight((short)1);
        if (this.NeedLayerInfo.getSelection()) {
            sheet.setColumnWidth(0, 2048);
            sheet.setColumnWidth(1, 4608);
            sheet.setColumnWidth(2, 4608);
            sheet.setColumnWidth(3, 6400);
            sheet.setColumnWidth(4, 4096);
            sheet.setColumnWidth(5, 6400);
            sheet.setColumnWidth(6, 4096);
            sheet.setColumnWidth(7, 3072);
            sheet.setColumnWidth(8, 3072);
            sheet.setColumnWidth(9, 2560);
            sheet.setColumnWidth(10, 3072);
            sheet.setColumnWidth(11, 15360);
            sheet.createFreezePane(0, 1, 0, 1);
            row = sheet.createRow(0);
            row.createCell(0).setCellValue("\u5c42");
            row.createCell(1).setCellValue("\u65b9\u6848|\u6269\u5c55");
            row.createCell(2).setCellValue("\u63d2\u4ef6");
            row.createCell(3).setCellValue("\u8868\u540d");
            row.createCell(4).setCellValue("\u8868\u6807\u7b7e");
            row.createCell(5).setCellValue("\u5b57\u6bb5\u540d");
            row.createCell(6).setCellValue("\u5b57\u6bb5\u6807\u7b7e");
            row.createCell(7).setCellValue("\u5b57\u6bb5\u7c7b\u578b");
            row.createCell(8).setCellValue("\u957f\u5ea6/\u7cbe\u5ea6");
            row.createCell(9).setCellValue("\u662f\u5426\u5fc5\u586b");
            row.createCell(10).setCellValue("\u9ed8\u8ba4\u503c");
            row.createCell(11).setCellValue("\u5907\u6ce8");
            row.getCell(0).setCellStyle(this.cellHead);
            row.getCell(1).setCellStyle(this.cellHead);
            row.getCell(2).setCellStyle(this.cellHead);
            row.getCell(3).setCellStyle(this.cellHead);
            row.getCell(4).setCellStyle(this.cellHead);
            row.getCell(5).setCellStyle(this.cellHead);
            row.getCell(6).setCellStyle(this.cellHead);
            row.getCell(7).setCellStyle(this.cellHead);
            row.getCell(8).setCellStyle(this.cellHead);
            row.getCell(9).setCellStyle(this.cellHead);
            row.getCell(10).setCellStyle(this.cellHead);
            row.getCell(11).setCellStyle(this.cellHead);
        } else {
            sheet.setColumnWidth(0, 6400);
            sheet.setColumnWidth(1, 6400);
            sheet.setColumnWidth(2, 6400);
            sheet.setColumnWidth(3, 4096);
            sheet.setColumnWidth(4, 3072);
            sheet.setColumnWidth(5, 3072);
            sheet.setColumnWidth(6, 2560);
            sheet.setColumnWidth(7, 3072);
            sheet.setColumnWidth(8, 15360);
            sheet.createFreezePane(0, 1, 0, 1);
            row = sheet.createRow(0);
            row.createCell(0).setCellValue("\u8868\u540d");
            row.createCell(1).setCellValue("\u8868\u6807\u7b7e");
            row.createCell(2).setCellValue("\u5b57\u6bb5\u540d");
            row.createCell(3).setCellValue("\u5b57\u6bb5\u6807\u7b7e");
            row.createCell(4).setCellValue("\u5b57\u6bb5\u7c7b\u578b");
            row.createCell(5).setCellValue("\u957f\u5ea6/\u7cbe\u5ea6");
            row.createCell(6).setCellValue("\u662f\u5426\u5fc5\u586b");
            row.createCell(7).setCellValue("\u9ed8\u8ba4\u503c");
            row.createCell(8).setCellValue("\u5907\u6ce8");
            row.getCell(0).setCellStyle(this.cellHead);
            row.getCell(1).setCellStyle(this.cellHead);
            row.getCell(2).setCellStyle(this.cellHead);
            row.getCell(3).setCellStyle(this.cellHead);
            row.getCell(4).setCellStyle(this.cellHead);
            row.getCell(5).setCellStyle(this.cellHead);
            row.getCell(6).setCellStyle(this.cellHead);
            row.getCell(7).setCellStyle(this.cellHead);
            row.getCell(8).setCellStyle(this.cellHead);
        }
        Set<String> keyset = this.tableEntitys.keySet();
        LayerDefinationManager layerDefinationManager = (LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class);
        LayerDefination layerDefination = layerDefinationManager.getRootLayer();
        while (layerDefination != null) {
            String id;
            String modifiedLayer;
            Element item;
            ArrayList<Element> solutionElemnts;
            String layerName = layerDefination.getLayerName();
            if ("app".equals(layerName)) {
                SolutionDefinitionManager solutionDefinitionManager = (SolutionDefinitionManager)ObjectContainer.getInstance(SolutionDefinitionManager.class);
                List solutions = solutionDefinitionManager.getSolutions();
                for (SolutionDefinition solutionDefinition : solutions) {
                    solutionElemnts = new ArrayList<Element>();
                    for (String key : keyset) {
                        item = this.tableEntitys.get(key);
                        modifiedLayer = item.attributeValue("modifiedLayer");
                        id = item.attributeValue("id");
                        if (id.contains(".")) {
                            id = id.substring(0, id.lastIndexOf("."));
                        }
                        if (id == null || !id.equals(solutionDefinition.getSolutionName()) || modifiedLayer == null || !modifiedLayer.equals(layerName)) continue;
                        solutionElemnts.add(item);
                    }
                    this.printExcelTable(sheet, solutionElemnts, layerName, solutionDefinition.getSolutionName(), "");
                }
            } else if ("plg".equals(layerName)) {
                SolutionPluginDefinitionManager pluginDefinitionManager = (SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class);
                List solutionPlugins = pluginDefinitionManager.getSolutionPlugins();
                for (SolutionPluginDefinition solutionPlugin : solutionPlugins) {
                    solutionElemnts = new ArrayList();
                    for (String key : keyset) {
                        item = this.tableEntitys.get(key);
                        modifiedLayer = item.attributeValue("modifiedLayer");
                        id = item.attributeValue("id");
                        if (id.contains(".")) {
                            id = id.substring(0, id.lastIndexOf("."));
                        }
                        if (id == null || !id.equals(solutionPlugin.getName()) || modifiedLayer == null || !modifiedLayer.equals(layerName)) continue;
                        solutionElemnts.add(item);
                    }
                    this.printExcelTable(sheet, solutionElemnts, layerName, solutionPlugin.getSolutionName(), solutionPlugin.getName());
                }
            } else if ("ext".equals(layerName)) {
                SolutionExtensionDefinitionManager extensionDefinitionManager = (SolutionExtensionDefinitionManager)ObjectContainer.getInstance(SolutionExtensionDefinitionManager.class);
                List solutionExtensions = extensionDefinitionManager.getSolutionExtensions();
                for (SolutionExtensionDefinition solutionExtension : solutionExtensions) {
                    solutionElemnts = new ArrayList();
                    for (String key : keyset) {
                        item = this.tableEntitys.get(key);
                        modifiedLayer = item.attributeValue("modifiedLayer");
                        if (!"ext".equals(modifiedLayer)) continue;
                        String createdLayer = item.attributeValue("createdLayer");
                        String id2 = item.attributeValue("id");
                        if (id2.contains(".")) {
                            id2 = id2.substring(0, id2.lastIndexOf("."));
                        }
                        if ("plg".equals(createdLayer)) {
                            SolutionPluginDefinitionManager pluginDefinitionManager = (SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class);
                            SolutionPluginDefinition solutionPlugin = pluginDefinitionManager.getSolutionPlugin(id2);
                            id2 = solutionPlugin.getSolutionName();
                        }
                        if (id2 == null || !id2.equals(solutionExtension.getSolutionName())) continue;
                        solutionElemnts.add(item);
                    }
                    this.printExcelTable(sheet, solutionElemnts, layerName, "", "");
                }
            } else {
                ArrayList<Element> elements = new ArrayList<Element>();
                for (String key : keyset) {
                    Element item2 = this.tableEntitys.get(key);
                    String modifiedLayer2 = item2.attributeValue("modifiedLayer");
                    if (modifiedLayer2 == null || !modifiedLayer2.equals(layerName)) continue;
                    elements.add(item2);
                }
                this.printExcelTable(sheet, elements, layerName, "", "");
            }
            String upperLayer = layerDefination.getUpperLayer();
            if (!StringUtils.isNotBlank((String)upperLayer) || "Gongqi_ERP_No_More_Layer".equals(upperLayer)) break;
            layerDefination = layerDefinationManager.getLayer(upperLayer);
        }
        workbook.setActiveSheet(0);
        workbook.write((OutputStream)outputStream);
        workbook.close();
        ((OutputStream)outputStream).close();
    }

    private void printExcelTable(HSSFSheet sheet, List<Element> elements, String layerName, String solutionName, String pluginName) {
        elements.sort(new Comparator<Element>(){

            @Override
            public int compare(Element o1, Element o2) {
                return o1.attributeValue("name").compareTo(o2.attributeValue("name"));
            }
        });
        for (Element element : elements) {
            int fieldSum = 0;
            HSSFRow row1 = this.excelCreateRow(sheet);
            ++this.line;
            String tableLabel = GOTHelp.getPPAttValue(element, "Name", "Label");
            if (this.NeedLayerInfo.getSelection()) {
                if ("ext".equals(layerName)) {
                    String createdLayer = element.attributeValue("createdLayer");
                    String id = element.attributeValue("id");
                    if (id.contains(".")) {
                        id = id.substring(0, id.lastIndexOf("."));
                    }
                    if ("plg".equals(createdLayer)) {
                        SolutionPluginDefinitionManager pluginDefinitionManager = (SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class);
                        SolutionPluginDefinition solutionPlugin = pluginDefinitionManager.getSolutionPlugin(id);
                        solutionName = solutionPlugin.getSolutionName();
                        pluginName = solutionPlugin.getName();
                    } else {
                        solutionName = id;
                        pluginName = "";
                    }
                }
                row1.getCell(0).setCellValue(layerName);
                row1.getCell(1).setCellValue(solutionName);
                row1.getCell(2).setCellValue(pluginName);
                row1.getCell(3).setCellValue(element.attributeValue("name"));
                row1.getCell(4).setCellValue(tableLabel);
            } else {
                row1.getCell(0).setCellValue(element.attributeValue("name"));
                row1.getCell(1).setCellValue(tableLabel);
            }
            List tableFields = element.selectNodes("./TableFields/TableField");
            for (Element tableField : tableFields) {
                String refentityid;
                String fieldName = tableField.attributeValue("name");
                String type = tableField.attributeValue("type");
                String fiellLabel = "";
                String stringSize = "";
                String NotNull = "";
                String Default = "";
                String Label2 = "";
                NotNull = GOTHelp.getPPAttValue(tableField, "Name", "NotNull");
                if (!this.NeedDefaultFile.getSelection() && ("CreatedDate".equals(fieldName) || "CreatedTime".equals(fieldName) || "CreatedBy".equals(fieldName) || "ModifiedDate".equals(fieldName) || "ModifiedTime".equals(fieldName) || "ModifiedBy".equals(fieldName) || "RecVersion".equals(fieldName) || "RecId".equals(fieldName))) continue;
                Element Extend = GOTHelp.getPPAttElement(tableField, "Name", "Extends");
                Element extendEle = null;
                if (Extend != null && StringUtils.isNotBlank((String)(refentityid = Extend.attributeValue("refentityid")))) {
                    extendEle = "Enum".equals(tableField.attributeValue("type")) ? this.enumEntitys.get(refentityid) : this.dateTypeEntitys.get(refentityid);
                }
                if ("Component".equals(type) && extendEle != null) {
                    List dataTypeArrayItems = extendEle.selectNodes("./DataTypeArray/DataTypeArrayItem");
                    for (Element dataTypeArrayItem : dataTypeArrayItems) {
                        Element refDataType = GOTHelp.getPPAttElement(dataTypeArrayItem, "Name", "RefDataType");
                        String refId = refDataType.attributeValue("refentityid");
                        if (StringUtils.isBlank((String)refId)) continue;
                        Element refEntity = this.dateTypeEntitys.get(refId);
                        String refName = refEntity.attributeValue("name");
                        fiellLabel = GOTHelp.getPPAttValue(refEntity, "Name", "Label");
                        type = refEntity.attributeValue("type");
                        if ("Decimal".equals(type)) {
                            stringSize = GOTHelp.getPPAttValue(refEntity, "Name", "NumOfDecimals");
                        } else if ("String".equals(type)) {
                            stringSize = GOTHelp.getPPAttValue(refEntity, "Name", "StringSize");
                        }
                        if (fieldSum >= 1) {
                            row1 = this.excelCreateRow(sheet);
                            ++this.line;
                        }
                        ++fieldSum;
                        this.printExcelLine(row1, String.valueOf(fieldName) + "_" + refName, fiellLabel, type, stringSize, NotNull, Default, "");
                    }
                    continue;
                }
                fiellLabel = GOTHelp.getPPAttValue(tableField, "Name", "Label");
                if (StringUtils.isBlank((String)fiellLabel) && extendEle != null && StringUtils.isBlank((String)(fiellLabel = GOTHelp.getPPAttValue(extendEle, "Name", "Label")))) {
                    fiellLabel = extendEle.attributeValue("name");
                }
                if ("Decimal".equals(type) && StringUtils.isBlank((String)(stringSize = GOTHelp.getPPAttValue(tableField, "Name", "NumOfDecimals"))) && extendEle != null) {
                    stringSize = GOTHelp.getPPAttValue(extendEle, "Name", "NumOfDecimals");
                }
                if ("String".equals(type) && StringUtils.isBlank((String)(stringSize = GOTHelp.getPPAttValue(tableField, "Name", "StringSize"))) && extendEle != null) {
                    stringSize = GOTHelp.getPPAttValue(extendEle, "Name", "StringSize");
                }
                Default = GOTHelp.getPPAttValue(tableField, "Name", "Default");
                if (this.NeedEnumDetail.getSelection() && "Enum".equals(tableField.attributeValue("type")) && extendEle != null) {
                    List EnumItems = extendEle.elements("EnumItem");
                    Label2 = "";
                    for (Element EnumItem2 : EnumItems) {
                        if (Label2 != "") {
                            Label2 = String.valueOf(Label2) + "\u3001";
                        }
                        Label2 = String.valueOf(Label2) + String.format("%s:%s", GOTHelp.getPPAttValue(EnumItem2, "Name", "Label"), GOTHelp.getPPAttValue(EnumItem2, "Name", "Value"));
                    }
                }
                if (fieldSum >= 1) {
                    row1 = this.excelCreateRow(sheet);
                    ++this.line;
                }
                ++fieldSum;
                this.printExcelLine(row1, fieldName, fiellLabel, type, stringSize, NotNull, Default, Label2);
            }
            if (fieldSum <= 0) continue;
            sheet.addMergedRegion(new CellRangeAddress(this.line - fieldSum, this.line - 1, 0, 0));
            sheet.addMergedRegion(new CellRangeAddress(this.line - fieldSum, this.line - 1, 1, 1));
            if (!this.NeedLayerInfo.getSelection()) continue;
            sheet.addMergedRegion(new CellRangeAddress(this.line - fieldSum, this.line - 1, 2, 2));
            sheet.addMergedRegion(new CellRangeAddress(this.line - fieldSum, this.line - 1, 3, 3));
            sheet.addMergedRegion(new CellRangeAddress(this.line - fieldSum, this.line - 1, 4, 4));
        }
    }

    private HSSFRow excelCreateRow(HSSFSheet sheet) {
        HSSFRow row1 = sheet.createRow(this.line);
        if (this.NeedLayerInfo.getSelection()) {
            row1.createCell(0).setCellStyle(this.cellStyle);
            row1.createCell(1).setCellStyle(this.cellStyle);
            row1.createCell(2).setCellStyle(this.cellStyle);
            row1.createCell(3).setCellStyle(this.cellStyle);
            row1.createCell(4).setCellStyle(this.cellStyle);
            row1.createCell(5).setCellStyle(this.cellStyle);
            row1.createCell(6).setCellStyle(this.cellStyle);
            row1.createCell(7).setCellStyle(this.cellStyle);
            row1.createCell(8).setCellStyle(this.cellStyle);
            row1.createCell(9).setCellStyle(this.cellStyle);
            row1.createCell(10).setCellStyle(this.cellStyle);
            row1.createCell(11).setCellStyle(this.leftStyle);
        } else {
            row1.createCell(0).setCellStyle(this.cellStyle);
            row1.createCell(1).setCellStyle(this.cellStyle);
            row1.createCell(2).setCellStyle(this.cellStyle);
            row1.createCell(3).setCellStyle(this.cellStyle);
            row1.createCell(4).setCellStyle(this.cellStyle);
            row1.createCell(5).setCellStyle(this.cellStyle);
            row1.createCell(6).setCellStyle(this.cellStyle);
            row1.createCell(7).setCellStyle(this.cellStyle);
            row1.createCell(8).setCellStyle(this.leftStyle);
        }
        return row1;
    }

    private void printExcelLine(HSSFRow row1, String fieldName, String fiellLabel, String type, String stringSize, String notNull, String default1, String label) {
        if (this.NeedLayerInfo.getSelection()) {
            row1.getCell(5).setCellValue(fieldName);
            row1.getCell(6).setCellValue(fiellLabel);
            row1.getCell(7).setCellValue(type);
            row1.getCell(8).setCellValue(stringSize);
            if ("true".equals(notNull)) {
                row1.getCell(9).setCellValue("\u662f");
            } else if ("false".equals(notNull)) {
                row1.getCell(9).setCellValue("\u5426");
            }
            row1.getCell(10).setCellValue(default1);
            row1.getCell(11).setCellValue(label);
        } else {
            row1.getCell(2).setCellValue(fieldName);
            row1.getCell(3).setCellValue(fiellLabel);
            row1.getCell(4).setCellValue(type);
            row1.getCell(5).setCellValue(stringSize);
            if ("true".equals(notNull)) {
                row1.getCell(6).setCellValue("\u662f");
            } else if ("false".equals(notNull)) {
                row1.getCell(6).setCellValue("\u5426");
            }
            row1.getCell(7).setCellValue(default1);
            row1.getCell(8).setCellValue(label);
        }
    }

    public void exportAsWord(String path) throws IOException, DocumentException {
        this.init();
        XWPFDocument document = new XWPFDocument();
        XWPFParagraph titleParagraph = document.createParagraph();
        titleParagraph.setAlignment(ParagraphAlignment.CENTER);
        XWPFRun titleParagraphRun = titleParagraph.createRun();
        titleParagraphRun.setText("\u6570\u636e\u5b57\u5178");
        titleParagraphRun.setFontFamily("\u9ed1\u4f53");
        titleParagraphRun.setFontSize(20);
        Set<String> keyset = this.tableEntitys.keySet();
        LayerDefinationManager layerDefinationManager = (LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class);
        LayerDefination layerDefination = layerDefinationManager.getRootLayer();
        while (layerDefination != null) {
            String id;
            String modifiedLayer;
            Element item;
            ArrayList<Element> solutionElemnts;
            String layerName = layerDefination.getLayerName();
            if ("app".equals(layerName)) {
                SolutionDefinitionManager solutionDefinitionManager = (SolutionDefinitionManager)ObjectContainer.getInstance(SolutionDefinitionManager.class);
                List solutions = solutionDefinitionManager.getSolutions();
                for (SolutionDefinition solutionDefinition : solutions) {
                    solutionElemnts = new ArrayList<Element>();
                    for (String key : keyset) {
                        item = this.tableEntitys.get(key);
                        modifiedLayer = item.attributeValue("modifiedLayer");
                        id = item.attributeValue("id");
                        if (id.contains(".")) {
                            id = id.substring(0, id.lastIndexOf("."));
                        }
                        if (id == null || !id.equals(solutionDefinition.getSolutionName()) || modifiedLayer == null || !modifiedLayer.equals(layerName)) continue;
                        solutionElemnts.add(item);
                    }
                    this.printWordTabel(document, solutionElemnts, layerName, solutionDefinition.getSolutionName(), "");
                }
            } else if ("plg".equals(layerName)) {
                SolutionPluginDefinitionManager pluginDefinitionManager = (SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class);
                List solutionPlugins = pluginDefinitionManager.getSolutionPlugins();
                for (SolutionPluginDefinition solutionPlugin : solutionPlugins) {
                    solutionElemnts = new ArrayList();
                    for (String key : keyset) {
                        item = this.tableEntitys.get(key);
                        modifiedLayer = item.attributeValue("modifiedLayer");
                        id = item.attributeValue("id");
                        if (id.contains(".")) {
                            id = id.substring(0, id.lastIndexOf("."));
                        }
                        if (id == null || !id.equals(solutionPlugin.getName()) || modifiedLayer == null || !modifiedLayer.equals(layerName)) continue;
                        solutionElemnts.add(item);
                    }
                    this.printWordTabel(document, solutionElemnts, layerName, solutionPlugin.getSolutionName(), solutionPlugin.getName());
                }
            } else if ("ext".equals(layerName)) {
                SolutionExtensionDefinitionManager extensionDefinitionManager = (SolutionExtensionDefinitionManager)ObjectContainer.getInstance(SolutionExtensionDefinitionManager.class);
                List solutionExtensions = extensionDefinitionManager.getSolutionExtensions();
                for (SolutionExtensionDefinition solutionExtension : solutionExtensions) {
                    solutionElemnts = new ArrayList();
                    for (String key : keyset) {
                        item = this.tableEntitys.get(key);
                        modifiedLayer = item.attributeValue("modifiedLayer");
                        if (!"ext".equals(modifiedLayer)) continue;
                        String createdLayer = item.attributeValue("createdLayer");
                        String id2 = item.attributeValue("id");
                        if (id2.contains(".")) {
                            id2 = id2.substring(0, id2.lastIndexOf("."));
                        }
                        if ("plg".equals(createdLayer)) {
                            SolutionPluginDefinitionManager pluginDefinitionManager = (SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class);
                            SolutionPluginDefinition solutionPlugin = pluginDefinitionManager.getSolutionPlugin(id2);
                            id2 = solutionPlugin.getSolutionName();
                        }
                        if (id2 == null || !id2.equals(solutionExtension.getSolutionName())) continue;
                        solutionElemnts.add(item);
                    }
                    this.printWordTabel(document, solutionElemnts, layerName, "", "");
                }
            } else {
                ArrayList<Element> elements = new ArrayList<Element>();
                for (String key : keyset) {
                    Element item2 = this.tableEntitys.get(key);
                    String modifiedLayer2 = item2.attributeValue("modifiedLayer");
                    if (modifiedLayer2 == null || !modifiedLayer2.equals(layerName)) continue;
                    elements.add(item2);
                }
                this.printWordTabel(document, elements, layerName, "", "");
            }
            String upperLayer = layerDefination.getUpperLayer();
            if (!StringUtils.isNotBlank((String)upperLayer) || "Gongqi_ERP_No_More_Layer".equals(upperLayer)) break;
            layerDefination = layerDefinationManager.getLayer(upperLayer);
        }
        File file = new File(path);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        document.write((OutputStream)fileOutputStream);
        fileOutputStream.close();
    }

    private void printWordTabel(XWPFDocument document, List<Element> elements, String layerName, String solutionName, String pluginName) {
        elements.sort(new Comparator<Element>(){

            @Override
            public int compare(Element o1, Element o2) {
                return o1.attributeValue("name").compareTo(o2.attributeValue("name"));
            }
        });
        for (Element element : elements) {
            XWPFParagraph titleParagraph = document.createParagraph();
            titleParagraph.setAlignment(ParagraphAlignment.LEFT);
            String title = element.attributeValue("name");
            String tableLabel = GOTHelp.getPPAttValue(element, "Name", "Label");
            if (tableLabel != "") {
                title = String.valueOf(title) + "(" + tableLabel + ")";
            }
            XWPFRun titleParagraphRun = titleParagraph.createRun();
            titleParagraphRun.setText(title);
            titleParagraphRun.setFontFamily("\u9ed1\u4f53");
            titleParagraphRun.setColor("000000");
            titleParagraphRun.setFontSize(13);
            if (this.NeedLayerInfo.getSelection()) {
                if ("ext".equals(layerName)) {
                    String createdLayer = element.attributeValue("createdLayer");
                    String id = element.attributeValue("id");
                    if (id.contains(".")) {
                        id = id.substring(0, id.lastIndexOf("."));
                    }
                    if ("plg".equals(createdLayer)) {
                        SolutionPluginDefinitionManager pluginDefinitionManager = (SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class);
                        SolutionPluginDefinition solutionPlugin = pluginDefinitionManager.getSolutionPlugin(id);
                        solutionName = solutionPlugin.getSolutionName();
                        pluginName = solutionPlugin.getName();
                    } else {
                        solutionName = id;
                        pluginName = "";
                    }
                }
                XWPFParagraph layerInfo = document.createParagraph();
                XWPFRun layerInfoRun = layerInfo.createRun();
                String layerText = "\u5c42:" + layerName;
                if (StringUtils.isNotBlank((String)solutionName)) {
                    layerText = String.valueOf(layerText) + "    \u65b9\u6848|\u6269\u5c55:" + solutionName;
                }
                if (StringUtils.isNotBlank((String)pluginName)) {
                    layerText = String.valueOf(layerText) + "    \u63d2\u4ef6:" + pluginName;
                }
                layerInfoRun.setText(layerText);
                layerInfoRun.setFontFamily("\u9ed1\u4f53");
                layerInfoRun.setColor("767171");
                layerInfoRun.setFontSize(12);
            }
            XWPFTable table = document.createTable();
            CTTblWidth comTableWidth = table.getCTTbl().addNewTblPr().addNewTblW();
            comTableWidth.setType(STTblWidth.DXA);
            CTTblPr tblPr = table.getCTTbl().getTblPr();
            CTTblLayoutType t = tblPr.isSetTblLayout() ? tblPr.getTblLayout() : tblPr.addNewTblLayout();
            t.setType(STTblLayoutType.FIXED);
            XWPFTableRow row0 = table.getRow(0);
            row0.setHeight(450);
            XWPFParagraph xwpParagraph = (XWPFParagraph)row0.getCell(0).getParagraphs().get(0);
            XWPFRun run = xwpParagraph.createRun();
            run.setFontSize(11);
            run.setColor("FFFFFF");
            run.setFontFamily("\u9ed1\u4f53");
            run.setText("\u5b57\u6bb5\u540d");
            row0.getCell(0).getCTTc().addNewTcPr().addNewTcW().setW(BigInteger.valueOf(2000L));
            row0.addNewTableCell();
            xwpParagraph = (XWPFParagraph)row0.getCell(1).getParagraphs().get(0);
            run = xwpParagraph.createRun();
            run.setFontSize(11);
            run.setColor("FFFFFF");
            run.setFontFamily("\u9ed1\u4f53");
            run.setText("\u5b57\u6bb5\u6807\u7b7e");
            row0.getCell(1).getCTTc().addNewTcPr().addNewTcW().setW(BigInteger.valueOf(1600L));
            row0.addNewTableCell();
            xwpParagraph = (XWPFParagraph)row0.getCell(2).getParagraphs().get(0);
            run = xwpParagraph.createRun();
            run.setFontSize(11);
            run.setColor("FFFFFF");
            run.setFontFamily("\u9ed1\u4f53");
            run.setText("\u5b57\u6bb5\u7c7b\u578b");
            row0.getCell(2).getCTTc().addNewTcPr().addNewTcW().setW(BigInteger.valueOf(1300L));
            row0.addNewTableCell();
            xwpParagraph = (XWPFParagraph)row0.getCell(3).getParagraphs().get(0);
            run = xwpParagraph.createRun();
            run.setFontSize(11);
            run.setColor("FFFFFF");
            run.setFontFamily("\u9ed1\u4f53");
            run.setText("\u957f\u5ea6\u7cbe\u5ea6");
            row0.getCell(3).getCTTc().addNewTcPr().addNewTcW().setW(BigInteger.valueOf(600L));
            row0.addNewTableCell();
            xwpParagraph = (XWPFParagraph)row0.getCell(4).getParagraphs().get(0);
            run = xwpParagraph.createRun();
            run.setFontSize(11);
            run.setColor("FFFFFF");
            run.setFontFamily("\u9ed1\u4f53");
            run.setText("\u662f\u5426\u5fc5\u586b");
            row0.getCell(4).getCTTc().addNewTcPr().addNewTcW().setW(BigInteger.valueOf(600L));
            row0.addNewTableCell();
            xwpParagraph = (XWPFParagraph)row0.getCell(5).getParagraphs().get(0);
            run = xwpParagraph.createRun();
            run.setFontSize(11);
            run.setColor("FFFFFF");
            run.setFontFamily("\u9ed1\u4f53");
            run.setText("\u9ed8\u8ba4\u503c");
            row0.getCell(5).getCTTc().addNewTcPr().addNewTcW().setW(BigInteger.valueOf(1200L));
            row0.addNewTableCell();
            xwpParagraph = (XWPFParagraph)row0.getCell(6).getParagraphs().get(0);
            run = xwpParagraph.createRun();
            run.setFontSize(11);
            run.setColor("FFFFFF");
            run.setFontFamily("\u9ed1\u4f53");
            run.setText("\u5907\u6ce8");
            row0.getCell(6).getCTTc().addNewTcPr().addNewTcW().setW(BigInteger.valueOf(2200L));
            List tableFields = element.selectNodes("./TableFields/TableField");
            for (Element tableField : tableFields) {
                String refentityid;
                String fieldName = tableField.attributeValue("name");
                if (!this.NeedDefaultFile.getSelection() && ("CreatedDate".equals(fieldName) || "CreatedTime".equals(fieldName) || "CreatedBy".equals(fieldName) || "ModifiedDate".equals(fieldName) || "ModifiedTime".equals(fieldName) || "ModifiedBy".equals(fieldName) || "RecVersion".equals(fieldName) || "RecId".equals(fieldName))) continue;
                String type = tableField.attributeValue("type");
                String fiellLabel = "";
                String stringSize = "";
                String NotNull = "";
                String Default = "";
                String Label2 = "";
                NotNull = GOTHelp.getPPAttValue(tableField, "Name", "NotNull");
                Element Extend = GOTHelp.getPPAttElement(tableField, "Name", "Extends");
                Element extendEle = null;
                if (Extend != null && StringUtils.isNotBlank((String)(refentityid = Extend.attributeValue("refentityid")))) {
                    extendEle = "Enum".equals(tableField.attributeValue("type")) ? this.enumEntitys.get(refentityid) : this.dateTypeEntitys.get(refentityid);
                }
                if ("Component".equals(type) && extendEle != null) {
                    List dataTypeArrayItems = extendEle.selectNodes("./DataTypeArray/DataTypeArrayItem");
                    for (Element dataTypeArrayItem : dataTypeArrayItems) {
                        Element refDataType = GOTHelp.getPPAttElement(dataTypeArrayItem, "Name", "RefDataType");
                        String refId = refDataType.attributeValue("refentityid");
                        if (StringUtils.isBlank((String)refId)) continue;
                        Element refEntity = this.dateTypeEntitys.get(refId);
                        String refName = refEntity.attributeValue("name");
                        fiellLabel = GOTHelp.getPPAttValue(refEntity, "Name", "Label");
                        type = refEntity.attributeValue("type");
                        if ("Decimal".equals(type)) {
                            stringSize = GOTHelp.getPPAttValue(refEntity, "Name", "NumOfDecimals");
                        } else if ("String".equals(type)) {
                            stringSize = GOTHelp.getPPAttValue(refEntity, "Name", "StringSize");
                        }
                        XWPFTableRow newRow = table.createRow();
                        newRow.setHeight(400);
                        this.printWordLine(row0, newRow, String.valueOf(fieldName) + "_" + refName, fiellLabel, type, stringSize, NotNull, Default, "");
                    }
                    continue;
                }
                fiellLabel = GOTHelp.getPPAttValue(tableField, "Name", "Label");
                if (StringUtils.isBlank((String)fiellLabel) && extendEle != null && StringUtils.isBlank((String)(fiellLabel = GOTHelp.getPPAttValue(extendEle, "Name", "Label")))) {
                    fiellLabel = extendEle.attributeValue("name");
                }
                if ("Decimal".equals(type)) {
                    stringSize = GOTHelp.getPPAttValue(tableField, "Name", "NumOfDecimals");
                    if (StringUtils.isBlank((String)stringSize) && extendEle != null) {
                        stringSize = GOTHelp.getPPAttValue(extendEle, "Name", "NumOfDecimals");
                    }
                } else if ("String".equals(type) && StringUtils.isBlank((String)(stringSize = GOTHelp.getPPAttValue(tableField, "Name", "StringSize"))) && extendEle != null) {
                    stringSize = GOTHelp.getPPAttValue(extendEle, "Name", "StringSize");
                }
                Default = GOTHelp.getPPAttValue(tableField, "Name", "Default");
                if (this.NeedEnumDetail.getSelection() && "Enum".equals(tableField.attributeValue("type")) && extendEle != null) {
                    List EnumItems = extendEle.elements("EnumItem");
                    Label2 = "";
                    for (Element EnumItem2 : EnumItems) {
                        if (Label2 != "") {
                            Label2 = String.valueOf(Label2) + "\u3001";
                        }
                        Label2 = String.valueOf(Label2) + String.format("%s:%s", GOTHelp.getPPAttValue(EnumItem2, "Name", "Label"), GOTHelp.getPPAttValue(EnumItem2, "Name", "Value"));
                    }
                }
                XWPFTableRow newRow = table.createRow();
                newRow.setHeight(400);
                this.printWordLine(row0, newRow, fieldName, fiellLabel, type, stringSize, NotNull, Default, Label2);
            }
            List rows = table.getRows();
            if (rows.size() == 1) {
                table.createRow().setHeight(400);
            }
            int currentRow = 0;
            for (XWPFTableRow row : rows) {
                List tableCells = row.getTableCells();
                for (XWPFTableCell cell : tableCells) {
                    CTTcPr ctTcPr = cell.getCTTc().addNewTcPr();
                    CTVerticalJc ctVerticalJc = ctTcPr.addNewVAlign();
                    ctVerticalJc.setVal(STVerticalJc.CENTER);
                    CTShd ctShd = ctTcPr.addNewShd();
                    ctShd.setColor((Object)"auto");
                    ctShd.setVal(STShd.CLEAR);
                    if (currentRow % 2 == 1) {
                        ctShd.setFill((Object)"e9edf4");
                    } else {
                        ctShd.setFill((Object)"FFFFFF");
                    }
                    if (currentRow == 0) {
                        ctShd.setFill((Object)"4f81bd");
                    }
                    xwpParagraph = (XWPFParagraph)cell.getParagraphs().get(0);
                    xwpParagraph.setAlignment(ParagraphAlignment.CENTER);
                }
                ++currentRow;
            }
            XWPFParagraph endParagraph = document.createParagraph();
            run = endParagraph.createRun();
            run.setText("");
            run.addBreak(BreakClear.ALL);
        }
    }

    private void printWordLine(XWPFTableRow titleRow, XWPFTableRow newRow, String fieldName, String fiellLabel, String type, String stringSize, String notNull, String default1, String label) {
        newRow.getCell(0).setText(fieldName);
        newRow.getCell(0).getCTTc().addNewTcPr().addNewTcW().setW(BigInteger.valueOf(2000L));
        newRow.getCell(1).setText(fiellLabel);
        newRow.getCell(1).getCTTc().addNewTcPr().addNewTcW().setW(BigInteger.valueOf(1600L));
        newRow.getCell(2).setText(type);
        newRow.getCell(2).getCTTc().addNewTcPr().addNewTcW().setW(BigInteger.valueOf(1300L));
        newRow.getCell(3).setText(stringSize);
        newRow.getCell(3).getCTTc().addNewTcPr().addNewTcW().setW(BigInteger.valueOf(600L));
        if ("true".equals(notNull)) {
            newRow.getCell(4).setText("\u662f");
        } else if ("false".equals(notNull)) {
            newRow.getCell(4).setText("\u5426");
        }
        newRow.getCell(4).getCTTc().addNewTcPr().addNewTcW().setW(BigInteger.valueOf(600L));
        newRow.getCell(5).setText(default1);
        newRow.getCell(5).getCTTc().addNewTcPr().addNewTcW().setW(BigInteger.valueOf(1200L));
        newRow.getCell(6).setText(label);
        newRow.getCell(6).getCTTc().addNewTcPr().addNewTcW().setW(BigInteger.valueOf(2200L));
    }
}

