/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.ui;

import com.alibaba.fastjson.JSONObject;
import com.ximpleware.NavException;
import gongqi.erp.framework.core.FrameworkManager;
import gongqi.erp.framework.core.LayerDefination;
import gongqi.erp.framework.core.LayerDeploymentMode;
import gongqi.erp.framework.core.LayerLocator;
import gongqi.erp.framework.core.LayerResolver;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinition;
import gongqi.erp.framework.core.extension.SolutionExtensionDeploymentMode;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinition;
import gongqi.erp.framework.core.plugin.SolutionPluginDeploymentMode;
import gongqi.erp.framework.core.solution.SolutionDefinition;
import gongqi.erp.framework.core.solution.SolutionDeploymentMode;
import gongqi.erp.framework.tools.ZipUtil;
import gongqi.erp.framework.util.FileUtils;
import gongqi.gdt.designer.ProjectConstants;
import gongqi.gdt.designer.service.LayerUpgradeService;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.service.node.GOTNode;
import gongqi.gdt.designer.service.node.GOTProperty;
import gongqi.gdt.designer.ui.DependVersionDialog;
import gongqi.gdt.designer.ui.MarketOnlineVersion;
import gongqi.gdt.designer.ui.UploadFailedDialog;
import gongqi.gdt.designer.utils.Images;
import gongqi.gdt.designer.utils.LayerUpgradeHelper;
import gongqi.gdt.designer.utils.MarketUtil;
import gongqi.gdt.designer.utils.PedestalLayerInfo;
import gongqi.gdt.designer.utils.RelationError;
import gongqi.gdt.designer.utils.SWTUtils;
import gongqi.gdt.designer.utils.SolutionExtInfo;
import gongqi.gdt.designer.utils.SolutionLayerInfo;
import gongqi.gdt.designer.utils.SolutionPluginInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.springframework.util.DigestUtils;

public class LayerChainPage {
    private Shell shell;
    private Table pedestal;
    private Tree tree;
    private Label updateInfo;
    private Font font = new Font((Device)Display.getCurrent(), "\u5fae\u8f6f\u96c5\u9ed1", 10, 0);
    private Map<String, PedestalLayerInfo> pedestalInfos;
    private Map<String, SolutionLayerInfo> solutionInfos;
    private static Logger log = Logger.getLogger(LayerChainPage.class);
    private Button button_Match;
    private Button button_Confirm;
    private Button button_ResetAll;
    private Button button_Upload;
    private ToolItem showBinaryOnly;
    private ToolItem showUpgradeOnly;
    private Consumer<String> confirmCallBack;
    private Consumer<String> openCallBack;
    private static LayerChainPage layerChainPage;

    public static LayerChainPage getInstance() {
        if (layerChainPage == null) {
            layerChainPage = new LayerChainPage();
        }
        return layerChainPage;
    }

    public void setConfirmCallBack(Consumer<String> confirmCallBack) {
        this.confirmCallBack = confirmCallBack;
    }

    public void setOpenCallBack(Consumer<String> openCallBack) {
        this.openCallBack = openCallBack;
    }

    public void open() {
        if (this.shell == null || this.shell.isDisposed()) {
            this.createContent();
            this.shell.open();
            Display display = this.shell.getDisplay();
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        } else {
            this.shell.setMinimized(false);
            this.shell.setMaximized(false);
        }
    }

    protected void createContent() {
        Display display = Display.getCurrent();
        this.shell = new Shell(display.getActiveShell(), 208);
        this.shell.setText("\u5c42\u94fe\u5347\u7ea7");
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(SWTUtils.zoom(800), SWTUtils.zoom(500));
        Rectangle bounds = Display.getDefault().getPrimaryMonitor().getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        ToolBar toolBar = new ToolBar((Composite)this.shell, 8519744);
        FormData formData = new FormData();
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-3));
        formData.right = new FormAttachment(100, SWTUtils.zoom(-90));
        toolBar.setLayoutData((Object)formData);
        this.showUpgradeOnly = new ToolItem(toolBar, 131104);
        this.showUpgradeOnly.setImage(Images.getIcon("layerUpgrade/Upgrade.png"));
        this.showUpgradeOnly.setToolTipText("\u4ec5\u663e\u793a\u5347\u7ea7\u5c42");
        this.showBinaryOnly = new ToolItem(toolBar, 131104);
        this.showBinaryOnly.setImage(Images.getIcon("layerUpgrade/Binary.png"));
        this.showBinaryOnly.setToolTipText("\u4ec5\u663e\u793a\u4e8c\u8fdb\u5236\u5c42");
        SelectionAdapter filterListen = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LayerChainPage.this.buildTable();
                LayerChainPage.this.buildTree();
            }
        };
        this.showUpgradeOnly.addSelectionListener((SelectionListener)filterListen);
        this.showBinaryOnly.addSelectionListener((SelectionListener)filterListen);
        this.updateInfo = new Label((Composite)this.shell, 16384);
        formData = new FormData();
        formData.top = new FormAttachment((Control)toolBar, 0, 128);
        formData.bottom = new FormAttachment((Control)toolBar, 0, 1024);
        formData.left = new FormAttachment(0, SWTUtils.zoom(5));
        formData.right = new FormAttachment((Control)toolBar, SWTUtils.zoom(2), 16384);
        this.updateInfo.setForeground(Display.getCurrent().getSystemColor(9));
        this.updateInfo.setLayoutData((Object)formData);
        this.pedestal = new Table((Composite)this.shell, 0x10010800);
        this.pedestal.setHeaderVisible(true);
        this.pedestal.setLinesVisible(false);
        formData = new FormData();
        formData.left = new FormAttachment(0, SWTUtils.zoom(5));
        formData.right = new FormAttachment((Control)toolBar, 0, 131072);
        formData.top = new FormAttachment(0, SWTUtils.zoom(5));
        formData.bottom = new FormAttachment(25);
        this.pedestal.setLayoutData((Object)formData);
        this.pedestal.setFont(this.font);
        TableColumn layerName = new TableColumn(this.pedestal, 0);
        layerName.setText("\u5c42\u540d");
        layerName.setWidth(SWTUtils.zoom(180));
        TableColumn layerSpace = new TableColumn(this.pedestal, 0);
        layerSpace.setText("\u5c42\u7a7a\u95f4");
        layerSpace.setWidth(SWTUtils.zoom(100));
        TableColumn layerLabel = new TableColumn(this.pedestal, 0);
        layerLabel.setText("\u5c42\u6807\u7b7e");
        layerLabel.setWidth(SWTUtils.zoom(100));
        TableColumn LayerDeployMode = new TableColumn(this.pedestal, 0x1000000);
        LayerDeployMode.setText("\u90e8\u7f72\u6a21\u5f0f");
        LayerDeployMode.setWidth(SWTUtils.zoom(80));
        TableColumn currentVersion = new TableColumn(this.pedestal, 0);
        currentVersion.setText("\u5f53\u524d\u7248\u672c");
        currentVersion.setWidth(SWTUtils.zoom(80));
        TableColumn targetVersion = new TableColumn(this.pedestal, 0);
        targetVersion.setText("\u76ee\u6807\u7248\u672c");
        targetVersion.setWidth(SWTUtils.zoom(80));
        this.addPedestalListener();
        this.tree = new Tree((Composite)this.shell, 67842);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(false);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.pedestal, 0, 16384);
        formData.right = new FormAttachment((Control)this.pedestal, 0, 131072);
        formData.top = new FormAttachment((Control)this.pedestal, SWTUtils.zoom(5), 1024);
        formData.bottom = new FormAttachment((Control)toolBar, SWTUtils.zoom(-5), 128);
        this.tree.setLayoutData((Object)formData);
        this.tree.setFont(this.font);
        this.addSolutionTreeListener();
        TreeColumn solutionName = new TreeColumn(this.tree, 0);
        solutionName.setText("\u5e94\u7528/\u63d2\u4ef6");
        solutionName.setWidth(SWTUtils.zoom(380));
        TreeColumn solutionDeployMode = new TreeColumn(this.tree, 0x1000000);
        solutionDeployMode.setText("\u90e8\u7f72\u6a21\u5f0f");
        solutionDeployMode.setWidth(SWTUtils.zoom(80));
        TreeColumn solutionCurrentVersion = new TreeColumn(this.tree, 0);
        solutionCurrentVersion.setText("\u5f53\u524d\u7248\u672c");
        solutionCurrentVersion.setWidth(SWTUtils.zoom(80));
        TreeColumn solutionTargettVersion = new TreeColumn(this.tree, 0);
        solutionTargettVersion.setText("\u76ee\u6807\u7248\u672c");
        solutionTargettVersion.setWidth(SWTUtils.zoom(80));
        this.button_Match = new Button((Composite)this.shell, 8);
        this.button_Match.setText("\u7248\u672c\u5339\u914d");
        formData = new FormData(SWTUtils.zoom(80), SWTUtils.zoom(32));
        formData.top = new FormAttachment((Control)this.pedestal, 0, 128);
        formData.left = new FormAttachment((Control)this.pedestal, SWTUtils.zoom(5), 131072);
        this.button_Match.setLayoutData((Object)formData);
        this.button_Upload = new Button((Composite)this.shell, 8);
        this.button_Upload.setText("\u6279\u91cf\u4e0a\u4f20");
        formData = new FormData(SWTUtils.zoom(80), SWTUtils.zoom(32));
        formData.top = new FormAttachment((Control)this.button_Match, SWTUtils.zoom(5), 1024);
        formData.left = new FormAttachment((Control)this.button_Match, 0, 16384);
        this.button_Upload.setLayoutData((Object)formData);
        this.button_Upload.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(LayerChainPage.this.shell, 69634);
                dialog.setFilterExtensions(new String[]{"*.app;*.plugin;*.lyr"});
                dialog.setText("\u5347\u7ea7\u6587\u4ef6");
                dialog.open();
                String[] selectFileNames = dialog.getFileNames();
                if (selectFileNames == null || selectFileNames.length <= 0) {
                    return;
                }
                ArrayList<String> uploadFaileds = new ArrayList<String>();
                String[] stringArray = selectFileNames;
                int n = selectFileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    File layerFile = new File(dialog.getFilterPath(), fileName);
                    if (!LayerChainPage.this.uploadPatch(layerFile)) {
                        uploadFaileds.add(fileName);
                    }
                    ++n2;
                }
                if (!uploadFaileds.isEmpty()) {
                    UploadFailedDialog failedDialog = new UploadFailedDialog(uploadFaileds);
                    failedDialog.open();
                }
            }
        });
        this.button_ResetAll = new Button((Composite)this.shell, 8);
        this.button_ResetAll.setText("\u91cd\u7f6e");
        formData = new FormData(SWTUtils.zoom(80), SWTUtils.zoom(32));
        formData.top = new FormAttachment((Control)this.button_Upload, SWTUtils.zoom(5), 1024);
        formData.left = new FormAttachment((Control)this.button_Upload, 0, 16384);
        this.button_ResetAll.setLayoutData((Object)formData);
        this.button_ResetAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LayerChainPage.this.resetAll();
            }
        });
        this.button_Confirm = new Button((Composite)this.shell, 8);
        this.button_Confirm.setText("\u786e\u8ba4");
        formData = new FormData(SWTUtils.zoom(80), SWTUtils.zoom(32));
        formData.top = new FormAttachment((Control)this.button_ResetAll, SWTUtils.zoom(5), 1024);
        formData.left = new FormAttachment((Control)this.button_ResetAll, 0, 16384);
        this.button_Confirm.setLayoutData((Object)formData);
        this.button_Match.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String objVersion = ((PedestalLayerInfo)LayerChainPage.this.pedestalInfos.get("obj")).getTargetVersion();
                if (StringUtils.isBlank((String)objVersion)) {
                    MessageDialog.openError((Shell)LayerChainPage.this.shell, (String)"\u63d0\u793a", (String)"\u8bf7\u5148\u9009\u62e9\u5e95\u5ea7\u7248\u672c");
                    return;
                }
                try {
                    MarketOnlineVersion.versionMatch(objVersion, LayerChainPage.this.solutionInfos);
                    MessageDialog.openInformation((Shell)LayerChainPage.this.shell, (String)"\u63d0\u793a", (String)"\u5339\u914d\u5b8c\u6210");
                    LayerChainPage.this.updateInfoRefresh();
                }
                catch (Exception e1) {
                    log.error((Object)"\u7248\u672c\u5339\u914d\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
                    MessageDialog.openError((Shell)LayerChainPage.this.shell, (String)"\u63d0\u793a", (String)ExceptionUtils.getRootCause((Throwable)e1).getMessage());
                }
            }
        });
        this.button_Confirm.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LayerChainPage.this.ifModify()) {
                    LayerChainPage.this.updateCache();
                    List<String> results = LayerChainPage.this.checkBeforeAnalysis();
                    if (results.isEmpty()) {
                        boolean targetRelationCheck = LayerChainPage.this.targetRelationCheck();
                        if (targetRelationCheck) {
                            if (LayerChainPage.this.confirmCallBack != null) {
                                LayerChainPage.this.confirmCallBack.accept(LayerChainPage.this.updateInfo.getText());
                            }
                            LayerChainPage.this.openCallBack.accept(LayerChainPage.this.updateInfo.getText());
                            LayerChainPage.this.shell.close();
                        } else {
                            MessageDialog.openError((Shell)LayerChainPage.this.shell, (String)"\u63d0\u793a", (String)"\u5b58\u5728\u5f15\u7528\u9519\u8bef");
                        }
                    } else {
                        MessageDialog.openError((Shell)LayerChainPage.this.shell, (String)"\u63d0\u793a", (String)String.join((CharSequence)System.lineSeparator(), results));
                    }
                } else {
                    LayerChainPage.this.checkBeforeAnalysis();
                    boolean targetRelationCheck = LayerChainPage.this.targetRelationCheck();
                    if (targetRelationCheck) {
                        LayerChainPage.this.openCallBack.accept(LayerChainPage.this.updateInfo.getText());
                        LayerChainPage.this.shell.close();
                    }
                }
            }
        });
        this.button_Confirm.setEnabled(false);
        this.button_Match.setEnabled(false);
        this.button_Upload.setEnabled(false);
        this.button_ResetAll.setEnabled(false);
        this.updateInfo.setText("\u6b63\u5728\u52a0\u8f7d\u5c42\u7ed3\u6784...");
        new Thread(() -> {
            this.findInLocalFileCache();
            Display.getDefault().asyncExec(() -> {
                if (!this.shell.isDisposed()) {
                    this.button_Confirm.setEnabled(true);
                    this.button_Match.setEnabled(true);
                    this.button_Upload.setEnabled(true);
                    this.button_ResetAll.setEnabled(true);
                    this.updateInfoRefresh();
                    this.openCallBack.accept(this.updateInfo.getText());
                }
            });
        }).start();
    }

    private boolean targetRelationCheck() {
        final Boolean[] result = new Boolean[]{true};
        try {
            final ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.shell);
            progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Display.getDefault().syncExec(() -> progressMonitorDialog.getShell().setText("\u76ee\u6807\u73af\u5883\u6821\u9a8c"));
                    LayerChainPage.this.downloadFile(monitor);
                    monitor.beginTask("", 10);
                    monitor.setTaskName("\u30102/2\u3011\u6b63\u5728\u8fdb\u884c\u6a21\u578b\u6821\u9a8c");
                    monitor.subTask("");
                    LayerUpgradeService upgradeService = new LayerUpgradeService();
                    Map<String, SolutionPluginInfo> pluginInfos = LayerChainPage.this.solutionInfos.values().stream().flatMap(solutionInfo -> solutionInfo.getPluginInfos().stream()).collect(Collectors.toMap(p -> p.getPluginId(), p -> p));
                    List<File> solutionPluginFiles = LayerChainPage.this.solutionInfos.values().stream().flatMap(solutionInfo -> solutionInfo.getPluginInfos().stream()).filter(p -> p.isOnline() != null && p.getDeploymentMode().equals((Object)SolutionPluginDeploymentMode.Package)).map(p -> p.getUpdateFile(p.getTargetVersion())).collect(Collectors.toList());
                    List<File> solutionFiles = LayerChainPage.this.solutionInfos.values().stream().filter(a -> a.isOnline() != null && a.getDeploymentMode().equals((Object)SolutionDeploymentMode.Package)).filter(a -> a.getTargetVersion() != null).map(a -> a.getUpdateFile(a.getTargetVersion())).collect(Collectors.toList());
                    List<File> layerFiles = LayerChainPage.this.pedestalInfos.values().stream().filter(a -> a.isOnline() != null).map(a -> a.getUpdateFile(a.getTargetVersion())).collect(Collectors.toList());
                    for (PedestalLayerInfo pedestalInfo : LayerChainPage.this.pedestalInfos.values()) {
                        pedestalInfo.clearRelationError();
                    }
                    for (SolutionLayerInfo solutionLayerInfo : LayerChainPage.this.solutionInfos.values()) {
                        solutionLayerInfo.clearRelationError();
                    }
                    for (SolutionPluginInfo solutionPluginInfo : pluginInfos.values()) {
                        solutionPluginInfo.clearRelationError();
                    }
                    upgradeService.setLayerFiles(layerFiles);
                    upgradeService.setSolutionFiles(solutionFiles);
                    upgradeService.setSolutionPluginFiles(solutionPluginFiles);
                    upgradeService.setSolutionExtensionFiles(new ArrayList<File>());
                    try {
                        upgradeService.initTargetGOTModel();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("\u89e3\u6790\u5f53\u5347\u7ea7\u6a21\u578b\u9519\u8bef", e);
                    }
                    monitor.worked(3);
                    List<RelationError> results = upgradeService.checkTargetRelation();
                    for (RelationError relationError : results) {
                        GOTProperty property = relationError.getProperty();
                        GOTNode gotNode = property.getGOTNode();
                        GOTEntity entity = gotNode.getEntity();
                        String modifiedLayer = gotNode.getModifiedLayer();
                        if (modifiedLayer.equals("ext")) continue;
                        if (modifiedLayer.equals("plg")) {
                            SolutionPluginInfo solutionPluginInfo;
                            String pluginName;
                            if (gotNode.getCreatedLayer().equals("app")) {
                                pluginName = gotNode.getId().substring(0, gotNode.getId().lastIndexOf("."));
                                solutionPluginInfo = pluginInfos.get(pluginName);
                                if (solutionPluginInfo != null) {
                                    solutionPluginInfo.addRelationError(relationError);
                                    continue;
                                }
                                log.error((Object)String.format("\u672a\u77e5\u7684\u5f15\u7528\u5f02\u5e38\u3010%s\u3011: %s", modifiedLayer, entity.getId()));
                                continue;
                            }
                            pluginName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                            solutionPluginInfo = pluginInfos.get(pluginName);
                            if (solutionPluginInfo != null) {
                                solutionPluginInfo.addRelationError(relationError);
                                continue;
                            }
                            log.error((Object)String.format("\u672a\u77e5\u7684\u5f15\u7528\u5f02\u5e38\u3010%s\u3011: %s", modifiedLayer, entity.getId()));
                            continue;
                        }
                        if (modifiedLayer.equals("app")) {
                            String solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                            SolutionLayerInfo solutionLayerInfo = (SolutionLayerInfo)LayerChainPage.this.solutionInfos.get(solutionName);
                            if (solutionLayerInfo != null) {
                                solutionLayerInfo.addRelationError(relationError);
                                continue;
                            }
                            log.error((Object)String.format("\u672a\u77e5\u7684\u5f15\u7528\u5f02\u5e38\u3010%s\u3011: %s", modifiedLayer, entity.getId()));
                            continue;
                        }
                        PedestalLayerInfo pedestalLayerInfo = (PedestalLayerInfo)LayerChainPage.this.pedestalInfos.get(modifiedLayer);
                        if (pedestalLayerInfo != null) {
                            pedestalLayerInfo.addRelationError(relationError);
                            continue;
                        }
                        log.error((Object)String.format("\u672a\u77e5\u7684\u5f15\u7528\u5f02\u5e38\u3010%s\u3011: %s", modifiedLayer, entity.getId()));
                    }
                    Display.getDefault().asyncExec(() -> {
                        for (PedestalLayerInfo pedestalInfo : LayerChainPage.this.pedestalInfos.values()) {
                            pedestalInfo.updateBindItem();
                        }
                        for (SolutionLayerInfo solutionLayerInfo : LayerChainPage.this.solutionInfos.values()) {
                            solutionLayerInfo.updateBindItem();
                        }
                        for (SolutionPluginInfo solutionPluginInfo : pluginInfos.values()) {
                            solutionPluginInfo.updateBindItem();
                        }
                    });
                    monitor.worked(2);
                    result[0] = results.isEmpty();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            log.error((Object)"\u5f15\u7528\u68c0\u6d4b\u5f02\u5e38", (Throwable)e);
            if (e instanceof InvocationTargetException) {
                MessageDialog.openError((Shell)this.shell, (String)"\u63d0\u793a", (String)e.getCause().getMessage());
            } else {
                MessageDialog.openError((Shell)this.shell, (String)"\u63d0\u793a", (String)e.getMessage());
            }
            return false;
        }
        return result[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void downloadFile(IProgressMonitor monitor) {
        FileOutputStream outputStream;
        InputStream inputStream;
        Object var20_39;
        Throwable throwable;
        URLConnection connection;
        URL url;
        JSONObject responseResult;
        HttpEntity entity;
        CloseableHttpResponse response;
        Object var12_24;
        Throwable throwable2;
        HttpPost httpPost;
        CloseableHttpClient httpClient;
        Serializable layersRoot;
        List solutionDownloads = this.solutionInfos.values().stream().filter(solutionInfo -> solutionInfo.isOnline() != null && solutionInfo.isOnline() != false && !solutionInfo.getUpdateFile(solutionInfo.getTargetVersion()).exists()).collect(Collectors.toList());
        List pluginDownloads = this.solutionInfos.values().stream().flatMap(solutionInfo -> solutionInfo.getPluginInfos().stream()).filter(pluginInfo -> pluginInfo.isOnline() != null && pluginInfo.isOnline() != false && !pluginInfo.getUpdateFile(pluginInfo.getTargetVersion()).exists()).collect(Collectors.toList());
        monitor.beginTask("", solutionDownloads.size() + pluginDownloads.size() + 1);
        monitor.setTaskName("\u30101/2\u3011\u6b63\u5728\u52a0\u8f7d\u5c42\u6587\u4ef6...");
        monitor.subTask("\u6b63\u5728\u4e0b\u8f7d\u5e95\u5ea7");
        String baseUrl = MarketUtil.baseUrl;
        Iterator<PedestalLayerInfo> iterator = this.pedestalInfos.values().iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            final PedestalLayerInfo pedestalInfo = iterator.next();
            File targetUpdateFile = pedestalInfo.getUpdateFile(pedestalInfo.getTargetVersion());
            if (pedestalInfo.isOnline() != null && pedestalInfo.isOnline().booleanValue() && !targetUpdateFile.exists()) {
                if (!targetUpdateFile.getParentFile().exists()) {
                    targetUpdateFile.getParentFile().mkdirs();
                }
                if (pedestalInfo.getCurrentVersion().equals(pedestalInfo.getTargetVersion())) {
                    try {
                        File basePath = ProjectConstants.getBasePath();
                        if (pedestalInfo.getDeploymentMode().equals((Object)LayerDeploymentMode.Package)) {
                            File updateFile = new File(basePath, String.format("Project/Server/GongqiERP/WEB-INF/layers/layer_%s.lyr", pedestalInfo.getLayerId()));
                            FileUtils.copyFile((File)updateFile, (File)targetUpdateFile);
                        }
                        if (targetUpdateFile.exists()) {
                            FileUtils.deleteDirectory((File)targetUpdateFile);
                        }
                        targetUpdateFile.mkdirs();
                    }
                    catch (Exception e) {
                        log.error((Object)"\u590d\u5236\u5e95\u5ea7\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
                        throw new RuntimeException("\u590d\u5236\u5e95\u5ea7\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", e);
                    }
                } else {
                    String downloadUrl = pedestalInfo.getDownloadUrl();
                    String[] split = downloadUrl.split("/");
                    String filename = split[split.length - 1];
                    if (!filename.endsWith(".lyr") && !filename.endsWith(".lyrs")) {
                        return;
                    }
                    try {
                        File layerFile;
                        block99: {
                            URL url2 = new URL(downloadUrl);
                            URLConnection connection2 = url2.openConnection();
                            connection2.addRequestProperty("Cookie", MarketUtil.getCookie());
                            File tempDirectory = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
                            tempDirectory.mkdirs();
                            layerFile = new File(tempDirectory, filename);
                            layerFile.createNewFile();
                            Throwable throwable3 = null;
                            Object var16_31 = null;
                            try {
                                InputStream inputStream2 = connection2.getInputStream();
                                try {
                                    try (FileOutputStream outputStream2 = new FileOutputStream(layerFile);){
                                        IOUtils.copy((InputStream)inputStream2, (OutputStream)outputStream2);
                                    }
                                    if (inputStream2 == null) break block99;
                                }
                                catch (Throwable throwable4) {
                                    if (throwable3 == null) {
                                        throwable3 = throwable4;
                                    } else if (throwable3 != throwable4) {
                                        throwable3.addSuppressed(throwable4);
                                    }
                                    if (inputStream2 == null) throw throwable3;
                                    inputStream2.close();
                                    throw throwable3;
                                }
                                inputStream2.close();
                            }
                            catch (Throwable throwable5) {
                                if (throwable3 == null) {
                                    throwable3 = throwable5;
                                    throw throwable3;
                                }
                                if (throwable3 == throwable5) throw throwable3;
                                throwable3.addSuppressed(throwable5);
                                throw throwable3;
                            }
                        }
                        File objLyr = null;
                        File tempDir = null;
                        if (layerFile.getName().endsWith(".lyrs")) {
                            tempDir = FileUtils.mkTempDir();
                            ZipUtil.unZipFiles((String)layerFile.getAbsolutePath(), (String)tempDir.getAbsolutePath());
                            objLyr = tempDir.listFiles(new FileFilter(){

                                @Override
                                public boolean accept(File file) {
                                    if (!file.getName().endsWith(".lyr")) {
                                        return false;
                                    }
                                    FrameworkManager.registerObjects();
                                    LayerResolver layerResolver = (LayerResolver)ObjectContainer.getInstance(LayerResolver.class);
                                    try {
                                        LayerDefination layerDefination = layerResolver.resolveLayer(file.getAbsolutePath());
                                        return pedestalInfo.getLayerId().equals(layerDefination.getLayerName());
                                    }
                                    catch (Exception exception) {
                                        return false;
                                    }
                                }
                            })[0];
                        } else if (layerFile.getName().endsWith(".lyr")) {
                            try {
                                FrameworkManager.registerObjects();
                                LayerResolver layerResolver = (LayerResolver)ObjectContainer.getInstance(LayerResolver.class);
                                LayerDefination layerDefination = layerResolver.resolveLayer(layerFile.getAbsolutePath());
                                if (pedestalInfo.getLayerId().equals(layerDefination.getLayerName())) {
                                    objLyr = layerFile;
                                }
                            }
                            catch (Exception exception) {}
                        }
                        if (objLyr == null) throw new RuntimeException("\u65e0\u6548\u7684\u5c42\u6587\u4ef6");
                        if (!objLyr.exists()) {
                            throw new RuntimeException("\u65e0\u6548\u7684\u5c42\u6587\u4ef6");
                        }
                        FileUtils.copyFile((File)objLyr, (File)targetUpdateFile);
                    }
                    catch (IOException e) {
                        log.error((Object)"\u4e0b\u8f7d\u5e95\u5ea7\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
                        throw new RuntimeException("\u4e0b\u8f7d\u5e95\u5ea7\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", e);
                    }
                }
            }
            monitor.worked(1);
        }
        iterator = solutionDownloads.iterator();
        while (true) {
            block100: {
                File appFile22;
                if (!iterator.hasNext()) break;
                SolutionLayerInfo solutionInfo2 = (SolutionLayerInfo)((Object)iterator.next());
                monitor.subTask(String.format("\u6b63\u5728\u4e0b\u8f7d\u5e94\u7528\u3010%s\u3011...", StringUtils.isBlank((String)solutionInfo2.getSolutionName()) ? solutionInfo2.getSolutionId() : solutionInfo2.getSolutionName()));
                if (solutionInfo2.getDeploymentMode().equals((Object)SolutionDeploymentMode.Source)) continue;
                if (solutionInfo2.getCurrentVersion().equals(solutionInfo2.getTargetVersion())) {
                    layersRoot = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayersRoot();
                    appFile22 = new File((File)layersRoot, String.format("app/%s%s", solutionInfo2.getSolutionId(), ".app"));
                    if (!appFile22.exists()) throw new RuntimeException("\u672a\u627e\u5230\u5e94\u7528\u6587\u4ef6" + appFile22.getAbsolutePath());
                    if (!appFile22.exists()) throw new RuntimeException("\u672a\u627e\u5230\u5e94\u7528\u6587\u4ef6" + appFile22.getAbsolutePath());
                    try {
                        FileUtils.copyFile((File)appFile22, (File)solutionInfo2.getUpdateFile(solutionInfo2.getTargetVersion()));
                    }
                    catch (IOException e) {
                        log.error((Object)"\u590d\u5236\u5e94\u7528\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
                        throw new RuntimeException("\u590d\u5236\u5e94\u7528\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", e);
                    }
                }
                try {
                    layersRoot = null;
                    appFile22 = null;
                    try {
                        httpClient = HttpClients.createDefault();
                        try {
                            httpPost = new HttpPost(String.format("%s/appuser/download/source?appUserId=%s&versionId=%s", baseUrl, solutionInfo2.getAppUserId(), solutionInfo2.getTargetVersion()));
                            httpPost.addHeader("Cookie", MarketUtil.getCookie());
                            throwable2 = null;
                            var12_24 = null;
                            try {
                                response = httpClient.execute((HttpUriRequest)httpPost);
                                try {
                                    if (response.getStatusLine().getStatusCode() != 200) break block100;
                                    entity = response.getEntity();
                                    responseResult = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)entity, (String)"utf-8"));
                                    if (responseResult.getInteger("errcode") != 0) {
                                        throw new RuntimeException(String.valueOf(solutionInfo2.getSolutionId()) + "\u4e0b\u8f7d\u5931\u8d25\uff1a" + responseResult.getString("errmsg"));
                                    }
                                    url = new URL(responseResult.getString("content"));
                                    connection = url.openConnection();
                                    connection.addRequestProperty("Cookie", MarketUtil.getCookie());
                                    File appFile = solutionInfo2.getUpdateFile(solutionInfo2.getTargetVersion());
                                    appFile.createNewFile();
                                    throwable = null;
                                    var20_39 = null;
                                    try {
                                        inputStream = connection.getInputStream();
                                        try {
                                            outputStream = new FileOutputStream(appFile);
                                            try {
                                                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                                            }
                                            finally {
                                                if (outputStream != null) {
                                                    outputStream.close();
                                                }
                                            }
                                            if (inputStream == null) break block100;
                                        }
                                        catch (Throwable throwable6) {
                                            if (throwable == null) {
                                                throwable = throwable6;
                                            } else if (throwable != throwable6) {
                                                throwable.addSuppressed(throwable6);
                                            }
                                            if (inputStream == null) throw throwable;
                                            inputStream.close();
                                            throw throwable;
                                        }
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable7) {
                                        if (throwable == null) {
                                            throwable = throwable7;
                                            throw throwable;
                                        }
                                        if (throwable == throwable7) throw throwable;
                                        throwable.addSuppressed(throwable7);
                                        throw throwable;
                                    }
                                }
                                finally {
                                    if (response != null) {
                                        response.close();
                                    }
                                }
                            }
                            catch (Throwable throwable8) {
                                if (throwable2 == null) {
                                    throwable2 = throwable8;
                                    throw throwable2;
                                }
                                if (throwable2 == throwable8) throw throwable2;
                                throwable2.addSuppressed(throwable8);
                                throw throwable2;
                            }
                        }
                        finally {
                            if (httpClient != null) {
                                httpClient.close();
                            }
                        }
                    }
                    catch (Throwable appFile22) {
                        if (layersRoot == null) {
                            layersRoot = appFile22;
                            throw layersRoot;
                        }
                        if (layersRoot == appFile22) throw layersRoot;
                        ((Throwable)layersRoot).addSuppressed(appFile22);
                        throw layersRoot;
                    }
                }
                catch (IOException e) {
                    log.error((Object)String.format("\u4e0b\u8f7d\u5e94\u7528\u3010%s\u3011\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", solutionInfo2.getSolutionId()), (Throwable)e);
                    throw new RuntimeException(String.format("\u4e0b\u8f7d\u5e94\u7528\u3010%s\u3011\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", solutionInfo2.getSolutionId()), e);
                }
            }
            monitor.worked(1);
        }
        iterator = pluginDownloads.iterator();
        while (true) {
            block102: {
                if (!iterator.hasNext()) {
                    return;
                }
                SolutionPluginInfo pluginInfo2 = (SolutionPluginInfo)((Object)iterator.next());
                monitor.subTask(String.format("\u6b63\u5728\u4e0b\u8f7d\u63d2\u4ef6\u3010%s\u3011...", pluginInfo2.getPluginId()));
                if (pluginInfo2.getDeploymentMode().equals((Object)SolutionPluginDeploymentMode.Source)) continue;
                if (pluginInfo2.getTargetVersion() == null || pluginInfo2.getCurrentVersion().equals(pluginInfo2.getTargetVersion())) {
                    layersRoot = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayersRoot();
                    File plgFile = new File((File)layersRoot, String.format("plg/%s/%s%s", pluginInfo2.getSolutionLayerInfo().getSolutionId(), pluginInfo2.getPluginId(), ".plugin"));
                    if (!plgFile.exists()) throw new RuntimeException("\u672a\u627e\u5230\u5e94\u7528\u6587\u4ef6" + plgFile.getAbsolutePath());
                    if (!plgFile.exists()) throw new RuntimeException("\u672a\u627e\u5230\u5e94\u7528\u6587\u4ef6" + plgFile.getAbsolutePath());
                    File tempDirectory = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
                    tempDirectory.mkdirs();
                    try {
                        FileUtils.copyFile((File)plgFile, (File)pluginInfo2.getUpdateFile(pluginInfo2.getTargetVersion()));
                    }
                    catch (IOException e) {
                        log.error((Object)"\u590d\u5236\u63d2\u4ef6\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
                        throw new RuntimeException("\u590d\u5236\u63d2\u4ef6\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", e);
                    }
                }
                try {
                    layersRoot = null;
                    Object var8_12 = null;
                    try {
                        httpClient = HttpClients.createDefault();
                        try {
                            httpPost = new HttpPost(String.format("%s/plugin/download/version?pluginId=%s&versionId=%s", baseUrl, pluginInfo2.getDownloadPluginId(), pluginInfo2.getTargetVersion()));
                            httpPost.addHeader("Cookie", MarketUtil.getCookie());
                            throwable2 = null;
                            var12_24 = null;
                            try {
                                response = httpClient.execute((HttpUriRequest)httpPost);
                                try {
                                    if (response.getStatusLine().getStatusCode() != 200) break block102;
                                    entity = response.getEntity();
                                    responseResult = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)entity, (String)"utf-8"));
                                    if (responseResult.getInteger("errcode") != 0) {
                                        throw new RuntimeException("\u4e0b\u8f7d" + pluginInfo2.getPluginId() + "\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a" + responseResult.getString("errmsg"));
                                    }
                                    url = new URL(responseResult.getString("content"));
                                    connection = url.openConnection();
                                    connection.addRequestProperty("Cookie", MarketUtil.getCookie());
                                    File pluginFile = pluginInfo2.getUpdateFile(pluginInfo2.getTargetVersion());
                                    pluginFile.createNewFile();
                                    throwable = null;
                                    var20_39 = null;
                                    try {
                                        inputStream = connection.getInputStream();
                                        try {
                                            outputStream = new FileOutputStream(pluginFile);
                                            try {
                                                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                                            }
                                            finally {
                                                if (outputStream != null) {
                                                    outputStream.close();
                                                }
                                            }
                                            if (inputStream == null) break block102;
                                        }
                                        catch (Throwable throwable9) {
                                            if (throwable == null) {
                                                throwable = throwable9;
                                            } else if (throwable != throwable9) {
                                                throwable.addSuppressed(throwable9);
                                            }
                                            if (inputStream == null) throw throwable;
                                            inputStream.close();
                                            throw throwable;
                                        }
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable10) {
                                        if (throwable == null) {
                                            throwable = throwable10;
                                            throw throwable;
                                        }
                                        if (throwable == throwable10) throw throwable;
                                        throwable.addSuppressed(throwable10);
                                        throw throwable;
                                    }
                                }
                                finally {
                                    if (response != null) {
                                        response.close();
                                    }
                                }
                            }
                            catch (Throwable throwable11) {
                                if (throwable2 == null) {
                                    throwable2 = throwable11;
                                    throw throwable2;
                                }
                                if (throwable2 == throwable11) throw throwable2;
                                throwable2.addSuppressed(throwable11);
                                throw throwable2;
                            }
                        }
                        finally {
                            if (httpClient != null) {
                                httpClient.close();
                            }
                        }
                    }
                    catch (Throwable throwable12) {
                        if (layersRoot == null) {
                            layersRoot = throwable12;
                            throw layersRoot;
                        }
                        if (layersRoot == throwable12) throw layersRoot;
                        ((Throwable)layersRoot).addSuppressed(throwable12);
                        throw layersRoot;
                    }
                }
                catch (IOException e) {
                    log.error((Object)String.format("\u4e0b\u8f7d\u63d2\u4ef6\u3010%s\u3011\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", pluginInfo2.getPluginId()), (Throwable)e);
                    throw new RuntimeException(String.format("\u4e0b\u8f7d\u63d2\u4ef6\u3010%s\u3011\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", pluginInfo2.getPluginId()), e);
                }
            }
            monitor.worked(1);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean uploadPatch(File lyrFile) {
        block35: {
            block40: {
                block45: {
                    block46: {
                        block43: {
                            block44: {
                                block41: {
                                    block42: {
                                        block38: {
                                            block39: {
                                                block36: {
                                                    block37: {
                                                        block33: {
                                                            block34: {
                                                                targetLayersRootDir = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
                                                                targetLayersRootDir.mkdirs();
                                                                if (!lyrFile.getName().endsWith(".lyr")) ** GOTO lbl26
                                                                FrameworkManager.registerObjects();
                                                                layerResolver = (LayerResolver)ObjectContainer.getInstance(LayerResolver.class);
                                                                layerDefination = layerResolver.resolveLayer(lyrFile.getAbsolutePath());
                                                                layerName = layerDefination.getLayerName();
                                                                pedestalInfo = this.pedestalInfos.get(layerName);
                                                                if (pedestalInfo.getDeploymentMode() != LayerDeploymentMode.Source) break block33;
                                                                if (!targetLayersRootDir.exists()) break block34;
                                                                try {
                                                                    FileUtils.deleteDirectory((File)targetLayersRootDir);
                                                                }
                                                                catch (IOException v0) {}
                                                            }
                                                            return false;
                                                        }
                                                        FileUtils.copyFile((File)lyrFile, (File)pedestalInfo.getUpdateFile(layerDefination.getLayerVersion()));
                                                        pedestalInfo.setTargetVersion(layerDefination.getLayerVersion());
                                                        pedestalInfo.setOnline(false);
                                                        pedestalInfo.updateBindItem();
                                                        break block35;
lbl26:
                                                        // 1 sources

                                                        if (!lyrFile.getName().endsWith("app")) ** GOTO lbl58
                                                        ZipUtil.unZipFiles((String)lyrFile.getAbsolutePath(), (String)targetLayersRootDir.getAbsolutePath());
                                                        appXML = new File(targetLayersRootDir, "/Application.xml");
                                                        document = FileUtils.readFileToDocument((File)appXML).getRootElement();
                                                        name = document.element("name").getText();
                                                        version = document.element("version") == null ? "" : document.element("version").getText();
                                                        solutionLayerInfo = this.solutionInfos.get(name);
                                                        if (solutionLayerInfo != null) break block36;
                                                        if (!targetLayersRootDir.exists()) break block37;
                                                        try {
                                                            FileUtils.deleteDirectory((File)targetLayersRootDir);
                                                        }
                                                        catch (IOException v1) {}
                                                    }
                                                    return false;
                                                }
                                                if (solutionLayerInfo.getDeploymentMode() != SolutionDeploymentMode.Source) break block38;
                                                if (!targetLayersRootDir.exists()) break block39;
                                                try {
                                                    FileUtils.deleteDirectory((File)targetLayersRootDir);
                                                }
                                                catch (IOException v2) {}
                                            }
                                            return false;
                                        }
                                        FileUtils.copyFile((File)lyrFile, (File)solutionLayerInfo.getUpdateFile(version));
                                        solutionLayerInfo.setTargetVersion(version);
                                        solutionLayerInfo.setOnline(false);
                                        solutionLayerInfo.updateBindItem();
                                        break block35;
lbl58:
                                        // 1 sources

                                        if (!lyrFile.getName().endsWith("plg")) break block40;
                                        ZipUtil.unZipFiles((String)lyrFile.getAbsolutePath(), (String)targetLayersRootDir.getAbsolutePath());
                                        pluginXML = new File(targetLayersRootDir, "/ApplicationPlugin.xml");
                                        document = FileUtils.readFileToDocument((File)pluginXML).getRootElement();
                                        pluginName = document.element("name").getText();
                                        solutionName = document.element("solutionName").getText();
                                        version = document.element("version") == null ? "" : document.element("version").getText();
                                        solutionLayerInfo = this.solutionInfos.get(solutionName);
                                        if (solutionLayerInfo != null) break block41;
                                        if (!targetLayersRootDir.exists()) break block42;
                                        try {
                                            FileUtils.deleteDirectory((File)targetLayersRootDir);
                                        }
                                        catch (IOException v3) {}
                                    }
                                    return false;
                                }
                                pluginInfo = solutionLayerInfo.getPluginInfo(pluginName);
                                if (pluginInfo != null) break block43;
                                if (!targetLayersRootDir.exists()) break block44;
                                try {
                                    FileUtils.deleteDirectory((File)targetLayersRootDir);
                                }
                                catch (IOException v4) {}
                            }
                            return false;
                        }
                        if (pluginInfo.getDeploymentMode() != SolutionPluginDeploymentMode.Source) break block45;
                        if (!targetLayersRootDir.exists()) break block46;
                        try {
                            FileUtils.deleteDirectory((File)targetLayersRootDir);
                        }
                        catch (IOException v5) {}
                    }
                    return false;
                }
                try {
                    FileUtils.copyFile((File)lyrFile, (File)pluginInfo.getUpdateFile(version));
                    pluginInfo.setTargetVersion(version);
                    pluginInfo.setOnline(false);
                    pluginInfo.updateBindItem();
                }
                catch (IOException e1) {
                    block47: {
                        try {
                            LayerChainPage.log.error((Object)String.format("\u5347\u7ea7\u5c42\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u635f\u574f\uff1a%s", new Object[]{lyrFile.getAbsolutePath()}), (Throwable)e1);
                            if (!targetLayersRootDir.exists()) break block47;
                        }
                        catch (Throwable var10_18) {
                            if (targetLayersRootDir.exists()) {
                                try {
                                    FileUtils.deleteDirectory((File)targetLayersRootDir);
                                }
                                catch (IOException v7) {}
                            }
                            throw var10_18;
                        }
                        try {
                            FileUtils.deleteDirectory((File)targetLayersRootDir);
                        }
                        catch (IOException v8) {}
                    }
                    return false;
                }
            }
            if (targetLayersRootDir.exists()) {
                try {
                    FileUtils.deleteDirectory((File)targetLayersRootDir);
                }
                catch (IOException v6) {}
            }
            return false;
        }
        if (targetLayersRootDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)targetLayersRootDir);
            }
            catch (IOException v9) {}
        }
        return true;
    }

    protected boolean ifModify() {
        String isOnline;
        Element cache;
        PedestalLayerInfo pedestalLayerInfo;
        File cacheFile = new File(LayerChainPage.getTempFileDir(), "Config.xml");
        Map<Object, Object> Pedestals_Cache = new HashMap();
        Map<Object, Object> Solutions_Cache = new HashMap();
        if (cacheFile.exists()) {
            try {
                Document document = FileUtils.readFileToDocument((File)cacheFile);
                Element Root = document.getRootElement();
                List Pedestals = Root.element("Pedestals").elements("Pedestal");
                List Solutions = Root.element("Solutions").elements("Solution");
                Pedestals_Cache = Pedestals.stream().collect(Collectors.toMap(p -> p.getText(), p -> p));
                Solutions_Cache = Solutions.stream().collect(Collectors.toMap(s -> s.attributeValue("id"), s -> s));
            }
            catch (Exception e) {
                log.error((Object)("\u8bfb\u53d6\u5c42\u94fe\u7f13\u5b58\u6587\u4ef6\u5f02\u5e38:" + cacheFile.getAbsolutePath()), (Throwable)e);
            }
        }
        if ((pedestalLayerInfo = this.pedestalInfos.get("sys")) != null && !Pedestals_Cache.containsKey("sys")) {
            if (pedestalLayerInfo.isOnline() != null) {
                return true;
            }
        } else {
            cache = (Element)Pedestals_Cache.get("sys");
            if (cache != null) {
                isOnline = cache.attributeValue("isOnline");
                if (!(Objects.equals(pedestalLayerInfo.isOnline(), Boolean.valueOf(isOnline)) && Objects.equals(pedestalLayerInfo.getTargetVersion(), cache.attributeValue("targetVersion")) && Objects.equals(pedestalLayerInfo.getDownloadUrl(), cache.attributeValue("downloadUrl")))) {
                    return true;
                }
            }
        }
        if ((pedestalLayerInfo = this.pedestalInfos.get("obj")) != null && !Pedestals_Cache.containsKey("obj")) {
            if (pedestalLayerInfo.isOnline() != null) {
                return true;
            }
        } else {
            cache = (Element)Pedestals_Cache.get("obj");
            if (cache != null) {
                isOnline = cache.attributeValue("isOnline");
                if (!(Objects.equals(pedestalLayerInfo.isOnline(), Boolean.valueOf(isOnline)) && Objects.equals(pedestalLayerInfo.getTargetVersion(), cache.attributeValue("targetVersion")) && Objects.equals(pedestalLayerInfo.getDownloadUrl(), cache.attributeValue("downloadUrl")))) {
                    return true;
                }
            }
        }
        if ((pedestalLayerInfo = this.pedestalInfos.get("iny")) != null && !Pedestals_Cache.containsKey("iny")) {
            if (pedestalLayerInfo.isOnline() != null) {
                return true;
            }
        } else {
            cache = (Element)Pedestals_Cache.get("iny");
            if (cache != null) {
                isOnline = cache.attributeValue("isOnline");
                if (!(Objects.equals(pedestalLayerInfo.isOnline(), Boolean.valueOf(isOnline)) && Objects.equals(pedestalLayerInfo.getTargetVersion(), cache.attributeValue("targetVersion")) && Objects.equals(pedestalLayerInfo.getDownloadUrl(), cache.attributeValue("downloadUrl")))) {
                    return true;
                }
            }
        }
        if ((pedestalLayerInfo = this.pedestalInfos.get("ent")) != null && !Pedestals_Cache.containsKey("ent")) {
            if (pedestalLayerInfo.isOnline() != null) {
                return true;
            }
        } else {
            cache = (Element)Pedestals_Cache.get("ent");
            if (cache != null) {
                isOnline = cache.attributeValue("isOnline");
                if (!(Objects.equals(pedestalLayerInfo.isOnline(), Boolean.valueOf(isOnline)) && Objects.equals(pedestalLayerInfo.getTargetVersion(), cache.attributeValue("targetVersion")) && Objects.equals(pedestalLayerInfo.getDownloadUrl(), cache.attributeValue("downloadUrl")))) {
                    return true;
                }
            }
        }
        for (String solutionId : this.solutionInfos.keySet()) {
            SolutionLayerInfo solutionLayerInfo = this.solutionInfos.get(solutionId);
            if (!Solutions_Cache.containsKey(solutionId)) {
                if (solutionLayerInfo.isOnline() != null) {
                    return true;
                }
                if (!solutionLayerInfo.getPluginInfos().stream().filter(s -> s.isOnline() != null).findAny().isPresent()) continue;
                return true;
            }
            Element cache2 = (Element)Solutions_Cache.get(solutionId);
            String isOnline2 = cache2.attributeValue("isOnline");
            if (!(Objects.equals(solutionLayerInfo.isOnline(), Boolean.valueOf(isOnline2)) && Objects.equals(solutionLayerInfo.getTargetVersion(), cache2.attributeValue("targetVersion")) && Objects.equals(solutionLayerInfo.getAppUserId(), cache2.attributeValue("appUserId")))) {
                return true;
            }
            List elements = cache2.element("Plugins").elements("Plugin");
            Map<String, Element> plugins_Cache = elements.stream().collect(Collectors.toMap(p -> p.attributeValue("id"), p -> p));
            List<SolutionPluginInfo> pluginInfos = solutionLayerInfo.getPluginInfos();
            for (SolutionPluginInfo pluginInfo : pluginInfos) {
                if (!plugins_Cache.containsKey(pluginInfo.getPluginId())) {
                    if (pluginInfo.isOnline() == null) continue;
                    return true;
                }
                cache2 = plugins_Cache.get(pluginInfo.getPluginId());
                pluginInfo.setOnline(Boolean.valueOf(isOnline2));
                if (Objects.equals(pluginInfo.isOnline(), Boolean.valueOf(isOnline2)) && Objects.equals(pluginInfo.getTargetVersion(), cache2.attributeValue("targetVersion")) && Objects.equals(pluginInfo.getDownloadPluginId(), cache2.attributeValue("downloadPluginId"))) continue;
                return true;
            }
        }
        return false;
    }

    private void findInLocalFileCache() {
        File cacheFile = new File(LayerChainPage.getTempFileDir(), "Config.xml");
        Map<String, Element> Pedestals_Cache = new HashMap<String, Element>();
        Map<String, Element> Solutions_Cache = new HashMap<String, Element>();
        if (cacheFile.exists()) {
            try {
                Document document = FileUtils.readFileToDocument((File)cacheFile);
                Element Root = document.getRootElement();
                List Pedestals = Root.element("Pedestals").elements("Pedestal");
                List Solutions = Root.element("Solutions").elements("Solution");
                Pedestals_Cache = Pedestals.stream().collect(Collectors.toMap(p -> p.getText(), p -> p));
                Solutions_Cache = Solutions.stream().collect(Collectors.toMap(s -> s.attributeValue("id"), s -> s));
            }
            catch (Exception e) {
                log.error((Object)("\u8bfb\u53d6\u5c42\u94fe\u7f13\u5b58\u6587\u4ef6\u5f02\u5e38:" + cacheFile.getAbsolutePath()), (Throwable)e);
            }
        }
        this.loadPedestal(Pedestals_Cache);
        this.loadSolution(Solutions_Cache);
        Display.getDefault().asyncExec(() -> {
            if (!this.shell.isDisposed()) {
                this.buildTable();
                this.buildTree();
                this.updateInfoRefresh();
            }
        });
        try {
            MarketOnlineVersion.checVersionNew(this.solutionInfos);
        }
        catch (Exception e) {
            log.error((Object)"\u52a0\u8f7d\u53ef\u5347\u7ea7\u7248\u672c\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    protected void clearCache() {
        this.pedestalInfos = new HashMap<String, PedestalLayerInfo>();
        this.solutionInfos = new HashMap<String, SolutionLayerInfo>();
        LayerUpgradeHelper.getInstance().initLayer();
        new Thread(() -> {
            File tempFileDir = LayerChainPage.getTempFileDir();
            if (tempFileDir.exists()) {
                try {
                    FileUtils.deleteDirectory((File)tempFileDir);
                }
                catch (IOException e) {
                    log.error((Object)"\u6e05\u7406\u7f13\u5b58\u76ee\u5f55\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
            }
        }).start();
        layerChainPage = null;
    }

    protected void updateCache() {
        File cacheFile = new File(LayerChainPage.getTempFileDir(), "Config.xml");
        try {
            String targetVersion;
            if (!cacheFile.exists()) {
                cacheFile.getParentFile().mkdirs();
                cacheFile.createNewFile();
            }
            Document document = DocumentHelper.createDocument();
            Element Cache = document.addElement("Cache");
            Element Pedestals = Cache.addElement("Pedestals");
            Element Solutions = Cache.addElement("Solutions");
            for (String layer : this.pedestalInfos.keySet()) {
                PedestalLayerInfo pedestalLayerInfo = this.pedestalInfos.get(layer);
                if (pedestalLayerInfo.isOnline() == null) continue;
                targetVersion = pedestalLayerInfo.getTargetVersion();
                String downloadUrl = pedestalLayerInfo.getDownloadUrl();
                Element Pedestal = Pedestals.addElement("Pedestal");
                Pedestal.setText(layer);
                Pedestal.addAttribute("isOnline", pedestalLayerInfo.isOnline().toString());
                Pedestal.addAttribute("targetVersion", targetVersion);
                Pedestal.addAttribute("downloadUrl", downloadUrl);
                Pedestal.addAttribute("signature", pedestalLayerInfo.getSignature());
            }
            for (String layer : this.solutionInfos.keySet()) {
                SolutionLayerInfo solutionLayerInfo = this.solutionInfos.get(layer);
                if (solutionLayerInfo.isOnline() == null && !solutionLayerInfo.getPluginInfos().stream().filter(p -> p.isOnline() != null).findAny().isPresent()) continue;
                targetVersion = solutionLayerInfo.getTargetVersion();
                String appUserId = solutionLayerInfo.getAppUserId();
                Element Solution = Solutions.addElement("Solution");
                Solution.addAttribute("id", layer);
                if (solutionLayerInfo.isOnline() != null) {
                    Solution.addAttribute("isOnline", solutionLayerInfo.isOnline().toString());
                }
                Solution.addAttribute("targetVersion", targetVersion);
                Solution.addAttribute("appUserId", appUserId);
                Solution.addAttribute("signature", solutionLayerInfo.getSignature());
                List<SolutionPluginInfo> pluginInfos = solutionLayerInfo.getPluginInfos();
                Element Plugins = Solution.addElement("Plugins");
                for (SolutionPluginInfo pluginInfo : pluginInfos) {
                    if (pluginInfo.isOnline() == null) continue;
                    Element Plugin = Plugins.addElement("Plugin");
                    Plugin.addAttribute("id", pluginInfo.getPluginId());
                    Plugin.addAttribute("isOnline", pluginInfo.isOnline().toString());
                    Plugin.addAttribute("targetVersion", pluginInfo.getTargetVersion());
                    Plugin.addAttribute("downloadPluginId", pluginInfo.getDownloadPluginId());
                    Plugin.addAttribute("signature", pluginInfo.getSignature());
                }
            }
            FileUtils.writeDocumentToFile((File)cacheFile, (Document)document);
        }
        catch (IOException e) {
            log.error((Object)"\u91cd\u7f6e\u5c42\u94fe\u7f13\u5b58\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
    }

    private void loadPedestalByCache(PedestalLayerInfo layerInfo, Element cache) {
        String isOnline = cache.attributeValue("isOnline");
        layerInfo.setOnline(Boolean.valueOf(isOnline));
        layerInfo.setTargetVersion(cache.attributeValue("targetVersion"));
        layerInfo.setDownloadUrl(cache.attributeValue("downloadUrl"));
    }

    private String getMd5Sign(File file) {
        if (file.exists() && file.isFile()) {
            return this.generateFileSign(file);
        }
        return "";
    }

    private String generateFileSign(File file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));){
                return DigestUtils.md5DigestAsHex((InputStream)input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)String.format("\u6587\u4ef6\u7b7e\u540d\u9519\u8bef\uff1a%s", file.getAbsolutePath()), (Throwable)e);
            return "";
        }
    }

    public void loadPedestal(Map<String, Element> pedestals_Cache) {
        Element pedestal_Cache;
        Element pedestal_Cache2;
        Element pedestal_Cache3;
        Element pedestal_Cache4;
        this.pedestalInfos = new HashMap<String, PedestalLayerInfo>();
        LayerDefination sysLayer = LayerUpgradeHelper.getInstance().getLayerDefination("sys");
        if (sysLayer == null) {
            return;
        }
        PedestalLayerInfo layerInfo = new PedestalLayerInfo();
        layerInfo.setLayerId("sys");
        layerInfo.setLayerName("\u7cfb\u7edf\u5c42(sys)");
        layerInfo.setLabel(sysLayer.getLayerLabel());
        layerInfo.setNamespace(sysLayer.getLayerNamespace());
        layerInfo.setCurrentVersion(sysLayer.getLayerVersion());
        layerInfo.setDeploymentMode(sysLayer.getDeploymentMode());
        String md5Sign = this.getMd5Sign(layerInfo.getBaseFile());
        layerInfo.setSignature(md5Sign);
        if (pedestals_Cache.containsKey("sys") && md5Sign.equals((pedestal_Cache4 = pedestals_Cache.get("sys")).attributeValue("signature"))) {
            this.loadPedestalByCache(layerInfo, pedestal_Cache4);
        }
        this.pedestalInfos.put("sys", layerInfo);
        LayerDefination objLayer = LayerUpgradeHelper.getInstance().getLayerDefination("obj");
        if (objLayer == null) {
            return;
        }
        layerInfo = new PedestalLayerInfo();
        layerInfo.setLayerId("obj");
        layerInfo.setLayerName("\u5bf9\u8c61\u5c42(obj)");
        layerInfo.setLabel(objLayer.getLayerLabel());
        layerInfo.setNamespace(objLayer.getLayerNamespace());
        layerInfo.setCurrentVersion(objLayer.getLayerVersion());
        layerInfo.setDeploymentMode(objLayer.getDeploymentMode());
        layerInfo.setLowerLayerInfo(this.pedestalInfos.get("sys"));
        md5Sign = this.getMd5Sign(layerInfo.getBaseFile());
        layerInfo.setSignature(md5Sign);
        if (pedestals_Cache.containsKey("obj") && md5Sign.equals((pedestal_Cache3 = pedestals_Cache.get("obj")).attributeValue("signature"))) {
            this.loadPedestalByCache(layerInfo, pedestal_Cache3);
        }
        this.pedestalInfos.put("obj", layerInfo);
        LayerDefination inyLayer = LayerUpgradeHelper.getInstance().getLayerDefination("iny");
        if (inyLayer == null) {
            return;
        }
        layerInfo = new PedestalLayerInfo();
        layerInfo.setLayerId("iny");
        layerInfo.setLayerName("\u884c\u4e1a\u5c42(iny)");
        layerInfo.setLabel(inyLayer.getLayerLabel());
        layerInfo.setNamespace(inyLayer.getLayerNamespace());
        layerInfo.setCurrentVersion(inyLayer.getLayerVersion());
        layerInfo.setDeploymentMode(inyLayer.getDeploymentMode());
        layerInfo.setLowerLayerInfo(this.pedestalInfos.get("obj"));
        md5Sign = this.getMd5Sign(layerInfo.getBaseFile());
        layerInfo.setSignature(md5Sign);
        if (pedestals_Cache.containsKey("iny") && md5Sign.equals((pedestal_Cache2 = pedestals_Cache.get("iny")).attributeValue("signature"))) {
            this.loadPedestalByCache(layerInfo, pedestal_Cache2);
        }
        this.pedestalInfos.put("iny", layerInfo);
        LayerDefination entLayer = LayerUpgradeHelper.getInstance().getLayerDefination("ent");
        if (entLayer == null) {
            return;
        }
        layerInfo = new PedestalLayerInfo();
        layerInfo.setLayerId("ent");
        layerInfo.setLayerName("\u4f01\u4e1a\u5c42(ent)");
        layerInfo.setLabel(entLayer.getLayerLabel());
        layerInfo.setNamespace(entLayer.getLayerNamespace());
        layerInfo.setCurrentVersion(entLayer.getLayerVersion());
        layerInfo.setDeploymentMode(entLayer.getDeploymentMode());
        layerInfo.setLowerLayerInfo(this.pedestalInfos.get("iny"));
        md5Sign = this.getMd5Sign(layerInfo.getBaseFile());
        layerInfo.setSignature(md5Sign);
        if (pedestals_Cache.containsKey("ent") && md5Sign.equals((pedestal_Cache = pedestals_Cache.get("ent")).attributeValue("signature"))) {
            this.loadPedestalByCache(layerInfo, pedestal_Cache);
        }
        this.pedestalInfos.put("ent", layerInfo);
    }

    private void buildTable() {
        this.pedestal.removeAll();
        if (this.pedestalInfos == null) {
            return;
        }
        this.doBuildTable("sys");
        this.doBuildTable("obj");
        this.doBuildTable("iny");
        this.doBuildTable("ent");
    }

    private void doBuildTable(String layerName) {
        if (!this.pedestalInfos.containsKey(layerName)) {
            return;
        }
        PedestalLayerInfo pedestalInfo = this.pedestalInfos.get(layerName);
        if (this.showBinaryOnly.getSelection() && pedestalInfo.getDeploymentMode().equals((Object)LayerDeploymentMode.Source)) {
            return;
        }
        if (this.showUpgradeOnly.getSelection() && pedestalInfo.isOnline() == null) {
            return;
        }
        TableItem tableItem = new TableItem(this.pedestal, 0);
        tableItem.setText(0, pedestalInfo.getLayerName());
        tableItem.setText(1, pedestalInfo.getNamespace());
        tableItem.setText(2, pedestalInfo.getLabel());
        tableItem.setText(3, pedestalInfo.getDeploymentMode().equals((Object)LayerDeploymentMode.Package) ? "\u4e8c\u8fdb\u5236" : "\u6e90\u7801");
        tableItem.setText(4, pedestalInfo.getCurrentVersion());
        tableItem.setText(5, pedestalInfo.getTargetVersion() == null ? "" : pedestalInfo.getTargetVersion());
        tableItem.setText(6, pedestalInfo.isOnline() == null ? "" : (pedestalInfo.isOnline() != false ? "\u5728\u7ebf" : "\u79bb\u7ebf"));
        tableItem.setData("LayerName", (Object)layerName);
        pedestalInfo.setBindItem(tableItem);
        pedestalInfo.updateBindItem();
    }

    public void loadSolution(Map<String, Element> solutions_Cache) {
        this.solutionInfos = new HashMap<String, SolutionLayerInfo>();
        List<SolutionDefinition> solutionDefinitions = LayerUpgradeHelper.getInstance().getSolutionDefinitions();
        List<SolutionPluginDefinition> solutionPluginDefinitions = LayerUpgradeHelper.getInstance().getSolutionPluginDefinitions();
        for (SolutionDefinition solutionDefinition : solutionDefinitions) {
            Element cache;
            SolutionLayerInfo solutionInfo = new SolutionLayerInfo();
            solutionInfo.setSolutionId(solutionDefinition.getSolutionName());
            if (StringUtils.isNotBlank((String)solutionDefinition.getSolutionLabel())) {
                solutionInfo.setSolutionName(solutionDefinition.getSolutionLabel());
            }
            solutionInfo.setCurrentVersion(solutionDefinition.getSolutionVersion());
            solutionInfo.setDeploymentMode(solutionDefinition.getDeploymentMode());
            solutionInfo.setFrameworkVersion(solutionDefinition.getFrameworkVersion());
            String md5Sign = this.getMd5Sign(solutionInfo.getBaseFile());
            solutionInfo.setSignature(md5Sign);
            Map<Object, Object> plugins_Cache = new HashMap();
            if (solutions_Cache.containsKey(solutionDefinition.getSolutionName()) && md5Sign.equals((cache = solutions_Cache.get(solutionDefinition.getSolutionName())).attributeValue("signature"))) {
                String isOnline = cache.attributeValue("isOnline");
                if (isOnline != null) {
                    solutionInfo.setOnline(Boolean.valueOf(isOnline));
                }
                solutionInfo.setTargetVersion(cache.attributeValue("targetVersion"));
                solutionInfo.setAppUserId(cache.attributeValue("appUserId"));
                List elements = cache.element("Plugins").elements("Plugin");
                plugins_Cache = elements.stream().collect(Collectors.toMap(p -> p.attributeValue("id"), p -> p));
            }
            for (SolutionPluginDefinition solutionPlugin : solutionPluginDefinitions) {
                Element cache2;
                if (!solutionPlugin.getSolutionName().equals(solutionDefinition.getSolutionName())) continue;
                SolutionPluginInfo pluginInfo = new SolutionPluginInfo(solutionInfo);
                pluginInfo.setPluginId(solutionPlugin.getName());
                if (StringUtils.isNotBlank((String)solutionPlugin.getLabel())) {
                    pluginInfo.setPluginName(solutionPlugin.getLabel());
                }
                pluginInfo.setCurrentVersion(solutionPlugin.getVersion());
                pluginInfo.setDeploymentMode(solutionPlugin.getDeploymentMode());
                md5Sign = this.getMd5Sign(pluginInfo.getBaseFile());
                pluginInfo.setSignature(md5Sign);
                if (!plugins_Cache.containsKey(solutionPlugin.getName()) || !md5Sign.equals((cache2 = (Element)plugins_Cache.get(solutionPlugin.getName())).attributeValue("signature"))) continue;
                String isOnline = cache2.attributeValue("isOnline");
                pluginInfo.setOnline(Boolean.valueOf(isOnline));
                pluginInfo.setTargetVersion(cache2.attributeValue("targetVersion"));
                pluginInfo.setDownloadPluginId(cache2.attributeValue("downloadPluginId"));
            }
            SolutionExtensionDefinition solutionExtension = LayerUpgradeHelper.getInstance().getSolutionExtensionDefinition(solutionDefinition.getSolutionName());
            if (solutionExtension != null) {
                SolutionExtInfo solutionExtInfo = new SolutionExtInfo(solutionInfo);
                solutionExtInfo.setCurrentVersion(solutionExtension.getExtensionVersion());
                solutionExtInfo.setDeploymentMode(solutionExtension.getDeploymentMode());
            }
            this.solutionInfos.put(solutionDefinition.getSolutionName(), solutionInfo);
        }
    }

    private void buildTree() {
        SolutionLayerInfo solutionLayerInfo;
        this.tree.removeAll();
        if (this.solutionInfos == null) {
            return;
        }
        for (String solutionName : this.solutionInfos.keySet()) {
            solutionLayerInfo = this.solutionInfos.get(solutionName);
            List<SolutionPluginInfo> pluginInfos = solutionLayerInfo.getPluginInfos();
            if (this.showBinaryOnly.getSelection() && solutionLayerInfo.getDeploymentMode().equals((Object)SolutionDeploymentMode.Source) || this.showUpgradeOnly.getSelection() && solutionLayerInfo.isOnline() == null && !pluginInfos.stream().filter(p -> p.isOnline() != null).findFirst().isPresent()) continue;
            TreeItem solutionItem = new TreeItem(this.tree, 0);
            solutionLayerInfo.setBindItem(solutionItem);
            solutionItem.setImage(Images.getIcon("Lyr.png"));
            solutionItem.setData("type", (Object)"app");
            solutionLayerInfo.updateBindItem();
            for (SolutionPluginInfo pluginInfo : pluginInfos) {
                if (this.showBinaryOnly.getSelection() && pluginInfo.getDeploymentMode().equals((Object)SolutionPluginDeploymentMode.Source) || this.showUpgradeOnly.getSelection() && pluginInfo.isOnline() == null) continue;
                TreeItem pluginItem = new TreeItem(solutionItem, 0);
                pluginItem.setImage(Images.getIcon("Plg.png"));
                pluginItem.setData("type", (Object)"plg");
                pluginInfo.setBindItem(pluginItem);
                pluginInfo.updateBindItem();
            }
            SolutionExtInfo extInfo = solutionLayerInfo.getExtInfo();
            if (extInfo == null || this.showBinaryOnly.getSelection() && extInfo.getDeploymentMode().equals((Object)SolutionExtensionDeploymentMode.Source) || this.showUpgradeOnly.getSelection()) continue;
            TreeItem extItem = new TreeItem(solutionItem, 0);
            extItem.setImage(Images.getIcon("Ext.png"));
            extItem.setText(0, "\u5e94\u7528\u6269\u5c55");
            extItem.setText(1, extInfo.getDeploymentMode().equals((Object)SolutionExtensionDeploymentMode.Package) ? "\u4e8c\u8fdb\u5236" : "\u6e90\u7801");
            extItem.setText(2, extInfo.getCurrentVersion());
            extItem.setText(3, extInfo.getTargetVersion() == null ? "" : extInfo.getTargetVersion());
            extItem.setData("type", (Object)"ext");
        }
        for (String solutionName : this.solutionInfos.keySet()) {
            solutionLayerInfo = this.solutionInfos.get(solutionName);
            if (solutionLayerInfo.getBindItem().isDisposed()) continue;
            solutionLayerInfo.getBindItem().setExpanded(true);
            solutionLayerInfo.updateBindItem();
        }
    }

    private void selectOnlineFile(TableItem objItem) {
        String layerName = (String)objItem.getData("LayerName");
        PedestalLayerInfo pedestalLayerInfo = this.pedestalInfos.get(layerName);
        if (pedestalLayerInfo.getDeploymentMode().equals((Object)LayerDeploymentMode.Source)) {
            return;
        }
        if (!MarketUtil.isConnect()) {
            MessageDialog.openError((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u5e94\u7528\u5e02\u573a\u8d26\u53f7\u4fe1\u606f\u672a\u8bbe\u7f6e\u6216\u8bbe\u7f6e\u9519\u8bef\uff0c\u65e0\u6cd5\u8fdb\u884c\u5728\u7ebf\u5b89\u88c5");
            return;
        }
        MarketOnlineVersion marketOnline = new MarketOnlineVersion(pedestalLayerInfo);
        marketOnline.open();
        this.updateInfoRefresh();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void selectOnlineFile(TreeItem treeItem) {
        String type = (String)treeItem.getData("type");
        if (type.equals("app")) {
            SolutionLayerInfo solutionInfo = this.solutionInfos.get(treeItem.getData("id"));
            if (solutionInfo.getDeploymentMode().equals((Object)SolutionDeploymentMode.Source)) {
                return;
            }
            if (MarketUtil.isConnect()) {
                MarketOnlineVersion marketOnline = new MarketOnlineVersion(solutionInfo, this.pedestalInfos.get("obj"));
                marketOnline.open();
                this.updateInfoRefresh();
                return;
            }
            MessageDialog.openError((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u5e94\u7528\u5e02\u573a\u8d26\u53f7\u4fe1\u606f\u672a\u8bbe\u7f6e\u6216\u8bbe\u7f6e\u9519\u8bef\uff0c\u65e0\u6cd5\u8fdb\u884c\u5728\u7ebf\u5347\u7ea7");
            return;
        }
        if (!type.equals("plg")) return;
        String solutionName = (String)treeItem.getParentItem().getData("id");
        SolutionLayerInfo solutionInfo = this.solutionInfos.get(solutionName);
        SolutionPluginInfo pluginInfo = solutionInfo.getPluginInfo((String)treeItem.getData("id"));
        if (pluginInfo.getDeploymentMode().equals((Object)SolutionPluginDeploymentMode.Source)) {
            return;
        }
        if (MarketUtil.isConnect()) {
            MarketOnlineVersion marketOnline = new MarketOnlineVersion(pluginInfo);
            marketOnline.open();
            this.updateInfoRefresh();
            return;
        }
        MessageDialog.openError((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u5e94\u7528\u5e02\u573a\u8d26\u53f7\u4fe1\u606f\u672a\u8bbe\u7f6e\u6216\u8bbe\u7f6e\u9519\u8bef\uff0c\u65e0\u6cd5\u8fdb\u884c\u5728\u7ebf\u5347\u7ea7");
    }

    private void updateInfoRefresh() {
        long pedestalSelect = this.pedestalInfos.values().stream().filter(p -> p.isOnline() != null && !p.getCurrentVersion().equals(p.getTargetVersion())).count();
        long solutionSelect = this.solutionInfos.values().stream().filter(s -> s.isOnline() != null && !s.getCurrentVersion().equals(s.getTargetVersion())).count();
        List plugins = this.solutionInfos.values().stream().flatMap(s -> s.getPluginInfos().stream()).collect(Collectors.toList());
        long pluginSelect = plugins.stream().filter(p -> p.isOnline() != null && !p.getCurrentVersion().equals(p.getTargetVersion())).count();
        this.updateInfo.setText(String.format("\u5e95\u5ea7: %d/%d    \u5e94\u7528:%d/%d    \u63d2\u4ef6:%d/%d", pedestalSelect, this.pedestalInfos.size(), solutionSelect, this.solutionInfos.size(), pluginSelect, plugins.size()));
    }

    private int getLayerLevel(String layerName) {
        switch (layerName) {
            case "sys": {
                return 1;
            }
            case "obj": {
                return 2;
            }
            case "iny": {
                return 3;
            }
            case "ent": {
                return 4;
            }
            case "app": {
                return 5;
            }
            case "plg": {
                return 6;
            }
            case "ext": {
                return 7;
            }
        }
        return 0;
    }

    protected List<String> checkBeforeAnalysis() {
        ArrayList<String> errInfos = new ArrayList<String>();
        List updateLayers = this.pedestalInfos.values().stream().filter(p -> p.isOnline() != null && !p.getCurrentVersion().equals(p.getTargetVersion())).collect(Collectors.toList());
        if (updateLayers.isEmpty()) {
            for (PedestalLayerInfo pedestalInfo : this.pedestalInfos.values()) {
                pedestalInfo.setOnline(true);
                pedestalInfo.setEmptyLayer(false);
                pedestalInfo.setTargetVersion(pedestalInfo.getCurrentVersion());
            }
        } else {
            List layers = this.pedestalInfos.values().stream().sorted((p1, p2) -> this.getLayerLevel(p1.getLayerId()) > this.getLayerLevel(p2.getLayerId()) ? -1 : 1).collect(Collectors.toList());
            boolean flag = false;
            for (PedestalLayerInfo layer : layers) {
                if (layer.isOnline() != null) {
                    flag = true;
                    continue;
                }
                if (!flag) {
                    layer.setOnline(true);
                    layer.setEmptyLayer(true);
                    layer.setTargetVersion(layer.getCurrentVersion());
                    continue;
                }
                errInfos.add(String.format("\u8bf7\u9009\u62e9\u5e95\u5ea7\u3010%s\u3011\u7684\u5347\u7ea7\u7248\u672c", layer.getLayerId()));
            }
            for (SolutionLayerInfo layerInfo : this.solutionInfos.values()) {
                if (layerInfo.isOnline() == null && layerInfo.getDeploymentMode().equals((Object)SolutionDeploymentMode.Package)) {
                    layerInfo.setOnline(true);
                    layerInfo.setTargetVersion(layerInfo.getCurrentVersion());
                }
                List<SolutionPluginInfo> pluginInfos = layerInfo.getPluginInfos();
                for (SolutionPluginInfo solutionPluginInfo : pluginInfos) {
                    if (solutionPluginInfo.isOnline() != null || !solutionPluginInfo.getDeploymentMode().equals((Object)SolutionPluginDeploymentMode.Package)) continue;
                    solutionPluginInfo.setOnline(true);
                    solutionPluginInfo.setTargetVersion(solutionPluginInfo.getCurrentVersion());
                }
            }
        }
        for (PedestalLayerInfo pedestalInfo : this.pedestalInfos.values()) {
            if (pedestalInfo.isOnline() == null || pedestalInfo.isOnline().booleanValue() || pedestalInfo.getUpdateFile(pedestalInfo.getTargetVersion()).exists()) continue;
            errInfos.add(String.format("\u5e95\u5ea7\u3010%s\u3011\u5347\u7ea7\u6587\u4ef6\u5df2\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20", pedestalInfo.getLayerId()));
        }
        for (SolutionLayerInfo layerInfo : this.solutionInfos.values()) {
            List<SolutionPluginInfo> pluginInfos = layerInfo.getPluginInfos();
            if (layerInfo.isOnline() != null) {
                List solutionPluginInfos = pluginInfos.stream().filter(p -> p.getDeploymentMode().equals((Object)SolutionPluginDeploymentMode.Package) && p.isOnline() == null).collect(Collectors.toList());
                for (SolutionPluginInfo solutionPluginInfo : solutionPluginInfos) {
                    solutionPluginInfo.setTargetVersion(solutionPluginInfo.getCurrentVersion());
                    solutionPluginInfo.setOnline(true);
                }
                if (layerInfo.isOnline() == null || layerInfo.isOnline().booleanValue() || layerInfo.getUpdateFile(layerInfo.getTargetVersion()).exists()) continue;
                errInfos.add(String.format("\u5e94\u7528\u3010%s\u3011\u5347\u7ea7\u6587\u4ef6\u5df2\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20", layerInfo.getSolutionName()));
                continue;
            }
            Optional<SolutionPluginInfo> findFirst = pluginInfos.stream().filter(p -> p.isOnline() != null).findFirst();
            if (!findFirst.isPresent()) continue;
            SolutionPluginInfo solutionPluginInfo2 = findFirst.get();
            SolutionLayerInfo solutionLayerInfo = solutionPluginInfo2.getSolutionLayerInfo();
            solutionLayerInfo.setOnline(true);
            solutionLayerInfo.setTargetVersion(solutionLayerInfo.getCurrentVersion());
        }
        List pluginInfos = this.solutionInfos.values().stream().flatMap(solutionInfo -> solutionInfo.getPluginInfos().stream()).filter(p -> p.isOnline() != null && p.isOnline() == false && !p.getUpdateFile(p.getTargetVersion()).exists()).collect(Collectors.toList());
        for (SolutionPluginInfo pluginInfo : pluginInfos) {
            errInfos.add(String.format("\u63d2\u4ef6\u3010%s\u3011:\u5347\u7ea7\u6587\u4ef6\u5df2\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20", pluginInfo.getPluginName()));
        }
        return errInfos;
    }

    protected void resetAll() {
        this.loadPedestal(new HashMap<String, Element>());
        this.buildTable();
        this.loadSolution(new HashMap<String, Element>());
        this.buildTree();
        this.updateInfoRefresh();
        try {
            MarketOnlineVersion.checVersionNew(this.solutionInfos);
        }
        catch (Exception e) {
            log.error((Object)"\u52a0\u8f7d\u53ef\u5347\u7ea7\u7248\u672c\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    public static File getTempFileDir() {
        File basePath = ProjectConstants.getBasePath();
        File cacheFile = new File(basePath, "Temp/LayerChainCache");
        if (!cacheFile.exists()) {
            cacheFile.mkdirs();
        }
        return cacheFile;
    }

    protected Map<String, SolutionLayerInfo> getSolutions() {
        return this.solutionInfos;
    }

    protected Map<String, PedestalLayerInfo> getPedestals() {
        return this.pedestalInfos;
    }

    private void addPedestalListener() {
        this.pedestal.addMouseListener((MouseListener)new MouseAdapter(){
            long lastSelectTime = 0L;

            public void mouseDown(MouseEvent e) {
                PedestalLayerInfo pedestalLayerInfo;
                TableItem[] selections = LayerChainPage.this.pedestal.getSelection();
                if (selections.length == 0) {
                    return;
                }
                final TableItem select = selections[0];
                if (LayerChainPage.this.pedestal.getMenu() != null) {
                    LayerChainPage.this.pedestal.getMenu().dispose();
                }
                if ((pedestalLayerInfo = (PedestalLayerInfo)LayerChainPage.this.pedestalInfos.get(select.getData("LayerName"))) == null) {
                    return;
                }
                if (e.button == 3 && select != null) {
                    Menu layMenu = new Menu((Control)LayerChainPage.this.pedestal);
                    this.createMenu(select, layMenu);
                    LayerChainPage.this.pedestal.setMenu(layMenu);
                } else {
                    int count = LayerChainPage.this.pedestal.getSelectionCount();
                    if (count == 0) {
                        return;
                    }
                    this.lastSelectTime = System.currentTimeMillis();
                    final Boolean[] selectFirst = new Boolean[]{true};
                    final TableItem item = LayerChainPage.this.pedestal.getItem(LayerChainPage.this.pedestal.getSelectionIndex());
                    Point point = new Point(e.x, e.y);
                    int selectCol = LayerChainPage.this.pedestal.getColumnCount() - 1;
                    Rectangle rect = item.getBounds(selectCol);
                    if (!rect.contains(point)) {
                        return;
                    }
                    TableEditor editor = new TableEditor(LayerChainPage.this.pedestal);
                    Control oldEditor = editor.getEditor();
                    if (oldEditor != null) {
                        oldEditor.dispose();
                    }
                    final Text changeItemText = new Text((Composite)LayerChainPage.this.pedestal, 0);
                    changeItemText.computeSize(-1, LayerChainPage.this.pedestal.getItemHeight());
                    editor.grabHorizontal = true;
                    editor.minimumHeight = changeItemText.getSize().y;
                    editor.minimumWidth = changeItemText.getSize().x;
                    editor.setEditor((Control)changeItemText, item, selectCol);
                    changeItemText.setEditable(false);
                    changeItemText.forceFocus();
                    changeItemText.setFont(item.getFont());
                    changeItemText.setText(item.getText(selectCol));
                    changeItemText.selectAll();
                    changeItemText.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusLost(FocusEvent focusevent) {
                            changeItemText.dispose();
                        }
                    });
                    changeItemText.addListener(35, new Listener(){

                        public void handleEvent(Event event) {
                            Menu layMenu = new Menu((Control)changeItemText);
                            this.createMenu(select, layMenu);
                            changeItemText.setMenu(layMenu);
                        }
                    });
                    changeItemText.addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseDoubleClick(MouseEvent e) {
                            this.open();
                        }

                        public void mouseUp(MouseEvent e) {
                            if (selectFirst[0].booleanValue()) {
                                selectFirst[0] = false;
                                return;
                            }
                            long time = System.currentTimeMillis() - lastSelectTime;
                            if (time < 500L) {
                                this.open();
                            }
                            if (e.button == 3 && select != null) {
                                Menu layMenu = new Menu((Control)changeItemText);
                                this.createMenu(select, layMenu);
                                changeItemText.setMenu(layMenu);
                            }
                        }

                        private void open() {
                            PedestalLayerInfo pedestalLayerInfo = (PedestalLayerInfo)LayerChainPage.this.pedestalInfos.get(item.getData("LayerName"));
                            boolean online = false;
                            if (pedestalLayerInfo.getDeploymentMode().equals((Object)LayerDeploymentMode.Package)) {
                                PedestalLayerInfo lowerLayerInfo = pedestalLayerInfo.getLowerLayerInfo();
                                if (pedestalLayerInfo.getLayerId().equals("obj") || pedestalLayerInfo.getLayerId().equals("iny") || pedestalLayerInfo.getLayerId().equals("sys")) {
                                    online = true;
                                }
                                while (lowerLayerInfo != null) {
                                    if (lowerLayerInfo.getDeploymentMode().equals((Object)LayerDeploymentMode.Source)) {
                                        online = false;
                                        break;
                                    }
                                    lowerLayerInfo = lowerLayerInfo.getLowerLayerInfo();
                                }
                            }
                            if (online) {
                                try {
                                    LayerChainPage.this.selectOnlineFile(item);
                                }
                                catch (Exception e1) {
                                    MessageDialog.openError((Shell)LayerChainPage.this.shell, (String)"\u63d0\u793a", (String)ExceptionUtils.getMessage((Throwable)e1));
                                }
                            }
                        }
                    });
                }
            }

            private void createMenu(final TableItem select, Menu layMenu) {
                PedestalLayerInfo pedestalLayerInfo = (PedestalLayerInfo)LayerChainPage.this.pedestalInfos.get(select.getData("LayerName"));
                MenuItem addItem = new MenuItem(layMenu, 8);
                addItem.setText("\u7248\u672c\u9009\u62e9");
                addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            LayerChainPage.this.selectOnlineFile(select);
                        }
                        catch (Exception e1) {
                            MessageDialog.openError((Shell)LayerChainPage.this.shell, (String)"\u63d0\u793a", (String)ExceptionUtils.getMessage((Throwable)e1));
                        }
                    }
                });
                MenuItem add_Local = new MenuItem(layMenu, 8);
                add_Local.setText("\u672c\u5730\u4e0a\u4f20");
                add_Local.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        block6: {
                            FileDialog dialog = new FileDialog(LayerChainPage.this.shell, 69634);
                            dialog.setFilterExtensions(new String[]{"*.lyr"});
                            dialog.setText("\u5347\u7ea7\u6587\u4ef6");
                            dialog.open();
                            String[] selectFileNames = dialog.getFileNames();
                            if (selectFileNames != null && selectFileNames.length > 0) {
                                File selectFile = new File(dialog.getFilterPath(), selectFileNames[0]);
                                if (selectFile.exists() && selectFile.getName().endsWith(".lyr")) {
                                    FrameworkManager.registerObjects();
                                    LayerResolver layerResolver = (LayerResolver)ObjectContainer.getInstance(LayerResolver.class);
                                    try {
                                        LayerDefination layerDefination = layerResolver.resolveLayer(selectFile.getAbsolutePath());
                                        String layerName = layerDefination.getLayerName();
                                        PedestalLayerInfo pedestalInfo = (PedestalLayerInfo)LayerChainPage.this.pedestalInfos.get(select.getData("LayerName"));
                                        if (pedestalInfo.getLayerId().equals(layerName)) {
                                            FileUtils.copyFile((File)selectFile, (File)pedestalInfo.getUpdateFile(layerDefination.getLayerVersion()));
                                            pedestalInfo.setTargetVersion(layerDefination.getLayerVersion());
                                            pedestalInfo.setOnline(false);
                                            pedestalInfo.updateBindItem();
                                            break block6;
                                        }
                                        MessageDialog.openError((Shell)LayerChainPage.this.shell, (String)"\u63d0\u793a", (String)String.format("\u6587\u4ef6\u4e0d\u5339\u914d\uff0c\u5f53\u524d\u4e3a%s\u5c42\uff0c\u4e0a\u4f20\u6587\u4ef6\u4e3a%s", pedestalInfo.getLayerId(), layerName));
                                    }
                                    catch (Exception exception) {
                                        MessageDialog.openError((Shell)LayerChainPage.this.shell, (String)"\u63d0\u793a", (String)"\u5347\u7ea7\u7684\u5c42\u6587\u4ef6\u975e\u6cd5");
                                    }
                                } else {
                                    MessageDialog.openError((Shell)LayerChainPage.this.shell, (String)"\u63d0\u793a", (String)"\u65e0\u6548\u7684\u5347\u7ea7\u6587\u4ef6");
                                }
                            }
                        }
                    }
                });
                MenuItem clearItem = new MenuItem(layMenu, 8);
                clearItem.setText("\u91cd\u7f6e");
                clearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        PedestalLayerInfo pedestalLayerInfo = (PedestalLayerInfo)LayerChainPage.this.pedestalInfos.get(select.getData("LayerName"));
                        pedestalLayerInfo.setOnline(null);
                        pedestalLayerInfo.setTargetVersion(null);
                        pedestalLayerInfo.setDownloadUrl(null);
                        pedestalLayerInfo.updateBindItem();
                        LayerChainPage.this.updateInfoRefresh();
                    }
                });
                addItem.setEnabled(false);
                add_Local.setEnabled(false);
                clearItem.setEnabled(false);
                if (pedestalLayerInfo.getDeploymentMode().equals((Object)LayerDeploymentMode.Package)) {
                    PedestalLayerInfo lowerLayerInfo = pedestalLayerInfo.getLowerLayerInfo();
                    if (pedestalLayerInfo.getLayerId().equals("obj") || pedestalLayerInfo.getLayerId().equals("iny") || pedestalLayerInfo.getLayerId().equals("sys")) {
                        addItem.setEnabled(true);
                    }
                    add_Local.setEnabled(true);
                    while (lowerLayerInfo != null) {
                        if (lowerLayerInfo.getDeploymentMode().equals((Object)LayerDeploymentMode.Source)) {
                            addItem.setEnabled(false);
                            add_Local.setEnabled(false);
                            break;
                        }
                        lowerLayerInfo = lowerLayerInfo.getLowerLayerInfo();
                    }
                }
                if (pedestalLayerInfo.isOnline() != null) {
                    clearItem.setEnabled(true);
                }
            }
        });
    }

    private void addSolutionTreeListener() {
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){
            long lastSelectTime = 0L;

            public void mouseDown(MouseEvent e) {
                String type;
                TreeItem[] selection = LayerChainPage.this.tree.getSelection();
                if (selection.length < 1) {
                    return;
                }
                final TreeItem select = selection[0];
                if (LayerChainPage.this.tree.getMenu() != null) {
                    LayerChainPage.this.tree.getMenu().dispose();
                }
                if ((type = (String)select.getData("type")).equals("ext")) {
                    return;
                }
                if (e.button == 3 && select != null) {
                    Menu layMenu = new Menu((Control)LayerChainPage.this.tree);
                    this.createMenu(select, layMenu);
                    LayerChainPage.this.tree.setMenu(layMenu);
                } else {
                    int count = LayerChainPage.this.tree.getSelectionCount();
                    if (count == 0) {
                        return;
                    }
                    final TreeItem item = LayerChainPage.this.tree.getSelection()[0];
                    Point point = new Point(e.x, e.y);
                    int selectCol = LayerChainPage.this.tree.getColumnCount() - 1;
                    Rectangle rect = item.getBounds(LayerChainPage.this.tree.getColumnCount() - 1);
                    if (!rect.contains(point)) {
                        return;
                    }
                    TreeEditor editor = new TreeEditor(LayerChainPage.this.tree);
                    Control oldEditor = editor.getEditor();
                    if (oldEditor != null) {
                        oldEditor.dispose();
                    }
                    this.lastSelectTime = System.currentTimeMillis();
                    final Boolean[] selectFirst = new Boolean[]{true};
                    final Text changeItemText = new Text((Composite)LayerChainPage.this.tree, 0);
                    changeItemText.computeSize(-1, LayerChainPage.this.tree.getItemHeight());
                    editor.grabHorizontal = true;
                    editor.minimumHeight = changeItemText.getSize().y;
                    editor.minimumWidth = changeItemText.getSize().x;
                    editor.setEditor((Control)changeItemText, item, selectCol);
                    changeItemText.forceFocus();
                    changeItemText.setEditable(false);
                    changeItemText.setFont(item.getFont());
                    changeItemText.setText(item.getText(selectCol));
                    changeItemText.selectAll();
                    changeItemText.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusLost(FocusEvent focusevent) {
                            changeItemText.dispose();
                        }
                    });
                    changeItemText.addListener(35, new Listener(){

                        public void handleEvent(Event event) {
                            Menu layMenu = new Menu((Control)changeItemText);
                            this.createMenu(select, layMenu);
                            changeItemText.setMenu(layMenu);
                        }
                    });
                    changeItemText.addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseDoubleClick(MouseEvent e) {
                            this.open();
                        }

                        public void mouseUp(MouseEvent e) {
                            if (selectFirst[0].booleanValue()) {
                                selectFirst[0] = false;
                                return;
                            }
                            long time = System.currentTimeMillis() - lastSelectTime;
                            if (time < 500L) {
                                this.open();
                            }
                            if (e.button == 3 && select != null) {
                                Menu layMenu = new Menu((Control)changeItemText);
                                this.createMenu(select, layMenu);
                                changeItemText.setMenu(layMenu);
                            }
                        }

                        private void open() {
                            boolean online = false;
                            String type = (String)item.getData("type");
                            if (type.equals("app")) {
                                SolutionLayerInfo solutionLayerInfo = (SolutionLayerInfo)LayerChainPage.this.solutionInfos.get(item.getData("id"));
                                if (solutionLayerInfo != null && solutionLayerInfo.getDeploymentMode().equals((Object)SolutionDeploymentMode.Package)) {
                                    online = true;
                                }
                            } else if (type.equals("plg")) {
                                String pluginName = (String)item.getData("id");
                                String solutionName = (String)item.getParentItem().getData("id");
                                SolutionLayerInfo solutionLayerInfo = (SolutionLayerInfo)LayerChainPage.this.solutionInfos.get(solutionName);
                                SolutionPluginInfo pluginInfo = null;
                                if (solutionLayerInfo != null) {
                                    pluginInfo = solutionLayerInfo.getPluginInfo(pluginName);
                                }
                                if (pluginInfo != null && pluginInfo.getDeploymentMode().equals((Object)SolutionPluginDeploymentMode.Package)) {
                                    online = true;
                                }
                            }
                            if (online) {
                                try {
                                    LayerChainPage.this.selectOnlineFile(item);
                                }
                                catch (Exception e1) {
                                    MessageDialog.openError((Shell)LayerChainPage.this.shell, (String)"\u63d0\u793a", (String)ExceptionUtils.getMessage((Throwable)e1));
                                }
                            }
                        }
                    });
                }
            }

            private void createMenu(final TreeItem select, Menu layMenu) {
                final String type = (String)select.getData("type");
                if (type.equals("ext")) {
                    return;
                }
                MenuItem addItem = new MenuItem(layMenu, 8);
                addItem.setText("\u7248\u672c\u9009\u62e9");
                addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            LayerChainPage.this.selectOnlineFile(select);
                        }
                        catch (Exception e1) {
                            MessageDialog.openError((Shell)LayerChainPage.this.shell, (String)"\u63d0\u793a", (String)ExceptionUtils.getMessage((Throwable)e1));
                        }
                    }
                });
                MenuItem add_Local = new MenuItem(layMenu, 8);
                add_Local.setText("\u672c\u5730\u4e0a\u4f20");
                add_Local.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        block33: {
                            FileDialog dialog = new FileDialog(LayerChainPage.this.shell, 69634);
                            if (type.equals("app")) {
                                dialog.setFilterExtensions(new String[]{"*.app"});
                            } else if (type.equals("plg")) {
                                dialog.setFilterExtensions(new String[]{"*.plugin"});
                            } else {
                                return;
                            }
                            dialog.setText("\u5347\u7ea7\u6587\u4ef6");
                            dialog.open();
                            String[] selectFileNames = dialog.getFileNames();
                            if (selectFileNames == null || selectFileNames.length <= 0) {
                                return;
                            }
                            File updateFile = new File(dialog.getFilterPath(), selectFileNames[0]);
                            try {
                                if (type.equals("app")) {
                                    SolutionLayerInfo solutionLayerInfo = (SolutionLayerInfo)LayerChainPage.this.solutionInfos.get(select.getData("id"));
                                    File targetLayersRootDir = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
                                    targetLayersRootDir.mkdirs();
                                    try {
                                        try {
                                            String version;
                                            ZipUtil.unZipFiles((String)updateFile.getAbsolutePath(), (String)targetLayersRootDir.getAbsolutePath());
                                            File appXML = new File(targetLayersRootDir, "/Application.xml");
                                            Element document = FileUtils.readFileToDocument((File)appXML).getRootElement();
                                            String name = document.element("name").getText();
                                            String string = version = document.element("version") == null ? "" : document.element("version").getText();
                                            if (!solutionLayerInfo.getSolutionId().equals(name) && (solutionLayerInfo = (SolutionLayerInfo)LayerChainPage.this.solutionInfos.get(name)) == null) {
                                                throw new RuntimeException(String.format("\u4e0a\u4f20\u7684\u5e94\u7528\u4e3a%s\uff0c\u672a\u5728\u5f53\u524d\u73af\u5883\u627e\u5230\u76f8\u5339\u914d\u7684\u5e94\u7528", name));
                                            }
                                            FileUtils.copyFile((File)updateFile, (File)solutionLayerInfo.getUpdateFile(version));
                                            solutionLayerInfo.setTargetVersion(version);
                                            solutionLayerInfo.setOnline(false);
                                            solutionLayerInfo.updateBindItem();
                                        }
                                        catch (IOException e1) {
                                            throw new RuntimeException(String.format("\u5347\u7ea7\u5c42\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u635f\u574f\uff1a%s", updateFile.getAbsolutePath()), e1);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        if (targetLayersRootDir.exists()) {
                                            try {
                                                FileUtils.deleteDirectory((File)targetLayersRootDir);
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        throw throwable;
                                    }
                                    if (targetLayersRootDir.exists()) {
                                        try {
                                            FileUtils.deleteDirectory((File)targetLayersRootDir);
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    break block33;
                                }
                                if (!type.equals("plg")) break block33;
                                String solutionName = (String)select.getParentItem().getData("id");
                                SolutionLayerInfo solutionLayerInfo = (SolutionLayerInfo)LayerChainPage.this.solutionInfos.get(solutionName);
                                SolutionPluginInfo pluginInfo = solutionLayerInfo.getPluginInfo((String)select.getData("id"));
                                File targetLayersRootDir = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
                                targetLayersRootDir.mkdirs();
                                try {
                                    try {
                                        String version;
                                        ZipUtil.unZipFiles((String)updateFile.getAbsolutePath(), (String)targetLayersRootDir.getAbsolutePath());
                                        File pluginXML = new File(targetLayersRootDir, "/ApplicationPlugin.xml");
                                        Element document = FileUtils.readFileToDocument((File)pluginXML).getRootElement();
                                        String pluginName = document.element("name").getText();
                                        String string = version = document.element("version") == null ? "" : document.element("version").getText();
                                        if (!pluginInfo.getPluginId().equals(pluginName)) {
                                            String appName = document.element("solutionName").getText();
                                            solutionLayerInfo = (SolutionLayerInfo)LayerChainPage.this.solutionInfos.get(appName);
                                            if (solutionLayerInfo == null) {
                                                throw new RuntimeException(String.format("\u4e0a\u4f20\u7684\u6587\u4ef6\u662f\u5e94\u7528%s\u7684\u63d2\u4ef6%s\uff0c\u5728\u5f53\u524d\u73af\u5883\u4e2d\uff0c\u672a\u627e\u5230\u4e0e\u4e4b\u5339\u914d\u7684\u63d2\u4ef6", appName, pluginName));
                                            }
                                            pluginInfo = solutionLayerInfo.getPluginInfo(pluginName);
                                            if (pluginInfo == null) {
                                                throw new RuntimeException(String.format("\u4e0a\u4f20\u7684\u6587\u4ef6\u662f\u5e94\u7528%s\u7684\u63d2\u4ef6%s\uff0c\u5728\u5f53\u524d\u73af\u5883\u4e2d\uff0c\u672a\u627e\u5230\u4e0e\u4e4b\u5339\u914d\u7684\u63d2\u4ef6", appName, pluginName));
                                            }
                                        }
                                        FileUtils.copyFile((File)updateFile, (File)pluginInfo.getUpdateFile(version));
                                        pluginInfo.setTargetVersion(version);
                                        pluginInfo.setOnline(false);
                                        pluginInfo.updateBindItem();
                                    }
                                    catch (IOException e1) {
                                        throw new RuntimeException(String.format("\u5347\u7ea7\u5c42\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u635f\u574f\uff1a%s", updateFile.getAbsolutePath()), e1);
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (targetLayersRootDir.exists()) {
                                        try {
                                            FileUtils.deleteDirectory((File)targetLayersRootDir);
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    throw throwable;
                                }
                                if (targetLayersRootDir.exists()) {
                                    try {
                                        FileUtils.deleteDirectory((File)targetLayersRootDir);
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                            catch (Exception e1) {
                                MessageDialog.openError((Shell)LayerChainPage.this.shell, (String)"\u63d0\u793a", (String)e1.getMessage());
                            }
                        }
                    }
                });
                MenuItem clearItem = new MenuItem(layMenu, 8);
                clearItem.setText("\u91cd\u7f6e");
                clearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (type.equals("app")) {
                            TreeItem[] plugins;
                            SolutionLayerInfo solutionLayerInfo = (SolutionLayerInfo)LayerChainPage.this.solutionInfos.get(select.getData("id"));
                            solutionLayerInfo.setOnline(null);
                            solutionLayerInfo.setTargetVersion(null);
                            solutionLayerInfo.setAppUserId(null);
                            solutionLayerInfo.updateBindItem();
                            TreeItem[] treeItemArray = plugins = select.getItems();
                            int n = plugins.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TreeItem treeItem = treeItemArray[n2];
                                String pluginName = (String)treeItem.getData("id");
                                SolutionPluginInfo pluginInfo = solutionLayerInfo.getPluginInfo(pluginName);
                                if (pluginInfo != null) {
                                    pluginInfo.setDownloadPluginId(null);
                                    pluginInfo.setOnline(null);
                                    pluginInfo.setTargetVersion(null);
                                    pluginInfo.updateBindItem();
                                }
                                ++n2;
                            }
                        } else if (type.equals("plg")) {
                            String pluginName = (String)select.getData("id");
                            String solutionName = (String)select.getParentItem().getData("id");
                            SolutionLayerInfo solutionLayerInfo = (SolutionLayerInfo)LayerChainPage.this.solutionInfos.get(solutionName);
                            SolutionPluginInfo pluginInfo = solutionLayerInfo.getPluginInfo(pluginName);
                            pluginInfo.setDownloadPluginId(null);
                            pluginInfo.setOnline(null);
                            pluginInfo.setTargetVersion(null);
                            pluginInfo.updateBindItem();
                        }
                        LayerChainPage.this.updateInfoRefresh();
                    }
                });
                MenuItem dependItem = new MenuItem(layMenu, 8);
                dependItem.setText("\u4f9d\u8d56\u7248\u672c");
                dependItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (type.equals("app")) {
                            SolutionLayerInfo solutionLayerInfo = (SolutionLayerInfo)LayerChainPage.this.solutionInfos.get(select.getData("id"));
                            DependVersionDialog dialog = new DependVersionDialog(solutionLayerInfo);
                            dialog.open();
                        } else if (type.equals("plg")) {
                            String pluginName = (String)select.getData("id");
                            String solutionName = (String)select.getParentItem().getData("id");
                            SolutionLayerInfo solutionLayerInfo = (SolutionLayerInfo)LayerChainPage.this.solutionInfos.get(solutionName);
                            SolutionPluginInfo pluginInfo = solutionLayerInfo.getPluginInfo(pluginName);
                            DependVersionDialog dialog = new DependVersionDialog(pluginInfo);
                            dialog.open();
                        }
                    }
                });
                final ArrayList<RelationError> relationErrors = new ArrayList<RelationError>();
                if ("app".equals(type)) {
                    relationErrors.addAll(((SolutionLayerInfo)LayerChainPage.this.solutionInfos.get(select.getData("id"))).getRelationErrors());
                } else if ("plg".equals(type)) {
                    relationErrors.addAll(((SolutionLayerInfo)LayerChainPage.this.solutionInfos.get(select.getParentItem().getData("id"))).getPluginInfo((String)select.getData("id")).getRelationErrors());
                }
                if (relationErrors != null && relationErrors.size() > 0) {
                    MenuItem showErrorMenuItem = new MenuItem(layMenu, 8);
                    showErrorMenuItem.setText("\u67e5\u770b\u8be6\u60c5");
                    showErrorMenuItem.setToolTipText("\u67e5\u770b\u5c5e\u6027\u5173\u8054\u9519\u8bef\u5217\u8868");
                    showErrorMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            Shell shell = new Shell(LayerChainPage.this.shell, 67680);
                            shell.setLayout((Layout)new FormLayout());
                            Rectangle bounds = LayerChainPage.this.shell.getBounds();
                            shell.setBounds(bounds.x + 50, bounds.y + 50, bounds.width - 100, bounds.height - 100);
                            Table table = new Table((Composite)shell, 67584);
                            table.setHeaderVisible(true);
                            FormData formData = new FormData();
                            formData.left = new FormAttachment(0, 10);
                            formData.right = new FormAttachment(100, -10);
                            formData.top = new FormAttachment(0, 5);
                            formData.bottom = new FormAttachment(100, -5);
                            table.setLayoutData((Object)formData);
                            String[] stringArray = new String[]{"\u7c7b\u578b", "\u5b9e\u4f53\u8282\u70b9", "\u63cf\u8ff0"};
                            TableColumn column = new TableColumn(table, 16384);
                            column.setText("\u7c7b\u578b");
                            column.setWidth(50);
                            column = new TableColumn(table, 16384);
                            column.setText("\u5b9e\u4f53\u540d\u79f0");
                            column.setWidth(160);
                            column = new TableColumn(table, 16384);
                            column.setText("\u9519\u8bef\u63cf\u8ff0");
                            column.setWidth(480);
                            for (RelationError relationError : relationErrors) {
                                GOTProperty property = relationError.getProperty();
                                GOTNode node = property.getGOTNode();
                                GOTEntity entity = node.getEntity();
                                String entityName = entity.getName();
                                TableItem item = new TableItem(table, 0);
                                item.setText(0, entity.getEntityType().name());
                                if ("plg".equals(select.getData("type")) && !entity.getId().startsWith((String)select.getData("id"))) {
                                    item.setText(1, entityName);
                                } else {
                                    item.setText(1, entityName.contains(".") ? entityName.substring(entityName.lastIndexOf(".")) : entityName);
                                }
                                try {
                                    item.setText(2, String.format("\u3010%s %s=%s\u3011\u8282\u70b9\u3010%s\u3011\u5c5e\u6027%s", node.getNodeType(), StringUtils.isBlank((String)node.getId()) ? "name" : "id", StringUtils.isBlank((String)node.getId()) ? node.getName() : node.getId(), property.getName(), relationError.getDescription()));
                                }
                                catch (NavException e1) {
                                    log.warn((Object)String.format("\u83b7\u53d6\u5b9e\u4f53\u3010%s %s\u3011\u8282\u70b9\u3010%s %s\u3011\u5c5e\u6027\u9519\u8bef\uff1a%s", entity.getEntityType().name(), entity.getName(), node.getNodeType(), node.getId(), property.dumpFragment()), (Throwable)e1);
                                }
                            }
                            shell.open();
                            while (!shell.isDisposed()) {
                                if (shell.getDisplay().readAndDispatch()) continue;
                                shell.getDisplay().sleep();
                            }
                        }
                    });
                }
                dependItem.setEnabled(false);
                clearItem.setEnabled(false);
                addItem.setEnabled(false);
                add_Local.setEnabled(false);
                if (type.equals("app")) {
                    SolutionLayerInfo solutionLayerInfo = (SolutionLayerInfo)LayerChainPage.this.solutionInfos.get(select.getData("id"));
                    if (solutionLayerInfo != null && solutionLayerInfo.getDeploymentMode().equals((Object)SolutionDeploymentMode.Package)) {
                        addItem.setEnabled(true);
                        add_Local.setEnabled(true);
                        dependItem.setEnabled(true);
                        if (solutionLayerInfo.isOnline() != null) {
                            clearItem.setEnabled(true);
                        }
                    }
                } else if (type.equals("plg")) {
                    String pluginName = (String)select.getData("id");
                    String solutionName = (String)select.getParentItem().getData("id");
                    SolutionLayerInfo solutionLayerInfo = (SolutionLayerInfo)LayerChainPage.this.solutionInfos.get(solutionName);
                    SolutionPluginInfo pluginInfo = null;
                    if (solutionLayerInfo != null) {
                        pluginInfo = solutionLayerInfo.getPluginInfo(pluginName);
                    }
                    if (pluginInfo != null && pluginInfo.getDeploymentMode().equals((Object)SolutionPluginDeploymentMode.Package)) {
                        addItem.setEnabled(true);
                        add_Local.setEnabled(true);
                        dependItem.setEnabled(true);
                        if (pluginInfo.isOnline() != null) {
                            clearItem.setEnabled(true);
                        }
                    }
                }
            }
        });
    }
}

