/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service.rename;

import com.ximpleware.VTDException;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.handler.JDTHandler;
import gongqi.gdt.designer.service.rename.BaseRename;
import gongqi.gdt.designer.service.rename.EntityRename;
import gongqi.gdt.designer.service.rename.MethodUtil;
import gongqi.gdt.designer.service.rename.NodeRename;
import gongqi.gdt.designer.service.rename.RefFormDataSourceFieldRename;
import gongqi.gdt.osgi.JDTService;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class TableRename
extends BaseRename {
    @Override
    protected void doModifyEntity(EntityRename element) throws VTDException, IOException {
        String entityId = element.getEntityId();
        String sourcePackageName = String.valueOf(this.getJavaPackage(entityId, element.getSourceEntityModifyLayer())) + ".tables";
        String targetPackageName = String.valueOf(this.getJavaPackage(entityId, element.getTargetEntityModifyLayer())) + ".tables";
        String entityName = this.getSimpleName(element.getSourceEntityName());
        String destName = this.getSimpleName(element.getTargetEntityName());
        for (NodeRename nodeRename : element.getNodeRenames()) {
            String type = nodeRename.getNodeType();
            if (!type.equals("TableField")) continue;
            this.renameTableField(String.valueOf(targetPackageName) + ".base", "Base" + entityName, nodeRename);
        }
        if (!entityName.equals(destName)) {
            this.renameEntityName(String.valueOf(targetPackageName) + ".base", "Base" + entityName, "Base" + destName);
            this.renameEntityName(targetPackageName, entityName, destName);
        }
        if (element.getIsPromote().booleanValue() && !entityName.equals(destName)) {
            this.renameEntityName(String.valueOf(sourcePackageName) + ".base", "Base" + entityName, "Base" + destName);
            this.renameEntityName(sourcePackageName, entityName, destName);
        }
    }

    private void renameTableField(String packageName, String entityName, NodeRename nodeRename) throws VTDException, IOException {
        String newName;
        String methodName;
        String srcName = this.getSimpleName(nodeRename.getSourceNodeName());
        String destName = this.getSimpleName(nodeRename.getTargetNodeName());
        JDTService server = JDTHandler.getServer();
        try {
            server.renameVariable(packageName, entityName, "_" + srcName, "_" + destName);
        }
        catch (Exception e) {
            this.log.warn((Object)String.format("\u3010%s.%s\u3011\u7684TableField\u8282\u70b9\u91cd\u547d\u540d\u3010%s -> %s\u3011\u5931\u8d25", packageName, entityName, srcName, destName), (Throwable)e);
        }
        try {
            methodName = "set" + srcName;
            newName = "set" + destName;
            server.renameMethod(packageName, entityName, methodName, nodeRename.getTableFiledParameterType(), newName);
        }
        catch (Exception e) {
            this.log.warn((Object)String.format("\u3010%s.%s\u3011\u7684TableField\u8282\u70b9set\u65b9\u6cd5\u91cd\u547d\u540d\u3010%s -> %s\u3011\u5931\u8d25", packageName, entityName, srcName, destName), (Throwable)e);
        }
        try {
            methodName = "get" + srcName;
            newName = "get" + destName;
            server.renameMethod(packageName, entityName, methodName, new String[0], newName);
        }
        catch (Exception e) {
            this.log.warn((Object)String.format("\u3010%s.%s\u3011\u7684TableField\u8282\u70b9get\u65b9\u6cd5\u91cd\u547d\u540d\u3010%s -> %s\u3011\u5931\u8d25", packageName, entityName, srcName, destName), (Throwable)e);
        }
        List<RefFormDataSourceFieldRename> refFormDataSourceFieldsRenames = nodeRename.getRefFormDataSourceFieldsRename();
        for (RefFormDataSourceFieldRename refFormDataSourceFieldsRename : refFormDataSourceFieldsRenames) {
            String formPackage = refFormDataSourceFieldsRename.getFormPackage();
            String className = refFormDataSourceFieldsRename.getClassName();
            try {
                Map<String, String[]> formItemMethods = MethodUtil.getFormDataSourceFileMethods();
                for (String method : formItemMethods.keySet()) {
                    String[] methodParams = formItemMethods.get(method);
                    server.renameMethod(formPackage, className, String.valueOf(method) + srcName, methodParams, String.valueOf(method) + destName);
                }
            }
            catch (Exception e) {
                this.log.warn((Object)String.format("\u3010%s.%s\u3011\u7684FormDataSourceField\u65b9\u6cd5\u91cd\u547d\u540d\u3010%s -> %s\u3011\u5931\u8d25", className, className, srcName, destName), (Throwable)e);
            }
        }
    }

    @Override
    protected EntityType getSupportEntityType() {
        return EntityType.Table;
    }
}

