/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service.modify;

import com.ximpleware.NavException;
import com.ximpleware.VTDException;
import gongqi.erp.framework.core.LayerDefination;
import gongqi.erp.framework.core.LayerDeploymentMode;
import gongqi.erp.framework.core.LayerLocator;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinition;
import gongqi.erp.framework.core.extension.SolutionExtensionLocator;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinition;
import gongqi.erp.framework.core.plugin.SolutionPluginDeploymentMode;
import gongqi.erp.framework.core.plugin.SolutionPluginLocator;
import gongqi.erp.framework.core.solution.SolutionDefinition;
import gongqi.erp.framework.core.solution.SolutionDeploymentMode;
import gongqi.erp.framework.core.solution.SolutionLocator;
import gongqi.erp.framework.exception.ERPException;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.service.GOTModel;
import gongqi.gdt.designer.service.ProgressMonitor;
import gongqi.gdt.designer.service.modify.Modify;
import gongqi.gdt.designer.service.modify.ModifyLevel;
import gongqi.gdt.designer.service.modify.ModifyType;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.service.node.GOTNode;
import gongqi.gdt.designer.service.node.GOTProperty;
import gongqi.gdt.designer.utils.GOTXMLUtils;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class BaseModify
implements Modify {
    protected final Logger log = Logger.getLogger(this.getClass());
    protected GOTModel sourceGOT;
    protected GOTModel targetGOT;
    protected GOTModel originalTargetGOT;

    public BaseModify(GOTModel sourceGOT, GOTModel targetGOT, GOTModel originalTargetGOT) {
        this.sourceGOT = sourceGOT;
        this.targetGOT = targetGOT;
        this.originalTargetGOT = originalTargetGOT;
    }

    @Override
    public final void modify(Element entitysModify, ProgressMonitor monitor) {
        long currentTimeMillis = System.currentTimeMillis();
        List elements = entitysModify.elements();
        for (Element entityModify : elements) {
            String entityId = entityModify.attributeValue("id");
            EntityType entityType = EntityType.valueOf((String)entityModify.getName());
            monitor.worked(0, String.format("\u6b63\u5728\u4fdd\u5b58%s\u3010%s\u3011\u4fee\u6539", entityType.name(), entityId));
            List modifyItems = entityModify.elements("Item");
            for (Element modifyItem : modifyItems) {
                if (ModifyLevel.valueOf(modifyItem.attributeValue("modifyLevel")) == ModifyLevel.Notify) continue;
                this.doModifyItem(entityId, entityType, modifyItem);
            }
        }
        this.log.info((Object)(String.valueOf(this.getSupportEntityType().name()) + "\u4fee\u6539\u8017\u65f6" + (System.currentTimeMillis() - currentTimeMillis)));
    }

    protected abstract EntityType getSupportEntityType();

    protected void doModifyItem(String entityId, EntityType entityType, Element modifyItem) {
        block15: {
            ModifyType modifyType = ModifyType.valueOf(modifyItem.attributeValue("modifyType"));
            try {
                if (modifyType == ModifyType.Entity_Add) {
                    this.applyEntityAddModify(entityId, entityType, modifyItem);
                    break block15;
                }
                if (modifyType == ModifyType.Entity_Delete) {
                    this.applyEntityDeleteModify(entityId, entityType, modifyItem);
                    break block15;
                }
                if (modifyType == ModifyType.Entity_Rename) {
                    this.applyEntityRenameModify(entityId, entityType, modifyItem);
                    break block15;
                }
                if (modifyType == ModifyType.Entity_Property_Value) {
                    this.applyEntityPropertyValueModify(entityId, entityType, modifyItem);
                    break block15;
                }
                if (modifyType == ModifyType.Entity_Property_Add) {
                    this.applyEntityPropertyAddModify(entityId, entityType, modifyItem);
                    break block15;
                }
                if (modifyType == ModifyType.Entity_Property_Delete) {
                    this.applyEntityPropertyDeleteModify(entityId, entityType, modifyItem);
                    break block15;
                }
                if (modifyType == ModifyType.InnerNode_Add) {
                    this.applyInnerNodeAddModify(entityId, entityType, modifyItem);
                    break block15;
                }
                if (modifyType == ModifyType.InnerNode_Delete) {
                    this.applyInnerNodeDeleteModify(entityId, entityType, modifyItem);
                    break block15;
                }
                if (modifyType == ModifyType.InnerNode_Rename) {
                    this.applyInnerNodeRenameModify(entityId, entityType, modifyItem);
                    break block15;
                }
                if (modifyType == ModifyType.InnerNode_Order) {
                    this.applyInnerNodeOrderModify(entityId, entityType, modifyItem);
                    break block15;
                }
                if (modifyType == ModifyType.InnerNode_Property_Value) {
                    this.applyInnerNodePropertyValueModify(entityId, entityType, modifyItem);
                    break block15;
                }
                if (modifyType == ModifyType.InnerNode_Property_Add) {
                    this.applyInnerNodePropertyAddModify(entityId, entityType, modifyItem);
                    break block15;
                }
                if (modifyType == ModifyType.InnerNode_Property_Delete) {
                    this.applyInnerNodePropertyDeleteModify(entityId, entityType, modifyItem);
                    break block15;
                }
                throw new RuntimeException(String.format("%s\u7c7b\u578b\u8282\u70b9%s\u8fdb\u884c\u5347\u7ea7\u8c03\u6574\u3010%s\u3011\u4e0d\u652f\u6301\uff1a%s", entityId, entityType.name(), modifyType.name(), modifyItem.attributeValue("description")));
            }
            catch (VTDException | IOException e) {
                throw new RuntimeException(String.format("%s\u7c7b\u578b\u8282\u70b9%s\u8fdb\u884c\u5347\u7ea7\u8c03\u6574\u9519\u8bef\uff1a%s", entityId, entityType.name(), modifyItem.attributeValue("description")), e);
            }
        }
    }

    protected void applyInnerNodePropertyDeleteModify(String entityId, EntityType entityType, Element modifyItem) throws VTDException {
        String propertyName = modifyItem.attributeValue("propertyName");
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(entityType, entityId);
        if (this.isModifiedLayerSource(this.sourceGOT, sourceEntity)) {
            GOTNode sourceNode = sourceEntity.getChildNode(modifyItem.attributeValue("innerId"));
            if (sourceNode == null) {
                String nodeType = modifyItem.attributeValue("nodeType");
                sourceNode = sourceEntity.selectSingleNode(nodeType);
            }
            if (sourceNode == null) {
                this.log.warn((Object)String.format("\u8282\u70b9\u4e0d\u5b58\u5728\uff1a%s, message=%s", entityId, modifyItem.asXML()));
                return;
            }
            sourceNode.removeProperty(propertyName);
            sourceEntity.applyModifier();
        } else if (!("app".equals(sourceEntity.getCreatedLayer()) && "plg".equals(sourceEntity.getModifiedLayer()) || this.existModifiedLayer(this.targetGOT, sourceEntity))) {
            throw new ERPException(String.format("%s\u3010%s\u3011\u5b9e\u4f53\u5728%s\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceEntity.getModifiedLayer()));
        }
    }

    protected void applyInnerNodePropertyAddModify(String entityId, EntityType entityType, Element modifyItem) throws VTDException, IOException {
        String propertyName = modifyItem.attributeValue("propertyName");
        GOTEntity targetEntity = this.targetGOT.getEntityById(entityType, entityId);
        GOTNode targetNode = targetEntity.getChildNode(modifyItem.attributeValue("innerId"));
        if (targetNode == null) {
            String nodeType = modifyItem.attributeValue("nodeType");
            targetNode = targetEntity.selectSingleNode(nodeType);
        }
        GOTProperty targetProperty = targetNode.getProperty(propertyName);
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(entityType, entityId);
        if (this.isModifiedLayerSource(this.sourceGOT, sourceEntity)) {
            GOTNode sourceNode = sourceEntity.getChildNode(targetNode.getId());
            if (sourceNode == null) {
                String nodeType = modifyItem.attributeValue("nodeType");
                sourceNode = sourceEntity.selectSingleNode(nodeType);
            }
            if (sourceNode == null) {
                this.log.warn((Object)String.format("\u8282\u70b9\u4e0d\u5b58\u5728\uff1a%s %s, message=%s", entityId, targetNode.getId(), modifyItem.asXML()));
                return;
            }
            List<GOTProperty> allProperties = targetNode.getPropertys();
            List<GOTProperty> currentProperties = sourceNode.getPropertys();
            int index = IntStream.range(0, allProperties.size()).filter(i -> {
                try {
                    return ((GOTProperty)allProperties.get(i)).getName().equals(propertyName);
                }
                catch (NavException navException) {
                    return false;
                }
            }).findFirst().orElse(-1);
            if (index == 0 || currentProperties.size() == 0) {
                sourceNode.addPropertyinHead(targetProperty);
            } else {
                boolean flag = false;
                while (index > 0) {
                    GOTProperty preProperty;
                    if ((preProperty = sourceNode.getProperty(allProperties.get(--index).getName())) == null) continue;
                    sourceNode.addProperty(preProperty, targetProperty);
                    flag = true;
                    break;
                }
                if (!flag) {
                    GOTProperty lastProperty = currentProperties.get(currentProperties.size() - 1);
                    sourceNode.addProperty(lastProperty, targetProperty);
                }
            }
            sourceEntity.applyModifier();
        } else if (!("app".equals(sourceEntity.getCreatedLayer()) && "plg".equals(sourceEntity.getModifiedLayer()) || this.existModifiedLayer(this.targetGOT, sourceEntity))) {
            throw new ERPException(String.format("%s\u3010%s\u3011\u5b9e\u4f53\u5728%s\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceEntity.getModifiedLayer()));
        }
    }

    protected void applyEntityPropertyDeleteModify(String entityId, EntityType entityType, Element modifyItem) throws VTDException {
        String propertyName = modifyItem.attributeValue("propertyName");
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(entityType, entityId);
        if (this.isModifiedLayerSource(this.sourceGOT, sourceEntity)) {
            sourceEntity.removeProperty(propertyName);
            sourceEntity.applyModifier();
        } else {
            GOTEntity targetEntity = this.targetGOT.getEntityById(entityType, entityId);
            if (!("app".equals(targetEntity.getCreatedLayer()) && "plg".equals(targetEntity.getModifiedLayer()) || this.existModifiedLayer(this.targetGOT, targetEntity))) {
                throw new ERPException(String.format("%s\u5b9e\u4f53%s\u5728%s\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceEntity.getModifiedLayer()));
            }
        }
    }

    protected void applyEntityPropertyAddModify(String entityId, EntityType entityType, Element modifyItem) throws VTDException {
        String propertyName = modifyItem.attributeValue("propertyName");
        GOTEntity targetEntity = this.targetGOT.getEntityById(entityType, entityId);
        GOTProperty targetProperty = targetEntity.getProperty(propertyName);
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(entityType, entityId);
        if (this.isModifiedLayerSource(this.sourceGOT, sourceEntity)) {
            List<GOTProperty> allProperties = targetEntity.getPropertys();
            List<GOTProperty> currentProperties = sourceEntity.getPropertys();
            int index = IntStream.range(0, allProperties.size()).filter(i -> {
                try {
                    return ((GOTProperty)allProperties.get(i)).getName().equals(propertyName);
                }
                catch (NavException navException) {
                    return false;
                }
            }).findFirst().orElse(-1);
            if (index == 0 || currentProperties.size() == 0) {
                sourceEntity.addPropertyinHead(targetProperty);
            } else {
                boolean flag = false;
                while (index > 0) {
                    GOTProperty preProperty;
                    if ((preProperty = sourceEntity.getProperty(allProperties.get(--index).getName())) == null) continue;
                    sourceEntity.addProperty(preProperty, targetProperty);
                    flag = true;
                    break;
                }
                if (!flag) {
                    GOTProperty lastProperty = currentProperties.get(currentProperties.size() - 1);
                    sourceEntity.addProperty(lastProperty, targetProperty);
                }
            }
            sourceEntity.applyModifier();
        } else if (!("app".equals(targetEntity.getCreatedLayer()) && "plg".equals(targetEntity.getModifiedLayer()) || this.existModifiedLayer(this.targetGOT, targetEntity))) {
            throw new ERPException(String.format("%s\u5b9e\u4f53%s\u5728%s\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceEntity.getModifiedLayer()));
        }
    }

    protected void applyEntityAddModify(String entityId, EntityType entityType, Element modifyItem) throws VTDException {
    }

    protected void applyEntityDeleteModify(String entityId, EntityType entityType, Element modifyItem) throws VTDException {
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(entityType, entityId);
        List<GOTProperty> propertys = this.getRefEntityPropertys(sourceEntity);
        for (GOTProperty property : propertys) {
            GOTNode node = property.getGOTNode();
            GOTEntity entity = node.getEntity();
            if (!this.isModifiedLayerSource(this.sourceGOT, entity)) continue;
            if (node.getCreatedLayer().equals(this.sourceGOT.getTopLayerDefination().getLayerName())) {
                throw new ERPException(String.format("%s\u3010%s\u3011\u5728\u3010%s\u3011\u5c42\u5b58\u5728\u5b9e\u4f53\u3010%s %s\u3011\u8282\u70b9\u3010 %s\u3011\u5f15\u7528\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), node.getCreatedLayer(), entity.getId(), entity.getName(), node.getId()));
            }
            if (this.sourceGOT.getLayerLevel(node.getCreatedLayer()) <= this.targetGOT.getTopLayerLevel() || this.sourceGOT.getLayerDefination(node.getCreatedLayer()).getDeploymentMode() != LayerDeploymentMode.Package) continue;
            throw new ERPException(String.format("%s\u5b9e\u4f53%s\u5b58\u5728\u4e0b\u5c42\u521b\u5efa\u7684\u8282\u70b9\u5f15\u7528\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), node.getCreatedLayer()));
        }
        this.sourceGOT.removeEntity(sourceEntity);
    }

    protected void applyEntityRenameModify(String entityId, EntityType entityType, Element modifyItem) throws VTDException, IOException {
        GOTEntity targetEntity = this.targetGOT.getEntityById(entityType, entityId);
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(targetEntity.getEntityType(), targetEntity.getId());
        List<GOTProperty> refPropertys = this.getRefEntityPropertys(sourceEntity);
        HashSet<GOTEntity> modifyEntitys = new HashSet<GOTEntity>();
        for (GOTProperty refProperty : refPropertys) {
            GOTNode refNode = refProperty.getGOTNode();
            GOTEntity refEntity = refNode.getEntity();
            if (refEntity.getModifiedLayer().equals("plg") && refEntity.getCreatedLayer().equals("app") && refNode.getCreatedLayer().equals("app") || !StringUtils.isBlank((String)refProperty.getRefInnerId())) continue;
            if (this.isModifiedLayerSource(this.sourceGOT, refEntity)) {
                refProperty.setValue(targetEntity.getName());
                modifyEntitys.add(refEntity);
                continue;
            }
            if (this.existModifiedLayer(this.targetGOT, refEntity)) continue;
            throw new ERPException(String.format("%s\u3010%s\u3011\u5728%s\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", refEntity.getNodeType(), refEntity.getName(), refEntity.getModifiedLayer()));
        }
        for (GOTEntity entity : modifyEntitys) {
            entity.applyModifier();
        }
        String destName = targetEntity.getName();
        if (this.isModifiedLayerSource(this.sourceGOT, sourceEntity)) {
            sourceEntity.setName(destName);
            sourceEntity.applyModifier();
        }
    }

    protected final File getJavaSourceDir(GOTEntity entity) {
        File javaSourceDir;
        block10: {
            try {
                if (this.isModifiedLayerSource(this.sourceGOT, entity)) break block10;
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("\u83b7\u53d6\u5b9e\u4f53%s\u6e90\u7801\u76ee\u5f55\u9519\u8bef", entity.getId()), e);
            }
        }
        if ("app".equals(entity.getModifiedLayer())) {
            String namespace = entity.getId().substring(0, entity.getId().lastIndexOf("."));
            javaSourceDir = ((SolutionLocator)ObjectContainer.getInstance(SolutionLocator.class)).getSolutionSourceDir(namespace);
        } else if ("plg".equals(entity.getModifiedLayer())) {
            String solutionPluginName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
            SolutionPluginDefinition solutionPluginDefinition = this.sourceGOT.getSolutionPluginDefinition(solutionPluginName);
            javaSourceDir = ((SolutionPluginLocator)ObjectContainer.getInstance(SolutionPluginLocator.class)).getSolutionPluginSourceDir(solutionPluginDefinition.getSolutionName(), solutionPluginName);
        } else if ("ext".equals(entity.getModifiedLayer())) {
            String solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
            if ("plg".equals(entity.getCreatedLayer())) {
                SolutionPluginDefinition solutionPluginDefinition = this.targetGOT.getSolutionPluginDefinition(solutionName);
                solutionName = solutionPluginDefinition.getSolutionName();
            }
            javaSourceDir = ((SolutionExtensionLocator)ObjectContainer.getInstance(SolutionExtensionLocator.class)).getSolutionExtensionSourceDir(solutionName);
        } else {
            javaSourceDir = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayerSourceDir(entity.getModifiedLayer());
        }
        return javaSourceDir;
    }

    protected final String getJavaPackage(GOTEntity entity) {
        try {
            if ("app".equals(entity.getModifiedLayer()) || "plg".equals(entity.getModifiedLayer()) || "ext".equals(entity.getModifiedLayer())) {
                String namespace = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                return String.format("%s.layers.%s", namespace, entity.getModifiedLayer());
            }
            return "gongqi.erp.layers." + entity.getModifiedLayer();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("\u83b7\u53d6\u5b9e\u4f53%s\u6e90\u7801\u5305\u9519\u8bef", entity.getId()), e);
        }
    }

    protected void applyEntityPropertyValueModify(String entityId, EntityType entityType, Element modifyItem) throws VTDException, IOException {
        String propertyName = modifyItem.attributeValue("propertyName");
        GOTEntity targetEntity = this.targetGOT.getEntityById(entityType, entityId);
        GOTProperty targetProperty = targetEntity.getProperty(propertyName);
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(entityType, entityId);
        targetEntity.getEntityType();
        if (this.sourceGOT.getLayerDefination(sourceEntity.getModifiedLayer()).getDeploymentMode() == LayerDeploymentMode.Source) {
            GOTProperty sourceProperty = sourceEntity.getProperty(propertyName);
            sourceProperty.setValue(targetProperty.getValue());
            sourceProperty.setInnerId(targetProperty.getInnerId());
            sourceProperty.setRefEntityId(targetProperty.getRefEntityId());
            sourceProperty.setRefInnerId(targetProperty.getRefInnerId());
            sourceEntity.applyModifier();
        } else if (!("app".equals(targetEntity.getCreatedLayer()) && "plg".equals(targetEntity.getModifiedLayer()) || this.existModifiedLayer(this.targetGOT, targetEntity))) {
            throw new ERPException(String.format("%s\u5b9e\u4f53%s\u5728%s\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceEntity.getModifiedLayer()));
        }
    }

    protected List<GOTProperty> getRefEntityPropertys(GOTEntity gotEntity) throws VTDException {
        return this.sourceGOT.getRefEntityPropertys(gotEntity.getId());
    }

    private Set<GOTEntity> applyDataTypeSizeOrDecimalModify(GOTEntity targetEntity) throws VTDException, IOException {
        HashSet<GOTEntity> modifyEntitys = new HashSet<GOTEntity>();
        if (EntityType.DataType != targetEntity.getEntityType()) {
            return modifyEntitys;
        }
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(targetEntity.getEntityType(), targetEntity.getId());
        if (sourceEntity == null) {
            return modifyEntitys;
        }
        List<GOTProperty> refPropertys = this.getRefEntityPropertys(targetEntity);
        for (GOTProperty refProperty : refPropertys) {
            GOTProperty sourceProperty;
            GOTProperty extendsProperty;
            GOTNode refNode = refProperty.getGOTNode();
            GOTEntity refEntity = refNode.getEntity();
            if (!this.sourceGOT.isSourceDeployment(refEntity.getModifiedLayer(), refEntity, null) || this.sourceGOT.getLayerDefination(refEntity.getModifiedLayer()).getDeploymentMode() != LayerDeploymentMode.Source || this.sourceGOT.getLayerDefination(refNode.getModifiedLayer()).getDeploymentMode() != LayerDeploymentMode.Source) continue;
            GOTProperty targetProperty = targetEntity.getProperty("StringSize");
            if (targetProperty != null) {
                if (("TableField".equals(refNode.getNodeType()) || "FormItem".equals(refNode.getNodeType())) && (extendsProperty = refNode.getProperty("Extends")) != null && StringUtils.isNotBlank((String)extendsProperty.getRefEntityId())) continue;
                sourceProperty = refNode.getProperty(targetProperty.getName());
                if (targetProperty != null && sourceProperty != null && Integer.parseInt(targetProperty.getValue()) > Integer.parseInt(sourceProperty.getValue())) {
                    sourceProperty.setValue(targetProperty.getValue());
                    modifyEntitys.add(refEntity);
                }
            }
            if ((targetProperty = targetEntity.getProperty("NumOfDecimals")) != null) {
                if ("TableField".equals(refNode.getNodeType()) && StringUtils.isNotBlank((String)(extendsProperty = refNode.getProperty("Extends")).getRefEntityId())) continue;
                sourceProperty = refNode.getProperty(targetProperty.getName());
                if (targetProperty != null && sourceProperty != null) {
                    String targetValue = targetProperty.getValue();
                    String sourceValue = sourceProperty.getValue();
                    if (Integer.parseInt(targetValue) > Integer.parseInt(sourceValue)) {
                        sourceProperty.setValue(targetValue);
                        modifyEntitys.add(refEntity);
                    }
                }
            }
            if (refEntity.getEntityType() != EntityType.DataType) continue;
            modifyEntitys.addAll(this.applyDataTypeSizeOrDecimalModify(refEntity));
        }
        return modifyEntitys;
    }

    /*
     * Unable to fully structure code
     */
    protected void applyInnerNodeAddModify(String entityId, EntityType entityType, Element modifyItem) throws VTDException, IOException {
        block27: {
            block24: {
                block26: {
                    targetEntity = this.targetGOT.getEntityById(entityType, entityId);
                    targetNode = targetEntity.getChildNode(modifyItem.attributeValue("innerId"));
                    if (targetNode == null) {
                        nodeType = modifyItem.attributeValue("nodeType");
                        targetNode = targetEntity.selectSingleNode(nodeType);
                    }
                    if (!this.isModifiedLayerSource(this.sourceGOT, sourceEntity = this.sourceGOT.getEntityById(entityType, entityId))) break block26;
                    prevSiblingNode = targetNode.getPrevSiblingNode();
                    if (prevSiblingNode != null) ** GOTO lbl25
                    sourceParent = sourceEntity.getChildNode(targetNode.getParent().getId());
                    if (sourceParent == null) {
                        sourceParent = sourceEntity.selectSingleNode(targetNode.getParent().getEntityXPath());
                    }
                    sourceParent.insertAfterHead(targetNode.dumpFragment());
                    sourceEntity.applyModifier();
                    break block24;
lbl-1000:
                    // 1 sources

                    {
                        sourcePrevSiblingNode = sourceEntity.getChildNode(prevSiblingNode.getId());
                        if (sourcePrevSiblingNode != null) {
                            sourcePrevSiblingNode.insertAfterElement(targetNode.dumpFragment());
                            sourceEntity.applyModifier();
                        } else {
                            if ((prevSiblingNode = prevSiblingNode.getPrevSiblingNode()) != null) continue;
                            sourceParent = sourceEntity.getChildNode(targetNode.getParent().getId());
                            sourceParent.insertAfterHead(targetNode.dumpFragment());
                            sourceEntity.applyModifier();
                        }
                        break block24;
lbl25:
                        // 2 sources

                        ** while (prevSiblingNode != null)
                    }
lbl26:
                    // 1 sources

                    break block24;
                }
                if (!("app".equals(targetEntity.getCreatedLayer()) && "plg".equals(targetEntity.getModifiedLayer()) || this.existModifiedLayer(this.targetGOT, targetNode))) {
                    throw new ERPException(String.format("%s\u5b9e\u4f53%s\u5728%s\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", new Object[]{sourceEntity.getNodeType(), sourceEntity.getName(), sourceEntity.getModifiedLayer()}));
                }
            }
            if (!targetNode.getNodeType().equals("TableField")) break block27;
            xpathFormat = "./FormDataSources/FormDataSource/Properties/Property[@refentityid='%s']/Name[text()='Table']/../../..";
            dataSourceIdentifiers = this.sourceGOT.getEntitys(EntityType.Form).values().stream().filter((Predicate<GOTEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$2(gongqi.gdt.designer.service.node.GOTEntity ), (Lgongqi/gdt/designer/service/node/GOTEntity;)Z)((BaseModify)this)).flatMap((Function<GOTEntity, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$3(java.lang.String gongqi.gdt.designer.service.node.GOTEntity gongqi.gdt.designer.service.node.GOTEntity ), (Lgongqi/gdt/designer/service/node/GOTEntity;)Ljava/util/stream/Stream;)((BaseModify)this, (String)xpathFormat, (GOTEntity)targetEntity)).map((Function<GOTNode, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$5(gongqi.gdt.designer.service.node.GOTNode ), (Lgongqi/gdt/designer/service/node/GOTNode;)Ljava/lang/String;)()).collect(Collectors.toList());
            for (String dataSourceIdentifier : dataSourceIdentifiers) {
                block28: {
                    block25: {
                        formId = dataSourceIdentifier.substring(0, dataSourceIdentifier.indexOf("#"));
                        dataSourceXPath = dataSourceIdentifier.substring(dataSourceIdentifier.indexOf("#") + 1);
                        sourceFormEntity = this.sourceGOT.getEntityById(EntityType.Form, formId);
                        refNode = sourceFormEntity.selectSingleNode(dataSourceXPath);
                        if (!this.isModifiedLayerSource(this.sourceGOT, refNode)) break block28;
                        nextInnerId = Integer.parseInt(sourceFormEntity.getAttributeValue("nextInnerId"));
                        formDataSourceFieldBuf = new StringBuffer();
                        if (targetNode.getAttributeValue("type").equals("Component")) {
                            exttendEntityId = targetNode.getProperty("Extends").getAttributeValue("refentityid");
                            componentDataType = this.sourceGOT.getEntityById(EntityType.DataType, exttendEntityId);
                            dataTypeArrayItems = componentDataType.selectNodes("DataTypeArray/DataTypeArrayItem");
                            for (GOTNode dataTypeArrayItem : dataTypeArrayItems) {
                                layerName = this.sourceGOT.getLayerLevel(dataTypeArrayItem.getCreatedLayer()) > this.sourceGOT.getLayerLevel(refNode.getCreatedLayer()) ? dataTypeArrayItem.getCreatedLayer() : refNode.getCreatedLayer();
                                formDataSourceField = GOTXMLUtils.createFormDataSourceField(String.valueOf(targetNode.getName()) + "." + dataTypeArrayItem.getName(), String.valueOf(nextInnerId++), layerName, "String", targetEntity.getId(), targetNode.getId(), String.valueOf(targetNode.getName()) + "." + dataTypeArrayItem.getName());
                                formDataSourceFieldBuf.append(System.getProperty("line.separator")).append(formDataSourceField);
                            }
                        }
                        layerName = this.sourceGOT.getLayerLevel(targetNode.getCreatedLayer()) > this.sourceGOT.getLayerLevel(refNode.getCreatedLayer()) ? targetNode.getCreatedLayer() : refNode.getCreatedLayer();
                        formDataSourceField = GOTXMLUtils.createFormDataSourceField(targetNode.getName(), String.valueOf(nextInnerId++), layerName, targetNode.getAttributeValue("type"), targetEntity.getId(), targetNode.getId(), targetNode.getName());
                        formDataSourceFieldBuf.append(System.getProperty("line.separator")).append(formDataSourceField);
                        targetPrevSiblingNode = targetNode.getPrevSiblingNode();
                        formDataSourceFields = refNode.selectSingleNode("FormDataSourceFields");
                        if (targetPrevSiblingNode != null) ** GOTO lbl104
                        targetNextSiblingNode = targetNode.getNextSiblingNode();
                        if (targetNextSiblingNode == null) {
                            formDataSourceFields.insertAfterHead(formDataSourceFieldBuf.toString());
                        } else {
                            do {
                                sourceFormDataSourceField = null;
                                if ("Component".equals(targetNextSiblingNode.getAttributeValue("type"))) {
                                    nodes = formDataSourceFields.selectNodes(String.format("FormDataSourceFields/FormDataSourceField/Properties/Property[@refentityid='%s' and @refinnerid='%s']/Name[text()='Field']/../../..", new Object[]{targetNextSiblingNode.getEntity().getId(), targetNextSiblingNode.getId()}));
                                    if (nodes.size() > 0) {
                                        sourceFormDataSourceField = nodes.get(0);
                                    }
                                } else {
                                    sourceFormDataSourceField = formDataSourceFields.selectSingleNode(String.format("FormDataSourceFields/FormDataSourceField/Properties/Property[@refentityid='%s' and @refinnerid='%s']/Name[text()='Field']/../../..", new Object[]{targetNextSiblingNode.getEntity().getId(), targetNextSiblingNode.getId()}));
                                }
                                if (sourceFormDataSourceField == null) continue;
                                sourceFormDataSourceField.insertBeforeElement(formDataSourceFieldBuf.toString());
                                break block25;
                            } while ((targetNextSiblingNode = targetNextSiblingNode.getNextSiblingNode()) != null);
                            formDataSourceFields.insertAfterHead(formDataSourceFieldBuf.toString());
                        }
                        break block25;
lbl-1000:
                        // 1 sources

                        {
                            sourceFormDataSourceField = null;
                            if ("Component".equals(targetPrevSiblingNode.getAttributeValue("type"))) {
                                nodes = formDataSourceFields.selectNodes(String.format("./FormDataSourceField/Properties/Property[@refentityid='%s' and @refinnerid='%s']/Name[text()='Field']/../../..", new Object[]{targetPrevSiblingNode.getEntity().getId(), targetPrevSiblingNode.getId()}));
                                if (!nodes.isEmpty()) {
                                    sourceFormDataSourceField = nodes.get(nodes.size() - 1);
                                }
                            } else {
                                sourceFormDataSourceField = formDataSourceFields.selectSingleNode(String.format("./FormDataSourceField/Properties/Property[@refentityid='%s' and @refinnerid='%s']/Name[text()='Field']/../../..", new Object[]{targetPrevSiblingNode.getEntity().getId(), targetPrevSiblingNode.getId()}));
                            }
                            if (sourceFormDataSourceField != null) {
                                sourceFormDataSourceField.insertAfterElement(formDataSourceFieldBuf.toString());
                                break;
                            }
                            if ((targetPrevSiblingNode = targetPrevSiblingNode.getPrevSiblingNode()) != null) continue;
                            targetNextSiblingNode = targetNode.getNextSiblingNode();
                            if (targetNextSiblingNode == null) {
                                formDataSourceFields.insertAfterHead(formDataSourceFieldBuf.toString());
                                break;
                            }
                            do {
                                if ("Component".equals(targetNextSiblingNode.getAttributeValue("type"))) {
                                    nodes = formDataSourceFields.selectNodes(String.format("./FormDataSourceField/Properties/Property[@refentityid='%s' and @refinnerid='%s']/Name[text()='Field']/../../..", new Object[]{targetNextSiblingNode.getEntity().getId(), targetNextSiblingNode.getId()}));
                                    sourceFormDataSourceField = nodes.get(0);
                                } else {
                                    sourceFormDataSourceField = formDataSourceFields.selectSingleNode(String.format("./FormDataSourceField/Properties/Property[@refentityid='%s' and @refinnerid='%s']/Name[text()='Field']/../../..", new Object[]{targetNextSiblingNode.getEntity().getId(), targetNextSiblingNode.getId()}));
                                }
                                if (sourceFormDataSourceField == null) continue;
                                sourceFormDataSourceField.insertBeforeElement(formDataSourceFieldBuf.toString());
                                break block4;
                            } while ((targetNextSiblingNode = targetNextSiblingNode.getNextSiblingNode()) != null);
                            formDataSourceFields.insertAfterHead(formDataSourceFieldBuf.toString());
                            break;
lbl104:
                            // 2 sources

                            ** while (targetPrevSiblingNode != null)
                        }
                    }
                    sourceFormEntity.setAttributeValue("nextInnerId", String.valueOf(nextInnerId));
                    sourceFormEntity.applyModifier();
                    continue;
                }
                throw new ERPException(String.format("%s\u3010%s\u3011\u5b9e\u4f53\u5185\u90e8\u8282\u70b9%s\u3010%s\u3011\u5f15\u7528\u8282\u70b9%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9%s\u3010%s\u3011\u5728%s\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", new Object[]{targetEntity.getNodeType(), targetEntity.getName(), targetNode.getNodeType(), targetNode.getName(), sourceFormEntity.getNodeType(), sourceFormEntity.getName(), refNode.getNodeType(), refNode.getName(), refNode.getModifiedLayer()}));
            }
        }
    }

    protected void applyInnerNodeDeleteModify(String entityId, EntityType entityType, Element modifyItem) throws VTDException, IOException {
        String innerId;
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(entityType, entityId);
        GOTNode innerNode = sourceEntity.getChildNode(innerId = modifyItem.attributeValue("innerId"));
        if (innerNode == null && StringUtils.isNotBlank((String)innerId)) {
            return;
        }
        if (innerNode == null) {
            String nodeType = modifyItem.attributeValue("nodeType");
            innerNode = sourceEntity.selectSingleNode(nodeType);
        }
        String innerNodeType = innerNode.getNodeType();
        if (this.isModifiedLayerSource(this.sourceGOT, sourceEntity)) {
            innerNode.remove();
            sourceEntity.applyModifier();
        } else if (!("app".equals(sourceEntity.getCreatedLayer()) && "plg".equals(sourceEntity.getModifiedLayer()) || this.existModifiedLayer(this.targetGOT, innerNode))) {
            throw new ERPException(String.format("%s\u3010%s\u3011\u5728%s\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceEntity.getModifiedLayer()));
        }
        if ("TableField".equals(innerNodeType)) {
            HashSet<GOTEntity> modifyEntitys = new HashSet<GOTEntity>();
            List<GOTProperty> refPropertys = this.getRefInnerPropertys("TableField", sourceEntity.getId(), innerId);
            int i = 0;
            int size = refPropertys.size();
            while (i < size) {
                GOTProperty refProperty = refPropertys.get(i);
                GOTNode refNode = refProperty.getGOTNode();
                if ("FormDataSourceField".equals(refNode.getNodeType()) && this.sourceGOT.getLayerDefination(refNode.getEntity().getModifiedLayer()).getDeploymentMode() == LayerDeploymentMode.Source) {
                    refNode.remove();
                    modifyEntitys.add(refNode.getEntity());
                }
                ++i;
            }
            for (GOTEntity modifyEntity : modifyEntitys) {
                modifyEntity.applyModifier();
            }
        }
    }

    protected List<GOTProperty> getRefInnerPropertys(String nodeType, String entityId, String nodeId) throws VTDException {
        return this.sourceGOT.getRefInnerPropertys(entityId, nodeId);
    }

    protected void applyInnerNodeRenameModify(String entityId, EntityType entityType, Element modifyItem) throws VTDException, IOException {
        GOTEntity targetEntity = this.targetGOT.getEntityById(entityType, entityId);
        GOTNode targetNode = targetEntity.getChildNode(modifyItem.attributeValue("innerId"));
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(entityType, entityId);
        GOTNode sourceNode = sourceEntity.getChildNode(targetNode.getId());
        List<GOTProperty> refPropertys = this.getRefInnerPropertys(targetNode.getNodeType(), targetEntity.getId(), targetNode.getId());
        HashSet<GOTEntity> modifyEntitys = new HashSet<GOTEntity>();
        for (GOTProperty refProperty : refPropertys) {
            GOTNode refNode = refProperty.getGOTNode();
            GOTEntity refEntity = refNode.getEntity();
            if ("app".equals(refEntity.getCreatedLayer()) && "plg".equals(refEntity.getModifiedLayer()) || !targetNode.getId().equals(refProperty.getRefInnerId())) continue;
            if (this.isModifiedLayerSource(this.sourceGOT, refEntity)) {
                refProperty.setValue(targetNode.getName());
                if ("FormDataSourceField".equals(refNode.getNodeType())) {
                    refNode.setName(targetNode.getName());
                }
                modifyEntitys.add(refEntity);
                continue;
            }
            if (this.existModifiedLayer(this.targetGOT, refEntity)) continue;
            throw new ERPException(String.format("%s\u5b9e\u4f53%s\u5728%s\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", refEntity.getNodeType(), refEntity.getName(), refEntity.getModifiedLayer()));
        }
        for (GOTEntity modifyEntity : modifyEntitys) {
            modifyEntity.applyModifier();
        }
        String destName = targetNode.getName();
        if (this.isModifiedLayerSource(this.sourceGOT, sourceEntity)) {
            boolean modify = false;
            List<GOTNode> refInnerNodes = sourceEntity.selectNodes(String.format(".//Properties/Property[@innerid='%s']/../..", targetNode.getId()));
            for (GOTNode refInnerNode : refInnerNodes) {
                if (this.isModifiedLayerSource(this.sourceGOT, sourceNode)) {
                    if ("TableIndexItem".equals(refInnerNode.getNodeType())) {
                        refInnerNode.setName(targetNode.getName());
                        modify = true;
                    }
                    for (GOTProperty property : refInnerNode.getPropertys()) {
                        if (!targetNode.getId().equals(property.getInnerId())) continue;
                        property.setValue(targetNode.getName());
                        modify = true;
                    }
                    continue;
                }
                if (this.existModifiedLayer(this.targetGOT, sourceNode)) continue;
                throw new ERPException(String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5728%s\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName(), sourceNode.getModifiedLayer()));
            }
            if (this.isModifiedLayerSource(this.sourceGOT, sourceEntity)) {
                sourceNode.setName(destName);
                modify = true;
            } else if (!this.existModifiedLayer(this.targetGOT, sourceEntity)) {
                throw new ERPException(String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5728%s\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName(), sourceNode.getModifiedLayer()));
            }
            if (modify) {
                sourceEntity.applyModifier();
            }
        } else if (!("app".equals(sourceEntity.getCreatedLayer()) && "plg".equals(sourceEntity.getModifiedLayer()) || this.existModifiedLayer(this.targetGOT, sourceEntity))) {
            throw new ERPException(String.format("%s\u3010%s\u3011\u5b9e\u4f53\u5728%s\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceEntity.getModifiedLayer()));
        }
    }

    protected void applyInnerNodePropertyValueModify(String entityId, EntityType entityType, Element modifyItem) throws VTDException, IOException {
        String propertyName = modifyItem.attributeValue("propertyName");
        GOTEntity targetEntity = this.targetGOT.getEntityById(entityType, entityId);
        GOTNode targetNode = targetEntity.getChildNode(modifyItem.attributeValue("innerId"));
        if (targetNode == null) {
            String nodeType = modifyItem.attributeValue("nodeType");
            targetNode = targetEntity.selectSingleNode(nodeType);
        }
        GOTProperty targetProperty = targetNode.getProperty(propertyName);
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(entityType, entityId);
        if (this.isModifiedLayerSource(this.sourceGOT, sourceEntity)) {
            GOTNode sourceNode = sourceEntity.getChildNode(targetNode.getId());
            if (sourceNode == null) {
                String nodeType = modifyItem.attributeValue("nodeType");
                sourceNode = sourceEntity.selectSingleNode(nodeType);
            }
            if (sourceNode == null) {
                this.log.warn((Object)String.format("\u8282\u70b9\u4e0d\u5b58\u5728\uff1a%s %s, message=%s", entityId, targetNode.getId(), modifyItem.asXML()));
                return;
            }
            GOTProperty sourceProperty = sourceNode.getProperty(propertyName);
            sourceProperty.setValue(targetProperty.getValue());
            sourceEntity.applyModifier();
            sourceProperty = sourceEntity.selectSingleNode(sourceNode.getEntityXPath()).getProperty(sourceProperty.getName());
            sourceProperty.setInnerId(targetProperty.getInnerId());
            sourceEntity.applyModifier();
            sourceProperty = sourceEntity.selectSingleNode(sourceNode.getEntityXPath()).getProperty(sourceProperty.getName());
            sourceProperty.setRefEntityId(targetProperty.getRefEntityId());
            sourceEntity.applyModifier();
            sourceProperty = sourceEntity.selectSingleNode(sourceNode.getEntityXPath()).getProperty(sourceProperty.getName());
            sourceProperty.setRefInnerId(targetProperty.getRefInnerId());
            sourceEntity.applyModifier();
        } else if (!("app".equals(sourceEntity.getCreatedLayer()) && "plg".equals(sourceEntity.getModifiedLayer()) || this.existModifiedLayer(this.targetGOT, sourceEntity))) {
            throw new ERPException(String.format("%s\u3010%s\u3011\u5b9e\u4f53\u5728%s\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceEntity.getModifiedLayer()));
        }
    }

    protected void applyInnerNodeOrderModify(String entityId, EntityType entityType, Element modifyItem) throws VTDException, IOException {
        GOTEntity targetEntity = this.targetGOT.getEntityById(entityType, entityId);
        GOTNode targetNode = targetEntity.getChildNode(modifyItem.attributeValue("innerId"));
        if (targetNode == null) {
            String nodeType = modifyItem.attributeValue("nodeType");
            targetNode = targetEntity.selectSingleNode(nodeType);
        }
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(entityType, entityId);
        GOTNode sourceNode = sourceEntity.selectSingleNode(targetNode.getEntityXPath());
        GOTNode targetPrevSiblingNode = targetNode.getPrevSiblingNode();
        sourceNode.remove();
        if (targetPrevSiblingNode == null) {
            GOTNode targetNextSiblingNode = targetNode.getNextSiblingNode();
            if (targetNextSiblingNode == null) {
                sourceNode.getParent().insertAfterHead(sourceNode.dumpFragment());
            } else {
                GOTNode sourceNextSiblingNode = sourceEntity.selectSingleNode(targetNextSiblingNode.getEntityXPath());
                if (sourceNextSiblingNode != null) {
                    sourceNextSiblingNode.insertBeforeElement(sourceNode.dumpFragment());
                } else {
                    sourceNode.getParent().insertAfterHead(sourceNode.dumpFragment());
                }
            }
        } else {
            GOTNode sourcePrevSiblingNode = sourceEntity.selectSingleNode(targetPrevSiblingNode.getEntityXPath());
            if (sourcePrevSiblingNode == null) {
                GOTNode targetNextSiblingNode = targetNode.getNextSiblingNode();
                if (targetNextSiblingNode == null) {
                    sourceNode.getParent().insertAfterHead(sourceNode.dumpFragment());
                } else {
                    GOTNode sourceNextSiblingNode = sourceEntity.selectSingleNode(targetNextSiblingNode.getEntityXPath());
                    if (sourceNextSiblingNode != null) {
                        sourceNextSiblingNode.insertBeforeElement(sourceNode.dumpFragment());
                    } else {
                        sourceNode.getParent().insertAfterElement(sourceNode.dumpFragment());
                    }
                }
            } else {
                sourcePrevSiblingNode.insertAfterElement(sourceNode.dumpFragment());
            }
        }
        sourceEntity.applyModifier();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void applyMergeNodeModify(GOTNode sourceNode, GOTNode targetNode) throws VTDException, IOException {
        GOTNode sourceNextSiblingNode;
        GOTEntity sourceEntity = sourceNode.getEntity();
        GOTEntity entityClone = GOTEntity.parse(sourceEntity.asXML());
        String nodeXPath = sourceNode.getEntityXPath();
        LinkedHashMap<String, String> nodeIds = new LinkedHashMap<String, String>();
        for (GOTNode child : sourceNode.getChildNodeBFS(true)) {
            nodeIds.put(child.getId(), child.getNodeType());
        }
        for (String nodeId : nodeIds.keySet()) {
            GOTNode node;
            String xpath = String.format(".//%s[@id='%s']", nodeIds.get(nodeId), nodeId);
            if (targetNode.selectSingleNode(xpath) != null || (node = sourceEntity.selectSingleNode(nodeXPath).selectSingleNode(xpath)) == null) continue;
            node.remove();
            sourceEntity.applyModifier();
        }
        GOTEntity transitionEntity = this.originalTargetGOT.getEntityById(sourceEntity.getEntityType(), sourceEntity.getId());
        for (GOTNode child : targetNode.getChildNodeBFS(true)) {
            GOTNode sourceNextSiblingNode2;
            GOTNode targetNextSiblingNode;
            GOTNode targetNextSiblingNode2;
            GOTNode sourcePrevSiblingNode;
            GOTNode targetPrevSiblingNode;
            GOTNode targetParent;
            GOTNode sourceParent;
            GOTNode node0;
            String format = ".//%s[@id='%s']";
            sourceNode = sourceEntity.selectSingleNode(nodeXPath);
            if (sourceNode.selectSingleNode(String.format(format, child.getNodeType(), child.getId())) != null) continue;
            Object nodeXML = child.getNodeContent();
            GOTNode transitionNode = transitionEntity.selectSingleNode(nodeXPath).selectSingleNode(String.format(format, child.getNodeType(), child.getId()));
            if (transitionNode != null && (node0 = entityClone.selectSingleNode(nodeXPath).selectSingleNode(nodeXPath).selectSingleNode(String.format(format, child.getNodeType(), child.getId()))) != null) {
                try {
                    Element element = DocumentHelper.parseText((String)nodeXML).getRootElement();
                    Element element0 = DocumentHelper.parseText((String)node0.dumpFragment()).getRootElement();
                    Element transitionElement = DocumentHelper.parseText((String)transitionNode.dumpFragment()).getRootElement();
                    List propertys = element.selectNodes("./Properties/Property");
                    for (Element property : propertys) {
                        Element property0 = (Element)element0.selectSingleNode(String.format("./Properties/Property[Name='%s']", property.elementText("Name")));
                        Element transitionProperty = (Element)transitionElement.selectSingleNode(String.format("./Properties/Property[Name='%s']", property.elementText("Name")));
                        if (property0 == null || transitionProperty == null) continue;
                        if (property0.attributes().size() != transitionProperty.attributes().size()) {
                            element.attributes().forEach(attribute -> {
                                boolean bl = property.remove((Attribute)attribute);
                            });
                            property0.attributes().forEach(attribute -> property.add(((Attribute)attribute).detach()));
                            property.element("Value").setText(property0.elementText("Value") != null ? property0.elementText("Value") : "");
                            continue;
                        }
                        boolean changeFlag = false;
                        if (property0.attributes().size() > 0) {
                            List attributes = property0.attributes();
                            for (Attribute attribute2 : attributes) {
                                Attribute transitionAttribute = transitionProperty.attribute(attribute2.getName());
                                if (transitionAttribute != null && attribute2.getValue().equals(transitionAttribute.getValue())) continue;
                                changeFlag = true;
                                break;
                            }
                        }
                        if (!changeFlag) {
                            String value0 = property0.elementText("Value");
                            String transitionValue = transitionProperty.elementText("Value");
                            if (value0 != null && !value0.equals(transitionValue) || transitionValue != null && !transitionValue.equals(value0)) {
                                changeFlag = true;
                            }
                        }
                        if (!changeFlag) continue;
                        element.attributes().forEach(attribute -> {
                            boolean bl = property.remove((Attribute)attribute);
                        });
                        property0.attributes().forEach(attribute -> property.add(((Attribute)attribute).detach()));
                        property.element("Value").setText(property0.elementText("Value") != null ? property0.elementText("Value") : "");
                    }
                    nodeXML = element.asXML();
                }
                catch (DocumentException e) {
                    throw new RuntimeException(String.format("\u89e3\u6790\u5b9e\u4f53\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u9519\u8bef\uff1a%s", sourceEntity.getId(), nodeXML), e);
                }
            }
            if ((sourceParent = sourceEntity.getChildNode((targetParent = child.getParent()).getId())) != null) {
                targetPrevSiblingNode = child.getPrevSiblingNode();
                if (targetPrevSiblingNode != null) {
                    sourcePrevSiblingNode = sourceNode.selectSingleNode(String.format(format, targetPrevSiblingNode.getNodeType(), targetPrevSiblingNode.getId()));
                    if (sourcePrevSiblingNode != null && targetParent.getId().equals(sourcePrevSiblingNode.getParent().getId())) {
                        sourcePrevSiblingNode.insertAfterElement((String)nodeXML);
                    } else {
                        targetNextSiblingNode2 = child.getNextSiblingNode();
                        if (targetNextSiblingNode2 != null) {
                            sourceNextSiblingNode = sourceNode.selectSingleNode(String.format(format, targetNextSiblingNode2.getNodeType(), targetNextSiblingNode2.getId()));
                            if (sourceNextSiblingNode != null && targetParent.getId().equals(sourceNextSiblingNode.getParent().getId())) {
                                sourceNextSiblingNode.insertBeforeElement((String)nodeXML);
                            } else {
                                sourceParent.insertBeforeTail((String)nodeXML);
                            }
                        } else {
                            sourceParent.insertBeforeTail((String)nodeXML);
                        }
                    }
                } else {
                    targetNextSiblingNode = child.getNextSiblingNode();
                    if (targetNextSiblingNode != null) {
                        sourceNextSiblingNode2 = sourceNode.selectSingleNode(String.format(format, targetNextSiblingNode.getNodeType(), targetNextSiblingNode.getId()));
                        if (sourceNextSiblingNode2 != null && targetParent.getId().equals(sourceNextSiblingNode2.getParent().getId())) {
                            sourceNextSiblingNode2.insertBeforeElement((String)nodeXML);
                        } else {
                            sourceParent.insertBeforeTail((String)nodeXML);
                        }
                    } else {
                        sourceParent.insertBeforeTail((String)nodeXML);
                    }
                }
            } else {
                targetPrevSiblingNode = child.getPrevSiblingNode();
                if (targetPrevSiblingNode != null) {
                    sourcePrevSiblingNode = sourceNode.selectSingleNode(String.format(format, targetPrevSiblingNode.getNodeType(), targetPrevSiblingNode.getId()));
                    if (sourcePrevSiblingNode != null) {
                        sourcePrevSiblingNode.insertAfterElement((String)nodeXML);
                    } else {
                        targetNextSiblingNode2 = child.getNextSiblingNode();
                        if (targetNextSiblingNode2 != null) {
                            sourceNextSiblingNode = sourceNode.selectSingleNode(String.format(format, targetNextSiblingNode2.getNodeType(), targetNextSiblingNode2.getId()));
                            if (sourceNextSiblingNode != null) {
                                sourceNextSiblingNode.insertBeforeElement((String)nodeXML);
                            } else {
                                sourceNode.insertBeforeTail((String)nodeXML);
                            }
                        } else {
                            sourceNode.insertBeforeTail((String)nodeXML);
                        }
                    }
                } else {
                    targetNextSiblingNode = child.getNextSiblingNode();
                    if (targetNextSiblingNode != null) {
                        sourceNextSiblingNode2 = sourceNode.selectSingleNode(String.format(format, targetNextSiblingNode.getNodeType(), targetNextSiblingNode.getId()));
                        if (sourceNextSiblingNode2 != null) {
                            sourceNextSiblingNode2.insertBeforeElement((String)nodeXML);
                        } else {
                            sourceNode.insertBeforeTail((String)nodeXML);
                        }
                    } else {
                        sourceNode.insertBeforeTail((String)nodeXML);
                    }
                }
            }
            sourceEntity.applyModifier();
        }
        GOTNode nodeClone = entityClone.selectSingleNode(nodeXPath);
        String format = ".//*[@id='%s']";
        for (String nodeId : nodeIds.keySet()) {
            GOTEntity entity;
            GOTNode node = nodeClone.selectSingleNode(String.format(format, nodeId));
            boolean append = false;
            LayerDefination layerDefination = this.sourceGOT.getLayerDefination(node.getCreatedLayer());
            if ("app".equals(layerDefination.getLayerName())) {
                entity = node.getEntity();
                if (!"app".equals(entity.getCreatedLayer())) {
                    throw new ERPException(String.format("\u5b9e\u4f53\u3010%s %s\u3011\u7ed3\u6784\u9519\u8bef\uff0c\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u521b\u5efa\u5c42\u4e3a\u5e94\u7528\u5c42\uff0c\u5b9e\u4f53\u521b\u5efa\u975e\u5e94\u7528\u5c42", entity.getEntityType().name(), entity.getId(), node.getId()));
                }
                if (!entity.getId().contains(".")) {
                    throw new ERPException(String.format("\u5b9e\u4f53\u3010%s %s\u3011\u7f16\u53f7\u9519\u8bef\uff0c\u521b\u5efa\u5c42\u4e3a\u5e94\u7528\u5c42\uff0c\u7f16\u53f7\u4e0d\u542b\u70b9\u53f7", entity.getEntityType().name(), entity.getId()));
                }
                if ("app".equals(entity.getModifiedLayer())) {
                    String solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                    SolutionDefinition solutionDefinition = this.sourceGOT.getSolutionDefinition(solutionName);
                    if (solutionDefinition == null) {
                        throw new ERPException(String.format("\u5b9e\u4f53\u3010%s %s\u3011\u521b\u5efa\u5c42\u4e3a\u5e94\u7528\u5c42\uff0c\u5bf9\u5e94\u5e94\u7528\u5b9a\u4e49\u672a\u627e\u5230", entity.getEntityType().name(), entity.getId()));
                    }
                    append = solutionDefinition.getDeploymentMode() == SolutionDeploymentMode.Source;
                } else if ("plg".equals(entity.getModifiedLayer())) {
                    append = false;
                } else {
                    if (!"ext".equals(entity.getModifiedLayer())) throw new ERPException(String.format("\u5b9e\u4f53\u3010%s %s\u3011\u4fee\u6539\u5c42\u9519\u8bef\uff1a\u521b\u5efa\u5c42\u4e3a\u5e94\u7528\u5c42\uff0c\u4fee\u6539\u5c42\u4e3a\u3010%s\u3011\u5c42", entity.getEntityType().name(), entity.getId(), entity.getModifiedLayer()));
                    append = false;
                }
            } else if ("plg".equals(layerDefination.getLayerName())) {
                entity = node.getEntity();
                if ("app".equals(entity.getCreatedLayer())) {
                    append = false;
                } else {
                    if (!"plg".equals(entity.getCreatedLayer())) throw new ERPException(String.format("\u5b9e\u4f53\u3010%s %s\u3011\u521b\u5efa\u5c42\u9519\u8bef\uff1a\u521b\u5efa\u5c42\u4e3a\u3010%s\u3011\uff0c\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u521b\u5efa\u5c42\u4e3a\u3010%s\u3011", entity.getEntityType().name(), entity.getId(), entity.getCreatedLayer(), node.getCreatedLayer()));
                    if (!entity.getId().contains(".")) {
                        throw new ERPException(String.format("\u5b9e\u4f53\u3010%s %s\u3011\u7f16\u53f7\u9519\u8bef\uff0c\u521b\u5efa\u5c42\u4e3a\u63d2\u4ef6\u5c42\uff0c\u7f16\u53f7\u4e0d\u542b\u70b9\u53f7", entity.getEntityType().name(), entity.getId()));
                    }
                    String solutionPluginName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                    if ("plg".equals(entity.getModifiedLayer())) {
                        SolutionPluginDefinition solutionPluginDefinition = this.sourceGOT.getSolutionPluginDefinition(solutionPluginName);
                        if (solutionPluginDefinition == null) {
                            throw new ERPException(String.format("\u5b9e\u4f53\u3010%s %s\u3011\u521b\u5efa\u5c42\u4e3a\u63d2\u4ef6\u5c42\uff0c\u5bf9\u5e94\u63d2\u4ef6\u5b9a\u4e49\u672a\u627e\u5230", entity.getEntityType().name(), entity.getId()));
                        }
                        append = solutionPluginDefinition.getDeploymentMode() == SolutionPluginDeploymentMode.Source;
                    } else {
                        if (!"ext".equals(entity.getModifiedLayer())) throw new ERPException(String.format("\u5b9e\u4f53\u3010%s %s\u3011\u4fee\u6539\u5c42\u9519\u8bef\uff1a\u521b\u5efa\u5c42\u4e3a\u63d2\u4ef6\u5c42\uff0c\u4fee\u6539\u5c42\u4e3a\u3010%s\u3011", entity.getEntityType().name(), entity.getId(), entity.getModifiedLayer()));
                        append = false;
                    }
                }
            } else if ("ext".equals(layerDefination.getLayerName())) {
                append = true;
            } else {
                boolean bl = append = layerDefination.getDeploymentMode() == LayerDeploymentMode.Source;
            }
            if (!append || sourceEntity.selectSingleNode(String.format(format, nodeId)) != null) continue;
            sourceNode = sourceEntity.selectSingleNode(nodeXPath);
            GOTNode prevSiblingNode = node.getPrevSiblingNode();
            GOTNode nextSiblingNode = node.getNextSiblingNode();
            GOTNode parentNode = node.getParent();
            if (prevSiblingNode != null && sourceNode.selectSingleNode(String.format(format, prevSiblingNode.getId())) != null) {
                GOTNode sourcePrevSiblingNode = sourceNode.selectSingleNode(String.format(format, prevSiblingNode.getId()));
                sourcePrevSiblingNode.insertAfterElement(node.getNodeContent());
            } else if (nextSiblingNode != null && sourceNode.selectSingleNode(String.format(format, nextSiblingNode.getId())) != null) {
                sourceNextSiblingNode = sourceNode.selectSingleNode(String.format(format, nextSiblingNode.getId()));
                sourceNextSiblingNode.insertBeforeElement(node.getNodeContent());
            } else if (parentNode != null && sourceNode.selectSingleNode(String.format(format, parentNode.getId())) != null) {
                GOTNode sourceParentNode = sourceNode.selectSingleNode(String.format(format, parentNode.getId()));
                sourceParentNode.insertBeforeTail(node.getNodeContent());
            } else {
                sourceNode.insertBeforeTail(node.getNodeContent());
            }
            sourceEntity.applyModifier();
        }
        nodeClone = sourceEntity.clone();
        GOTNode nodeFormDesignClone = nodeClone.selectSingleNode(sourceNode.getEntityXPath());
        List<GOTNode> childNodes = nodeFormDesignClone.getChildNodeBFS(true);
        Iterator<GOTNode> iterator = childNodes.iterator();
        while (iterator.hasNext()) {
            GOTNode targetParent;
            GOTNode sourceChild;
            GOTNode sourceNextSiblingNode0;
            GOTNode sourceParent;
            GOTNode targetNextSiblingNode;
            GOTNode sourceNextSiblingNode3;
            GOTNode sourcePrevSiblingNode;
            GOTNode targetPrevSiblingNode;
            format = ".//%s[@id='%s']";
            GOTNode child = iterator.next();
            GOTNode targetChild = targetNode.selectSingleNode(String.format(format, child.getNodeType(), child.getId()));
            if (targetChild == null) {
                GOTNode sourceParent2;
                GOTNode transitionChild = transitionEntity.getChildNode(child.getId());
                if (transitionChild != null) continue;
                GOTNode sourceChild2 = sourceNode.selectSingleNode(String.format(format, child.getNodeType(), child.getId()));
                if (sourceChild2 == null) {
                    GOTNode targetParent2 = child.getParent();
                    GOTNode sourceParent3 = sourceEntity.getChildNode(targetParent2.getId());
                    if (sourceParent3 == null) continue;
                    String nodeXML = child.getNodeContent();
                    targetPrevSiblingNode = child.getPrevSiblingNode();
                    if (targetPrevSiblingNode != null) {
                        sourcePrevSiblingNode = sourceNode.selectSingleNode(String.format(format, targetPrevSiblingNode.getNodeType(), targetPrevSiblingNode.getId()));
                        if (sourcePrevSiblingNode != null && (targetParent2.getId() != null ? targetParent2.getId() : targetParent2.getNodeType()).equals(sourcePrevSiblingNode.getParent().getId() != null ? sourcePrevSiblingNode.getParent().getId() : sourcePrevSiblingNode.getParent().getNodeType())) {
                            sourcePrevSiblingNode.insertAfterElement(nodeXML);
                        } else {
                            GOTNode targetNextSiblingNode3 = child.getNextSiblingNode();
                            if (targetNextSiblingNode3 != null) {
                                sourceNextSiblingNode3 = sourceNode.selectSingleNode(String.format(format, targetNextSiblingNode3.getNodeType(), targetNextSiblingNode3.getId()));
                                if (sourceNextSiblingNode3 != null && targetParent2.getId().equals(sourceNextSiblingNode3.getParent().getId())) {
                                    sourceNextSiblingNode3.insertBeforeElement(nodeXML);
                                } else {
                                    sourceParent3.insertBeforeTail(nodeXML);
                                }
                            } else {
                                sourceParent3.insertBeforeTail(nodeXML);
                            }
                        }
                    } else {
                        targetNextSiblingNode = child.getNextSiblingNode();
                        if (targetNextSiblingNode != null) {
                            GOTNode sourceNextSiblingNode4 = sourceNode.selectSingleNode(String.format(format, targetNextSiblingNode.getNodeType(), targetNextSiblingNode.getId()));
                            if (sourceNextSiblingNode4 != null && (targetParent2.getId() != null && targetParent2.getId().equals(sourceNextSiblingNode4.getParent().getId()) || targetParent2.getName().equals(sourceNextSiblingNode4.getParent().getName()))) {
                                sourceNextSiblingNode4.insertBeforeElement(nodeXML);
                            } else {
                                sourceParent3.insertBeforeTail(nodeXML);
                            }
                        } else {
                            sourceParent3.insertBeforeTail(nodeXML);
                        }
                    }
                    sourceEntity.applyModifier();
                    continue;
                }
                GOTNode node0 = entityClone.selectSingleNode(String.format(format, child.getNodeType(), child.getId()));
                if (node0 == null) continue;
                String nodeXML = child.getNodeContent();
                GOTNode sourceParent0 = node0.getParent();
                GOTNode sourcePrevSiblingNode0 = node0.getPrevSiblingNode();
                if (!child.getEntityXPath().equals(node0.getEntityXPath())) {
                    if (sourcePrevSiblingNode0 != null) {
                        sourcePrevSiblingNode = sourceNode.selectSingleNode(String.format(format, sourcePrevSiblingNode0.getNodeType(), sourcePrevSiblingNode0.getId()));
                        if (sourcePrevSiblingNode != null && (sourceParent0.getId() != null ? sourceParent0.getId() : sourceParent0.getNodeType()).equals(sourcePrevSiblingNode.getParent().getId() != null ? sourcePrevSiblingNode.getParent().getId() : sourcePrevSiblingNode.getParent().getNodeType())) {
                            if (sourceChild2 != null) {
                                sourceChild2.remove();
                            }
                            sourcePrevSiblingNode.insertAfterElement(nodeXML);
                        } else {
                            GOTNode sourceNextSiblingNode02 = node0.getNextSiblingNode();
                            if (sourceNextSiblingNode02 != null) {
                                sourceNextSiblingNode3 = sourceNode.selectSingleNode(String.format(format, sourceNextSiblingNode02.getNodeType(), sourceNextSiblingNode02.getId()));
                                if (sourceNextSiblingNode3 != null && sourceParent0.getId().equals(sourceNextSiblingNode3.getParent().getId())) {
                                    if (sourceChild2 != null) {
                                        sourceChild2.remove();
                                    }
                                    sourceNextSiblingNode3.insertBeforeElement(nodeXML);
                                } else {
                                    GOTNode sourceParent4 = sourceEntity.getChildNode(sourceParent0.getId());
                                    if (sourceParent4 != null) {
                                        if (sourceChild2 != null) {
                                            sourceChild2.remove();
                                        }
                                        sourceParent4.insertBeforeTail(nodeXML);
                                    }
                                }
                            } else {
                                sourceParent = sourceEntity.getChildNode(sourceParent0.getId());
                                if (sourceParent != null) {
                                    if (sourceChild2 != null) {
                                        sourceChild2.remove();
                                    }
                                    sourceParent.insertBeforeTail(nodeXML);
                                }
                            }
                        }
                    } else {
                        sourceNextSiblingNode0 = node0.getNextSiblingNode();
                        if (sourceNextSiblingNode0 != null) {
                            GOTNode sourceNextSiblingNode5 = sourceNode.selectSingleNode(String.format(format, sourceNextSiblingNode0.getNodeType(), sourceNextSiblingNode0.getId()));
                            if (sourceNextSiblingNode5 != null && sourceParent0.getId().equals(sourceNextSiblingNode5.getParent().getId())) {
                                if (sourceChild2 != null) {
                                    sourceChild2.remove();
                                }
                                sourceNextSiblingNode5.insertBeforeElement(nodeXML);
                            } else {
                                sourceParent = sourceEntity.getChildNode(sourceParent0.getId());
                                if (sourceParent != null) {
                                    if (sourceChild2 != null) {
                                        sourceChild2.remove();
                                    }
                                    sourceParent.insertBeforeTail(nodeXML);
                                }
                            }
                        } else {
                            GOTNode sourceParent5 = sourceEntity.getChildNode(sourceParent0.getId());
                            if (sourceParent5 != null) {
                                if (sourceChild2 != null) {
                                    sourceChild2.remove();
                                }
                                sourceParent5.insertBeforeTail(nodeXML);
                            }
                        }
                    }
                    sourceEntity.applyModifier();
                    continue;
                }
                GOTNode childParent = child.getParent();
                if (childParent == null || sourceParent0 == null || !(childParent.getId() != null ? childParent.getId() : childParent.getNodeType()).equals(sourceParent0.getId() != null ? sourceParent0.getId() : sourceParent0.getNodeType())) continue;
                if (sourcePrevSiblingNode0 != null) {
                    GOTNode sourcePrevSiblingNode2 = sourceChild2.getPrevSiblingNode();
                    GOTNode sourcePrevSiblingNodeTarget = sourceNode.selectSingleNode(String.format(format, sourcePrevSiblingNode0.getNodeType(), sourcePrevSiblingNode0.getId()));
                    if (sourcePrevSiblingNode2 != null && sourcePrevSiblingNodeTarget != null) {
                        if (!(sourcePrevSiblingNode2.getId() != null ? sourcePrevSiblingNode2.getId() : sourcePrevSiblingNode2.getNodeType()).equals(sourcePrevSiblingNode0.getId() != null ? sourcePrevSiblingNode0.getId() : sourcePrevSiblingNode0.getNodeType())) {
                            if (sourceChild2 != null) {
                                sourceChild2.remove();
                            }
                            sourcePrevSiblingNodeTarget.insertAfterElement(nodeXML);
                        }
                    } else {
                        GOTNode sourceNextSiblingNode03 = node0.getNextSiblingNode();
                        if (sourceNextSiblingNode03 != null) {
                            GOTNode sourceNextSiblingNode6 = sourceChild2.getNextSiblingNode();
                            GOTNode sourceNextSiblingNodeTarget = sourceNode.selectSingleNode(String.format(format, sourceNextSiblingNode03.getNodeType(), sourceNextSiblingNode03.getId()));
                            if (sourceNextSiblingNode6 != null && sourceNextSiblingNodeTarget != null && !(sourceNextSiblingNode6.getId() != null ? sourceNextSiblingNode6.getId() : sourceNextSiblingNode6.getNodeType()).equals(sourceNextSiblingNode03.getId() != null ? sourceNextSiblingNode03.getId() : sourceNextSiblingNode03.getNodeType())) {
                                if (sourceChild2 != null) {
                                    sourceChild2.remove();
                                }
                                sourceNextSiblingNodeTarget.insertBeforeElement(nodeXML);
                            }
                        }
                    }
                } else if (sourceChild2.getPrevSiblingNode() != null && (sourceParent2 = sourceEntity.getChildNode(sourceParent0.getId())) != null) {
                    if (sourceChild2 != null) {
                        sourceChild2.remove();
                    }
                    sourceParent2.insertAfterHead(nodeXML);
                }
                sourceEntity.applyModifier();
                continue;
            }
            if (!child.getEntityXPath().equals(targetChild.getEntityXPath())) {
                String nodeXML = child.getNodeContent();
                GOTNode transitionChild = transitionEntity.getChildNode(child.getId());
                if (transitionChild != null && !child.getEntityXPath().equals(transitionChild.getEntityXPath())) continue;
                sourceNode = sourceEntity.selectSingleNode(nodeXPath);
                sourceChild = sourceNode.selectSingleNode(String.format(format, child.getNodeType(), child.getId()));
                GOTNode targetParent3 = targetChild.getParent();
                GOTNode sourceParent6 = sourceEntity.getChildNode(targetParent3.getId());
                targetPrevSiblingNode = targetChild.getPrevSiblingNode();
                if (targetPrevSiblingNode != null) {
                    sourcePrevSiblingNode = sourceNode.selectSingleNode(String.format(format, targetPrevSiblingNode.getNodeType(), targetPrevSiblingNode.getId()));
                    if (sourcePrevSiblingNode != null && (targetParent3.getId() != null ? targetParent3.getId() : targetParent3.getNodeType()).equals(sourcePrevSiblingNode.getParent().getId() != null ? sourcePrevSiblingNode.getParent().getId() : sourcePrevSiblingNode.getParent().getNodeType())) {
                        if (sourceChild != null) {
                            sourceChild.remove();
                        }
                        sourcePrevSiblingNode.insertAfterElement(nodeXML);
                    } else {
                        GOTNode targetNextSiblingNode4 = targetChild.getNextSiblingNode();
                        if (targetNextSiblingNode4 != null) {
                            sourceNextSiblingNode3 = sourceNode.selectSingleNode(String.format(format, targetNextSiblingNode4.getNodeType(), targetNextSiblingNode4.getId()));
                            if (sourceNextSiblingNode3 != null && targetParent3.getId().equals(sourceNextSiblingNode3.getParent().getId())) {
                                if (sourceChild != null) {
                                    sourceChild.remove();
                                }
                                sourceNextSiblingNode3.insertBeforeElement(nodeXML);
                            } else if (sourceParent6 != null) {
                                if (sourceChild != null) {
                                    sourceChild.remove();
                                }
                                sourceParent6.insertBeforeTail(nodeXML);
                            }
                        } else if (sourceParent6 != null) {
                            if (sourceChild != null) {
                                sourceChild.remove();
                            }
                            sourceParent6.insertBeforeTail(nodeXML);
                        }
                    }
                } else {
                    targetNextSiblingNode = targetChild.getNextSiblingNode();
                    if (targetNextSiblingNode != null) {
                        GOTNode sourceNextSiblingNode7 = sourceNode.selectSingleNode(String.format(format, targetNextSiblingNode.getNodeType(), targetNextSiblingNode.getId()));
                        if (sourceNextSiblingNode7 != null && (targetParent3.getId() != null && targetParent3.getId().equals(sourceNextSiblingNode7.getParent().getId()) || targetParent3.getName().equals(sourceNextSiblingNode7.getParent().getName()))) {
                            if (sourceChild != null) {
                                sourceChild.remove();
                            }
                            sourceNextSiblingNode7.insertBeforeElement(nodeXML);
                        } else if (sourceParent6 != null) {
                            if (sourceChild != null) {
                                sourceChild.remove();
                            }
                            sourceParent6.insertBeforeTail(nodeXML);
                        }
                    } else if (sourceParent6 != null) {
                        if (sourceChild != null) {
                            sourceChild.remove();
                        }
                        sourceParent6.insertBeforeTail(nodeXML);
                    }
                }
                sourceEntity.applyModifier();
                continue;
            }
            GOTNode node0 = entityClone.selectSingleNode(String.format(format, child.getNodeType(), child.getId()));
            if (node0 == null) continue;
            String nodeXML = child.getNodeContent();
            sourceNode = sourceEntity.selectSingleNode(nodeXPath);
            sourceChild = sourceNode.selectSingleNode(String.format(format, child.getNodeType(), child.getId()));
            GOTNode sourceParent0 = node0.getParent();
            GOTNode sourcePrevSiblingNode0 = node0.getPrevSiblingNode();
            if (!child.getEntityXPath().equals(node0.getEntityXPath())) {
                if (sourcePrevSiblingNode0 != null) {
                    GOTNode sourcePrevSiblingNode3 = sourceNode.selectSingleNode(String.format(format, sourcePrevSiblingNode0.getNodeType(), sourcePrevSiblingNode0.getId()));
                    if (sourcePrevSiblingNode3 != null && (sourceParent0.getId() != null ? sourceParent0.getId() : sourceParent0.getNodeType()).equals(sourcePrevSiblingNode3.getParent().getId() != null ? sourcePrevSiblingNode3.getParent().getId() : sourcePrevSiblingNode3.getParent().getNodeType())) {
                        if (sourceChild != null) {
                            sourceChild.remove();
                        }
                        sourcePrevSiblingNode3.insertAfterElement(nodeXML);
                    } else {
                        sourceNextSiblingNode0 = node0.getNextSiblingNode();
                        if (sourceNextSiblingNode0 != null) {
                            GOTNode sourceNextSiblingNode8 = sourceNode.selectSingleNode(String.format(format, sourceNextSiblingNode0.getNodeType(), sourceNextSiblingNode0.getId()));
                            if (sourceNextSiblingNode8 != null && sourceParent0.getId().equals(sourceNextSiblingNode8.getParent().getId())) {
                                if (sourceChild != null) {
                                    sourceChild.remove();
                                }
                                sourceNextSiblingNode8.insertBeforeElement(nodeXML);
                            } else {
                                sourceParent = sourceEntity.getChildNode(sourceParent0.getId());
                                if (sourceParent == null) {
                                    GOTNode targetParent4 = targetChild.getParent();
                                    sourceParent = sourceEntity.getChildNode(targetParent4.getId());
                                }
                                if (sourceParent != null) {
                                    if (sourceChild != null) {
                                        sourceChild.remove();
                                    }
                                    sourceParent.insertBeforeTail(nodeXML);
                                }
                            }
                        } else {
                            GOTNode sourceParent7 = sourceEntity.getChildNode(sourceParent0.getId());
                            if (sourceParent7 == null) {
                                targetParent = targetChild.getParent();
                                sourceParent7 = sourceEntity.getChildNode(targetParent.getId());
                            }
                            if (sourceParent7 != null) {
                                if (sourceChild != null) {
                                    sourceChild.remove();
                                }
                                sourceParent7.insertBeforeTail(nodeXML);
                            }
                        }
                    }
                } else {
                    GOTNode sourceParent8 = sourceEntity.getChildNode(sourceParent0.getId());
                    if (sourceParent8 == null) {
                        GOTNode targetParent5 = targetChild.getParent();
                        sourceParent8 = sourceEntity.getChildNode(targetParent5.getId());
                    }
                    if (sourceParent8 != null) {
                        if (sourceChild != null) {
                            sourceChild.remove();
                        }
                        sourceParent8.insertAfterHead(nodeXML);
                    }
                }
                sourceEntity.applyModifier();
                continue;
            }
            GOTNode childParent = child.getParent();
            if (childParent == null || sourceParent0 == null || !(child.getId() != null ? child.getId() : child.getNodeType()).equals(sourceParent0.getId() != null ? sourceParent0.getId() : sourceParent0.getNodeType())) continue;
            if (sourcePrevSiblingNode0 != null) {
                if (sourceChild != null) {
                    sourcePrevSiblingNode = sourceChild.getPrevSiblingNode();
                    GOTNode sourcePrevSiblingNodeTarget = sourceNode.selectSingleNode(String.format(format, sourcePrevSiblingNode0.getNodeType(), sourcePrevSiblingNode0.getId()));
                    if (sourcePrevSiblingNode != null && sourcePrevSiblingNodeTarget != null) {
                        if (!(sourcePrevSiblingNode.getId() != null ? sourcePrevSiblingNode.getId() : sourcePrevSiblingNode.getNodeType()).equals(sourcePrevSiblingNode0.getId() != null ? sourcePrevSiblingNode0.getId() : sourcePrevSiblingNode0.getNodeType())) {
                            if (sourceChild != null) {
                                sourceChild.remove();
                            }
                            sourcePrevSiblingNodeTarget.insertAfterElement(nodeXML);
                        }
                    } else {
                        GOTNode sourceNextSiblingNode04 = node0.getNextSiblingNode();
                        if (sourceNextSiblingNode04 != null) {
                            GOTNode sourceNextSiblingNode9 = sourceChild.getNextSiblingNode();
                            GOTNode sourceNextSiblingNodeTarget = sourceNode.selectSingleNode(String.format(format, sourceNextSiblingNode04.getNodeType(), sourceNextSiblingNode04.getId()));
                            if (sourceNextSiblingNode9 != null && sourceNextSiblingNodeTarget != null && !(sourceNextSiblingNode9.getId() != null ? sourceNextSiblingNode9.getId() : sourceNextSiblingNode9.getNodeType()).equals(sourceNextSiblingNode04.getId() != null ? sourceNextSiblingNode04.getId() : sourceNextSiblingNode04.getNodeType())) {
                                if (sourceChild != null) {
                                    sourceChild.remove();
                                }
                                sourceNextSiblingNodeTarget.insertBeforeElement(nodeXML);
                            }
                        }
                    }
                }
            } else {
                sourcePrevSiblingNode = child.getPrevSiblingNode();
                if (sourcePrevSiblingNode != null) {
                    GOTNode sourceParent9 = sourceEntity.getChildNode(sourceParent0.getId());
                    if (sourceParent9 == null) {
                        targetParent = targetChild.getParent();
                        sourceParent9 = sourceEntity.getChildNode(targetParent.getId());
                    }
                    if (sourceParent9 != null) {
                        if (sourceChild != null) {
                            sourceChild.remove();
                        }
                        sourceParent9.insertAfterHead(nodeXML);
                    }
                }
            }
            sourceEntity.applyModifier();
        }
    }

    private boolean isCreatedLayerSource(GOTModel got, GOTNode node) {
        String modifiedLayer = node.getCreatedLayer();
        GOTEntity entity = node.getEntity();
        try {
            if (!node.isEntityNode()) {
                return got.isSourceDeployment(modifiedLayer, entity, node.getId());
            }
            return got.isSourceDeployment(modifiedLayer, entity, null);
        }
        catch (NavException e) {
            throw new RuntimeException("node\u89e3\u6790\u5f02\u5e38", e);
        }
    }

    private boolean isModifiedLayerSource(GOTModel got, GOTNode node) {
        String modifiedLayer = node.getModifiedLayer();
        GOTEntity entity = node.getEntity();
        try {
            if (!node.isEntityNode()) {
                return got.isSourceDeployment(modifiedLayer, entity, node.getId());
            }
            return got.isSourceDeployment(modifiedLayer, entity, null);
        }
        catch (NavException e) {
            throw new RuntimeException("node\u89e3\u6790\u5f02\u5e38", e);
        }
    }

    private boolean existModifiedLayer(GOTModel got, GOTNode node) throws VTDException {
        String modifiedLayer = node.getModifiedLayer();
        GOTEntity entity = node.getEntity();
        if ("app".equals(modifiedLayer)) {
            String solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
            SolutionDefinition solutionDefinition = got.getSolutionDefinition(solutionName);
            return solutionDefinition != null;
        }
        if ("plg".equals(modifiedLayer)) {
            SolutionPluginDefinition solutionPluginDefinition;
            String solutionPluginName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
            if ("app".equals(entity.getCreatedLayer()) && node.getId().contains(".")) {
                solutionPluginName = node.getId().substring(0, node.getId().lastIndexOf("."));
            }
            return (solutionPluginDefinition = got.getSolutionPluginDefinition(solutionPluginName)) != null;
        }
        if ("ext".equals(modifiedLayer)) {
            String solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
            SolutionExtensionDefinition solutionExtensionDefinition = got.getSolutionExtensionDefinition(solutionName);
            return solutionExtensionDefinition != null;
        }
        LayerDefination layerDefination = got.getLayerDefination(modifiedLayer);
        return layerDefination != null;
    }

    private /* synthetic */ boolean lambda$2(GOTEntity formEntity) {
        return this.isModifiedLayerSource(this.sourceGOT, formEntity);
    }

    private /* synthetic */ Stream lambda$3(String string, GOTEntity gOTEntity, GOTEntity formEntity) {
        return formEntity.selectNodes(String.format(string, gOTEntity.getId())).stream().filter(formDataSource -> this.isCreatedLayerSource(this.sourceGOT, (GOTNode)formDataSource));
    }

    private static /* synthetic */ String lambda$5(GOTNode dataSource) {
        return String.valueOf(dataSource.getEntity().getId()) + "#" + dataSource.getEntityXPath();
    }
}

