/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service;

import com.ximpleware.NavException;
import com.ximpleware.VTDException;
import gongqi.erp.framework.core.LayerDefination;
import gongqi.erp.framework.core.LayerDeploymentMode;
import gongqi.erp.framework.core.LayerResolver;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinition;
import gongqi.erp.framework.core.extension.SolutionExtensionDeploymentMode;
import gongqi.erp.framework.core.extension.SolutionExtensionResolver;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinition;
import gongqi.erp.framework.core.plugin.SolutionPluginDeploymentMode;
import gongqi.erp.framework.core.plugin.SolutionPluginResolver;
import gongqi.erp.framework.core.solution.SolutionDefinition;
import gongqi.erp.framework.core.solution.SolutionDeploymentMode;
import gongqi.erp.framework.core.solution.SolutionEntityCombiner;
import gongqi.erp.framework.core.solution.SolutionResolver;
import gongqi.erp.framework.exception.ERPException;
import gongqi.erp.framework.util.FileUtils;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.service.node.GOTNode;
import gongqi.gdt.designer.service.node.GOTProperty;
import gongqi.gdt.designer.utils.RelationError;
import gongqi.gdt.designer.utils.VTDUtils;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;

public class GOTModel {
    private static Logger log = Logger.getLogger(GOTModel.class);
    private List<LayerDefination> layerDefinations = new ArrayList<LayerDefination>();
    private List<SolutionDefinition> solutionDefinitions = new ArrayList<SolutionDefinition>();
    private List<SolutionPluginDefinition> solutionPluginDefinitions = new ArrayList<SolutionPluginDefinition>();
    private List<SolutionExtensionDefinition> solutionExtensionDefinitions = new ArrayList<SolutionExtensionDefinition>();
    private Map<EntityType, Map<String, GOTEntity>> entityIdMaps = new ConcurrentHashMap<EntityType, Map<String, GOTEntity>>();
    private List<GOTEntity> removeEntitys = new ArrayList<GOTEntity>();
    private Map<String, List<GOTProperty>> catchRefInnerIdMap = new HashMap<String, List<GOTProperty>>();
    private boolean catchRefInnerId = false;
    private File layersRootDir;
    private Map<String, List<String>> tableRelateFormMaps = new HashMap<String, List<String>>();

    public GOTModel(File layersRootDir) {
        try {
            List layerDefinations = ((LayerResolver)ObjectContainer.getInstance(LayerResolver.class)).resolveLayers(layersRootDir.getAbsolutePath());
            List solutionDefinitions = Collections.emptyList();
            File solutionsRootDir = new File(layersRootDir, "app");
            if (solutionsRootDir.exists()) {
                solutionDefinitions = ((SolutionResolver)ObjectContainer.getInstance(SolutionResolver.class)).resolveSolutions(solutionsRootDir.getAbsolutePath());
            }
            List solutionPluginDefinitions = Collections.emptyList();
            File solutionPluginsRootDir = new File(layersRootDir, "plg");
            if (solutionPluginsRootDir.exists()) {
                solutionPluginDefinitions = ((SolutionPluginResolver)ObjectContainer.getInstance(SolutionPluginResolver.class)).resolveSolutionPlugins(solutionPluginsRootDir.getAbsolutePath());
            }
            List solutionExtensionDefinitions = Collections.emptyList();
            File solutionExtensionsRootDir = new File(layersRootDir, "ext");
            if (solutionExtensionsRootDir.exists()) {
                solutionExtensionDefinitions = ((SolutionExtensionResolver)ObjectContainer.getInstance(SolutionExtensionResolver.class)).resolveSolutionExtensions(solutionExtensionsRootDir.getAbsolutePath());
            }
            if (layerDefinations == null || layerDefinations.isEmpty()) {
                throw new ERPException("\u65e0\u6548\u7684\u5c42\u5b9a\u4e49\u5217\u8868");
            }
            this.layerDefinations = layerDefinations;
            if (solutionDefinitions != null) {
                solutionDefinitions.forEach(definition -> definition.getLayerDependencies().forEach(dependency -> {
                    Optional<LayerDefination> optional = layerDefinations.stream().filter(layerDefination -> layerDefination.getLayerName().equals(dependency.getLayerName())).findFirst();
                    if (!optional.isPresent()) {
                        throw new RuntimeException(String.format("\u4f9d\u8d56%s\u5c42\u4e0d\u5b58\u5728", dependency.getLayerName()));
                    }
                }));
                this.solutionDefinitions = solutionDefinitions;
            }
            if (solutionPluginDefinitions != null) {
                solutionPluginDefinitions.forEach(definition -> {
                    Optional<SolutionDefinition> solutionOptional = this.solutionDefinitions.stream().filter(solution -> solution.getSolutionName().equals(definition.getSolutionName())).findFirst();
                    if (solutionOptional.isPresent()) {
                        SolutionDefinition solutionDefinition = solutionOptional.get();
                        try {
                            BigDecimal solutionVersion = new BigDecimal(solutionDefinition.getSolutionVersion());
                            BigDecimal dependencySolutionVersion = new BigDecimal(definition.getSolutionVersion());
                            if (solutionVersion.compareTo(dependencySolutionVersion) == -1) {
                                log.warn((Object)String.format("\u3010%s\u3011\u65b9\u6848\u3010%s\u3011\u63d2\u4ef6\u4f9d\u8d56\u65b9\u6848\u3010%s\u3011\u7248\u672c\uff0c\u65b9\u6848\u5b9e\u9645\u7248\u672c\u4e3a\u3010%s\u3011,\u4e0d\u7b26\u5408\u4f9d\u8d56\u8981\u6c42", definition.getSolutionName(), definition.getName(), definition.getSolutionVersion(), solutionDefinition.getSolutionVersion()));
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                        definition.getSolutionPluginLayerDependencies().forEach(layerDependency -> {
                            LayerDefination dependencyLayerDefination = layerDefinations.stream().filter(layerDefination -> layerDefination.getLayerName().equals(layerDependency.getLayerName())).findFirst().get();
                            try {
                                BigDecimal solutionDependencyVersion = new BigDecimal(layerDependency.getLayerVersion());
                                BigDecimal layerVersion = new BigDecimal(dependencyLayerDefination.getLayerVersion());
                                if (solutionDependencyVersion.compareTo(layerVersion) == 1) {
                                    log.warn((Object)String.format("\u3010%s\u3011\u65b9\u6848\u3010%s\u3011\u63d2\u4ef6\u4f9d\u8d56\u3010%s\u3011\u5c42\u3010%s\u3011\u7248\u672c\uff0c\u3010%s\u3011\u5c42\u5b9e\u9645\u7248\u672c\u3010%s\u3011\uff0c\u4e0d\u7b26\u5408\u4f9d\u8d56\u8981\u6c42", definition.getSolutionName(), definition.getName(), layerDependency.getLayerName(), layerDependency.getLayerVersion(), dependencyLayerDefination.getLayerName(), dependencyLayerDefination.getLayerVersion()));
                                }
                            }
                            catch (NumberFormatException numberFormatException) {}
                        });
                    }
                });
                this.solutionPluginDefinitions = solutionPluginDefinitions;
            }
            if (solutionExtensionDefinitions != null) {
                this.solutionExtensionDefinitions = solutionExtensionDefinitions;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u5c42\u6a21\u578b\u89e3\u6790\u9519\u8bef\uff1a" + layersRootDir.getAbsolutePath(), e);
        }
        this.initModelEntitys();
        this.layersRootDir = layersRootDir;
    }

    private void initModelEntitys() {
        HashMap entityDocs = new HashMap();
        EntityType.stream().forEach(entityType -> entityDocs.put(entityType, new TreeMap()));
        int i = this.layerDefinations.size();
        while (i > 0) {
            LayerDefination layerDefination = this.layerDefinations.get(i - 1);
            if ("app".equals(layerDefination.getLayerName())) {
                for (SolutionDefinition solutionDefinition : this.solutionDefinitions) {
                    EntityType[] entityTypeArray = EntityType.values();
                    int n = entityTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        EntityType entityType2 = entityTypeArray[n2];
                        HashMap<String, String> documents = new HashMap<String, String>(solutionDefinition.getEntityDocumentMap(entityType2));
                        Map<String, List<Map.Entry>> entitys = this.solutionPluginDefinitions.stream().filter(definition -> definition.getSolutionName().equals(solutionDefinition.getSolutionName())).flatMap(solutionPlugin -> solutionPlugin.getSolutionEntityDocuments(entityType2).entrySet().stream()).filter(entry -> documents.containsKey(entry.getKey())).collect(Collectors.groupingBy(Map.Entry::getKey));
                        for (String entityId : entitys.keySet()) {
                            Document solutionDoc = FileUtils.parseStringToDocument((String)((String)documents.get(entityId)));
                            for (Map.Entry plgEntitys : entitys.get(entityId)) {
                                Document pluginDoc = FileUtils.parseStringToDocument((String)((String)plgEntitys.getValue()));
                                ((SolutionEntityCombiner)ObjectContainer.getInstance(SolutionEntityCombiner.class)).combineEntity(solutionDoc.getRootElement(), pluginDoc.getRootElement());
                            }
                            documents.put(entityId, solutionDoc.asXML());
                        }
                        ((Map)entityDocs.get(entityType2)).putAll(documents);
                        ++n2;
                    }
                }
            } else if ("plg".equals(layerDefination.getLayerName())) {
                for (SolutionPluginDefinition solutionPluginDefinition : this.solutionPluginDefinitions) {
                    EntityType.stream().forEach(entityType -> ((Map)entityDocs.get(entityType)).putAll(solutionPluginDefinition.getEntityDocumentMap(entityType)));
                }
            } else if ("ext".equals(layerDefination.getLayerName())) {
                for (SolutionExtensionDefinition solutionExtensionDefinition : this.solutionExtensionDefinitions) {
                    EntityType.stream().forEach(entityType -> ((Map)entityDocs.get(entityType)).putAll(solutionExtensionDefinition.getEntityDocumentMap(entityType)));
                }
            } else {
                EntityType.stream().forEach(entityType -> ((Map)entityDocs.get(entityType)).putAll(layerDefination.getEntityDocumentMap(entityType)));
            }
            --i;
        }
        for (Map.Entry entry2 : entityDocs.entrySet()) {
            Iterator entityFileIterator = ((Map)entry2.getValue()).values().iterator();
            while (entityFileIterator.hasNext()) {
                try {
                    GOTEntity entity = new GOTEntity(VTDUtils.parseXML(((String)entityFileIterator.next()).getBytes(StandardCharsets.UTF_8)));
                    this.getEntityIdMap(entity.getEntityType()).put(entity.getId(), entity);
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("\u89e3\u6790%s\u5b9e\u4f53\u9519\u8bef", ((EntityType)entry2.getKey()).name()), e);
                }
            }
        }
    }

    public File getLayersRootDir() {
        return this.layersRootDir;
    }

    public List<SolutionDefinition> getSolutionDefinitions() {
        return Collections.unmodifiableList(this.solutionDefinitions);
    }

    public SolutionDefinition getSolutionDefinition(String solutionName) {
        for (SolutionDefinition solutionDefinition : this.solutionDefinitions) {
            if (!solutionDefinition.getSolutionName().equals(solutionName)) continue;
            return solutionDefinition;
        }
        return null;
    }

    public List<SolutionPluginDefinition> getSolutionPluginDefinitions() {
        return Collections.unmodifiableList(this.solutionPluginDefinitions);
    }

    public SolutionPluginDefinition getSolutionPluginDefinition(String solutionPluginName) {
        for (SolutionPluginDefinition solutionPluginDefinition : this.solutionPluginDefinitions) {
            if (!solutionPluginDefinition.getName().equals(solutionPluginName)) continue;
            return solutionPluginDefinition;
        }
        return null;
    }

    public List<SolutionExtensionDefinition> getSolutionExtensionDefinitions() {
        return Collections.unmodifiableList(this.solutionExtensionDefinitions);
    }

    public SolutionExtensionDefinition getSolutionExtensionDefinition(String solutionName) {
        for (SolutionExtensionDefinition solutionExtensionDefinition : this.solutionExtensionDefinitions) {
            if (!solutionExtensionDefinition.getSolutionName().equals(solutionName)) continue;
            return solutionExtensionDefinition;
        }
        return null;
    }

    public LayerDefination getTopLayerDefination() {
        return this.layerDefinations.get(0);
    }

    public LayerDefination getLayerDefination(String layerName) {
        for (LayerDefination layerDefination : this.layerDefinations) {
            if (!layerDefination.getLayerName().equals(layerName)) continue;
            return layerDefination;
        }
        return null;
    }

    public int getLayerLevel(String layerName) {
        LayerDefination layerDefination = this.getLayerDefination(layerName);
        if (layerDefination == null) {
            throw new IllegalArgumentException(String.format("\u83b7\u53d6\u5c42\u7ea7\u4fe1\u606f\u9519\u8bef\uff0c%s\u5c42\u5728\u5c42\u94fe\u4e2d\u4e0d\u5b58\u5728", layerName));
        }
        return this.layerDefinations.size() - this.layerDefinations.indexOf(layerDefination);
    }

    public int getTopLayerLevel() {
        LayerDefination topLayerDefination = this.getTopLayerDefination();
        return this.getLayerLevel(topLayerDefination.getLayerName());
    }

    public List<LayerDefination> getLayerDefinations() {
        return Collections.unmodifiableList(this.layerDefinations);
    }

    private Map<String, GOTEntity> getEntityIdMap(EntityType entityType) {
        Map<String, GOTEntity> entityIdMap = this.entityIdMaps.get(entityType);
        if (entityIdMap == null) {
            entityIdMap = new LinkedHashMap<String, GOTEntity>();
            this.entityIdMaps.put(entityType, entityIdMap);
        }
        return entityIdMap;
    }

    public Map<String, GOTEntity> getEntitys(EntityType entityType) {
        Map<String, GOTEntity> entityMap = this.entityIdMaps.get(entityType);
        return entityMap != null ? Collections.unmodifiableMap(entityMap) : Collections.emptyMap();
    }

    public GOTEntity getEntityById(EntityType entityType, String entityId) {
        return this.getEntityIdMap(entityType).get(entityId);
    }

    public GOTEntity getEntityByName(EntityType entityType, String entityName) throws NavException {
        for (GOTEntity entity : this.getEntityIdMap(entityType).values()) {
            if (!entity.getName().equals(entityName)) continue;
            return entity;
        }
        return null;
    }

    public List<GOTProperty> getRefEntityPropertys(String entityId) throws VTDException {
        Objects.requireNonNull(entityId, "\u67e5\u627e\u8282\u70b9\u5f15\u7528\u5217\u8868entityId\u4e3anull");
        ArrayList<GOTProperty> propertys = new ArrayList<GOTProperty>();
        String xpath = String.format(".//Property[@refentityid='%s']", entityId);
        for (Map<String, GOTEntity> entityMap : this.entityIdMaps.values()) {
            for (GOTEntity entity : entityMap.values()) {
                propertys.addAll(entity.selectPropertys(xpath));
            }
        }
        return propertys;
    }

    public List<GOTProperty> getRefInnerPropertys(String entityId, String innerId) throws VTDException {
        Objects.requireNonNull(entityId, "\u67e5\u627e\u8282\u70b9\u5f15\u7528\u5217\u8868entityId\u4e3anull");
        ArrayList<GOTProperty> propertys = new ArrayList<GOTProperty>();
        if (this.catchRefInnerId) {
            List<GOTProperty> list = this.catchRefInnerIdMap.get(String.valueOf(entityId) + "-" + innerId);
            if (list != null) {
                propertys.addAll(list);
            }
            return propertys;
        }
        String xpath = String.format(".//Property[@%s='%s' and @%s='%s']", "refentityid", entityId, "refinnerid", innerId);
        for (Map<String, GOTEntity> entityMap : this.entityIdMaps.values()) {
            for (GOTEntity entity : entityMap.values()) {
                propertys.addAll(entity.selectPropertys(xpath));
            }
        }
        return propertys;
    }

    public List<GOTProperty> getRefPropertys(Map<EntityType, String> xpaths) {
        ArrayList<GOTProperty> propertys = new ArrayList<GOTProperty>();
        for (EntityType entityType : xpaths.keySet()) {
            String xpath = xpaths.get(entityType);
            for (GOTEntity entity : this.entityIdMaps.get(entityType).values()) {
                propertys.addAll(entity.selectPropertys(xpath));
            }
        }
        return propertys;
    }

    public void initTableRelateFormMap() throws NavException {
        this.tableRelateFormMaps = new HashMap<String, List<String>>();
        for (GOTEntity formEntity : this.entityIdMaps.get(EntityType.Form).values()) {
            String formId = formEntity.getId();
            List<GOTNode> formDataSources = formEntity.selectNodes("./FormDataSources/FormDataSource");
            for (GOTNode formDataSource : formDataSources) {
                String refEntityId = formDataSource.getProperty("Table").getRefEntityId();
                this.tableRelateFormMaps.computeIfAbsent(refEntityId, k -> new ArrayList()).add(formId);
            }
        }
    }

    public List<GOTProperty> getTableFieldRefPropertys(String tableId, String xpath) {
        ArrayList<GOTProperty> propertys = new ArrayList<GOTProperty>();
        if (!this.tableRelateFormMaps.containsKey(tableId)) {
            return propertys;
        }
        Map<String, GOTEntity> formMaps = this.entityIdMaps.get(EntityType.Form);
        for (String formId : this.tableRelateFormMaps.get(tableId)) {
            GOTEntity form = formMaps.get(formId);
            if (form == null) continue;
            propertys.addAll(form.selectPropertys(xpath));
        }
        return propertys;
    }

    public void removeEntity(GOTEntity entity) throws VTDException {
        this.getEntityIdMap(entity.getEntityType()).remove(entity.getId());
        this.removeEntitys.add(entity);
    }

    public List<GOTEntity> getRemoveEntitys() {
        return Collections.unmodifiableList(this.removeEntitys);
    }

    public boolean isSourceDeployment(String layerName, GOTEntity entity, String innerId) {
        String entityId = entity.getId();
        if ("app".equals(layerName)) {
            String solutionName = entityId.substring(0, entityId.lastIndexOf("."));
            SolutionDefinition solutionDefinition = this.getSolutionDefinition(solutionName);
            return solutionDefinition.getDeploymentMode() == SolutionDeploymentMode.Source;
        }
        if ("ext".equals(layerName)) {
            SolutionExtensionDefinition solutionExtensionDefinition;
            String solutionName = entityId.substring(0, entityId.lastIndexOf("."));
            if (entityId.substring(entityId.lastIndexOf(".") + 3).startsWith("5")) {
                SolutionPluginDefinition solutionPluginDefinition = this.getSolutionPluginDefinition(solutionName);
                if (solutionPluginDefinition == null) {
                    log.warn((Object)String.format("\u5b9e\u4f53\u3010%s %s\u3011\u5bf9\u5e94\u5bbf\u4e3b\u63d2\u4ef6\u4e0d\u5b58\u5728", entityId, entity.getName()));
                    throw new RuntimeException(String.format("\u5b9e\u4f53\u3010%s %s\u3011\u5bbf\u4e3b\u63d2\u4ef6\u4e0d\u5b58\u5728", entity.getId(), entity.getName()));
                }
                solutionName = solutionPluginDefinition.getSolutionName();
            }
            return (solutionExtensionDefinition = this.getSolutionExtensionDefinition(solutionName)).getDeploymentMode() == SolutionExtensionDeploymentMode.Source;
        }
        if ("plg".equals(layerName)) {
            if (entity.getCreatedLayer().equals("app")) {
                String pluginName;
                SolutionPluginDefinition solutionPluginDefinition;
                if (StringUtils.isNotBlank((CharSequence)innerId) && innerId.contains(".") && (solutionPluginDefinition = this.getSolutionPluginDefinition(pluginName = innerId.substring(0, innerId.lastIndexOf(".")))) != null) {
                    return solutionPluginDefinition.getDeploymentMode() == SolutionPluginDeploymentMode.Source;
                }
                List<GOTNode> plgNodes = entity.selectNodes(".//*[@createdLayer = 'plg']");
                for (GOTNode gotNode : plgNodes) {
                    String pluginName2;
                    SolutionPluginDefinition solutionPluginDefinition2;
                    String plgId = gotNode.getId();
                    if (StringUtils.isBlank((CharSequence)plgId) || !plgId.contains(".") || (solutionPluginDefinition2 = this.getSolutionPluginDefinition(pluginName2 = plgId.substring(0, plgId.lastIndexOf(".")))) == null || solutionPluginDefinition2.getDeploymentMode() != SolutionPluginDeploymentMode.Source) continue;
                    return true;
                }
                String solutionName = entityId.substring(0, entityId.lastIndexOf("."));
                SolutionExtensionDefinition solutionExtensionDefinition = this.getSolutionExtensionDefinition(solutionName);
                if (solutionExtensionDefinition != null) {
                    return solutionExtensionDefinition.getDeploymentMode() == SolutionExtensionDeploymentMode.Source;
                }
                SolutionDefinition solutionDefinition = this.getSolutionDefinition(solutionName);
                return solutionDefinition.getDeploymentMode() == SolutionDeploymentMode.Source;
            }
            String solutionPluginName = entityId.substring(0, entityId.lastIndexOf("."));
            SolutionPluginDefinition solutionPluginDefinition = this.getSolutionPluginDefinition(solutionPluginName);
            if (solutionPluginDefinition == null) {
                return true;
            }
            return solutionPluginDefinition.getDeploymentMode() == SolutionPluginDeploymentMode.Source;
        }
        LayerDefination layerDefination = this.getLayerDefination(layerName);
        return layerDefination.getDeploymentMode() == LayerDeploymentMode.Source;
    }

    public void catchRefInnerId() throws VTDException {
        this.clearCatchRefInnerId();
        String xpath = String.format(".//Property[@%s and @%s]", "refentityid", "refinnerid");
        for (Map<String, GOTEntity> entityMap : this.entityIdMaps.values()) {
            for (GOTEntity entity : entityMap.values()) {
                List<GOTProperty> propertys = entity.selectPropertys(xpath);
                for (GOTProperty property : propertys) {
                    List<GOTProperty> refList = this.catchRefInnerIdMap.get(String.format("%s-%s", property.getRefEntityId(), property.getRefInnerId()));
                    if (refList == null) {
                        refList = new ArrayList<GOTProperty>();
                        this.catchRefInnerIdMap.put(String.format("%s-%s", property.getRefEntityId(), property.getRefInnerId()), refList);
                    }
                    refList.add(property);
                }
            }
        }
        this.catchRefInnerId = true;
    }

    public void clearCatchRefInnerId() {
        this.catchRefInnerIdMap.clear();
        this.catchRefInnerId = false;
    }

    public List<RelationError> checkRelation() {
        ArrayList<RelationError> results = new ArrayList<RelationError>();
        EntityType[] entityTypeArray = EntityType.values();
        int n = entityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityType entityType = entityTypeArray[n2];
            Map<String, GOTEntity> entitys = this.getEntitys(entityType);
            for (GOTEntity entity : entitys.values()) {
                results.addAll(this.doCheck(entity));
            }
            ++n2;
        }
        return results;
    }

    public List<RelationError> checkRelation(List<String> scopeIds) {
        ArrayList<RelationError> results = new ArrayList<RelationError>();
        EntityType[] entityTypeArray = EntityType.values();
        int n = entityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityType entityType = entityTypeArray[n2];
            Map<String, GOTEntity> entitys = this.getEntitys(entityType);
            for (GOTEntity entity : entitys.values()) {
                String id = entity.getId();
                if (id.contains(".") && !scopeIds.contains(id = id.substring(0, id.lastIndexOf(".")))) continue;
                results.addAll(this.doCheck(entity));
            }
            ++n2;
        }
        return results;
    }

    private EntityType getEntityTypeById(String entityId) {
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return null;
        }
        if (entityId.contains(".")) {
            entityId = entityId.substring(entityId.lastIndexOf(".") + 1);
        }
        if (entityId.startsWith("10")) {
            return EntityType.Enum;
        }
        if (entityId.startsWith("20")) {
            return EntityType.DataType;
        }
        if (entityId.startsWith("30")) {
            return EntityType.Table;
        }
        if (entityId.startsWith("40")) {
            return EntityType.Form;
        }
        if (entityId.startsWith("50")) {
            return EntityType.MenuItem;
        }
        if (entityId.startsWith("60")) {
            return EntityType.Menu;
        }
        if (entityId.startsWith("73")) {
            return EntityType.Report;
        }
        if (entityId.startsWith("80")) {
            return EntityType.Class;
        }
        return null;
    }

    private List<RelationError> doCheck(GOTEntity entity) {
        ArrayList<RelationError> results = new ArrayList<RelationError>();
        EntityType entityType = entity.getEntityType();
        for (GOTProperty property : entity.selectPropertys("//Property[@refentityid]")) {
            try {
                RelationError error;
                String nodeName = property.getGOTNode().getNodeType();
                String propertyName = property.getName();
                String propertyVaue = property.getValue();
                String refEntityId = property.getRefEntityId();
                String refInnerId = property.getRefInnerId();
                EntityType refEntityTye = this.getEntityTypeById(refEntityId);
                if (refEntityTye == null) {
                    error = new RelationError();
                    error.setProperty(property);
                    error.setDescription("RefEntityId\u7684\u975e\u6cd5");
                    results.add(error);
                }
                if (!this.entityIdMaps.get(refEntityTye).containsKey(refEntityId)) {
                    error = new RelationError();
                    error.setProperty(property);
                    error.setDescription("\u5f15\u7528\u7684\u5b9e\u4f53\u8282\u70b9\u4e0d\u5b58\u5728");
                    results.add(error);
                    continue;
                }
                GOTEntity refEntity = this.entityIdMaps.get(refEntityTye).get(refEntityId);
                if (StringUtils.isNotBlank((CharSequence)refInnerId)) {
                    GOTNode refNode = GOTModel.getRefInnerId(refEntity, refInnerId, property);
                    if (refNode == null) {
                        error = new RelationError();
                        error.setProperty(property);
                        error.setDescription("\u5f15\u7528\u7684\u5185\u90e8\u8282\u70b9\u4e0d\u5b58\u5728");
                        results.add(error);
                        continue;
                    }
                    if (entityType == EntityType.Enum) continue;
                    if (entityType == EntityType.DataType) {
                        if ((!"DataTypeRelation".equals(nodeName) || !"Field".equals(propertyName)) && (!"DataTypeRelation".equals(nodeName) || !"FilterField".equals(propertyName)) || refNode.getName().equals(property.getValue())) continue;
                        this.doValidatePropertyValueMatch(property, refEntity, results);
                        continue;
                    }
                    if (entityType == EntityType.Table) continue;
                    if (entityType == EntityType.Form) {
                        boolean match;
                        GOTEntity extendsEntity;
                        GOTProperty extendsProperty;
                        if ("FormDataSources".equals(nodeName) && "ReturnField".equals(propertyName) || "FormDataSourceFieldGroup".equals(nodeName) && "FieldGroup".equals(propertyName)) {
                            if (refNode.getName().equals(property.getValue())) continue;
                            this.doValidatePropertyValueMatch(property, refEntity, results);
                            continue;
                        }
                        if ("FormDataSourceRelationItem".equals(nodeName)) {
                            if (!"Field".equals(propertyName) && !"ParentField".equals(propertyName) || refNode.getName().equals(property.getName())) continue;
                            if ("Component".equals(refNode.getAttributeValue("type"))) {
                                extendsProperty = refNode.getProperty("Extends");
                                if (StringUtils.isNotBlank((CharSequence)extendsProperty.getRefEntityId())) {
                                    extendsEntity = this.entityIdMaps.get(EntityType.DataType).get(extendsProperty.getRefEntityId());
                                    match = extendsEntity.selectNodes("./DataTypeArray/DataTypeArrayItem").stream().anyMatch(arrayItemNode -> String.format("%s.%s", refNode.getName(), arrayItemNode.getName()).equals(propertyVaue));
                                    if (match) continue;
                                    this.doValidatePropertyValueMatch(property, refNode, results);
                                    continue;
                                }
                                this.doValidatePropertyValueMatch(property, refNode, results);
                                continue;
                            }
                            this.doValidatePropertyValueMatch(property, refNode, results);
                            continue;
                        }
                        if ("FormDataSourceField".equals(nodeName)) {
                            if (!"Field".equals(propertyName) || refNode.getName().equals(property.getName())) continue;
                            if ("String".equals(property.getGOTNode().getAttributeValue("type")) && "Component".equals(refNode.getAttributeValue("type"))) {
                                extendsProperty = refNode.getProperty("Extends");
                                if (StringUtils.isNotBlank((CharSequence)extendsProperty.getRefEntityId())) {
                                    extendsEntity = this.entityIdMaps.get(EntityType.DataType).get(extendsProperty.getRefEntityId());
                                    match = extendsEntity.selectNodes("./DataTypeArray/DataTypeArrayItem").stream().anyMatch(arrayItemNode -> String.format("%s.%s", refNode.getName(), arrayItemNode.getName()).equals(propertyVaue));
                                    if (match) continue;
                                    this.doValidatePropertyValueMatch(property, refNode, results);
                                    continue;
                                }
                                this.doValidatePropertyValueMatch(property, refNode, results);
                                continue;
                            }
                            this.doValidatePropertyValueMatch(property, refNode, results);
                            continue;
                        }
                        if ((!"FormItem".equals(nodeName) || !"Extends".equals(propertyName)) && (!"FormItem".equals(nodeName) || !"QueryField".equals(propertyName)) || refNode.getName().equals(property.getName())) continue;
                        if ("StringEditor".equals(property.getGOTNode().getAttributeValue("type")) && "Component".equals(refNode.getAttributeValue("type"))) {
                            extendsProperty = refNode.getProperty("Extends");
                            if (StringUtils.isNotBlank((CharSequence)extendsProperty.getRefEntityId())) {
                                extendsEntity = this.entityIdMaps.get(EntityType.DataType).get(extendsProperty.getRefEntityId());
                                match = extendsEntity.selectNodes("./DataTypeArray/DataTypeArrayItem").stream().anyMatch(arrayItemNode -> String.format("%s.%s", refNode.getName(), arrayItemNode.getName()).equals(propertyVaue));
                                if (match) continue;
                                this.doValidatePropertyValueMatch(property, refNode, results);
                                continue;
                            }
                            this.doValidatePropertyValueMatch(property, refNode, results);
                            continue;
                        }
                        this.doValidatePropertyValueMatch(property, refNode, results);
                        continue;
                    }
                    if (entityType == EntityType.MenuItem) continue;
                    continue;
                }
                if (entityType == EntityType.Enum) continue;
                if (entityType == EntityType.DataType) {
                    if (!("DataType".equals(nodeName) && "Extends".equals(propertyName) || "DataType".equals(nodeName) && "FormLookup".equals(propertyName) || "DataTypeRelation".equals(nodeName) && "Table".equals(propertyName) || "DataTypeRelation".equals(nodeName) && "RefMenuItem".equals(propertyName)) && (!"DataTypeArrayItem".equals(nodeName) || !"RefDataType".equals(propertyName)) || refEntity.getName().equals(property.getValue())) continue;
                    this.doValidatePropertyValueMatch(property, refEntity, results);
                    continue;
                }
                if (entityType == EntityType.Table) {
                    if (!"TableField".equals(nodeName) || !"Extends".equals(propertyName)) continue;
                    this.doValidatePropertyValueMatch(property, refEntity, results);
                    continue;
                }
                if (entityType == EntityType.Form) {
                    if (!("FormDataSource".equals(nodeName) && "Table".equals(propertyName) || "FormItem".equals(nodeName) && "Extends".equals(propertyName)) && (!"FormItem".equals(nodeName) || !"FormLookup".equals(propertyName))) continue;
                    this.doValidatePropertyValueMatch(property, refEntity, results);
                    continue;
                }
                if (entityType == EntityType.MenuItem) {
                    if (!"MenuItem".equals(nodeName) || !"Source".equals(propertyName)) continue;
                    this.doValidatePropertyValueMatch(property, refEntity, results);
                    continue;
                }
                if (entityType != EntityType.Menu || !"MenuRefMenuItem".equals(nodeName) || !"MenuItem".equals(propertyName)) continue;
                this.doValidatePropertyValueMatch(property, refEntity, results);
            }
            catch (NavException e) {
                log.error((Object)"VTD\u89e3\u6790\u5f02\u5e38", (Throwable)e);
            }
        }
        return results;
    }

    private void doValidatePropertyValueMatch(GOTProperty property, GOTNode refNode, List<RelationError> results) throws NavException {
        if (!refNode.getName().equals(property.getValue())) {
            RelationError error = new RelationError();
            error.setProperty(property);
            error.setDescription("\u5c5e\u6027\u503c\u4e0e\u5b9e\u4f53\u540d\u79f0\u4e0d\u4e00\u81f4");
            results.add(error);
        }
    }

    public static GOTNode getRefInnerId(GOTEntity refEntity, String refInnerId, GOTProperty property) throws NavException {
        String name = property.getName();
        String nodeType = property.getGOTNode().getNodeType();
        switch (name) {
            case "Field": {
                if (!"FormDataSourceField".equals(nodeType) && !"DataTypeRelation".equals(nodeType) && !"FormDataSourceRelationItem".equals(nodeType) && !"FormDataSourceGroupByItem".equals(nodeType)) break;
                return refEntity.selectSingleNode(String.format("./TableFields/TableField[@id ='%s']", refInnerId));
            }
            case "FilterField": {
                if (!"DataTypeRelation".equals(nodeType)) break;
                return refEntity.selectSingleNode(String.format("./TableFields/TableField[@id ='%s']", refInnerId));
            }
            case "Extends": {
                if (!"FormItem".equals(nodeType) || refEntity.getEntityType() != EntityType.Table) break;
                return refEntity.selectSingleNode(String.format("./TableFields/TableField[@id ='%s']", refInnerId));
            }
            case "FieldGroup": {
                if (!("FormDataSourceFieldGroup".equals(nodeType) ? refEntity.getEntityType() == EntityType.Table : "FormItem".equals(nodeType) && refEntity.getEntityType() == EntityType.Table)) break;
                return refEntity.selectSingleNode(String.format("./TableFieldGroups[@name='FieldGroups']/TableFieldGroup[@id='%s']", refInnerId));
            }
            case "DefaultOrderBy": {
                if (!"FormDataSource".equals(nodeType) || refEntity.getEntityType() != EntityType.Table) break;
                return refEntity.selectSingleNode(String.format("./TableIndexes/TableIndex[@id='%s']", refInnerId));
            }
            case "ParentField": {
                if (!"FormDataSourceRelationItem".equals(nodeType)) break;
                return refEntity.selectSingleNode(String.format("./TableFields/TableField[@id ='%s']", refInnerId));
            }
            case "ReturnField": {
                if (!"FormDataSources".equals(nodeType)) break;
                return refEntity.selectSingleNode(String.format("./TableFields/TableField[@id ='%s']", refInnerId));
            }
            case "Component": {
                if (!"FormItem".equals(nodeType)) break;
                return refEntity.selectSingleNode(String.format("./TableFields/TableField[@id ='%s']", refInnerId));
            }
            case "UnionField": {
                if (!"FormDataSourceGroupByItem".equals(nodeType)) break;
                return refEntity.selectSingleNode(String.format("./TableFields/TableField[@id ='%s']", refInnerId));
            }
        }
        return refEntity.selectSingleNode(String.format("//*[@id='%s']", refInnerId));
    }
}

