/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.core.got.validate;

import com.ximpleware.NavException;
import com.ximpleware.VTDException;
import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.gdt.designer.core.got.validate.IValidator;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.service.node.GOTNode;
import gongqi.gdt.designer.service.node.GOTProperty;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class ResolverValidator
implements IValidator {
    protected String currentLayer = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer();

    @Override
    public List<String> validateResolver(GOTNode item) throws NavException, VTDException {
        return null;
    }

    public ResolverValidator(GOTEntity entity) {
    }

    protected String getURL(GOTNode node) {
        return String.format("%s\u3010%s\u3011", node.getNodeType(), node.getName());
    }

    protected List<GOTNode> getAllChildNodes(GOTNode entity) throws VTDException {
        List<GOTNode> childNodes = entity.getChildNodeBFS(true);
        return childNodes.stream().filter(c -> c.getModifiedLayer().equals(this.currentLayer)).collect(Collectors.toList());
    }

    protected boolean isEditedNode(GOTNode entity) throws VTDException {
        return this.currentLayer.equals(entity.getModifiedLayer());
    }

    public Boolean matchPropertyRedundant(String name, List<Element> rProperties) {
        if (name.equals("CreatedDate") || name.equals("CreatedTime") || name.equals("CreatedBy") || name.equals("ModifiedDate") || name.equals("ModifiedTime") || name.equals("ModifiedBy")) {
            return false;
        }
        for (Element rProperty : rProperties) {
            if (!name.equals(rProperty.elementText("Name"))) continue;
            return false;
        }
        return true;
    }

    public Boolean matchAttrRedundant(String key, List<Element> rAttrs) {
        for (Element rAttr : rAttrs) {
            if (!key.equals(rAttr.elementText("Name"))) continue;
            return false;
        }
        return true;
    }

    public Boolean matchAttrLack(Element rAttr, Map<String, String> rAttrs) {
        for (String attr : rAttrs.keySet()) {
            if (!attr.equals(rAttr.elementText("Name"))) continue;
            return false;
        }
        return true;
    }

    public Boolean matchPropertyLack(Element rProperty, List<String> properties) {
        for (String property : properties) {
            if (!property.equals(rProperty.elementText("Name"))) continue;
            return false;
        }
        return true;
    }

    public String matchDTB(GOTEntity entity) throws VTDException {
        List<GOTProperty> properties = entity.getPropertys();
        int i = properties.size() - 1;
        String result = "";
        String[] dtb = new String[]{"ModifiedBy", "ModifiedTime", "ModifiedDate", "CreatedBy", "CreatedTime", "CreatedDate"};
        int j = 0;
        while (j < 6) {
            GOTProperty property = properties.get(i);
            if (!property.getName().equals(dtb[j])) {
                result = "DTB\u9519\u8bef:\u671f\u671b" + dtb[j] + "\u975e" + property.getName();
                break;
            }
            --i;
            ++j;
        }
        return result;
    }

    public String matchATTRFieldGroup(GOTNode formItem) throws NavException {
        String value;
        GOTProperty fieldGroupPro = formItem.getProperty("FieldGroup");
        GOTProperty componentPro = formItem.getProperty("Component");
        String result = "";
        if (fieldGroupPro != null && StringUtils.isNotBlank((String)(value = fieldGroupPro.getValue())) && StringUtils.isBlank((String)fieldGroupPro.getRefEntityId())) {
            result = "/Properties/Property/FieldGroup:\u6ca1\u6709@refentityid\u6216\u8005@refinnerid";
        }
        if (componentPro != null && StringUtils.isNotBlank((String)(value = componentPro.getValue())) && StringUtils.isBlank((String)componentPro.getRefEntityId())) {
            result = "/Properties/Property/Component:\u6ca1\u6709@refentityid\u6216\u8005@refinnerid";
        }
        return result;
    }

    protected Boolean isSequenceMatch(List<String> properties, List<Element> rProperties) {
        int proNum = rProperties.size();
        Boolean flag = true;
        int i = 0;
        while (i < proNum) {
            if (!properties.get(i).equals(rProperties.get(i).elementText("Name"))) {
                flag = false;
                break;
            }
            ++i;
        }
        return flag;
    }
}

