/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.core.got.validate;

import com.ximpleware.NavException;
import com.ximpleware.VTDException;
import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.gdt.designer.core.got.validate.ResolverValidator;
import gongqi.gdt.designer.core.got.validate.ResolverValidatorAttrMatch;
import gongqi.gdt.designer.core.got.validate.ResolverValidatorModify;
import gongqi.gdt.designer.core.got.validate.ResolverValidatorPrompt;
import gongqi.gdt.designer.core.got.validate.ResolverValidatorSequence;
import gongqi.gdt.designer.core.got.validate.ResolverValidatorValue;
import gongqi.gdt.designer.core.got.validate.ValidateResult;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.service.node.GOTNode;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Display;

public class EntityValidateService {
    private GOTEntity entity;
    private String currentLayer = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer();
    private static Logger log = Logger.getLogger(EntityValidateService.class);
    private ResolverValidator promtoValidate;
    private ResolverValidator attrMatchValidate;
    private ResolverValidator sequenceValidate;
    private ResolverValidator valueValidate;
    private ResolverValidator modifyValidate;
    private MergeMatching type;

    public EntityValidateService(GOTEntity entity, MergeMatching type) {
        this.entity = entity;
        this.type = type;
        if (MergeMatching.Validate.equals((Object)type)) {
            this.promtoValidate = new ResolverValidatorPrompt(entity);
            this.attrMatchValidate = new ResolverValidatorAttrMatch(entity);
            this.sequenceValidate = new ResolverValidatorSequence(entity);
            this.valueValidate = new ResolverValidatorValue(entity);
        } else if (MergeMatching.Adjust.equals((Object)type)) {
            this.modifyValidate = new ResolverValidatorModify(entity);
        }
    }

    public ValidateResult validateResolver() {
        ValidateResult result = new ValidateResult(this.entity);
        try {
            if (MergeMatching.Validate.equals((Object)this.type)) {
                result.addResult(this.doValidate(this.entity));
                List<GOTNode> childItems = this.getAllChildNodes();
                for (GOTNode gotNode : childItems) {
                    result.addResult(this.doValidate(gotNode));
                }
            } else if (MergeMatching.Adjust.equals((Object)this.type)) {
                result.addResult(this.doAdjust(this.entity));
                if (!result.getResults().isEmpty()) {
                    this.restoreUI();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"\u8282\u70b9\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }

    private void restoreUI() {
        GotXmlDto.getInstance().updateEntityElement(this.entity);
        final String entityId = this.entity.getId();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                FormDataSyn.restore(entityId);
            }
        });
    }

    private List<GOTNode> getAllChildNodes() throws VTDException {
        List<GOTNode> childNodes = this.entity.getChildNodeBFS(true);
        return childNodes.stream().filter(c -> c.getModifiedLayer().equals(this.currentLayer)).collect(Collectors.toList());
    }

    private List<String> doValidate(GOTNode item) throws NavException, VTDException {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.promtoValidate.validateResolver(item));
        result.addAll(this.attrMatchValidate.validateResolver(item));
        result.addAll(this.sequenceValidate.validateResolver(item));
        result.addAll(this.valueValidate.validateResolver(item));
        return result;
    }

    private List<String> doAdjust(GOTNode item) throws NavException, VTDException {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.modifyValidate.validateResolver(item));
        List paths = item.getChildNodeBFS(false).stream().map(g -> g.getEntityXPath()).collect(Collectors.toList());
        for (String path : paths) {
            GOTNode gotNode = item.getEntity().selectSingleNode(path);
            result.addAll(this.doAdjust(gotNode));
        }
        return result;
    }

    public static enum MergeMatching {
        Validate,
        Adjust;

    }
}

