/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.core.got.node.form;

import com.ximpleware.VTDException;
import gongqi.designer.got.vtd.EntityNode;
import gongqi.designer.got.vtd.GOTNode;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.core.got.node.Inner;
import gongqi.gdt.designer.core.got.node.NodeGOT;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class FormDataSourceGroupByItem
extends Inner {
    @Override
    public void doAfterInsert() {
        this.xml.addAttribute("id", NodeGOT.getNextInnerId(FormDataSourceGroupByItem.getEntity(this.xml)));
    }

    @Override
    public String allowDcEnter() {
        return "false";
    }

    @Override
    public String allowEdit() {
        return "false";
    }

    @Override
    protected void changeNameByProperty(Element property) {
        String propertyName = property.elementText("Name");
        if ("Field".equals(propertyName) || "UnionField".equals(propertyName) || "ArrayItem".equals(propertyName)) {
            String formDataSourceName = "";
            String type = this.xml.attributeValue("type");
            if ("Field".equals(type)) {
                formDataSourceName = this.xml.getParent().getParent().attributeValue("name");
            } else if ("UnionField".equals(type)) {
                formDataSourceName = GOTHelp.getPPAttValue(this.xml, "Name", "UnionSource");
            }
            String field = GOTHelp.getPPAttValue(this.xml, "Name", type);
            String arrayItem = GOTHelp.getPPAttValue(this.xml, "Name", "ArrayItem");
            String name = StringUtils.isNotBlank((String)arrayItem) ? String.format("%s.%s.%s", formDataSourceName, field, arrayItem) : String.format("%s.%s", formDataSourceName, field);
            this.xml.attribute("name").setValue(name);
        } else {
            super.changeNameByProperty(property);
        }
    }

    @Override
    public List<String> getPropertyItemEditorArray(String propertyName, String fixedRegular, GOTNode innerNode) {
        if ("UnionSource".equals(propertyName)) {
            Element baseDataSource = this.xml.getParent().getParent();
            String baseId = baseDataSource.attributeValue("id");
            List formDataSources = baseDataSource.getParent().elements("FormDataSource");
            List<String> names = formDataSources.stream().filter(f -> {
                if (f.attributeValue("id").equals(baseId)) {
                    return false;
                }
                return this.isUnionDataSource(baseDataSource, (Element)f);
            }).map(f -> f.attributeValue("name")).collect(Collectors.toList());
            return names;
        }
        if ("UnionField".equals(propertyName)) {
            ArrayList<String> array = new ArrayList<String>();
            Element unionSource = GOTHelp.getPPAttElement(this.xml, "Name", "UnionSource");
            String innerId = unionSource.attributeValue("innerid");
            Element dataSources = this.xml.getParent().getParent().getParent();
            Element dataSource = (Element)dataSources.selectSingleNode(String.format("./FormDataSource[@id = '%s']", innerId));
            if (dataSource != null) {
                Element tablePro = GOTHelp.getPPAttElement(dataSource, "Name", "Table");
                String refentityid = tablePro.attributeValue("refentityid");
                EntityNode table = GotXmlDto.getInstance().getEntityByIdAndType(EntityType.Table, refentityid);
                List tableFields = table.selectNodes("./TableFields/TableField");
                return tableFields.stream().map(t -> t.getName()).collect(Collectors.toList());
            }
            return array;
        }
        if ("ArrayItem".equals(propertyName)) {
            ArrayList<String> array = new ArrayList<String>();
            String refentityid = null;
            String refinnerid = null;
            if ("Field".equals(this.xml.attributeValue("type"))) {
                Element field = GOTHelp.getPPAttElement(this.xml, "Name", "Field");
                refentityid = field.attributeValue("refentityid");
                refinnerid = field.attributeValue("refinnerid");
            } else if ("UnionField".equals(this.xml.attributeValue("type"))) {
                Element unionField = GOTHelp.getPPAttElement(this.xml, "Name", "UnionField");
                refentityid = unionField.attributeValue("refentityid");
                refinnerid = unionField.attributeValue("refinnerid");
            }
            if (StringUtils.isBlank(refentityid) || StringUtils.isBlank(refinnerid)) {
                return array;
            }
            EntityNode table = GotXmlDto.getInstance().getEntityByIdAndType(EntityType.Table, refentityid);
            try {
                GOTNode tableField = table.selectSingleNode(String.format("./TableFields/TableField[@id = '%s']", refinnerid));
                if (tableField != null && "Component".equals(tableField.getAttributeValue("type"))) {
                    EntityNode dataType = GotXmlDto.getInstance().getEntityByIdAndType(EntityType.DataType, tableField.getProperty("Extends").getRefEntityId());
                    return dataType.selectNodes("./DataTypeArray/DataTypeArrayItem").stream().map(d -> d.getName()).collect(Collectors.toList());
                }
            }
            catch (VTDException e) {
                throw new RuntimeException(e);
            }
            return array;
        }
        return super.getPropertyItemEditorArray(propertyName, fixedRegular, innerNode);
    }

    private boolean isUnionDataSource(Element baseDataSource, Element validateDataSource) {
        String baseId = baseDataSource.attributeValue("id");
        Element joinSource = GOTHelp.getPPAttElement(validateDataSource, "Name", "JoinSource");
        List formDataSource = baseDataSource.getParent().elements("./FormDataSource");
        String joinType = GOTHelp.getPPAttValue(validateDataSource, "Name", "JoinType");
        Map<String, Element> maps = formDataSource.stream().collect(Collectors.toMap(e -> e.attributeValue("id"), e -> e));
        while (joinSource != null && StringUtils.isNotBlank((String)joinSource.attributeValue("innerid")) && !joinType.equals("Delayed")) {
            String innerid = joinSource.attributeValue("innerid");
            if (innerid.equals(baseId)) {
                return true;
            }
            Element joinDataSource = maps.get(innerid);
            if (joinDataSource == null) {
                return false;
            }
            joinSource = GOTHelp.getPPAttElement(joinDataSource, "Name", "JoinSource");
            joinType = GOTHelp.getPPAttValue(validateDataSource, "Name", "JoinType");
        }
        return false;
    }

    @Override
    protected void addRelation(Element property) {
        Attribute refinnerid;
        Attribute refentityid;
        super.addRelation(property);
        String propertyName = property.elementText("Name");
        if ("Field".equals(propertyName) || "UnionField".equals(propertyName)) {
            Element ppAttElement = GOTHelp.getPPAttElement(this.xml, "Name", "ArrayItem");
            ppAttElement.element("Value").setText("");
            refentityid = ppAttElement.attribute("refentityid");
            if (refentityid != null) {
                ppAttElement.remove(refentityid);
            }
            if ((refinnerid = ppAttElement.attribute("refinnerid")) != null) {
                ppAttElement.remove(refinnerid);
            }
        }
        if ("UnionField".equals(propertyName)) {
            Element unionSource = GOTHelp.getPPAttElement(this.xml, "Name", "UnionSource");
            String innerId = unionSource.attributeValue("innerid");
            Element dataSources = this.xml.getParent().getParent().getParent();
            Element dataSource = (Element)dataSources.selectSingleNode(String.format("./FormDataSource[@id = '%s']", innerId));
            if (dataSource != null) {
                Element tablePro = GOTHelp.getPPAttElement(dataSource, "Name", "Table");
                String refentityid2 = tablePro.attributeValue("refentityid");
                EntityNode table = GotXmlDto.getInstance().getEntityByIdAndType(EntityType.Table, refentityid2);
                try {
                    String tableFieIdName = property.elementText("Value");
                    GOTNode tableField = table.selectSingleNode(String.format("./TableFields/TableField[@name = '%s']", tableFieIdName));
                    property.addAttribute("refentityid", table.getId());
                    property.addAttribute("refinnerid", tableField.getId());
                }
                catch (VTDException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if ("ArrayItem".equals(propertyName)) {
            String componentName = property.elementText("Value");
            if (StringUtils.isBlank((String)componentName)) {
                refentityid = property.attribute("refentityid");
                if (refentityid != null) {
                    property.remove(refentityid);
                }
                if ((refinnerid = property.attribute("refinnerid")) != null) {
                    property.remove(refinnerid);
                }
            }
            Element field = GOTHelp.getPPAttElement(this.xml, "Name", this.xml.attributeValue("type"));
            String refentityid3 = field.attributeValue("refentityid");
            String refinnerid2 = field.attributeValue("refinnerid");
            EntityNode table = GotXmlDto.getInstance().getEntityByIdAndType(EntityType.Table, refentityid3);
            try {
                GOTNode tableField = table.selectSingleNode(String.format("./TableFields/TableField[@id ='%s']", refinnerid2));
                String dataTypeId = tableField.getProperty("Extends").getRefEntityId();
                EntityNode dataType = GotXmlDto.getInstance().getEntityByIdAndType(EntityType.DataType, dataTypeId);
                GOTNode dataTypeArrayItem = dataType.selectSingleNode("./DataTypeArray/DataTypeArrayItem[@name='" + componentName + "']");
                if (dataTypeArrayItem == null) {
                    throw new RuntimeException("\u672a\u627e\u5230\u7ef4\u5ea6\u9879" + componentName);
                }
                property.addAttribute("refentityid", dataTypeId);
                property.addAttribute("refinnerid", dataTypeArrayItem.getId());
            }
            catch (VTDException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

