/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.utils;

import gongqi.erp.framework.core.solution.SolutionDeploymentMode;
import gongqi.gdt.designer.ProjectConstants;
import gongqi.gdt.designer.utils.Images;
import gongqi.gdt.designer.utils.RelationError;
import gongqi.gdt.designer.utils.SolutionExtInfo;
import gongqi.gdt.designer.utils.SolutionPluginInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;

public class SolutionLayerInfo {
    private String solutionId;
    private String solutionName;
    private SolutionDeploymentMode deploymentMode;
    private String currentVersion;
    private String targetVersion;
    private String frameworkVersion;
    private List<SolutionPluginInfo> pluginInfos = new ArrayList<SolutionPluginInfo>();
    private SolutionExtInfo extInfo;
    private TreeItem bindItem;
    private String appUserId;
    private Boolean online;
    private String signature;
    private boolean hasNewVersion = false;
    private List<RelationError> relationErrors = new ArrayList<RelationError>();

    public boolean isHasNewVersion() {
        return this.hasNewVersion;
    }

    public void setHasNewVersion(boolean hasNewVersion) {
        this.hasNewVersion = hasNewVersion;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public Boolean isOnline() {
        return this.online;
    }

    public void setOnline(Boolean online) {
        this.online = online;
    }

    public String getAppUserId() {
        return this.appUserId;
    }

    public void setAppUserId(String appUserId) {
        this.appUserId = appUserId;
    }

    public TreeItem getBindItem() {
        return this.bindItem;
    }

    public void setBindItem(TreeItem bindItem) {
        this.bindItem = bindItem;
    }

    public void setExtInfo(SolutionExtInfo extInfo) {
        this.extInfo = extInfo;
    }

    public String getSolutionId() {
        return this.solutionId;
    }

    public void setSolutionId(String solutionId) {
        this.solutionId = solutionId;
    }

    public String getSolutionName() {
        return this.solutionName;
    }

    public void setSolutionName(String solutionName) {
        this.solutionName = solutionName;
    }

    public SolutionDeploymentMode getDeploymentMode() {
        return this.deploymentMode;
    }

    public void setDeploymentMode(SolutionDeploymentMode deploymentMode) {
        this.deploymentMode = deploymentMode;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public void setTargetVersion(String targetVersion) {
        this.targetVersion = targetVersion;
    }

    public String getFrameworkVersion() {
        return this.frameworkVersion;
    }

    public void setFrameworkVersion(String frameworkVersion) {
        this.frameworkVersion = frameworkVersion;
    }

    public File getUpdateFile(String version) {
        File basePath = ProjectConstants.getBasePath();
        File updateFile = new File(basePath, String.format("Temp/LayerChainCache/UpdateFile/app/%s/%s/%s.app", this.solutionId, version, this.solutionId));
        if (!updateFile.getParentFile().exists()) {
            updateFile.getParentFile().mkdirs();
        }
        return updateFile;
    }

    public File getBaseFile() {
        File layerRoot = new File(ProjectConstants.getBasePath(), "Project/Server/GongqiERP/WEB-INF/layers");
        return this.getBaseFile(layerRoot);
    }

    public File getBaseFile(File layerRoot) {
        if (this.deploymentMode.equals((Object)SolutionDeploymentMode.Package)) {
            File baseFile = new File(layerRoot, String.format("app/%s.app", this.solutionId));
            return baseFile;
        }
        File baseFile = new File(layerRoot, String.format("app/%s", this.solutionId));
        return baseFile;
    }

    public void addPlugin(SolutionPluginInfo pluginInfo) {
        this.pluginInfos.add(pluginInfo);
    }

    public List<SolutionPluginInfo> getPluginInfos() {
        return this.pluginInfos;
    }

    public SolutionExtInfo getExtInfo() {
        return this.extInfo;
    }

    public SolutionPluginInfo getPluginInfo(String pluginName) {
        Optional<SolutionPluginInfo> find = this.pluginInfos.stream().filter(p -> p.getPluginId().equals(pluginName)).findFirst();
        if (find.isPresent()) {
            return find.get();
        }
        return null;
    }

    public void updateBindItem() {
        if (this.bindItem == null || this.bindItem.isDisposed()) {
            return;
        }
        this.bindItem.setData("id", (Object)this.getSolutionId());
        this.bindItem.setText(0, this.getSolutionName() == null ? this.getSolutionId() : String.valueOf(this.getSolutionId()) + "(" + this.getSolutionName() + ")");
        this.bindItem.setText(1, this.getDeploymentMode().equals((Object)SolutionDeploymentMode.Package) ? "\u4e8c\u8fdb\u5236" : "\u6e90\u7801");
        this.bindItem.setText(2, this.getCurrentVersion());
        this.bindItem.setText(3, this.getTargetVersion() == null ? "" : this.getTargetVersion());
        if (this.isHasNewVersion()) {
            this.bindItem.setImage(2, Images.getIcon("layerUpgrade/UpVersion.png"));
        }
        if (StringUtils.isNotBlank((String)this.getTargetVersion()) && !this.getTargetVersion().equals(this.getCurrentVersion())) {
            FontData fontData = this.bindItem.getFont().getFontData()[0];
            fontData.setStyle(1);
            this.bindItem.setFont(new Font((Device)Display.getCurrent(), fontData));
        } else {
            FontData fontData = this.bindItem.getFont().getFontData()[0];
            fontData.setStyle(0);
            this.bindItem.setFont(new Font((Device)Display.getCurrent(), fontData));
        }
        if (this.relationErrors.isEmpty()) {
            this.bindItem.setForeground(Display.getCurrent().getSystemColor(2));
        } else {
            this.bindItem.setForeground(Display.getCurrent().getSystemColor(3));
        }
    }

    public SolutionLayerInfo clone() {
        SolutionLayerInfo solutionLayerInfo = new SolutionLayerInfo();
        solutionLayerInfo.setSolutionId(this.solutionId);
        solutionLayerInfo.setSolutionName(this.solutionName);
        solutionLayerInfo.setDeploymentMode(this.deploymentMode);
        solutionLayerInfo.setCurrentVersion(this.currentVersion);
        solutionLayerInfo.setTargetVersion(this.targetVersion);
        solutionLayerInfo.setBindItem(this.bindItem);
        solutionLayerInfo.setSolutionId(this.solutionId);
        solutionLayerInfo.setAppUserId(this.appUserId);
        solutionLayerInfo.setOnline(this.online);
        for (SolutionPluginInfo solutionPluginInfo : this.pluginInfos) {
            solutionPluginInfo.clone(solutionLayerInfo);
        }
        if (this.extInfo != null) {
            this.extInfo.clone(solutionLayerInfo);
        }
        return solutionLayerInfo;
    }

    public void clearRelationError() {
        this.relationErrors.clear();
        this.relationErrors = new ArrayList<RelationError>();
    }

    public void addRelationError(RelationError relationError) {
        this.relationErrors.add(relationError);
    }
}

