/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.utils;

import gongqi.designer.core.DesignerServer;
import gongqi.erp.framework.core.LayerDefination;
import gongqi.erp.framework.core.LayerResolver;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinition;
import gongqi.erp.framework.core.extension.SolutionExtensionResolver;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinition;
import gongqi.erp.framework.core.plugin.SolutionPluginResolver;
import gongqi.erp.framework.core.solution.SolutionDefinition;
import gongqi.erp.framework.core.solution.SolutionResolver;
import gongqi.gdt.designer.ProjectConstants;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;

public class LayerUpgradeHelper {
    private static Logger log = Logger.getLogger(LayerUpgradeHelper.class);
    private static LayerUpgradeHelper instance;
    private List<LayerDefination> layerDefinations = new ArrayList<LayerDefination>();
    private List<SolutionDefinition> solutionDefinitions = new ArrayList<SolutionDefinition>();
    private List<SolutionPluginDefinition> solutionPluginDefinitions = new ArrayList<SolutionPluginDefinition>();
    private List<SolutionExtensionDefinition> solutionExtensionDefinitions = new ArrayList<SolutionExtensionDefinition>();
    private static Boolean firstStart;

    static {
        firstStart = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LayerUpgradeHelper getInstance() {
        if (instance != null) return instance;
        Class<LayerUpgradeHelper> clazz = LayerUpgradeHelper.class;
        synchronized (LayerUpgradeHelper.class) {
            if (instance != null) return instance;
            instance = new LayerUpgradeHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LayerUpgradeHelper() {
        this.initLayer();
    }

    public void initLayer() {
        LayerResolver resolver = (LayerResolver)ObjectContainer.getInstance(LayerResolver.class);
        if (resolver == null && firstStart.booleanValue()) {
            firstStart = false;
            DesignerServer.prepareStart((File)ProjectConstants.getBasePath());
        }
        File layersRootDir = new File(ProjectConstants.getBasePath(), "Project/Server/GongqiERP/WEB-INF/layers");
        try {
            this.layerDefinations = ((LayerResolver)ObjectContainer.getInstance(LayerResolver.class)).resolveLayers(layersRootDir.getAbsolutePath());
            this.solutionDefinitions = Collections.emptyList();
            File solutionsRootDir = new File(layersRootDir, "app");
            if (solutionsRootDir.exists()) {
                this.solutionDefinitions = ((SolutionResolver)ObjectContainer.getInstance(SolutionResolver.class)).resolveSolutions(solutionsRootDir.getAbsolutePath());
            }
            this.solutionPluginDefinitions = Collections.emptyList();
            File solutionPluginsRootDir = new File(layersRootDir, "plg");
            if (solutionPluginsRootDir.exists()) {
                this.solutionPluginDefinitions = ((SolutionPluginResolver)ObjectContainer.getInstance(SolutionPluginResolver.class)).resolveSolutionPlugins(solutionPluginsRootDir.getAbsolutePath());
            }
            this.solutionExtensionDefinitions = Collections.emptyList();
            File solutionExtensionsRootDir = new File(layersRootDir, "ext");
            if (solutionExtensionsRootDir.exists()) {
                this.solutionExtensionDefinitions = ((SolutionExtensionResolver)ObjectContainer.getInstance(SolutionExtensionResolver.class)).resolveSolutionExtensions(solutionExtensionsRootDir.getAbsolutePath());
            }
        }
        catch (Exception e) {
            log.error((Object)"\u521d\u59cb\u5316\u5c42\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<LayerDefination> getLayerDefinations() {
        return this.layerDefinations;
    }

    public List<SolutionDefinition> getSolutionDefinitions() {
        return this.solutionDefinitions;
    }

    public List<SolutionPluginDefinition> getSolutionPluginDefinitions() {
        return this.solutionPluginDefinitions;
    }

    public List<SolutionExtensionDefinition> getSolutionExtensionDefinitions() {
        return this.solutionExtensionDefinitions;
    }

    public LayerDefination getLayerDefination(String layerName) {
        Optional<LayerDefination> optional = this.layerDefinations.stream().filter(l -> l.getLayerName().equals(layerName)).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    public SolutionDefinition getSolutionDefinition(String solutionId) {
        Optional<SolutionDefinition> optional = this.solutionDefinitions.stream().filter(l -> l.getSolutionName().equals(solutionId)).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    public SolutionPluginDefinition getSolutionPluginDefinition(String pluginId) {
        Optional<SolutionPluginDefinition> optional = this.solutionPluginDefinitions.stream().filter(l -> l.getName().equals(pluginId)).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    public SolutionExtensionDefinition getSolutionExtensionDefinition(String solutionId) {
        Optional<SolutionExtensionDefinition> optional = this.solutionExtensionDefinitions.stream().filter(l -> l.getSolutionName().equals(solutionId)).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }
}

