/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.utils;

import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.service.node.GOTNode;
import gongqi.gdt.designer.utils.LayerJavaCode;
import gongqi.gdt.designer.utils.LayerJavaMethod;
import gongqi.gdt.designer.utils.RenameNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EntityMethods {
    private GOTEntity sourceEntity;
    private GOTEntity targetEntity;
    private List<LayerJavaCode> sourceJavaCodes;
    private List<LayerJavaCode> targetJavaCodes;
    private EntityType entityType;
    private List<RenameNode> renameNodes = new ArrayList<RenameNode>();

    public EntityMethods(GOTEntity sourceEntity, GOTEntity targetEntity, EntityType entityType) {
        this.sourceEntity = sourceEntity;
        this.targetEntity = targetEntity;
        this.sourceJavaCodes = new ArrayList<LayerJavaCode>();
        this.targetJavaCodes = new ArrayList<LayerJavaCode>();
        this.entityType = entityType;
        if (targetEntity == null || sourceEntity == null) {
            return;
        }
        if (!sourceEntity.getName().equals(targetEntity.getName())) {
            LayerJavaCode.JavaType javaType = null;
            if (entityType == EntityType.Table) {
                javaType = LayerJavaCode.JavaType.Table;
            } else if (entityType == EntityType.Class) {
                javaType = LayerJavaCode.JavaType.Class;
            } else if (entityType == EntityType.Form) {
                javaType = LayerJavaCode.JavaType.Form;
            }
            String sourceName = sourceEntity.getName();
            String targetName = targetEntity.getName();
            if (sourceName.contains(".")) {
                sourceName = sourceName.substring(sourceName.lastIndexOf(".") + 1);
            }
            if (targetName.contains(".")) {
                targetName = targetName.substring(targetName.lastIndexOf(".") + 1);
            }
            this.renameNodes.add(new RenameNode(sourceName, targetName, javaType));
        }
        if (entityType == EntityType.Form) {
            List<GOTNode> formDataSources = sourceEntity.selectNodes("./FormDataSources/FormDataSource");
            for (GOTNode formDataSource : formDataSources) {
                String id = formDataSource.getId();
                GOTNode targetFormDataSource = targetEntity.selectSingleNode(String.format("./FormDataSources/FormDataSource[@id='%s']", id));
                if (targetFormDataSource == null || targetFormDataSource.getName().equals(formDataSource.getName())) continue;
                String sourceName = formDataSource.getName();
                String targetName = targetFormDataSource.getName();
                if (sourceName.contains(".")) {
                    sourceName = sourceName.substring(sourceName.lastIndexOf(".") + 1);
                }
                if (targetName.contains(".")) {
                    targetName = targetName.substring(targetName.lastIndexOf(".") + 1);
                }
                this.renameNodes.add(new RenameNode(sourceName, targetName, LayerJavaCode.JavaType.DataSource));
            }
        }
    }

    public boolean isDeleteEntity() {
        return this.targetEntity == null;
    }

    public List<RenameNode> getRenameNodes() {
        return this.renameNodes;
    }

    public void setSourceJavaCodes(List<LayerJavaCode> sourceJavaCodes) {
        this.sourceJavaCodes = sourceJavaCodes;
    }

    public void setTargetJavaCodes(List<LayerJavaCode> targetJavaCodes) {
        this.targetJavaCodes = targetJavaCodes;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    private List<String> getTargetJavaCodes(LayerJavaCode.JavaType javaType) {
        return this.targetJavaCodes.stream().filter(c -> javaType == c.getJavaType()).map(c -> c.getSimpleName()).collect(Collectors.toList());
    }

    private List<String> getSourceJavaCodes(LayerJavaCode.JavaType javaType) {
        return this.sourceJavaCodes.stream().filter(c -> javaType == c.getJavaType()).map(c -> c.getSimpleName()).collect(Collectors.toList());
    }

    public List<String> getAllCodes(LayerJavaCode.JavaType javaType) {
        List<String> codes = this.getTargetJavaCodes(javaType);
        codes.addAll(this.getSourceJavaCodes(javaType));
        return codes.stream().distinct().sorted((o1, o2) -> o1.compareTo((String)o1)).collect(Collectors.toList());
    }

    private List<LayerJavaCode> getSourceJavaCode(String simpleName, LayerJavaCode.JavaType javaType) {
        return this.sourceJavaCodes.stream().filter(c -> simpleName.equals(c.getSimpleName()) && javaType == c.getJavaType()).collect(Collectors.toList());
    }

    private List<LayerJavaCode> getTargetJavaCode(String simpleName, LayerJavaCode.JavaType javaType) {
        return this.targetJavaCodes.stream().filter(c -> simpleName.equals(c.getSimpleName()) && javaType == c.getJavaType()).collect(Collectors.toList());
    }

    public Map<String, List<LayerJavaMethod>> getSourceMethods(String simpleName, LayerJavaCode.JavaType javaType) {
        return this.getSourceJavaCode(simpleName, javaType).stream().flatMap(s -> s.getLayerJavaMethods().stream()).collect(Collectors.groupingBy(LayerJavaMethod::getSignature));
    }

    public Map<String, List<LayerJavaMethod>> getTargetMethods(String simpleName, LayerJavaCode.JavaType javaType) {
        return this.getTargetJavaCode(simpleName, javaType).stream().flatMap(s -> s.getLayerJavaMethods().stream()).collect(Collectors.groupingBy(LayerJavaMethod::getSignature));
    }
}

