/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service.rename;

import com.ximpleware.VTDException;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.handler.JDTHandler;
import gongqi.gdt.designer.service.rename.BaseRename;
import gongqi.gdt.designer.service.rename.EntityRename;
import gongqi.gdt.designer.service.rename.MethodUtil;
import gongqi.gdt.designer.service.rename.NodeRename;
import gongqi.gdt.osgi.JDTService;
import java.util.List;
import java.util.Map;

public class FormRename
extends BaseRename {
    @Override
    protected void doModifyEntity(EntityRename element) throws VTDException {
        String entityId = element.getEntityId();
        String entityName = this.getSimpleName(element.getSourceEntityName());
        String destName = this.getSimpleName(element.getTargetEntityName());
        String sourcePackageName = String.valueOf(this.getJavaPackage(entityId, element.getSourceEntityModifyLayer())) + ".forms." + entityName;
        String targetPackageName = String.valueOf(this.getJavaPackage(entityId, element.getTargetEntityModifyLayer())) + ".forms." + entityName;
        for (NodeRename nodeRename : element.getNodeRenames()) {
            String type = nodeRename.getNodeType();
            if (type.equals("FormDataSource")) continue;
            if (type.equals("FormItem")) {
                this.renameFormItem(targetPackageName, entityName, nodeRename);
            }
            if (!element.getIsPromote().booleanValue() || type.equals("FormDataSource") || !type.equals("FormItem")) continue;
            this.renameFormItem(sourcePackageName, entityName, nodeRename);
        }
        Map<String, String> sourceFormDataSources = element.getSourceFormDataSources();
        Map<String, String> targetFormDataSources = element.getTargetFormDataSources();
        for (String formDataSourceId : sourceFormDataSources.keySet()) {
            String sourceFormDataSourceName = sourceFormDataSources.get(formDataSourceId);
            String targetFormDataSourceName = targetFormDataSources.get(formDataSourceId);
            if (entityName.equals(destName) && sourceFormDataSourceName.equals(targetFormDataSourceName)) continue;
            this.renameFormDataSource(targetPackageName, entityName, destName, sourceFormDataSourceName, targetFormDataSourceName);
            if (!element.getIsPromote().booleanValue()) continue;
            this.renameFormDataSource(sourcePackageName, entityName, destName, sourceFormDataSourceName, targetFormDataSourceName);
        }
        if (!entityName.equals(destName)) {
            this.renameEntityName(String.valueOf(targetPackageName) + ".base", "FormBase_" + entityName, "FormBase_" + destName);
            this.renameEntityName(targetPackageName, "Form_" + entityName, "Form_" + destName);
            this.renameFormPackage(targetPackageName, String.valueOf(this.getJavaPackage(entityId, element.getTargetEntityModifyLayer())) + ".forms." + destName);
            if (element.getIsPromote().booleanValue()) {
                this.renameEntityName(String.valueOf(sourcePackageName) + ".base", "FormBase_" + entityName, "FormBase_" + destName);
                this.renameEntityName(sourcePackageName, "Form_" + entityName, "Form_" + destName);
                this.renameFormPackage(sourcePackageName, String.valueOf(this.getJavaPackage(entityId, element.getSourceEntityModifyLayer())) + ".forms." + destName);
            }
        }
    }

    private void renameFormPackage(String formPackageName, String newPackageName) {
        try {
            JDTService server = JDTHandler.getServer();
            server.renamePackage(formPackageName, newPackageName);
        }
        catch (Exception e) {
            this.log.warn((Object)String.format("\u5305\u540d\u91cd\u547d\u540d\u3010%s -> %s\u3011\u5931\u8d25", formPackageName, newPackageName), (Throwable)e);
        }
    }

    private void renameFormDataSource(String packageName, String entityName, String newEntityName, String sourceFormDataSourceName, String targetFormDataSourceName) {
        String newName;
        String className;
        String srcName = this.getSimpleName(sourceFormDataSourceName);
        String destName = this.getSimpleName(targetFormDataSourceName);
        JDTService server = JDTHandler.getServer();
        try {
            server.renameVariable(String.valueOf(packageName) + ".base", "FormBase_" + entityName, "__DS_" + srcName, "__DS_" + destName);
        }
        catch (Exception e) {
            this.log.warn((Object)String.format("\u3010%s.%s\u3011\u7684FormDataSource\u53d8\u91cf\u91cd\u547d\u540d\u3010%s -> %s\u3011\u5931\u8d25", String.valueOf(packageName) + ".base", "FormBase_" + entityName, srcName, destName), (Throwable)e);
        }
        try {
            className = String.format("Form_%s_DataSourceBase_%s", entityName, srcName);
            newName = String.format("Form_%s_DataSourceBase_%s", newEntityName, destName);
            server.renameClass(String.valueOf(packageName) + ".datasource.base", className, newName);
        }
        catch (Exception e) {
            this.log.warn((Object)String.format("\u3010%s.%s\u3011\u7684FormDataSource\u7684base\u7c7b\u91cd\u547d\u540d\u3010%s -> %s\u3011\u5931\u8d25", String.valueOf(packageName) + ".datasource.base", entityName, srcName, destName), (Throwable)e);
        }
        try {
            className = String.format("Form_%s_DataSource_%s", entityName, srcName);
            newName = String.format("Form_%s_DataSource_%s", newEntityName, destName);
            server.renameClass(String.valueOf(packageName) + ".datasource", className, newName);
        }
        catch (Exception e) {
            this.log.warn((Object)String.format("\u3010%s.%s\u3011\u7684FormDataSource\u7c7b\u91cd\u547d\u540d\u3010%s -> %s\u3011\u5931\u8d25", String.valueOf(packageName) + ".datasource", entityName, srcName, destName), (Throwable)e);
        }
    }

    private void renameFormItem(String packageName, String entityName, NodeRename nodeRename) {
        String srcName = this.getSimpleName(nodeRename.getSourceNodeName());
        String destName = this.getSimpleName(nodeRename.getTargetNodeName());
        JDTService server = JDTHandler.getServer();
        try {
            server.renameVariable(String.valueOf(packageName) + ".base", "FormBase_" + entityName, "_" + srcName, "_" + destName);
        }
        catch (Exception e) {
            this.log.warn((Object)String.format("\u3010%s.%s\u3011\u7684FormItem\u53d8\u91cf\u91cd\u547d\u540d\u3010%s -> %s\u3011\u5931\u8d25", String.valueOf(packageName) + ".base", "FormBase_" + entityName, srcName, destName), (Throwable)e);
        }
        try {
            List<String> formItemMethods = nodeRename.getFormItemMethods();
            for (String method : formItemMethods) {
                String[] methodParams = MethodUtil.getMethodParams(method);
                server.renameMethod(packageName, "Form_" + entityName, String.valueOf(method) + srcName, methodParams, String.valueOf(method) + destName);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)String.format("\u3010%s.%s\u3011\u7684FormItem\u65b9\u6cd5\u91cd\u547d\u540d\u3010%s -> %s\u3011\u5931\u8d25", String.valueOf(packageName) + ".base", "FormBase_" + entityName, srcName, destName), (Throwable)e);
        }
    }

    @Override
    protected EntityType getSupportEntityType() {
        return EntityType.Form;
    }
}

