/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service.rename;

import com.ximpleware.NavException;
import com.ximpleware.VTDException;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.handler.JDTHandler;
import gongqi.gdt.designer.service.GOTModel;
import gongqi.gdt.designer.service.modify.ModifyLevel;
import gongqi.gdt.designer.service.modify.ModifyType;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.service.node.GOTNode;
import gongqi.gdt.designer.service.node.GOTProperty;
import gongqi.gdt.designer.service.rename.EntityRename;
import gongqi.gdt.designer.service.rename.MethodUtil;
import gongqi.gdt.designer.service.rename.NodeRename;
import gongqi.gdt.designer.service.rename.RefFormDataSourceFieldRename;
import gongqi.gdt.osgi.JDTService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public abstract class BaseRename {
    protected final Logger log = Logger.getLogger(this.getClass());
    private Map<String, EntityRename> entityRenames = new HashMap<String, EntityRename>();

    public void init(Element entitysModify, GOTModel sourceGOT, GOTModel targetGOT) {
        List elements = entitysModify.elements();
        for (Element entityModify : elements) {
            String entityId = entityModify.attributeValue("id");
            List modifyItems = entityModify.elements("Item");
            for (Element modifyItem : modifyItems) {
                if (ModifyLevel.valueOf(modifyItem.attributeValue("modifyLevel")) == ModifyLevel.Notify) continue;
                ModifyType modifyType = ModifyType.valueOf(modifyItem.attributeValue("modifyType"));
                if (modifyType == ModifyType.Entity_Rename && !this.entityRenames.containsKey(entityId)) {
                    this.entityRenames.put(entityId, this.initEntityRename(entityId, sourceGOT, targetGOT));
                }
                if (modifyType != ModifyType.InnerNode_Rename) continue;
                try {
                    EntityRename entityRename = null;
                    if (!this.entityRenames.containsKey(entityId)) {
                        entityRename = this.initEntityRename(entityId, sourceGOT, targetGOT);
                        this.entityRenames.put(entityId, entityRename);
                    } else {
                        entityRename = this.entityRenames.get(entityId);
                    }
                    String nodeId = modifyItem.attributeValue("innerId");
                    GOTEntity sourceEntity = sourceGOT.getEntityById(this.getSupportEntityType(), entityId);
                    GOTEntity targetEntity = targetGOT.getEntityById(this.getSupportEntityType(), entityId);
                    GOTNode sourceNode = sourceEntity.getChildNode(nodeId);
                    GOTNode targetNode = targetEntity.getChildNode(nodeId);
                    NodeRename nodeRename = new NodeRename(entityId, nodeId, sourceNode.getNodeType(), sourceNode.getName(), targetNode.getName());
                    if ("TableField".equals(sourceNode.getNodeType())) {
                        nodeRename.setTableFiledParameterType(this.getTableFiledParameterType(sourceNode, sourceGOT));
                        List<GOTProperty> refPropertys = this.getTableFieldRefInnerPropertys(nodeRename.getEntityId(), nodeRename.getNodeId(), sourceGOT);
                        ArrayList<RefFormDataSourceFieldRename> refFormDataSourceFields = new ArrayList<RefFormDataSourceFieldRename>();
                        for (GOTProperty refProperty : refPropertys) {
                            GOTNode refNode = refProperty.getGOTNode();
                            if (!"FormDataSourceField".equals(refNode.getNodeType())) continue;
                            RefFormDataSourceFieldRename fieldRename = new RefFormDataSourceFieldRename();
                            GOTEntity entity = refNode.getEntity();
                            String formPackage = String.valueOf(this.getJavaPackage(nodeRename.getEntityId(), entity.getModifiedLayer())) + ".forms.datasource";
                            String formDataSourceName = this.getSimpleName(refNode.getParent().getParent().getName());
                            String className = String.format("Form_%s_DataSource_%s", this.getSimpleName(entity.getName()), formDataSourceName);
                            fieldRename.setClassName(className);
                            fieldRename.setFormPackage(formPackage);
                            refFormDataSourceFields.add(fieldRename);
                        }
                        nodeRename.setRefFormDataSourceFieldsRename(refFormDataSourceFields);
                    } else if ("FormItem".equals(sourceNode.getNodeType())) {
                        nodeRename.setFormItemMethods(MethodUtil.getFormItemMethods(sourceNode));
                    }
                    entityRename.addNodeRenames(nodeRename);
                }
                catch (Exception e) {
                    this.log.error((Object)"Rename\u521d\u59cb\u5316\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    public void modify() {
        for (EntityRename element : this.entityRenames.values()) {
            try {
                this.doModifyEntity(element);
            }
            catch (Exception e) {
                this.log.error((Object)String.format("\u5b9e\u4f53\u3010%s\u3011\u65b9\u6cd5\u91cd\u547d\u540d\u5f02\u5e38", element.getEntityId()), (Throwable)e);
            }
        }
    }

    private EntityRename initEntityRename(String entityId, GOTModel sourceGOT, GOTModel targetGOT) {
        GOTEntity sourceEntity = sourceGOT.getEntityById(this.getSupportEntityType(), entityId);
        GOTEntity targetEntity = targetGOT.getEntityById(this.getSupportEntityType(), entityId);
        EntityRename entityRename = new EntityRename(entityId);
        entityRename.setSourceEntityName(sourceEntity.getName());
        entityRename.setTargetEntityName(targetEntity.getName());
        entityRename.setIsPromote(sourceGOT.isSourceDeployment(sourceEntity.getModifiedLayer(), sourceEntity, null));
        entityRename.setSourceEntityModifyLayer(sourceEntity.getModifiedLayer());
        entityRename.setTargetEntityModifyLayer(targetEntity.getModifiedLayer());
        if (sourceEntity.getEntityType() == EntityType.Form) {
            entityRename.setSourceFormDataSources(sourceEntity.selectNodes("./FormDataSources/FormDataSource").stream().collect(Collectors.toMap(n -> n.getId(), n -> n.getName())));
            entityRename.setTargetFormDataSources(targetEntity.selectNodes("./FormDataSources/FormDataSource").stream().collect(Collectors.toMap(n -> n.getId(), n -> n.getName())));
        }
        return entityRename;
    }

    protected abstract void doModifyEntity(EntityRename var1) throws VTDException, IOException;

    protected abstract EntityType getSupportEntityType();

    protected final String getJavaPackage(String entityId, String modifyLayer) {
        try {
            if ("app".equals(modifyLayer) || "plg".equals(modifyLayer) || "ext".equals(modifyLayer)) {
                if (entityId.contains(".")) {
                    entityId = entityId.substring(0, entityId.lastIndexOf("."));
                }
                return String.format("%s.layers.%s", entityId, modifyLayer);
            }
            return "gongqi.erp.layers." + modifyLayer;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("\u83b7\u53d6\u5b9e\u4f53%s\u6e90\u7801\u5305\u9519\u8bef", entityId), e);
        }
    }

    protected void renameEntityName(String packageName, String entityName, String destName) {
        try {
            JDTService server = JDTHandler.getServer();
            server.renameClass(packageName, entityName, destName);
        }
        catch (Exception e) {
            this.log.warn((Object)String.format("\u3010%s.%s\u3011Java\u7c7b\u540d\u91cd\u547d\u540d\u3010%s -> %s\u3011\u5931\u8d25", packageName, entityName, entityName, destName), (Throwable)e);
        }
    }

    protected String getSimpleName(String name) {
        if (name.contains(".")) {
            name = name.substring(name.lastIndexOf(".") + 1);
        }
        return name;
    }

    public String[] getTableFiledParameterType(GOTNode tableFiled, GOTModel sourceGOT) throws NavException {
        String type;
        switch (type = tableFiled.getAttributeValue("type")) {
            case "String": {
                return new String[]{"Ljava.lang.String;"};
            }
            case "Long": {
                return new String[]{"J"};
            }
            case "Decimal": {
                return new String[]{"Ljava.math.BigDecimal;"};
            }
            case "Date": {
                return new String[]{"Ljava.sql.Date;"};
            }
            case "Time": {
                return new String[]{"Ljava.sql.Time;"};
            }
            case "DateTime": {
                return new String[]{"Ljava.sql.Timestamp;"};
            }
            case "Boolean": {
                return new String[]{"Z"};
            }
            case "Enum": {
                return new String[]{"I"};
            }
            case "Blob": {
                return new String[]{"[B"};
            }
            case "Clob": {
                return new String[]{"Ljava.lang.String;"};
            }
            case "Component": {
                GOTEntity dateType;
                GOTProperty property = tableFiled.getProperty("Extends");
                if (property == null || !StringUtils.isNotBlank((String)property.getRefEntityId()) || (dateType = sourceGOT.getEntityById(EntityType.DataType, property.getRefEntityId())) == null) break;
                String parameterType = String.valueOf(this.getJavaPackage(dateType.getId(), dateType.getModifiedLayer())) + ".datatypes.DataType_" + this.getSimpleName(property.getValue());
                return new String[]{"L" + parameterType + ";"};
            }
        }
        return new String[0];
    }

    protected List<GOTProperty> getTableFieldRefInnerPropertys(String entityId, String nodeId, GOTModel sourceGOT) throws VTDException {
        String xpathExpression = String.format("./FormDataSources/FormDataSource/FormDataSourceFields/FormDataSourceField/Properties/Property[@%s='%s' and @%s='%s']", "refentityid", entityId, "refinnerid", nodeId);
        return sourceGOT.getTableFieldRefPropertys(entityId, xpathExpression);
    }
}

