/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service.analysis;

import com.ximpleware.VTDException;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.service.GOTModel;
import gongqi.gdt.designer.service.analysis.BaseAnalysis;
import gongqi.gdt.designer.service.modify.ModifyLevel;
import gongqi.gdt.designer.service.modify.ModifyType;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.service.node.GOTNode;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class MenuAnalysis
extends BaseAnalysis {
    public MenuAnalysis(GOTModel sourceGOT, GOTModel targetGOT, GOTModel originalGOT) {
        super(sourceGOT, targetGOT, originalGOT);
    }

    @Override
    protected EntityType getSupportEntityType() {
        return EntityType.Menu;
    }

    @Override
    protected List<Element> analysisEntityInnerModify(GOTEntity sourceEntity, GOTEntity targetEntity) throws VTDException {
        String[] nodeBaseXPaths;
        ArrayList<Element> modifyItems = new ArrayList<Element>();
        String[] stringArray = nodeBaseXPaths = new String[]{"//MenuRefMenuItem", "//MenuSeperator", "//MenuSub"};
        int n = nodeBaseXPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String nodeBaseXPath = stringArray[n2];
            for (GOTNode targetMenuChild : targetEntity.selectNodes(nodeBaseXPath)) {
                modifyItems.addAll(this.analysisInnerNode(targetMenuChild));
            }
            ++n2;
        }
        List<GOTNode> targetMenuChilds = targetEntity.getChildNodeBFS(true);
        GOTEntity transitionMenu = this.originalTargetGOT.getEntityById(targetEntity.getEntityType(), targetEntity.getId());
        if (transitionMenu != null) {
            List<GOTNode> sourceMenuChilds = transitionMenu.getChildNodeBFS(true);
            if (targetMenuChilds.size() == sourceMenuChilds.size()) {
                int i = 0;
                while (i < targetMenuChilds.size()) {
                    if (!targetMenuChilds.get(i).getId().equals(sourceMenuChilds.get(i).getId())) {
                        modifyItems.add(this.createModifyItem(ModifyType.InnerNode_Order, ModifyLevel.Must, targetEntity.getNodeType(), null, null, "\u83dc\u5355\u7ed3\u6784\u8c03\u6574", null, null));
                        break;
                    }
                    ++i;
                }
            } else {
                modifyItems.add(this.createModifyItem(ModifyType.InnerNode_Order, ModifyLevel.Must, targetEntity.getNodeType(), null, null, "\u83dc\u5355\u7ed3\u6784\u8c03\u6574", null, null));
            }
        }
        return modifyItems;
    }

    @Override
    protected List<Element> analysisEntityInnerDelete(GOTEntity sourceEntity, GOTEntity targetEntity) throws VTDException {
        String[] nodeBaseXPaths;
        ArrayList<Element> items = new ArrayList<Element>();
        String[] stringArray = nodeBaseXPaths = new String[]{"//MenuRefMenuItem", "//MenuSeperator", "//MenuSub"};
        int n = nodeBaseXPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String nodeBaseXPath = stringArray[n2];
            for (GOTNode sourceMenuChild : sourceEntity.selectNodes(nodeBaseXPath)) {
                GOTNode targetMenuChild;
                if (this.sourceGOT.isSourceDeployment(sourceMenuChild.getCreatedLayer(), sourceEntity, null) || (targetMenuChild = targetEntity.selectSingleNode(String.format("%s[@id='%s']", nodeBaseXPath, sourceMenuChild.getId()))) != null || "ent".equals(sourceMenuChild.getCreatedLayer())) continue;
                items.add(this.createModifyItem(ModifyType.InnerNode_Delete, ModifyLevel.Must, sourceMenuChild.getNodeType(), sourceMenuChild.getId(), null, String.format("\u5347\u7ea7\u5c42\u5b9e\u4f53\u5220\u9664\u5185\u90e8\u8282\u70b9\u3010%s %s\u3011", sourceMenuChild.getNodeType(), sourceMenuChild.getName()), null, null));
            }
            ++n2;
        }
        return items;
    }
}

