/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.core.got.node.table;

import gongqi.designer.core.LayerLevelManager;
import gongqi.designer.got.vtd.EntityNode;
import gongqi.designer.got.vtd.GOTNode;
import gongqi.designer.services.LayerService;
import gongqi.designer.utils.Dom4jUtils;
import gongqi.designer.utils.GOTHelper;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.core.got.node.Entity;
import gongqi.gdt.designer.core.toolsgot.GOTXMLHelper;
import gongqi.gdt.designer.core.toolsgot.Macros;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.tool.GOTHelp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.eclipse.swt.widgets.TreeItem;

public class Table
extends Entity {
    private static String maySqlKeys = "ADD ALL ALTER ANALYZE AND AS ASC ASENSITIVE BEFORE BETWEEN BIGINT BINARY BLOB BOTH BY CALL CASCADE CASE CHANGE CHAR CHARACTER CHECK COLLATE COLUMN CONDITION CONNECTION CONSTRAINT CONTINUE CONVERT CREATE CROSS CURRENT_DATE CURRENT_TIME CURRENT_TIMESTAMP CURRENT_USER CURSOR DATABASE DATABASES DAY_HOUR DAY_MICROSECOND DAY_MINUTE DAY_SECOND DEC DECIMAL DECLARE DEFAULT DELAYED DELETEDESC DESCRIBE DETERMINISTIC DISTINCT DISTINCTROW DIV DOUBLE DROP DUAL EACH ELSE ELSEIF ENCLOSED ESCAPED EXISTS EXIT EXPLAIN FALSE FETCH FLOAT FLOAT4 FLOAT8 FOR FORCE FOREIGN FROM FULLTEXT GOTO GRANT GROUP HAVING HIGH_PRIORITY HOUR_MICROSECOND HOUR_MINUTE HOUR_SECOND IF IGNORE IN INDEX INFILE INNER INOUT INSENSITIVE INSERT INT INT1 INT2 INT3 INT4 INT8 INTEGER INTERVAL INTO IS ITERATE JOIN KEY KEYS KILL LABEL LEADING LEAVE LEFT LIKE LIMIT LINEARLINES LOAD LOCALTIME LOCALTIMESTAMP LOCK LONG LONGBLOB LONGTEXT LOOP LOW_PRIORITY MATCH MEDIUMBLOB MEDIUMINT MEDIUMTEXT MIDDLEINT MINUTE_MICROSECOND MINUTE_SECOND MOD MODIFIES NATURAL NOT NO_WRITE_TO_BINLOG NULL NUMERIC ON OPTIMIZE OPTION OPTIONALLY OR ORDER OUT OUTER OUTFILE PRECISION PRIMARY PROCEDURE PURGE RAID0 RANGE READ READS REAL REFERENCES REGEXP RELEASE RENAME REPEAT REPLACE REQUIRE RESTRICT RETURN REVOKE RIGHT RLIKE SCHEMA SCHEMAS SECOND_MICROSECOND SELECT SENSITIVE SEPARATOR SET SHOW SMALLINT SPATIAL SPECIFIC SQL SQLEXCEPTION SQLSTATE SQLWARNING SQL_BIG_RESULT SQL_CALC_FOUND_ROWS SQL_SMALL_RESULTSSL STARTING STRAIGHT_JOIN TABLE TERMINATED THEN TINYBLOB TINYINT TINYTEXT TO TRAILING TRIGGER TRUE UNDO UNION UNIQUE UNLOCK UNSIGNED UPDATE USAGE USE USING UTC_DATE UTC_TIME UTC_TIMESTAMP VALUES VARBINARY VARCHAR VARCHARACTER VARYING WHEN WHERE WHILE WITH WRITE X59 XOR YEAR_MONTH ZEROFILL UID ABSTRACT";

    @Override
    public void doBeforeInsert() {
        Element tableFields = this.xml.element("TableFields");
        Element tableIndexs = this.xml.element("TableIndexes");
        Element tableGroupRecordCM = (Element)this.xml.element("TableFieldGroups").elements("TableFieldGroup").get(1);
        List<Element> elements = GOTXMLHelper.getAutoTableFields();
        for (Element element : elements) {
            tableFields.add(element.detach());
        }
        tableIndexs.add(GOTXMLHelper.getAutoRecIdxTableIndex().detach());
        elements = GOTXMLHelper.getAutoTableFieldGroupItems();
        for (Element element : elements) {
            tableGroupRecordCM.add(element.detach());
        }
        super.doBeforeInsert();
    }

    @Override
    public void doAfterInsert() {
        String lay = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer();
        String unique = this.resolverNode.getAttributeValue("name", "Unique");
        if (unique.equals("brother")) {
            this.setBrotherUniqueName(this.xml);
        } else if (unique.equals("inner")) {
            this.setInnerUniqueName(this.xml);
        }
        this.setInnerId();
        this.xml.remove(this.xml.attribute("saved"));
        this.setUnsaved();
        this.xml.addAttribute("createdLayer", lay);
    }

    private void setInnerId() {
        List tableFieldGroups = this.xml.element("TableFieldGroups").elements("TableFieldGroup");
        int nextInnerId = 26;
        int base = ((LayerLevelManager)ObjectContainer.getInstance(LayerLevelManager.class)).getLayerLevel(((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer()) * 10000;
        for (Element tableFieldGroup : tableFieldGroups) {
            tableFieldGroup.addAttribute("id", String.valueOf(base + nextInnerId));
            ++nextInnerId;
            List tableFieldGroupItems = tableFieldGroup.elements("TableFieldGroupItem");
            Iterator iterator = tableFieldGroupItems.iterator();
            while (iterator.hasNext()) {
                Element tableFieldGroupItem = (Element)iterator.next();
                String idStr = tableFieldGroupItem.attributeValue("id");
                int _id = Integer.parseInt(idStr);
                tableFieldGroupItem.attribute("id").setValue(String.valueOf(base + _id));
                List properties = tableFieldGroupItem.element("Properties").elements("Property");
                for (Element property : properties) {
                    Attribute attr = property.attribute("innerid");
                    if (attr == null) continue;
                    String innerId = attr.getValue();
                    int iid = Integer.parseInt(innerId);
                    attr.setValue(String.valueOf(base + iid));
                }
            }
        }
        if (base > 0) {
            List tableFields = this.xml.element("TableFields").elements("TableField");
            for (Element tableField : tableFields) {
                String idStr = tableField.attributeValue("id");
                int _id = Integer.parseInt(idStr);
                tableField.attribute("id").setValue(String.valueOf(base + _id));
            }
            List tableIndexes = this.xml.element("TableIndexes").elements("TableIndex");
            for (Element tableIndex : tableIndexes) {
                String idStr = tableIndex.attributeValue("id");
                int _id = Integer.parseInt(idStr);
                tableIndex.attribute("id").setValue(String.valueOf(base + _id));
                List tableIndexItems = tableIndex.elements("TableIndexItem");
                for (Element tableIndexItem : tableIndexItems) {
                    String _idStr = tableIndexItem.attributeValue("id");
                    int __id = Integer.parseInt(_idStr);
                    tableIndexItem.attribute("id").setValue(String.valueOf(base + __id));
                    List properties = tableIndexItem.element("Properties").elements("Property");
                    for (Element property : properties) {
                        Attribute attr = property.attribute("innerid");
                        if (attr == null) continue;
                        String innerId = attr.getValue();
                        int iid = Integer.parseInt(innerId);
                        attr.setValue(String.valueOf(base + iid));
                    }
                }
            }
        }
        Attribute attr = this.xml.attribute("nextInnerId");
        attr.setValue(String.valueOf(base + nextInnerId));
    }

    private void addRecordCMDTB(Element tableGroupRecordCM, String isSessionExist) {
        for (Element tableFieldGroupItem : GOTXMLHelper.getAutoTableFieldGroupItems()) {
            tableGroupRecordCM.add(tableFieldGroupItem.detach());
        }
    }

    private void removeRecordCMDTB(Element tableGroupRecordCM) {
        String xpath = "TableFieldGroupItem[@name='CreatedDate']";
        Element element = (Element)tableGroupRecordCM.selectNodes(xpath).get(0);
        tableGroupRecordCM.remove(element);
        xpath = "TableFieldGroupItem[@name='CreatedTime']";
        element = (Element)tableGroupRecordCM.selectNodes(xpath).get(0);
        tableGroupRecordCM.remove(element);
        xpath = "TableFieldGroupItem[@name='CreatedBy']";
        element = (Element)tableGroupRecordCM.selectNodes(xpath).get(0);
        tableGroupRecordCM.remove(element);
        xpath = "TableFieldGroupItem[@name='ModifiedDate']";
        element = (Element)tableGroupRecordCM.selectNodes(xpath).get(0);
        tableGroupRecordCM.remove(element);
        xpath = "TableFieldGroupItem[@name='ModifiedTime']";
        element = (Element)tableGroupRecordCM.selectNodes(xpath).get(0);
        tableGroupRecordCM.remove(element);
        xpath = "TableFieldGroupItem[@name='ModifiedBy']";
        element = (Element)tableGroupRecordCM.selectNodes(xpath).get(0);
        tableGroupRecordCM.remove(element);
    }

    private void addRecordDTB(Element tableFields, String isSessionExist) {
        this.addExtendIdAndLayerForRecordDTB();
        String xpath = "";
        if (isSessionExist.equals("true")) {
            xpath = "TableField[@name='CreatedSessionId']";
            Element createdSessionId = (Element)tableFields.selectNodes(xpath).get(0);
            GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.getAutoTableField("CreatedBy"), createdSessionId);
            GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.getAutoTableField("CreatedTime"), createdSessionId);
            GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.getAutoTableField("CreatedDate"), createdSessionId);
            xpath = "TableField[@name='ModifiedSessionId']";
            Element modifiedSessionId = (Element)tableFields.selectNodes(xpath).get(0);
            GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.getAutoTableField("ModifiedBy"), modifiedSessionId);
            GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.getAutoTableField("ModifiedTime"), modifiedSessionId);
            GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.getAutoTableField("ModifiedDate"), modifiedSessionId);
        } else {
            xpath = "TableField[@name='RecVersion']";
            Element recVersion = (Element)tableFields.selectNodes(xpath).get(0);
            GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.getAutoTableField("CreatedDate"), recVersion);
            GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.getAutoTableField("CreatedTime"), recVersion);
            GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.getAutoTableField("CreatedBy"), recVersion);
            GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.getAutoTableField("ModifiedDate"), recVersion);
            GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.getAutoTableField("ModifiedTime"), recVersion);
            GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.getAutoTableField("ModifiedBy"), recVersion);
        }
    }

    private void removeRecordDTB(Element tableFields) {
        String xpath = "TableField[@name='CreatedDate']";
        Element element = (Element)tableFields.selectNodes(xpath).get(0);
        tableFields.remove(element);
        xpath = "TableField[@name='CreatedTime']";
        element = (Element)tableFields.selectNodes(xpath).get(0);
        tableFields.remove(element);
        xpath = "TableField[@name='CreatedBy']";
        element = (Element)tableFields.selectNodes(xpath).get(0);
        tableFields.remove(element);
        xpath = "TableField[@name='ModifiedDate']";
        element = (Element)tableFields.selectNodes(xpath).get(0);
        tableFields.remove(element);
        xpath = "TableField[@name='ModifiedTime']";
        element = (Element)tableFields.selectNodes(xpath).get(0);
        tableFields.remove(element);
        xpath = "TableField[@name='ModifiedBy']";
        element = (Element)tableFields.selectNodes(xpath).get(0);
        tableFields.remove(element);
    }

    private void addRecordSession(Element tableFields, String isDTBExist) {
        String xpath = "";
        if (isDTBExist.equals("true")) {
            xpath = "TableField[@name='CreatedDate']";
            Element createdDate = (Element)tableFields.selectNodes(xpath).get(0);
            GOTHelp.insertChildBefore(tableFields, GOTXMLHelper.getCreatedSessionId(), createdDate);
            xpath = "TableField[@name='ModifiedDate']";
            Element cfr_ignored_0 = (Element)tableFields.selectNodes(xpath).get(0);
            GOTHelp.insertChildBefore(tableFields, GOTXMLHelper.getModifiedSessionId(), createdDate);
        } else {
            xpath = "TableField[@name='RecVersion']";
            Element recVersion = (Element)tableFields.selectNodes(xpath).get(0);
            GOTHelp.insertChildBefore(tableFields, GOTXMLHelper.getCreatedSessionId(), recVersion);
            GOTHelp.insertChildBefore(tableFields, GOTXMLHelper.getModifiedSessionId(), recVersion);
        }
    }

    private void removeRecordSession(Element tableFields) {
        String xpath = "TableField[@name='CreatedSessionId']";
        Element element = (Element)tableFields.selectNodes(xpath).get(0);
        tableFields.remove(element);
        xpath = "TableField[@name='ModifiedSessionId']";
        element = (Element)tableFields.selectNodes(xpath).get(0);
        tableFields.remove(element);
    }

    private void addExtendIdAndLayerForRecordDTB() {
        ArrayList<Element> array = new ArrayList<Element>();
        array.add(GOTXMLHelper.getAutoTableField("CreatedBy"));
        array.add(GOTXMLHelper.getAutoTableField("CreatedDate"));
        array.add(GOTXMLHelper.getAutoTableField("CreatedTime"));
        array.add(GOTXMLHelper.getAutoTableField("ModifiedBy"));
        array.add(GOTXMLHelper.getAutoTableField("ModifiedDate"));
        array.add(GOTXMLHelper.getAutoTableField("ModifiedTime"));
        String lay = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer();
        for (Element tableField : array) {
            Element property = GOTHelp.getPPAttElement(tableField, "Name", "Extends");
            String dataTypeValue = property.elementText("Value");
            EntityNode dataType = GotXmlDto.getInstance().getEntityByName(EntityType.DataType, dataTypeValue);
            String id = dataType.getId();
            property.addAttribute("refentityid", id);
            tableField.addAttribute("createdLayer", lay);
            tableField.addAttribute("modifiedLayer", lay);
        }
    }

    @Override
    public void doAfterPropertyModified(Element property, String ... args) {
        super.doAfterPropertyModified(property, args);
        if (property.elementText("Name").equals("RecordDTB")) {
            String isSessionExist = GOTHelp.getPPAttValue(this.xml, "Name", "RecordSession");
            if (property.elementText("Value").equals("true")) {
                this.addRecordDTB(this.xml.element("TableFields"), isSessionExist);
                Element element = (Element)this.xml.element("TableFieldGroups").elements("TableFieldGroup").get(2);
                this.addRecordCMDTB(element, isSessionExist);
            } else if (property.elementText("Value").equals("false")) {
                this.removeRecordDTB(this.xml.element("TableFields"));
                Element element = (Element)this.xml.element("TableFieldGroups").elements("TableFieldGroup").get(2);
                this.removeRecordCMDTB(element);
            }
        } else if (property.elementText("Name").equals("RecordSession")) {
            if (property.elementText("Value").equals("true")) {
                String isDTBExist = GOTHelp.getPPAttValue(this.xml, "Name", "RecordDTB");
                this.addRecordSession(this.xml.element("TableFields"), isDTBExist);
            } else if (property.elementText("Value").equals("false")) {
                this.removeRecordSession(this.xml.element("TableFields"));
            }
        } else if (property.elementText("Name").equals("LineNumFilter")) {
            String value = property.elementText("Value");
            if (value.equals("SysLineNum")) {
                return;
            }
            Element tablePP = GOTHelp.getProperty(this.xml, "Temporary");
            if (tablePP.elementText("Value").equals("true")) {
                return;
            }
            String lineNumIndexName = "SysLineNumIdx";
            Element linNumIndexElement = (Element)this.xml.selectSingleNode(String.format("./TableIndexes/TableIndex[@name='%s']", lineNumIndexName));
            if (linNumIndexElement != null) {
                String xpath;
                Element item;
                if (StringUtils.isNotBlank((String)args[0]) && (item = (Element)linNumIndexElement.selectSingleNode(xpath = "./TableIndexItem[@name='" + args[0] + "']")) != null) {
                    TreeItem treeItem_item = FormDataSyn.getTreeItrmByElement(item, FormDataSyn.currentTreeUi);
                    linNumIndexElement.remove(item);
                    if (treeItem_item != null) {
                        FormDataSyn.deleteOneTreeItem(treeItem_item);
                    }
                }
                if (value.equals("")) {
                    return;
                }
                Element tarField = (Element)this.xml.selectSingleNode(String.format("./TableFields/TableField[@name='%s']", value));
                long nextInnerId = Long.parseLong(this.xml.attributeValue("nextInnerId"));
                String layerName = this.xml.attributeValue("modifiedLayer");
                String TableIndexItem2 = "<TableIndexItem name=\"\" id=\"\" createdLayer=\"\" modifiedLayer=\"\"><Properties><Property innerid=\"\"><Name>Field</Name><Value/></Property><Property><Name>ArrayItem</Name><Value/></Property><Property><Name>SortOrder</Name><Value>ASC</Value></Property></Properties></TableIndexItem>";
                Element tableIndexItemElement = Dom4jUtils.parserElement((String)TableIndexItem2);
                tableIndexItemElement.addAttribute("id", Long.toString(nextInnerId++));
                tableIndexItemElement.addAttribute("name", value);
                tableIndexItemElement.addAttribute("createdLayer", layerName);
                tableIndexItemElement.addAttribute("modifiedLayer", layerName);
                Element fieldProperty = GOTHelp.getProperty(tableIndexItemElement, "Field");
                fieldProperty.addAttribute("innerid", tarField.attributeValue("id"));
                fieldProperty.element("Value").setText(tarField.attributeValue("name"));
                this.xml.addAttribute("nextInnerId", Long.toString(nextInnerId));
                GOTHelp.insertChildBefore(linNumIndexElement, (Element)linNumIndexElement.elements().get(0), tableIndexItemElement);
                TreeItem treeItem = FormDataSyn.getTreeItrmByElement(linNumIndexElement, FormDataSyn.currentTreeUi);
                if (treeItem != null) {
                    FormDataSyn.actionSyn(treeItem, tableIndexItemElement, 0, true);
                }
            }
        }
    }

    @Override
    protected String validateOther() {
        List indexList = this.xml.element("TableIndexes").elements("TableIndex");
        for (Element index : indexList) {
            if (index.elements("TableIndexItem").size() == 0) {
                return "false" + index.attributeValue("name") + ":" + index.getName() + "  \u5e94\u8be5\u81f3\u5c11\u6709\u4e00\u4e2aItem";
            }
            List elements = index.elements("TableIndexItem");
            for (Element tableIndexItem : elements) {
                Element tableField;
                String innerId;
                String xpath;
                List tableFields;
                Element fieldPro;
                String arrayItemProperty = GOTHelper.getPropertyValue((Element)tableIndexItem, (String)"ArrayItem");
                if (arrayItemProperty != null && !arrayItemProperty.equals("") || (fieldPro = GOTHelper.getProperty((Element)tableIndexItem, (String)"Field")).attribute("innerid") != null || (tableFields = this.xml.selectNodes(xpath = "TableFields/TableField[@id=" + (innerId = fieldPro.attributeValue("innerid")) + "]")).size() <= 0 || !(tableField = (Element)tableFields.get(0)).attributeValue("type").equals("Component")) continue;
                return "false:" + tableIndexItem.attributeValue("name") + "-->\u7531\u4e8e\u5176\u5f15\u7528\u4e86Component\u5b57\u6bb5 \u6240\u4ee5ArrayItem\u5c5e\u6027\u4e00\u5b9a\u8981\u6709\u503c";
            }
        }
        String name = this.xml.attributeValue("name");
        if (name != null && name.indexOf(".") != -1) {
            int lastIndex = name.lastIndexOf(".");
            name = name.substring(lastIndex + 1);
        }
        if (maySqlKeys.contains(name.trim())) {
            return "false:" + name + "\u4e3a\u5173\u952e\u5b57";
        }
        char num = name.charAt(0);
        if (num < 'A' || num > 'Z') {
            return "false:" + name + "-->\u5b57\u6bb5\u540d\u5fc5\u987b\u4ee5\u5927\u5199\u5b57\u6bcd\u5f00\u5934";
        }
        List tableFields = this.xml.element("TableFields").elements("TableField");
        for (Element tableField : tableFields) {
            name = tableField.attributeValue("name");
            if (name != null && name.length() > 64) {
                return "false:\u5b57\u6bb5\u540d\u957f\u5ea6\u4e0d\u5f97\u5927\u4e8e64\uff1a" + name.substring(20);
            }
            if (name != null && name.indexOf(".") != -1) {
                int lastIndex = name.lastIndexOf(".");
                name = name.substring(lastIndex + 1);
            }
            if (maySqlKeys.contains(name.trim())) {
                return "false:" + name + "\u4e3a\u5173\u952e\u5b57";
            }
            num = name.charAt(0);
            if (num >= 'A' && num <= 'Z') continue;
            return "false:" + name + "-->\u5b57\u6bb5\u540d\u5fc5\u987b\u4ee5\u5927\u5199\u5b57\u6bcd\u5f00\u5934";
        }
        List autoLookupItems = this.xml.selectNodes("./TableFieldGroups/TableFieldGroup[@name = 'AutoLookup']/TableFieldGroupItem");
        for (Element autoLookupItem : autoLookupItems) {
            String field = GOTHelper.getPropertyValue((Element)autoLookupItem, (String)"Field");
            if (!StringUtils.isBlank((String)field)) continue;
            return "false: AutoLookup\u7684" + autoLookupItem.attributeValue("name") + "\u672a\u6307\u5b9a\u6307\u5b9a\u5b57\u6bb5";
        }
        return "true";
    }

    @Override
    protected String validateAttributes() {
        List tableFields = this.xml.element("TableFields").elements("TableField");
        ArrayList<Element> compTableFields = new ArrayList<Element>();
        for (Element tableField : tableFields) {
            String _name;
            String _type;
            if (tableField.attribute("editOnCreate") != null) {
                tableField.remove(tableField.attribute("editOnCreate"));
            }
            if ((_type = tableField.attributeValue("type")).equals("Time") && (_name = tableField.attributeValue("name")).indexOf(_type) == -1) {
                return "false:" + _name + "\u5fc5\u987b\u5305\u542bTime\uff08Time\u7c7b\u578b\u7684TableField\u5176\u540d\u79f0\u5fc5\u987b\u5305\u542bTime\uff09";
            }
            if (StringUtils.isBlank((String)tableField.attributeValue("createdLayer"))) {
                _name = tableField.attributeValue("name");
                return "false:" + _name + "\u7f3a\u5c11\u5c5e\u6027createdLayer";
            }
            if (StringUtils.isBlank((String)tableField.attributeValue("modifiedLayer"))) {
                _name = tableField.attributeValue("name");
                return "false:" + _name + "\u7f3a\u5c11\u5c5e\u6027modifiedLayer";
            }
            if (tableField.attribute("type") == null || !"Component".equals(tableField.attributeValue("type"))) continue;
            compTableFields.add(tableField);
        }
        for (Element compTableField : compTableFields) {
            Element extendsPro = GOTHelper.getProperty((Element)compTableField, (String)"Extends");
            String entityId = extendsPro.attributeValue("refentityid");
            EntityNode extendsCompDataType = GotXmlDto.getInstance().getEntityByIdAndType(EntityType.DataType, entityId);
            if (extendsCompDataType == null) {
                return "false:" + this.xml.attributeValue("name") + "." + compTableField.attributeValue("name") + " \u4e3aComponent\u7c7b\u578b\uff0c\u5176Extends" + Macros.ERROR_PROPERTIES_NULL;
            }
            List datatypearrayitems = extendsCompDataType.selectNodes(".//DataTypeArrayItem");
            for (GOTNode item : datatypearrayitems) {
                String _name = String.valueOf(compTableField.attributeValue("name")) + "_" + item.getName();
                for (Element item2 : tableFields) {
                    if (!item2.attributeValue("name").toLowerCase().equals(_name.toLowerCase())) continue;
                    return "false:" + Macros.ERROR_VALUE_NONUNIQUE;
                }
            }
        }
        return "true";
    }

    @Override
    protected String validateProperties(Element nodeBeValidated) {
        String xpath = "TableFields/TableField/Properties/Properties[@innerid]";
        List allInnerIdProperties = nodeBeValidated.selectNodes(xpath);
        for (Element innerIdProperty : allInnerIdProperties) {
            String innerId = innerIdProperty.attributeValue("innerid");
            String _name = innerIdProperty.elementText("Value");
            xpath = "TableFields/TableField[@id='" + innerId + "'][@name='" + _name + "']";
            List tableFields = nodeBeValidated.selectNodes(xpath);
            if (tableFields.size() > 0) continue;
            return "false\u5c5e\u6027" + innerIdProperty.elementText("Name") + "\u5173\u8054\u7684\u5b57\u6bb5\u4e0d\u5b58\u5728";
        }
        xpath = "TableIndexes/TableIndex";
        List tableIndexes = nodeBeValidated.selectNodes(xpath);
        for (Element tableIndex : tableIndexes) {
            List tableIndexItems = tableIndex.elements("TableIndexItem");
            for (Element tableIndexItem : tableIndexItems) {
                String _name;
                List results = tableIndexItem.selectNodes("TableIndexItem[@name='" + (_name = tableIndexItem.attributeValue("name")) + "']");
                if (results.size() <= 1) continue;
                return "false" + tableIndex.attributeValue("name") + "\u4e0b\u6709\u591a\u4e2a\u540d\u79f0\u4e3a:" + _name + "\u7684TableIndexItem";
            }
        }
        return "true";
    }

    @Override
    public String allowPropertyEdit(String propertyName) {
        String lay = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer();
        if ((propertyName.equals("RecordSession") || propertyName.equals("RecordDTB")) && !this.xml.attributeValue("createdLayer").equals(lay)) {
            return Macros.INFO_FALSE;
        }
        if (propertyName.equals("PrimaryIndex")) {
            return Macros.INFO_FALSE;
        }
        return super.allowPropertyEdit(propertyName);
    }
}

