/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.core.got.node.form;

import gongqi.gdt.designer.core.got.node.Branch;
import gongqi.gdt.designer.core.got.node.NodeGOT;
import gongqi.gdt.designer.core.got.node.form.FormItemDragController;
import gongqi.gdt.designer.core.got.node.form.IFormItemDragController;
import info.gongqi.got.tool.GOTHelp;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.eclipse.swt.events.MouseEvent;

public class FormDesign
extends Branch {
    private IFormItemDragController dragCtrl = FormItemDragController.getInstance();

    @Override
    public NodeGOT getAccpDragNewNode(Element src) {
        if (src.getName().equals("Enum")) {
            NodeGOT node = super.doAccpDragNew("FormItem", "EnumEditor");
            this.dragCtrl.doAccpDragNewAfter(src, node);
            return node;
        }
        if (src.getName().equals("DataType")) {
            String type = this.getFormItemType(src.attributeValue("type"));
            NodeGOT node = super.doAccpDragNew("FormItem", type);
            this.dragCtrl.doAccpDragNewAfter(src, node);
            return node;
        }
        if (src.getName().equals("FormDataSourceField")) {
            NodeGOT node = super.doAccpDragNew("FormItem", this.getFormItemType(src.attributeValue("type")));
            this.dragCtrl.doAccpDragNewAfter(src, node);
            return node;
        }
        if (src.getName().equals("FormDataSourceGroupByItem")) {
            String type = src.attributeValue("type");
            Element field = GOTHelp.getPPAttElement(src, "Name", type);
            String refentityid = field.attributeValue("refentityid");
            String refinnerid = field.attributeValue("refinnerid");
            if (StringUtils.isBlank((String)refentityid) || StringUtils.isBlank((String)refinnerid)) {
                throw new RuntimeException("\u8bf7\u5148\u6307\u5b9aFormDataSourceGroupByItem\u7684\u5173\u8054\u5b57\u6bb5");
            }
            Element formDataSource = null;
            if ("Field".equals(type)) {
                formDataSource = src.getParent().getParent();
            } else if ("UnionField".equals(type)) {
                Element unionSource = GOTHelp.getPPAttElement(src, "Name", "UnionSource");
                String innerid = unionSource.attributeValue("innerid");
                List formDataSources = src.getParent().getParent().getParent().selectNodes(String.format("./FormDatSource[@id = '%s']", innerid));
                if (!formDataSources.isEmpty()) {
                    formDataSource = (Element)formDataSources.get(0);
                }
            }
            if (formDataSource == null) {
                throw new RuntimeException("\u672a\u627e\u5230\u8be5FormDataSourceGroupByItem\u7684\u5173\u8054\u5b57\u6bb5");
            }
            Element tableField = (Element)formDataSource.selectSingleNode(String.format("./FormDataSourceFields/FormDataSourceField/Properties/Property[@refentityid = '%s' and @refinnerid ='%s']/Name[text()='Field']/../../..", refentityid, refinnerid));
            if (tableField == null) {
                throw new RuntimeException("\u672a\u627e\u5230\u8be5FormDataSourceGroupByItem\u7684\u5173\u8054\u5b57\u6bb5");
            }
            NodeGOT node = super.doAccpDragNew("FormItem", this.getFormItemType(tableField.attributeValue("type")));
            this.dragCtrl.doAccpDragNewAfter(tableField, node);
            return node;
        }
        if (src.getName().equals("FormDataSourceAggregationItem")) {
            String type = src.attributeValue("type");
            Element field = GOTHelp.getPPAttElement(src, "Name", type);
            String refentityid = field.attributeValue("refentityid");
            String refinnerid = field.attributeValue("refinnerid");
            if (StringUtils.isBlank((String)refentityid) || StringUtils.isBlank((String)refinnerid)) {
                throw new RuntimeException("\u8bf7\u5148\u6307\u5b9aFormDataSourceAggregationItem\u7684\u5173\u8054\u5b57\u6bb5");
            }
            Element formDataSource = null;
            if ("Field".equals(type)) {
                formDataSource = src.getParent().getParent();
            } else if ("UnionField".equals(type)) {
                Element unionSource = GOTHelp.getPPAttElement(src, "Name", "UnionSource");
                String innerid = unionSource.attributeValue("innerid");
                List formDataSources = src.getParent().getParent().getParent().selectNodes(String.format("./FormDataSource[@id = '%s']", innerid));
                if (!formDataSources.isEmpty()) {
                    formDataSource = (Element)formDataSources.get(0);
                }
            }
            if (formDataSource == null) {
                throw new RuntimeException("\u672a\u627e\u5230\u8be5FormDataSourceAggregationItem\u7684\u5173\u8054\u5b57\u6bb5");
            }
            Element tableField = (Element)formDataSource.selectSingleNode(String.format("./FormDataSourceFields/FormDataSourceField/Properties/Property[@refentityid = '%s' and @refinnerid ='%s']/Name[text()='Field']/../../..", refentityid, refinnerid));
            if (tableField == null) {
                throw new RuntimeException("\u672a\u627e\u5230\u8be5FormDataSourceAggregationItem\u7684\u5173\u8054\u5b57\u6bb5");
            }
            NodeGOT node = super.doAccpDragNew("FormItem", this.getFormItemType(tableField.attributeValue("type")));
            this.dragCtrl.doAccpDragNewAfter(tableField, node);
            Element dataMethodPro = GOTHelp.getPPAttElement(node.xml, "Name", "DataMethod");
            dataMethodPro.element("Value").setText("Aggregation");
            Element aggregationFieldPro = GOTHelp.getPPAttElement(node.xml, "Name", "AggregationField");
            aggregationFieldPro.element("Value").setText(src.attributeValue("name"));
            aggregationFieldPro.addAttribute("innerid", src.attributeValue("id"));
            Element extendPros = GOTHelp.getPPAttElement(node.xml, "Name", "Extends");
            Attribute refentityidAttr = extendPros.attribute("refentityid");
            if (refentityid != null) {
                extendPros.remove(refentityidAttr);
            }
            Attribute refinneridAttr = extendPros.attribute("refinnerid");
            if (refinnerid != null) {
                extendPros.remove(refinneridAttr);
            }
            extendPros.element("Value").setText("");
            return node;
        }
        if (src.getName().equals("FormDataSourceFieldGroup")) {
            NodeGOT node = super.doAccpDragNew("FormItem", "FieldGroup");
            this.dragCtrl.doAccpDragNewAfterForFormDataSourceFieldGroup(src, node);
            return node;
        }
        if (src.getName().equals("MenuItem")) {
            NodeGOT node = super.doAccpDragNew("FormItem", "MenuItemButton");
            this.dragCtrl.doAccpDragNewAfter(src, node);
            return node;
        }
        return null;
    }

    private String getFormItemType(String origType) {
        if (origType.equals("Component")) {
            return "FieldGroup";
        }
        return String.valueOf(origType) + "Editor";
    }

    private void setNotNullAndVisible(Element xml) {
        List<Element> pro = GOTHelp.getDDDAttElementList(xml, "Name", "NotNull");
        if (pro.size() == 1) {
            pro.get(0).element("Value").setText("false");
        }
        if ((pro = GOTHelp.getDDDAttElementList(xml, "Name", "Visible")).size() == 1) {
            pro.get(0).element("Value").setText("true");
        }
    }

    private Boolean isNotAllowDragOut(Element fieldGroup) {
        List<Element> fieldGroupPro = GOTHelp.getPPAttElementList(fieldGroup, "Name", "FieldGroup");
        List<Element> componentPro = GOTHelp.getPPAttElementList(fieldGroup, "Name", "Component");
        List<Element> dataSourcePro = GOTHelp.getPPAttElementList(fieldGroup, "Name", "DataSource");
        String dataSourceValue = dataSourcePro.get(0).elementText("Value");
        String componentValue = componentPro.get(0).elementText("Value");
        String fieldGroupValue = fieldGroupPro.get(0).elementText("Value");
        if (!dataSourceValue.equals("") && !componentValue.equals("") || !dataSourceValue.equals("") && !fieldGroupValue.equals("")) {
            return true;
        }
        return false;
    }

    @Override
    public String moveType(Element srcItem, MouseEvent event) {
        if (srcItem.getName().equals("FormItem")) {
            Element parent = srcItem.getParent();
            if (parent != null && "FieldGroup".equals(parent.attributeValue("type")) && this.isNotAllowDragOut(parent).booleanValue()) {
                return "false";
            }
            return "append";
        }
        return "false";
    }

    @Override
    public String getAccpDragNewInsertBase() {
        return "self";
    }

    @Override
    public Boolean isSibling(Element srcItem) {
        if (srcItem.getName().equals("FormItem")) {
            return true;
        }
        return false;
    }

    @Override
    public String validateAccpDragMove(Element srcItem, MouseEvent event) {
        Element parent = srcItem.getParent();
        if (this.isNotAllowDragOut(parent).booleanValue()) {
            return "do not place here";
        }
        return "down";
    }

    private void setAllowEditDefault(NodeGOT node) {
        List<Element> allowEditPro;
        if (node == null) {
            node = this;
        }
        if ((allowEditPro = GOTHelp.getPPAttElementList(node.xml, "Name", "AllowEdit")).size() != 1) {
            throw new Error("FormItem\u4e0a\u6ca1\u6709\u627e\u5230\u6b63\u786e\u6570\u91cf\u7684AllowEdit\u5c5e\u6027");
        }
        allowEditPro.get(0).element("Value").setText(node.resolverNode.getPropertyValue("AllowEdit", "Default"));
    }
}

