/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.ui.event;

import com.ximpleware.NavException;
import gongqi.designer.core.LayerLevelManager;
import gongqi.designer.got.vtd.EntityNode;
import gongqi.designer.got.vtd.GOTNode;
import gongqi.designer.services.GOTService;
import gongqi.designer.services.LayerService;
import gongqi.designer.utils.GOTHelper;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.core.got.GOTNodesConst;
import gongqi.gdt.designer.core.got.node.Branch;
import gongqi.gdt.designer.core.got.node.Entity;
import gongqi.gdt.designer.core.got.node.Inner;
import gongqi.gdt.designer.core.got.node.NodeFactory;
import gongqi.gdt.designer.core.got.node.NodeGOT;
import gongqi.gdt.designer.core.got.validate.DoMerge;
import gongqi.gdt.designer.core.resolvergot.ResolverNode;
import gongqi.gdt.designer.core.resolvergot.ResolverNodeFactory;
import gongqi.gdt.designer.core.toolsgot.GOTXMLHelper;
import gongqi.gdt.designer.core.toolsgot.Macros;
import gongqi.gdt.designer.handler.JDTHandler;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.tool.ProgressBarRefNodeUtil;
import info.gongqi.got.tool.ProgressBarUtil;
import info.gongqi.got.tool.PromoteSyncDialog;
import info.gongqi.got.tool.TreeOperationInfo;
import info.gongqi.got.ui.ConfigComposite;
import info.gongqi.got.ui.LoadXML;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.ui.TreeUi;
import info.gongqi.got.ui.TreeUiBean;
import info.gongqi.got.util.GOTMessageDialog;
import info.gongqi.got.util.TreeUIUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public class MouseRightMenuEvent
extends SelectionAdapter {
    public Element menuItem;
    public Element currentTreeNode;
    public GOTNode currentTreeGOTNode;
    private TreeItem treeitem;
    public static Map<String, List<String>> deletedNodesCache = new HashMap<String, List<String>>();
    public boolean _isDeletingNode = false;
    private ProgressBarUtil barUtil;
    private Element SyncResultXMl = null;
    private String syncResultString = "";
    private ProgressBarRefNodeUtil barRefNodeUtil;

    public MouseRightMenuEvent(Element element, TreeItem treeitem) {
        this.menuItem = element;
        this.treeitem = treeitem;
        this.currentTreeNode = GotXmlDto.getInstance().getCurrentElement(treeitem);
        this.currentTreeGOTNode = TreeUIUtil.getCurrentElement2(treeitem);
        FormDataSyn.current = treeitem;
    }

    public TreeItem getTreeitem() {
        return this.treeitem;
    }

    public void setTreeitem(TreeItem treeitem) {
        this.treeitem = treeitem;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        super.widgetDefaultSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        try {
            String function;
            this.currentTreeNode = GotXmlDto.getInstance().getCurrentElement(this.treeitem);
            ConfigComposite.configComposite.set_text_op_info("");
            switch (function = this.menuItem.attributeValue("func")) {
                case "new": {
                    this.AddHandle();
                    TreeOperationInfo.addInfo(String.valueOf(this.menuItem.attributeValue("label")) + ":" + this.treeitem.getText() + "\u5b50\u8282\u70b9");
                    break;
                }
                case "save": {
                    this.saveHandle(false);
                    break;
                }
                case "delete": {
                    this.deleteNodeCMI(false);
                    break;
                }
                case "restore": {
                    this.restoreNode();
                    break;
                }
                case "sync": {
                    this.syncNodes();
                    break;
                }
                case "copy": {
                    this.duplicateNode();
                    break;
                }
                case "showXML": {
                    this.showXML();
                    break;
                }
                case "quote": {
                    this.enterNodeRef();
                    break;
                }
                case "method": {
                    this.methodSet();
                    break;
                }
                case "newWindow": {
                    this.openNewFrom(e.stateMask == 262144);
                    break;
                }
                case "syncFDSF": {
                    this.syncFDSF();
                    break;
                }
                case "resetRelationName": {
                    this.resetRelationName();
                    break;
                }
                case "checkFormDataSourceFieldRate": {
                    this.checkFormDataSourceFieldRate();
                    break;
                }
                case "AdjustCreatedLayer": {
                    this.adjustCreatedLayer();
                    break;
                }
                case "syncDataTableStructure": {
                    this.syncDataTableStructure();
                    break;
                }
                case "lock": {
                    this.lock();
                    break;
                }
                case "unlock": {
                    this.unlock();
                    break;
                }
                case "tovisible": {
                    this.tovisible();
                    break;
                }
                case "tounvisible": {
                    this.tounvisible();
                    break;
                }
                case "promoteSync": {
                    this.promoteSync();
                    break;
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"UI\u54cd\u5e94\u9519\u8bef", (Throwable)ex);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(ex);
                }
            });
        }
        ConfigComposite.configComposite.setUnsavedText();
    }

    private void promoteSync() {
        GOTNode entity = TreeUIUtil.getCurrentElement2(this.treeitem);
        if (entity == null) {
            return;
        }
        PromoteSyncDialog dialog = new PromoteSyncDialog(entity.getEntity());
        dialog.open();
    }

    private void tovisible() {
        try {
            GOTNode current = TreeUIUtil.getCurrentElement2(this.treeitem);
            if (current == null || !current.isEntityNode()) {
                GOTMessageDialog.alert(String.format("\u5f53\u524d\u9009\u4e2d\u8282\u70b9\u3010%s\u3011\u65e0\u6cd5\u6807\u8bb0\u4e3a\u53ef\u89c1", this.treeitem.getText()));
                return;
            }
            String currentLayer = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer();
            if (!currentLayer.equals(current.getCreatedLayer())) {
                GOTMessageDialog.alert(String.format("\u975e\u5f53\u524d\u5c42\u521b\u5efa\u8282\u70b9,\u65e0\u6cd5\u6807\u8bb0\u4e3a\u53ef\u89c1", this.treeitem.getText()));
                return;
            }
            Element entity = current.getEntity().toElement();
            Attribute attribute = entity.attribute("visible");
            if (attribute != null) {
                entity.remove(attribute);
            }
            GotXmlDto.getInstance().updateEntityElement(entity);
            FormDataSyn.restore(this.treeitem, null);
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)e);
        }
    }

    private void tounvisible() {
        try {
            GOTNode current = TreeUIUtil.getCurrentElement2(this.treeitem);
            if (current == null || !current.isEntityNode()) {
                GOTMessageDialog.alert(String.format("\u5f53\u524d\u9009\u4e2d\u8282\u70b9\u3010%s\u3011\u65e0\u6cd5\u6807\u8bb0\u4e3a\u4e0d\u53ef\u89c1", this.treeitem.getText()));
                return;
            }
            String currentLayer = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer();
            if (!currentLayer.equals(current.getCreatedLayer())) {
                GOTMessageDialog.alert(String.format("\u975e\u5f53\u524d\u5c42\u521b\u5efa\u8282\u70b9,\u65e0\u6cd5\u6807\u8bb0\u4e3a\u4e0d\u53ef\u89c1", this.treeitem.getText()));
                return;
            }
            Element entity = current.getEntity().toElement();
            entity.addAttribute("visible", "false");
            GotXmlDto.getInstance().updateEntityElement(entity);
            FormDataSyn.restore(this.treeitem, null);
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)e);
        }
    }

    private void unlock() {
        try {
            GOTNode current = TreeUIUtil.getCurrentElement2(this.treeitem);
            if (current == null || !current.isEntityNode()) {
                GOTMessageDialog.alert(String.format("\u5f53\u524d\u9009\u4e2d\u8282\u70b9\u3010%s\u3011\u65e0\u6cd5\u8fdb\u884c\u89e3\u9664\u9501\u5b9a\u64cd\u4f5c", this.treeitem.getText()));
                return;
            }
            String currentLayer = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer();
            if (!currentLayer.equals(current.getCreatedLayer())) {
                GOTMessageDialog.alert(String.format("\u975e\u5f53\u524d\u5c42\u521b\u5efa\u8282\u70b9,\u65e0\u6cd5\u8fdb\u884c\u89e3\u9664\u9501\u5b9a\u64cd\u4f5c", this.treeitem.getText()));
                return;
            }
            Element entity = current.getEntity().toElement();
            Attribute attribute = entity.attribute("locked");
            if (attribute != null) {
                entity.remove(attribute);
            }
            GotXmlDto.getInstance().updateEntityElement(entity);
            FormDataSyn.restore(this.treeitem, null);
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)e);
        }
    }

    private void lock() {
        try {
            GOTNode current = TreeUIUtil.getCurrentElement2(this.treeitem);
            if (current == null || !current.isEntityNode()) {
                GOTMessageDialog.alert(String.format("\u5f53\u524d\u9009\u4e2d\u8282\u70b9\u3010%s\u3011\u65e0\u6cd5\u8fdb\u884c\u9501\u5b9a\u64cd\u4f5c", this.treeitem.getText()));
                return;
            }
            String currentLayer = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer();
            if (!currentLayer.equals(current.getCreatedLayer())) {
                GOTMessageDialog.alert("\u975e\u5f53\u524d\u5c42\u521b\u5efa\u8282\u70b9,\u65e0\u6cd5\u8fdb\u884c\u9501\u5b9a\u64cd\u4f5c");
                return;
            }
            Element entity = current.getEntity().toElement();
            entity.addAttribute("locked", "true");
            GotXmlDto.getInstance().updateEntityElement(entity);
            FormDataSyn.restore(this.treeitem, null);
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)e);
        }
    }

    private void adjustCreatedLayer() {
        final Shell shell = new Shell(Display.getCurrent(), 65568);
        shell.setText("\u8c03\u6574\u521b\u5efa\u5c42");
        shell.setSize(200, 190);
        Monitor monitor = shell.getMonitor();
        Rectangle bounds = monitor.getBounds();
        Rectangle rect = shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        shell.setLocation(x, y);
        shell.setLayout((Layout)new FormLayout());
        Label label_LayerName = new Label((Composite)shell, 131072);
        label_LayerName.setText("  \u5c42\u540d\u79f0");
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment(0, 10);
        label_LayerName.setLayoutData((Object)formData);
        final Combo combo_LayerName = new Combo((Composite)shell, 8);
        formData = new FormData();
        formData.left = new FormAttachment((Control)label_LayerName, 5, 131072);
        formData.top = new FormAttachment((Control)label_LayerName, 0, 128);
        formData.right = new FormAttachment(100, -5);
        combo_LayerName.setLayoutData((Object)formData);
        Label label_SolutionName = new Label((Composite)shell, 131072);
        label_SolutionName.setText("\u5e94\u7528\u540d\u79f0");
        formData = new FormData();
        formData.left = new FormAttachment((Control)label_LayerName, 0, 16384);
        formData.top = new FormAttachment((Control)label_LayerName, 20, 1024);
        formData.right = new FormAttachment((Control)label_LayerName, 0, 131072);
        label_SolutionName.setLayoutData((Object)formData);
        final Combo combo_SolutionName = new Combo((Composite)shell, 8);
        formData = new FormData();
        formData.left = new FormAttachment((Control)label_SolutionName, 5, 131072);
        formData.top = new FormAttachment((Control)label_SolutionName, 0, 128);
        formData.right = new FormAttachment((Control)combo_LayerName, 0, 131072);
        combo_SolutionName.setLayoutData((Object)formData);
        combo_SolutionName.setEnabled(false);
        Label label_SolutionPluginName = new Label((Composite)shell, 131072);
        label_SolutionPluginName.setText("\u63d2\u4ef6\u540d\u79f0");
        formData = new FormData();
        formData.left = new FormAttachment((Control)label_SolutionName, 0, 16384);
        formData.top = new FormAttachment((Control)label_SolutionName, 20, 1024);
        formData.right = new FormAttachment((Control)label_SolutionName, 0, 131072);
        label_SolutionPluginName.setLayoutData((Object)formData);
        final Combo combo_solutionPluginName = new Combo((Composite)shell, 8);
        formData = new FormData();
        formData.left = new FormAttachment((Control)label_SolutionPluginName, 5, 131072);
        formData.top = new FormAttachment((Control)label_SolutionPluginName, 0, 128);
        formData.right = new FormAttachment((Control)combo_SolutionName, 0, 131072);
        combo_solutionPluginName.setLayoutData((Object)formData);
        combo_solutionPluginName.setEnabled(false);
        final Button button_confirm = new Button((Composite)shell, 0);
        button_confirm.setText("\u786e\u5b9a");
        formData = new FormData();
        formData.width = 60;
        formData.left = new FormAttachment(20);
        formData.bottom = new FormAttachment(100, -10);
        button_confirm.setLayoutData((Object)formData);
        Button button_cancel = new Button((Composite)shell, 0);
        button_cancel.setText("\u53d6\u6d88");
        formData = new FormData();
        formData.width = 60;
        formData.left = new FormAttachment(60);
        formData.bottom = new FormAttachment((Control)button_confirm, 0, 1024);
        button_cancel.setLayoutData((Object)formData);
        combo_LayerName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String layerName = combo_LayerName.getText();
                if ("app".equals(layerName)) {
                    combo_SolutionName.setEnabled(true);
                    List canEditSolutionList = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCanEditSolutionList();
                    String createdLayer = MouseRightMenuEvent.this.currentTreeNode.attributeValue("createdLayer");
                    if ("app".equals(createdLayer)) {
                        String entityId = MouseRightMenuEvent.this.currentTreeNode.attributeValue("id");
                        String solutionName = entityId.substring(0, entityId.lastIndexOf("."));
                        canEditSolutionList.remove(solutionName);
                    }
                    combo_SolutionName.setItems(canEditSolutionList.toArray(new String[canEditSolutionList.size()]));
                    combo_solutionPluginName.setEnabled(false);
                    combo_solutionPluginName.setText("");
                    button_confirm.setEnabled(false);
                } else if ("plg".equals(layerName)) {
                    combo_SolutionName.setEnabled(true);
                    List canEditSolutionList = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCanEditSolutionList();
                    combo_SolutionName.setItems(canEditSolutionList.toArray(new String[canEditSolutionList.size()]));
                    combo_solutionPluginName.setEnabled(false);
                    combo_solutionPluginName.setText("");
                    button_confirm.setEnabled(false);
                } else if ("ext".equals(layerName)) {
                    combo_SolutionName.setEnabled(true);
                    List canEditSolutionExtensionList = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCanEditExtensionList();
                    combo_SolutionName.setItems(canEditSolutionExtensionList.toArray(new String[canEditSolutionExtensionList.size()]));
                    combo_solutionPluginName.setEnabled(false);
                    combo_solutionPluginName.setText("");
                    button_confirm.setEnabled(false);
                } else {
                    combo_SolutionName.setEnabled(false);
                    combo_SolutionName.setText("");
                    combo_solutionPluginName.setEnabled(false);
                    combo_solutionPluginName.setText("");
                    button_confirm.setEnabled(true);
                }
            }
        });
        combo_SolutionName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String layerName = combo_LayerName.getText();
                if ("plg".equals(layerName)) {
                    combo_solutionPluginName.setEnabled(true);
                    String solutionName = combo_SolutionName.getText();
                    List canEditSolutionPluginList = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCanEditSolutionPluginList(solutionName);
                    String createdLayer = MouseRightMenuEvent.this.currentTreeNode.attributeValue("createdLayer");
                    if ("plg".equals(createdLayer)) {
                        String entityId = MouseRightMenuEvent.this.currentTreeNode.attributeValue("id");
                        String solutionPluginName = entityId.substring(0, entityId.lastIndexOf("."));
                        canEditSolutionPluginList.remove(solutionPluginName);
                    }
                    combo_solutionPluginName.setItems(canEditSolutionPluginList.toArray(new String[canEditSolutionPluginList.size()]));
                    button_confirm.setEnabled(false);
                } else {
                    button_confirm.setEnabled(true);
                }
            }
        });
        combo_solutionPluginName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                button_confirm.setEnabled(true);
            }
        });
        button_cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                shell.close();
            }
        });
        button_confirm.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String layerName = combo_LayerName.getText();
                String solutionName = combo_SolutionName.getText();
                String solutionPluginName = combo_solutionPluginName.getText();
                String entityId = MouseRightMenuEvent.this.currentTreeNode.attributeValue("id");
                try {
                    ((GOTService)ObjectContainer.getInstance(GOTService.class)).adjustCreatedLayer(entityId, layerName, solutionName, solutionPluginName);
                    MessageDialog.openInformation((Shell)shell, (String)"\u63d0\u793a", (String)"\u8c03\u6574\u521b\u5efa\u5c42\u5b8c\u6210\uff0c\u8bf7\u91cd\u65b0\u52a0\u8f7dGOT");
                    shell.close();
                }
                catch (Exception ex) {
                    Logger.getLogger(MouseRightMenuEvent.class).error((Object)"\u8c03\u6574\u521b\u5efa\u5c42\u9519\u8bef", (Throwable)ex);
                    MessageDialog.openWarning((Shell)shell, (String)"\u63d0\u793a", (String)("\u8c03\u6574\u521b\u5efa\u5c42\u9519\u8bef\uff1a" + ex.getMessage()));
                }
            }
        });
        List canEditorLayers = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCanEditLayerList();
        String modifiedLayer = this.currentTreeNode.attributeValue("modifiedLayer");
        if (!(modifiedLayer == null || "app".equals(modifiedLayer) || "plg".equals(modifiedLayer) || "ext".equals(modifiedLayer))) {
            canEditorLayers.remove(modifiedLayer);
        }
        if (!canEditorLayers.isEmpty()) {
            combo_LayerName.setItems(canEditorLayers.toArray(new String[canEditorLayers.size()]));
        }
        shell.open();
    }

    public void AddHandle() {
        String type = this.menuItem.attribute("nodeType") == null ? null : this.menuItem.attributeValue("nodeType");
        Element elementDate = this.currentTreeNode;
        NodeGOT nodeGOT = NodeFactory.getNode(elementDate);
        List rNodeList = new ArrayList();
        if (!nodeGOT.allowNew().booleanValue()) {
            return;
        }
        rNodeList = nodeGOT.resolverNode.getNode().elements("node");
        if (rNodeList.isEmpty()) {
            GOTMessageDialog.alert("\u65e0\u8be5\u64cd\u4f5c");
        }
        if (rNodeList.size() == 1) {
            String _name = ((Element)rNodeList.get(0)).attributeValue("name");
            String _type = ((Element)rNodeList.get(0)).element("Info").elementText("Type");
            ResolverNode rnodeGOT = ResolverNodeFactory.getResolverNode(_name, _type);
            this.newNode(rnodeGOT, true);
        } else if (type == null) {
            ArrayList<String> array = new ArrayList<String>();
            for (Element child : rNodeList) {
                array.add(String.valueOf(child.attributeValue("name")) + "." + child.element("Info").elementText("Type"));
            }
            String returnstr = GOTMessageDialog.typeSelector(array);
            if (returnstr == null || "".equals(returnstr)) {
                return;
            }
            this.nodeTypeSelected(returnstr);
        } else {
            this.nodeTypeSelected(type);
        }
    }

    private void newNode(ResolverNode rNode, boolean checkType) {
        if (rNode == null) {
            GOTMessageDialog.alert("\u65b0\u589e\u65f6\u672a\u627e\u5230rNode");
            return;
        }
        if (!this.validateNodeNum(this.currentTreeNode, rNode, checkType).booleanValue()) {
            TreeOperationInfo.addErrorInfo("\u8d85\u8fc7\u6700\u5927\u6570\u91cf");
            return;
        }
        String name = rNode.getNode().attributeValue("name");
        String type = rNode.getInfoValue("Type");
        String idType = rNode.getAttributeValue("id", "Default");
        if ("##getEntityId".equals(idType)) {
            String id = "";
            try {
                id = LoadXmlCore.gotServices.getEntityId(EntityType.valueOf((String)name));
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"", (Throwable)e);
                GOTMessageDialog.alert(e);
                return;
            }
            if (id.equals("-1")) {
                GOTMessageDialog.alert("\u83b7\u53d6id\u5931\u8d25");
                return;
            }
            this.resultNew(name, type, id, false);
        } else if ("##getInnerId".equals(idType)) {
            this.resultNew(name, type, "", true);
        } else if ("".equals(idType)) {
            this.resultNew(name, type, null, false);
        } else if (idType == null) {
            this.resultNew(name, type, null, false);
        } else {
            GOTMessageDialog.alert("\u672a\u77e5Id:" + idType);
        }
    }

    private Boolean validateNodeNum(Element parent, ResolverNode rNode, Boolean checkType) {
        if (rNode.getInfoValue("MaxOccurs").equals("unbounded")) {
            return true;
        }
        int maxNum = Integer.parseInt(rNode.getInfoValue("MaxOccurs"));
        int num = 0;
        List list = parent.elements(rNode.getNode().attributeValue("name"));
        String type = rNode.getInfoValue("Type");
        if (checkType.booleanValue()) {
            for (Element child : list) {
                if (!type.equals(child.attributeValue("type"))) continue;
                ++num;
            }
        } else {
            num = list.size();
        }
        if (num >= maxNum) {
            return false;
        }
        return true;
    }

    private void resultNew(String name, String type, String id, Boolean isGetInnerId) {
        NodeGOT node = NodeFactory.createNode(name, type, id);
        if (node.editOnCreate().booleanValue()) {
            node.xml.addAttribute("editOnCreate", "true");
        }
        Element childBefore = node.getInsertChildBefore(this.currentTreeNode);
        this.insertNode(node, null, childBefore, true);
        String nodeName = node.xml.getName();
        if (nodeName.equals("Form")) {
            ++ConfigComposite.fromNum;
            ConfigComposite.text_static_info();
        } else if (nodeName.equals("Table")) {
            ++ConfigComposite.tableNum;
            ConfigComposite.text_static_info();
        }
    }

    public void insertNode(NodeGOT node, Element parent, Element childBefore, Boolean autoEnterEdit) {
        node.doBeforeInsert();
        Integer index = null;
        Element xml = node.xml;
        if (parent == null) {
            parent = this.currentTreeNode;
        }
        if (childBefore == null) {
            String insertAt = node.getInsertAt();
            if (insertAt.equals("append")) {
                parent.add(xml.detach());
            } else {
                parent.elements().add(0, xml);
                index = 0;
            }
        } else {
            int beforeIndex = parent.elements().indexOf(childBefore);
            parent.elements().add(beforeIndex, xml);
        }
        node.doAfterInsert();
        if (!this.getTreeitem().getExpanded()) {
            this.getTreeitem().setExpanded(true);
        }
        if (NodeGOT.getEntity(parent) == null) {
            GotXmlDto.getInstance().addEntityElement(xml);
        } else {
            GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(parent));
        }
        FormDataSyn.actionSyn(this.getTreeitem(), xml, index, true);
    }

    private void nodeTypeSelected(String type) {
        if (type.equals("##close")) {
            TreeOperationInfo.addInfo(String.valueOf(this.getTreeitem().getText()) + "\u65b0\u589e\u64cd\u4f5c\u53d6\u6d88");
            ConfigComposite.configComposite.set_text_op_info("\u64cd\u4f5c\u53d6\u6d88");
            return;
        }
        String _name = "";
        String _type = "";
        String[] str = type.split("\\.");
        if (str.length == 2) {
            _name = str[0];
            _type = str[1];
        } else if (str.length == 1) {
            _name = str[0];
        }
        ResolverNode rNode = ResolverNodeFactory.getResolverNode(_name, _type);
        this.newNode(rNode, true);
    }

    public void saveHandle(boolean fromShortCut) {
        Element elementDate = GotXmlDto.getInstance().getCurrentElement(this.treeitem);
        NodeGOT node = NodeFactory.getNode(elementDate);
        if (!fromShortCut && NodeGOT.canPromote(node.xml).booleanValue()) {
            List dslist;
            String entityId;
            String newName;
            String sameEntityId;
            String entityLayer;
            Entity entity = (Entity)node;
            String info = entity.validateBeforePromote();
            if (!info.equals(Macros.INFO_TRUE)) {
                TreeOperationInfo.addInfo(String.valueOf(this.getTreeitem().getText()) + "\u4fdd\u5b58:" + Macros.INFO_OPR_FAIL);
                ConfigComposite.configComposite.set_text_op_info(Macros.INFO_OPR_FAIL);
                if (info.substring(0, 4) == "tree") {
                    TreeOperationInfo.addInfo(String.valueOf(this.getTreeitem().getText()) + "\u4fdd\u5b58:" + info.substring(5));
                    ConfigComposite.configComposite.set_text_op_info(info.substring(5));
                    GOTMessageDialog.alert(String.valueOf(this.getTreeitem().getText()) + "\u4fdd\u5b58:" + info.substring(5));
                } else {
                    TreeOperationInfo.addInfo(String.valueOf(this.getTreeitem().getText()) + "\u4fdd\u5b58:" + info.substring(4));
                    ConfigComposite.configComposite.set_text_op_info(info.substring(4));
                    GOTMessageDialog.alert(info.substring(4));
                }
                return;
            }
            String entityName = entity.xml.getName();
            String currentLayer = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer();
            if ("ext".equals(currentLayer) && ("app".equals(entityLayer = entity.xml.attributeValue("createdLayer")) || "plg".equals(entityLayer)) && (sameEntityId = this.checkNamePromote(entityName, newName = entity.xml.attributeValue("name"), entityId = entity.xml.attributeValue("id"))) != null) {
                GOTMessageDialog.alert(String.format("\u63d0\u5347\u8282\u70b9\u5931\u8d25\uff0c\u7b80\u5355\u540d\u79f0\u4e0e %s\u8282\u70b9\u91cd\u590d", sameEntityId));
                return;
            }
            entity.setSelfUnsaved();
            if (entityName.equals("Form") && (dslist = entity.xml.element("FormDataSources").elements("ForDataSource")).size() > 0) {
                for (Element item : dslist) {
                    item.addAttribute("modifiedLayer", ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer());
                }
            }
            String result = "";
            try {
                result = LoadXmlCore.gotServices.promoteEntity(entity.xml.asXML());
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"", (Throwable)e);
                GOTMessageDialog.alert(e);
                return;
            }
            this.rpc_result_Save(result, info, entity, "promote");
        } else {
            Element entityXML;
            Entity entity = null;
            if (node instanceof Entity) {
                entity = (Entity)node;
            } else if ((node instanceof Inner || node instanceof Branch) && (entityXML = NodeGOT.getEntity(node.xml)) != null) {
                entity = (Entity)NodeFactory.getNode(entityXML);
            }
            if (entity == null) {
                return;
            }
            String info = entity.validateBeforeSave();
            if (!info.equals("true")) {
                TreeOperationInfo.addInfo(String.valueOf(this.getTreeitem().getText()) + "\u4fdd\u5b58:" + Macros.INFO_OPR_FAIL);
                ConfigComposite.configComposite.set_text_op_info(Macros.INFO_OPR_FAIL);
                if (info.substring(0, 4) == "tree") {
                    TreeOperationInfo.addInfo(String.valueOf(this.getTreeitem().getText()) + "\u4fdd\u5b58:" + info.substring(5));
                    ConfigComposite.configComposite.set_text_op_info(info.substring(5));
                } else {
                    TreeOperationInfo.addInfo(String.valueOf(this.getTreeitem().getText()) + "\u4fdd\u5b58:" + info.substring(4));
                    ConfigComposite.configComposite.set_text_op_info(info.substring(4));
                }
                return;
            }
            String result = "";
            try {
                result = LoadXmlCore.gotServices.saveEntity(entity.xml.asXML());
            }
            catch (Throwable e) {
                Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"", e);
                GOTMessageDialog.alert(e);
                return;
            }
            if (!"".equals(result)) {
                this.rpc_result_Save(result, "", entity, "save");
            }
        }
    }

    private String checkNamePromote(String type, String newName, String entityId) {
        Map<String, String> names = GotXmlDto.getInstance().typesNameIdList(entityId);
        if (newName.contains(".")) {
            newName = newName.substring(newName.lastIndexOf(".") + 1);
        }
        for (String key : names.keySet()) {
            String name = names.get(key);
            if (!name.contains(".") || !(name = name.substring(name.lastIndexOf(".") + 1)).equals(newName)) continue;
            return key;
        }
        return null;
    }

    private EntityNode getGOTNodeByQname(String qname, String nodeId) {
        if (qname.equals("Form")) {
            return GotXmlDto.getInstance().getEntityByIdAndType(EntityType.Form, nodeId);
        }
        if (qname.equals("Table")) {
            return GotXmlDto.getInstance().getEntityByIdAndType(EntityType.Table, nodeId);
        }
        if (qname.equals("DataType")) {
            return GotXmlDto.getInstance().getEntityByIdAndType(EntityType.DataType, nodeId);
        }
        if (qname.equals("MenuItem")) {
            return GotXmlDto.getInstance().getEntityByIdAndType(EntityType.MenuItem, nodeId);
        }
        if (qname.equals("Menu")) {
            return GotXmlDto.getInstance().getEntityByIdAndType(EntityType.Menu, nodeId);
        }
        if (qname.equals("Enum")) {
            return GotXmlDto.getInstance().getEntityByIdAndType(EntityType.Enum, nodeId);
        }
        if (qname.equals("Report")) {
            return GotXmlDto.getInstance().getEntityByIdAndType(EntityType.Report, nodeId);
        }
        if (!qname.equals("Map") && qname.equals("Class")) {
            return GotXmlDto.getInstance().getEntityByIdAndType(EntityType.Class, nodeId);
        }
        return null;
    }

    private void rpc_result_Save(String result, String info, Entity entity, String type) {
        MouseRightMenuEvent.clearDeletedNodesCache(entity.xml.attributeValue("id"));
        result = "<rootTemp>" + result + "</rootTemp>";
        Element xmlParent = GOTXMLHelper.createElementByXMLString(result);
        List list = xmlParent.elements();
        JDTHandler.getServer().saveEntity();
        for (Element r : list) {
            if (r.getName().equals("Error")) {
                info = String.valueOf(info) + r.getText() + "\n\u4fdd\u5b58\u5931\u8d25\uff0c\u5e94\u6267\u884c\u53f3\u952e\u6062\u590d\uff0c\u4ee5\u9632\u6570\u636e\u4e22\u5931\n";
                continue;
            }
            String nodeId = r.attributeValue("id");
            String qname = r.getName();
            GotXmlDto.getInstance().saveEntity(nodeId);
            EntityNode node = this.getGOTNodeByQname(qname, nodeId);
            if (node == null) continue;
            if (entity.xml.attributeValue("id").equals(r.attributeValue("id"))) {
                info = String.valueOf(info) + r.attributeValue("name") + ":" + r.getName() + "  \u5df2\u4fee\u6539 OK\n";
                FormDataSyn.setSaved(this.treeitem);
                if (!type.equals("promote")) continue;
                JDTHandler.asyncTask(() -> JDTHandler.getServer().promoteEntity(r.asXML(), entity.xml.attributeValue("modifiedLayer")));
                continue;
            }
            TreeItem item = FormDataSyn.getTreeItrmByNode((GOTNode)node, null);
            if (item != null) {
                FormDataSyn.restore(item, null);
            }
            info = String.valueOf(info) + r.attributeValue("name") + ":" + r.getName() + "  \u5df2\u4fee\u6539 OK\n";
        }
        if (list.size() > 1) {
            GOTMessageDialog.info(info);
            TreeOperationInfo.addErrorInfo(String.valueOf(this.getTreeitem().getText()) + "\u4fdd\u5b58:" + info);
        } else if (list.size() == 1) {
            String _entityId;
            Element error = (Element)list.get(0);
            if (error.getName().equals("Error")) {
                TreeOperationInfo.addInfo(String.valueOf(this.getTreeitem().getText()) + "\u4fdd\u5b58:" + Macros.INFO_OPR_FAIL);
                ConfigComposite.configComposite.set_text_op_info(Macros.INFO_OPR_FAIL);
                GOTMessageDialog.alert(info);
                return;
            }
            TreeOperationInfo.addInfo(String.valueOf(this.getTreeitem().getText()) + "\u4fdd\u5b58:" + Macros.INFO_OPR_SUCCESS);
            ConfigComposite.configComposite.set_text_op_info(Macros.INFO_OPR_SUCCESS);
            FormDataSyn.setSaved(this.treeitem);
            GOTNode el = TreeUIUtil.getCurrentElement2(this.treeitem);
            FormDataSyn.currentTreeUi.loadTableValue(FormDataSyn.currentTreeUi.getTable(), el, this.treeitem);
            EntityNode _entity = el.getEntity();
            if (_entity == null) {
                return;
            }
            TreeItem entityTreeItem = FormDataSyn.getEntityTreeItem(this.treeitem);
            if (entityTreeItem != null) {
                FormDataSyn.refreshTreeItemLabel(entityTreeItem, (GOTNode)_entity);
            }
            if (entityTreeItem != null && _entity.getNodeType().equals("Table")) {
                entityTreeItem.setText(LoadXML.nodeText((GOTNode)_entity));
            }
            String _innerId = (_entityId = _entity.getId()).equals(el.getId()) ? null : el.getId();
            String result_ = "";
            try {
                result_ = LoadXmlCore.gotServices.getNodeRef(_entity.getNodeType(), _entityId, _innerId);
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"", (Throwable)e);
                GOTMessageDialog.alert(e);
                return;
            }
            if (StringUtils.isNotBlank((String)result_)) {
                Element flash_xml = GOTXMLHelper.createElementByXMLString(result_);
                List elements = flash_xml.elements();
                for (Element element : elements) {
                    TreeItem treeItemId;
                    if (element.attributeValue("entityId") == null || element.attributeValue("entityId").equals(_entityId) || (treeItemId = FormDataSyn.getEntityTreeItem(element.attributeValue("entityId"))) == null) continue;
                    FormDataSyn.restore(treeItemId, null);
                    break;
                }
            }
        } else {
            GOTMessageDialog.alert("\u8fd4\u56delist.length()<1\uff0c\u5f02\u5e38");
        }
        for (TreeUi treeUi : FormDataSyn.treeUis) {
            treeUi.doRedrawTree();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteNodeCMI(boolean fromShortCut) {
        String nodeType;
        TreeItem[] items = this.treeitem.getParent().getSelection();
        if (items.length == 1) {
            Element item = this.currentTreeNode;
            NodeGOT node = NodeFactory.getNode(item);
            if (!fromShortCut && NodeGOT.canRevert(node.xml).booleanValue()) {
                String prompt = "\u786e\u8ba4\u56de\u6eda";
                String strValidate = node.validateRollback();
                if (!this.validateResult(strValidate).booleanValue()) {
                    return;
                }
                prompt = String.valueOf(prompt) + " " + item.getName() + " " + item.attributeValue("name");
                MessageBox messagebox = new MessageBox(GOTMessageDialog.shell, 196);
                messagebox.setText("\u786e\u5b9a\u8981\u56de\u6eda\u5417\uff0c\u56de\u6eda\u540e\u5c06\u65e0\u6cd5\u6062\u590d");
                messagebox.setMessage(prompt);
                int message = messagebox.open();
                if (message != 64) return;
                this.doCmi_Revert(node);
                return;
            }
        }
        if (items.length <= 0) return;
        String prompt = "\u786e\u8ba4\u5220\u9664";
        if (items.length == 1) {
            Element item = this.currentTreeNode;
            NodeGOT node = NodeFactory.getNode(item);
            String strValidate = node.validateDelete();
            if (!this.validateResult(strValidate).booleanValue()) {
                return;
            }
            prompt = String.valueOf(prompt) + " " + item.getName() + " " + item.attributeValue("name");
        } else {
            Element parent = this.currentTreeNode.getParent();
            TreeItem[] treeItemArray = items;
            int message = items.length;
            int messagebox = 0;
            while (messagebox < message) {
                TreeItem item = treeItemArray[messagebox];
                Element itemElement = GotXmlDto.getInstance().getCurrentElement(item);
                if (itemElement != null) {
                    NodeGOT node = NodeFactory.getNode(itemElement);
                    if (!node.resolverNode.getInfoValue("NodeType").equals("inner") || !itemElement.getParent().asXML().equals(parent.asXML())) {
                        GOTMessageDialog.alert("\u4e0d\u80fd\u540c\u65f6\u5220\u9664\u591a\u4e2a\u8282\u70b9");
                        return;
                    }
                    String strValidate = node.validateDelete();
                    if (!this.validateResult(strValidate).booleanValue()) {
                        return;
                    }
                }
                ++messagebox;
            }
            prompt = String.valueOf(prompt) + items.length + "\u4e2a\u8282\u70b9";
        }
        MessageBox messagebox = new MessageBox(GOTMessageDialog.shell, 196);
        messagebox.setText("\u786e\u5b9a\u8981\u5220\u9664\u5417\uff0c\u5220\u9664\u540e\u5c06\u65e0\u6cd5\u6062\u590d");
        messagebox.setMessage(prompt);
        int message = messagebox.open();
        if (message != 64) return;
        Element item = this.currentTreeNode;
        NodeGOT node = NodeFactory.getNode(item);
        switch (nodeType = node.resolverNode.getInfoValue("NodeType")) {
            case "entity": {
                if ("0".equals(item.attributeValue("version"))) {
                    if (!this.deleteNode(items).booleanValue()) return;
                    this.doDeleteUiTreeItem(items);
                    return;
                }
                Entity entity = null;
                if (node instanceof Entity) {
                    entity = (Entity)node;
                }
                if (entity == null) {
                    return;
                }
                String msg = "";
                try {
                    msg = LoadXmlCore.gotServices.deleteEntity(item.asXML());
                }
                catch (Exception e) {
                    Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"", (Throwable)e);
                    GOTMessageDialog.alert(e);
                }
                this.rpc_result_Delete(msg, entity);
                return;
            }
            case "inner": {
                this.deleteInnerNode();
                return;
            }
            case "branch": {
                TreeItem[] sitems = this.treeitem.getParent().getSelection();
                if (sitems.length == 1 && this.deleteNode(sitems).booleanValue()) {
                    this.setEntityUnsaved();
                }
                this.doDeleteUiTreeItem(items);
                return;
            }
            default: {
                return;
            }
        }
    }

    private Boolean validateResult(String result) {
        if (result.length() <= 4) {
            return true;
        }
        String isResultValid = result.substring(0, 5);
        if (isResultValid.equals(Macros.INFO_FALSE) || isResultValid.equals(Macros.INFO_ERROR)) {
            GOTMessageDialog.showXmlInfo(result, "\u4fe1\u606f");
            return false;
        }
        return true;
    }

    private Boolean deleteNode(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem trtmNewTreeitem = treeItemArray[n2];
            Element item = GotXmlDto.getInstance().getCurrentElement(trtmNewTreeitem);
            if (item != null) {
                Element parent = item.getParent();
                Boolean isSuc = GOTXMLHelper.deleteNode(item);
                if (!isSuc.booleanValue()) {
                    GOTMessageDialog.alert("\u5220\u9664\u5931\u8d25");
                    return false;
                }
                String nodeName = item.getName();
                if (nodeName.equals("Form")) {
                    --ConfigComposite.fromNum;
                    ConfigComposite.text_static_info();
                } else if (nodeName.equals("Table")) {
                    --ConfigComposite.tableNum;
                    ConfigComposite.text_static_info();
                }
                if (item.attribute("version") != null) {
                    GotXmlDto.getInstance().deleteEntityElement(item);
                } else {
                    GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(parent));
                }
            }
            ++n2;
        }
        return true;
    }

    public void rpc_result_Revert(String result, NodeGOT entity, String modifiedLayer) {
        if (!this.validateResult(result).booleanValue()) {
            return;
        }
        this.do_rpc_result_Revert(result, entity, modifiedLayer);
    }

    private void do_rpc_result_Revert(String result, NodeGOT entity, String modifiedLayer) {
        if (!StringUtils.isNotBlank((String)result)) {
            return;
        }
        result = "<Elements>".concat(result).concat("</Elements>");
        MouseRightMenuEvent.clearDeletedNodesCache(entity.xml.attributeValue("id"));
        Element tempXml = GOTXMLHelper.createElementByXMLString(result);
        List elements = tempXml.elements();
        String info = "";
        String his = "";
        block0: for (Element element : elements) {
            if (element.attribute("id") == null) continue;
            String strId = element.attributeValue("id");
            for (Element xmlCompare : elements) {
                if (element == xmlCompare || xmlCompare.attribute("id") == null || !xmlCompare.attributeValue("id").equals(strId)) continue;
                element.addAttribute("del", "true");
                continue block0;
            }
        }
        for (Element r : elements) {
            if (r.attribute("del") != null) continue;
            if (r.getName().equals("Error")) {
                info = String.valueOf(info) + r.getText() + "\n\u56de\u6eda\u5931\u8d25\uff0c\u5e94\u6267\u884c\u53f3\u952e\u6062\u590d\uff0c\u4ee5\u9632\u6570\u636e\u4e22\u5931\n";
                continue;
            }
            if (his.indexOf(r.attributeValue("id")) != -1) continue;
            JDTHandler.getServer().reverEntity(r.asXML(), modifiedLayer);
            his = String.valueOf(his) + "$" + r.attributeValue("id");
            Element entityEle = NodeGOT.getEntity(r);
            GotXmlDto.getInstance().saveEntity(entityEle.attributeValue("id"));
            TreeItem item = FormDataSyn.getTreeItrmByElement(entityEle, null);
            if (item == null) continue;
            FormDataSyn.restore(item, null);
        }
        TreeOperationInfo.addErrorInfo("\u6062\u590d:" + info);
        if (StringUtils.isNotBlank((String)info)) {
            GOTMessageDialog.alert(info);
        } else {
            ConfigComposite.configComposite.set_text_op_info("\u6210\u529f");
        }
        EntityNode el = GotXmlDto.getInstance().getEntityById(entity.xml.attributeValue("id"));
        FormDataSyn.currentTreeUi.loadTableValue(FormDataSyn.currentTreeUi.getTable(), (GOTNode)el, this.treeitem);
    }

    private void rpc_result_Delete(String result, NodeGOT entity) {
        if (!this.validateResult(result).booleanValue()) {
            return;
        }
        JDTHandler.getServer().deleteEntity();
        if (result.equals(Macros.INFO_TRUE)) {
            TreeItem[] items = this.treeitem.getParent().getSelection();
            this.deleteNode(items);
            this.doDeleteUiTreeItem(items);
        }
    }

    private void deleteInnerNode() {
        GOTNode item;
        TreeItem[] sitems = this.treeitem.getParent().getSelection();
        if (sitems.length > 0 && (item = TreeUIUtil.getCurrentElement2(sitems[0])) != null) {
            if (item.getNodeType().equals("TableField")) {
                String tableFieldIds = "";
                TreeItem[] treeItemArray = sitems;
                int n = sitems.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem treeitem = treeItemArray[n2];
                    GOTNode tableField = TreeUIUtil.getCurrentElement2(treeitem);
                    tableFieldIds = String.valueOf(tableFieldIds) + tableField.getId() + ",";
                    ++n2;
                }
                if (!tableFieldIds.equals("")) {
                    tableFieldIds = tableFieldIds.substring(0, tableFieldIds.length() - 1);
                }
                EntityNode table = item.getEntity();
                String result = "";
                try {
                    result = LoadXmlCore.gotServices.validateDeleteTableField(table.getId(), tableFieldIds);
                }
                catch (Exception e) {
                    Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"", (Throwable)e);
                    GOTMessageDialog.alert(e);
                    return;
                }
                if (result != null && !"".equals(result)) {
                    GOTMessageDialog.alert(result);
                } else {
                    this.doDeleteInnerNode(sitems);
                }
            } else {
                this.doDeleteInnerNode(sitems);
            }
        }
    }

    private void doDeleteInnerNode(TreeItem[] sitems) {
        if (this.deleteNode(sitems).booleanValue()) {
            EntityNode entityNode = TreeUIUtil.getCurrentEntityElement2(this.treeitem);
            if (entityNode.getNodeType().equals("Table")) {
                TreeItem[] treeItemArray = sitems;
                int n = sitems.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem treeItem2 = treeItemArray[n2];
                    MouseRightMenuEvent.addDeletedNodesCache(entityNode.getId(), String.valueOf(treeItem2.getData("elementName")));
                    ++n2;
                }
            }
            this.setEntityUnsaved();
            this.doDeleteUiTreeItem(sitems);
        }
    }

    public void setEntityUnsaved() {
        TreeItem treeItem = MouseRightMenuEvent.getEntityTreeItem(this.treeitem);
        Element _entityNode = GotXmlDto.getInstance().getCurrentElement(treeItem);
        if (_entityNode != null && _entityNode.attribute("saved") == null) {
            _entityNode.addAttribute("saved", "0");
        }
        String id = treeItem.getData("id").toString();
        for (TreeUi treeUi : FormDataSyn.treeUis) {
            TreeItem item = FormDataSyn.getTreeItrmEntityById(treeUi, id);
            if (item == null) continue;
            FormDataSyn.setUnSave(item);
        }
    }

    private static void addDeletedNodesCache(String entityid, String name) {
        if (deletedNodesCache.get(entityid) != null) {
            List<String> sv = deletedNodesCache.get(entityid);
            if (sv.indexOf(name) == -1) {
                sv.add(name);
            }
        } else {
            ArrayList<String> sv = new ArrayList<String>();
            sv.add(name);
            deletedNodesCache.put(entityid, sv);
        }
    }

    private static void clearDeletedNodesCache(String key) {
        deletedNodesCache.remove(key);
    }

    public static List<String> getDeletedNodesCache(String key) {
        return deletedNodesCache.get(key);
    }

    private static TreeItem getEntityTreeItem(TreeItem treeItem) {
        GOTNode element = TreeUIUtil.getCurrentElement2(treeItem);
        if (element == null) {
            return MouseRightMenuEvent.getEntityTreeItem(treeItem.getParentItem());
        }
        try {
            if (element.isEntityNode()) {
                return treeItem;
            }
            return MouseRightMenuEvent.getEntityTreeItem(treeItem.getParentItem());
        }
        catch (NavException navException) {
            return null;
        }
    }

    private void doDeleteUiTreeItem(TreeItem[] sitems) {
        TreeItem[] treeItemArray = sitems;
        int n = sitems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            FormDataSyn.deleteTreeItem(treeItem, true);
            ++n2;
        }
    }

    private void doCmi_Revert(NodeGOT node) {
        String nodeType;
        this._isDeletingNode = false;
        switch (nodeType = node.resolverNode.getInfoValue("NodeType")) {
            case "entity": {
                if ("0".equals(this.currentTreeNode.attributeValue("version"))) {
                    FormDataSyn.setSaved(this.treeitem);
                    this.deleteNode(new TreeItem[]{this.treeitem});
                    break;
                }
                Entity entity = null;
                if (node instanceof Entity) {
                    entity = (Entity)node;
                }
                if (entity == null) {
                    return;
                }
                String modifiedLayer = this.currentTreeNode.attributeValue("modifiedLayer");
                String result = LoadXmlCore.gotServices.revertEntity(this.currentTreeNode.asXML());
                this.rpc_result_Revert(result, entity, modifiedLayer);
                break;
            }
            case "inner": {
                TreeItem[] sitems = this.treeitem.getParent().getSelection();
                if (!this.deleteNode(sitems).booleanValue()) break;
                Element entityNode = NodeGOT.getEntity(this.currentTreeNode);
                this.setEntityUnsaved();
                if (!entityNode.getName().equals(GOTNodesConst.TABLE)) break;
                TreeItem[] treeItemArray = sitems;
                int n = sitems.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem treeItem = treeItemArray[n2];
                    GOTNode sitem = TreeUIUtil.getCurrentElement2(treeItem);
                    MouseRightMenuEvent.addDeletedNodesCache(entityNode.attributeValue("id"), sitem.getName());
                    ++n2;
                }
                break;
            }
            case "branch": {
                TreeItem[] sitems = this.treeitem.getParent().getSelection();
                if (sitems.length != 1 || !this.deleteNode(sitems).booleanValue()) break;
                this.setEntityUnsaved();
                break;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void restoreNode() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[5] lbl40 : CaseStatement: default:\u000a, @NONE, blocks:[5] lbl40 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void rpc_result_Restore(String result) {
        if (!this.validateResult(result).booleanValue()) {
            return;
        }
        Element resultXML = GOTXMLHelper.createElementByXMLString(result);
        String baseId = this.treeitem.getData("id").toString();
        TreeItem item = FormDataSyn.treeUis.get((int)0).itemsMap.get(baseId);
        this.rpc_ui_Restore(item, resultXML);
    }

    private void rpc_ui_Restore(TreeItem item, Element resultXML) {
        TreeOperationInfo.addInfo(String.valueOf(this.treeitem.getText()) + "\u6062\u590d\uff1a" + Macros.INFO_OPR_SUCCESS);
        ConfigComposite.configComposite.set_text_op_info(Macros.INFO_OPR_SUCCESS);
        GotXmlDto.getInstance().saveEntity(resultXML.attributeValue("id"));
        FormDataSyn.restore(item, null);
    }

    public void syncNodes() {
        MessageBox messagebox = new MessageBox(GOTMessageDialog.shell, 196);
        messagebox.setText("\u786e\u8ba4\u64cd\u4f5c");
        messagebox.setMessage("\u786e\u5b9a\u8981\u540c\u6b65\u5417");
        int message = messagebox.open();
        if (message == 64) {
            this.barUtil = new ProgressBarUtil(GOTMessageDialog.shell, 2144, this);
            this.barUtil.open();
        }
    }

    public void doSyncNodes() {
        TreeItem[] items = this.treeitem.getParent().getSelection();
        int length = items.length;
        String name = "";
        if (length == 1) {
            name = items[0].getText();
            if (name.equals("Enums") || name.equals("DataTypes") || name.equals("Tables") || name.equals("Menus") || name.equals("MenuItems") || name.equals("Forms") || name.equals("Reports") || name.equals("Classes") || name.equals("GOT")) {
                this.barUtil.setShellText("\u6b63\u5728\u540c\u6b65\uff1a" + name);
                this.syncNode(name);
                return;
            }
            if (name.equals("DataDictionary")) {
                GOTMessageDialog.alert("\u4e0d\u652f\u6301\u540c\u6b65" + name);
                return;
            }
        }
        this.syncResultString = "";
        int i = 0;
        while (i < length) {
            TreeItem treeItem = items[i];
            Element item = GotXmlDto.getInstance().getCurrentElement(treeItem);
            this.syncNode(item);
            if (this.barUtil == null || this.barUtil.shell.isDisposed()) break;
            this.barUtil.setShellText("\u6b63\u5728\u540c\u6b65\uff1a" + item.attributeValue("name"));
            int num = (i + 1) * 100 / length;
            this.barUtil.setProgressBar(num);
            ++i;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!((MouseRightMenuEvent)MouseRightMenuEvent.this).barUtil.shell.isDisposed()) {
                    ((MouseRightMenuEvent)MouseRightMenuEvent.this).barUtil.shell.dispose();
                    MouseRightMenuEvent.this.syncMessage();
                }
            }
        });
    }

    public void syncMessage() {
        Element xml = this.rpc_result_sync(this.syncResultString);
        if (this.SyncResultXMl == null) {
            this.SyncResultXMl = xml;
        } else {
            this.SyncResultXMl.add(xml.detach());
        }
        if (this.SyncResultXMl != null) {
            GOTMessageDialog.showSynResult(this.SyncResultXMl);
        }
    }

    public void syncNode(final String name) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                String result = "";
                try {
                    if (name.equals("Enums")) {
                        result = LoadXmlCore.gotServices.syncEntitys(EntityType.Enum);
                    } else if (name.equals("DataTypes")) {
                        result = LoadXmlCore.gotServices.syncEntitys(EntityType.DataType);
                    } else if (name.equals("Tables")) {
                        result = LoadXmlCore.gotServices.syncEntitys(EntityType.Table);
                    } else if (name.equals("Menus")) {
                        result = LoadXmlCore.gotServices.syncEntitys(EntityType.Menu);
                    } else if (name.equals("MenuItems")) {
                        result = LoadXmlCore.gotServices.syncEntitys(EntityType.MenuItem);
                    } else if (name.equals("Forms")) {
                        result = LoadXmlCore.gotServices.syncEntitys(EntityType.Form);
                    } else if (name.equals("Reports")) {
                        result = LoadXmlCore.gotServices.syncEntitys(EntityType.Report);
                    } else if (name.equals("Classes")) {
                        result = LoadXmlCore.gotServices.syncEntitys(EntityType.Class);
                    } else if (name.equals("GOT")) {
                        result = LoadXmlCore.gotServices.syncGOT();
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass()).error((Object)"\u540c\u6b65\u9519\u8bef", (Throwable)e);
                    MouseRightMenuEvent mouseRightMenuEvent = MouseRightMenuEvent.this;
                    mouseRightMenuEvent.syncResultString = String.valueOf(mouseRightMenuEvent.syncResultString) + name + " " + e.getMessage() + ":sync False \n";
                    return;
                }
                MouseRightMenuEvent.this.rpc_result_Sync(result, null);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ((MouseRightMenuEvent)(this).MouseRightMenuEvent.this).barUtil.shell.dispose();
                        MouseRightMenuEvent.this.syncMessage();
                    }
                });
            }
        });
        thread.start();
    }

    public void syncNode(Element item) {
        NodeGOT node = NodeFactory.getNode(item);
        String nodeType = node.resolverNode.getInfoValue("NodeType");
        String name = item.getName();
        switch (nodeType) {
            case "outer": {
                MessageBox messagebox = new MessageBox(GOTMessageDialog.shell, 196);
                messagebox.setText("\u786e\u8ba4\u64cd\u4f5c");
                messagebox.setMessage("\u786e\u5b9a\u8981\u540c\u6b65\u5417");
                int message = messagebox.open();
                if (message != 64) break;
                String result = "";
                try {
                    if (name.equals("Enums")) {
                        result = LoadXmlCore.gotServices.syncEntitys(EntityType.Enum);
                    } else if (name.equals("DataTypes")) {
                        result = LoadXmlCore.gotServices.syncEntitys(EntityType.DataType);
                    } else if (name.equals("Tables")) {
                        result = LoadXmlCore.gotServices.syncEntitys(EntityType.Table);
                    } else if (name.equals("Menus")) {
                        result = LoadXmlCore.gotServices.syncEntitys(EntityType.Menu);
                    } else if (name.equals("MenuItems")) {
                        result = LoadXmlCore.gotServices.syncEntitys(EntityType.MenuItem);
                    } else if (name.equals("Forms")) {
                        result = LoadXmlCore.gotServices.syncEntitys(EntityType.Form);
                    } else if (name.equals("Reports")) {
                        result = LoadXmlCore.gotServices.syncEntitys(EntityType.Report);
                    } else if (name.equals("Classes")) {
                        result = LoadXmlCore.gotServices.syncEntitys(EntityType.Class);
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"\u540c\u6b65\u9519\u8bef", (Throwable)e);
                    this.syncResultString = String.valueOf(this.syncResultString) + item.attributeValue("id") + "." + item.attributeValue("name") + " " + e.getMessage() + ":sync False \n";
                    return;
                }
                this.rpc_result_Sync(result, null);
                break;
            }
            case "entity": {
                if (item.attribute("saved") != null) {
                    TreeOperationInfo.addInfo(String.valueOf(this.treeitem.getText()) + "\u540c\u6b65\uff1a" + Macros.WARNING_DATA_UNSAVED);
                    ConfigComposite.configComposite.set_text_op_info(Macros.WARNING_DATA_UNSAVED);
                    break;
                }
                String result = "";
                try {
                    result = LoadXmlCore.gotServices.syncEntity(item.asXML());
                }
                catch (Exception e) {
                    Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"", (Throwable)e);
                    this.syncResultString = String.valueOf(this.syncResultString) + item.attributeValue("id") + "." + item.attributeValue("name") + " " + e.getMessage() + ":sync False \n";
                    return;
                }
                this.rpc_result_Sync(result, item);
                break;
            }
        }
    }

    private void rpc_result_Sync(String result, Element item) {
        if (result.equals(Macros.INFO_TRUE)) {
            TreeOperationInfo.addInfo(String.valueOf(this.treeitem.getText()) + "\u540c\u6b65:" + Macros.INFO_OPR_SUCCESS);
            ConfigComposite.configComposite.set_text_op_info(Macros.INFO_OPR_SUCCESS);
            if (item != null) {
                this.syncResultString = String.valueOf(this.syncResultString) + item.attributeValue("id") + "." + item.attributeValue("name") + ":sync OK\n";
            }
        } else if (result.length() > 5 && result.substring(0, 5).equals(Macros.INFO_FALSE)) {
            TreeOperationInfo.addErrorInfo(String.valueOf(item.attributeValue("name")) + result);
            if (item != null) {
                this.syncResultString = String.valueOf(this.syncResultString) + item.attributeValue("id") + "." + item.attributeValue("name") + ":sync False \n";
            }
        } else {
            this.syncResultString = String.valueOf(this.syncResultString) + result;
        }
    }

    private Element rpc_result_sync(String result) {
        String[] strs;
        Element xml = GOTXMLHelper.createElement("tempRoot");
        String[] stringArray = strs = result.split("\\n");
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (!"".equals(string)) {
                String[] rtype = string.split(":");
                String nodeName = rtype[1];
                if (xml.element(nodeName) == null) {
                    xml.addElement(nodeName);
                    xml.element(nodeName).addElement(nodeName).setText(rtype[0]);
                } else {
                    xml.element(nodeName).addElement(nodeName).setText(rtype[0]);
                }
            }
            ++n2;
        }
        List list = xml.elements();
        for (Element element : list) {
            List list2 = element.elements();
            element.setName(String.valueOf(element.getName()) + list2.size());
        }
        return xml;
    }

    public void duplicateNode() {
        Element item = this.currentTreeNode;
        String name = item.getName();
        String id = "";
        try {
            id = LoadXmlCore.gotServices.getEntityId(EntityType.valueOf((String)name));
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"", (Throwable)e);
            GOTMessageDialog.alert(e);
            return;
        }
        if (id.equals("-1")) {
            GOTMessageDialog.alert("\u83b7\u53d6id\u5931\u8d25");
            return;
        }
        this.rpc_result_Duplicate(id);
    }

    private void rpc_result_Duplicate(String id) {
        if (id != null && !id.equals("")) {
            Element item = this.currentTreeNode;
            Element copy = item.createCopy();
            Boolean current = copy.attributeValue("createdLayer").equals(((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer());
            copy.addAttribute("createdLayer", ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer());
            copy.addAttribute("modifiedLayer", ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer());
            String entitySimpleName = copy.attributeValue("name");
            if (id.contains(".")) {
                String nameSpace = id.substring(0, id.lastIndexOf("."));
                entitySimpleName = entitySimpleName.contains(".") ? String.valueOf(nameSpace) + "." + entitySimpleName.substring(entitySimpleName.lastIndexOf(".") + 1) : entitySimpleName;
            }
            copy.addAttribute("name", String.valueOf(entitySimpleName) + "_copy");
            copy.addAttribute("id", id);
            copy.addAttribute("version", "0");
            copy.addAttribute("saved", "0");
            String nodeName = item.getName();
            if (!current.booleanValue()) {
                int base = ((LayerLevelManager)ObjectContainer.getInstance(LayerLevelManager.class)).getLayerLevel(((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer()) * 10000;
                int _intNextInnerId = base + 1;
                copy.addAttribute("nextInnerId", String.valueOf(_intNextInnerId));
                nodeName = copy.getName();
                HashMap<String, Integer> mapIdChanged = new HashMap<String, Integer>();
                mapIdChanged.put("intNextInnerId", _intNextInnerId);
                this.descendantsChilds(copy, "Table".equals(nodeName), mapIdChanged);
                this.descendantsChilds2(copy, "Table".equals(nodeName), mapIdChanged);
                copy.addAttribute("nextInnerId", String.valueOf(mapIdChanged.get("intNextInnerId")));
            }
            if (nodeName.equals("Form")) {
                ++ConfigComposite.fromNum;
                ConfigComposite.text_static_info();
            } else if (nodeName.equals("Table")) {
                ++ConfigComposite.tableNum;
                ConfigComposite.text_static_info();
            }
            NodeGOT node = NodeFactory.getNode(item);
            node.setBrotherUniqueName(copy);
            GotXmlDto.getInstance().addEntityElement(copy);
            int index = 0;
            if (this.treeitem.getParentItem() == null) {
                index = 0;
                FormDataSyn.actionCopySyn(this.getTreeitem(), copy, index, true);
            } else {
                index = this.treeitem.getParentItem().indexOf(this.treeitem);
                FormDataSyn.actionCopySyn(this.getTreeitem(), copy, index, true);
            }
        }
    }

    private void descendantsChilds(Element copy, Boolean isTable, Map<String, Integer> mapIdChanged) {
        List childs = copy.elements();
        for (Element child : childs) {
            if (child.attribute("createdLayer") != null) {
                child.addAttribute("createdLayer", ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer());
                child.addAttribute("modifiedLayer", ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer());
            }
            if (child.attribute("id") != null && child.attribute("id") != null) {
                String now = child.attributeValue("id");
                mapIdChanged.put(now, mapIdChanged.get("intNextInnerId"));
                child.addAttribute("id", mapIdChanged.get("intNextInnerId").toString());
                int num = mapIdChanged.get("intNextInnerId");
                mapIdChanged.put("intNextInnerId", ++num);
            }
            this.descendantsChilds(child, isTable, mapIdChanged);
        }
    }

    private void descendantsChilds2(Element copy, Boolean isTable, Map<String, Integer> mapIdChanged) {
        List childs = copy.elements();
        for (Element child : childs) {
            String now;
            if (child.attribute("innerid") != null && mapIdChanged.containsKey(now = child.attributeValue("innerid"))) {
                child.addAttribute("innerid", mapIdChanged.get(now).toString());
            }
            this.descendantsChilds2(child, isTable, mapIdChanged);
        }
    }

    public void showXML() {
        GOTNode item = TreeUIUtil.getCurrentElement2(this.treeitem);
        GOTMessageDialog.showXmlInfo(MouseRightMenuEvent.formatXml(item.toString()), item.getName());
    }

    public static String formatXml(String str) {
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)str);
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            StringWriter writer = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)writer, format);
            xmlWriter.write(document);
            xmlWriter.close();
            str = writer.toString();
        }
        catch (IOException | DocumentException e) {
            Logger.getLogger(MouseRightMenuEvent.class).error((Object)"", e);
        }
        return str;
    }

    public void enterNodeRef() {
        this.barRefNodeUtil = new ProgressBarRefNodeUtil(GOTMessageDialog.shell, 2144, this);
        this.barRefNodeUtil.open();
    }

    public void doEnterNodeRef() {
        Element item = this.currentTreeNode;
        Element _entity = NodeGOT.getEntity(item);
        if (_entity == null) {
            return;
        }
        String _entityId = _entity.attributeValue("id");
        String _innerId = _entityId.equals(item.attributeValue("id")) ? null : item.attributeValue("id");
        String result = "";
        try {
            result = LoadXmlCore.gotServices.getNodeRef(item.getName(), _entityId, _innerId);
            if (this.barRefNodeUtil != null && !this.barRefNodeUtil.shell.isDisposed()) {
                this.barRefNodeUtil.shell.close();
                this.barRefNodeUtil = null;
            }
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"", (Throwable)e);
            GOTMessageDialog.alert(e);
        }
        this.rpc_result_getNodeRef(result);
    }

    private void rpc_result_getNodeRef(String result) {
        if (result != null) {
            Element xml = GOTXMLHelper.createElementByXMLString(result);
            GOTMessageDialog.showEnterNodeRef(xml);
        }
    }

    public void methodSet() {
        GOTNode item = this.currentTreeGOTNode;
        GOTMessageDialog.showMethod(item);
    }

    public void openNewFrom(boolean open) {
        new TreeUiBean(this.treeitem, open);
    }

    public void syncFDSF() {
        DoMerge.checkSelectTable();
    }

    public void resetRelationName() {
        Element item = this.currentTreeNode;
        if (item.getName().equals("Table")) {
            String _entityId = item.attributeValue("id");
            String result = "";
            try {
                result = LoadXmlCore.gotServices.getNodeRef(item.getName(), _entityId, null);
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"", (Throwable)e);
                GOTMessageDialog.alert(e);
            }
            if (result != null) {
                Element xml = GOTXMLHelper.createElementByXMLString(result);
                GOTMessageDialog.showEnterNodeReset(xml);
            }
        } else if (item.getName().equals("FormDataSource")) {
            ArrayList<Element> differenceFormItems = new ArrayList<Element>();
            Element formElement = NodeGOT.getEntity(item);
            List elements = formElement.selectNodes(String.format("//FormItem/Properties/Property[@innerid='%s']", item.attributeValue("id")));
            for (Element propertyElement : elements) {
                Element componentProperty;
                Element extendsProperty;
                Element formItemElement = propertyElement.getParent().getParent();
                String formItemType = formItemElement.attributeValue("type");
                if ("StringEditor".equals(formItemType) || "LongEditor".equals(formItemType) || "DecimalEditor".equals(formItemType) || "DateEditor".equals(formItemType) || "TimeEditor".equals(formItemType) || "DateTimeEditor".equals(formItemType) || "EnumEditor".equals(formItemType) || "BooleanEditor".equals(formItemType) ? !"DataSource".equals(propertyElement.elementText("Name")) || StringUtils.isBlank((String)(extendsProperty = GOTHelper.getProperty((Element)formItemElement, (String)"Extends")).attributeValue("refinnerid")) || "FieldGroup".equals(formItemElement.getParent().attributeValue("type")) && StringUtils.isNotBlank((String)GOTHelper.getPropertyValue((Element)formItemElement.getParent(), (String)"Component")) : !"FieldGroup".equals(formItemType) || StringUtils.isBlank((String)(componentProperty = GOTHelp.getProperty(formItemElement, "Component")).attributeValue("refinnerid"))) continue;
                differenceFormItems.add(formItemElement);
            }
            GOTMessageDialog.showEnterNodeResetFormDataSource(differenceFormItems, item);
        }
    }

    public void syncDataTableStructure() {
        Element item = this.currentTreeNode;
        if (item.getName().equals("Table")) {
            try {
                LoadXmlCore.databaseServices.syncTable(item);
                GOTMessageDialog.info("\u540c\u6b65\u6210\u529f");
            }
            catch (Exception e) {
                Logger.getLogger(MouseRightMenuEvent.class).error((Object)"", (Throwable)e);
                GOTMessageDialog.alert("\u540c\u6b65\u5931\u8d25");
            }
        }
    }

    public void checkFormDataSourceFieldRate() {
        try {
            DoMerge.checkFormDataSourceFieldRate();
        }
        catch (Exception e) {
            Logger.getLogger(MouseRightMenuEvent.class).error((Object)"", (Throwable)e);
            GOTMessageDialog.alert("checkFormDataSourceFieldRate\u5f02\u5e38");
        }
    }
}

