/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.model;

import gongqi.designer.got.vtd.EntityNode;
import gongqi.designer.got.vtd.GOTNode;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.core.toolsgot.GOTXMLHelper;
import gongqi.gdt.designer.service.node.GOTEntity;
import info.gongqi.got.ui.LoadXML;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.util.GOTUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.eclipse.swt.widgets.TreeItem;

public class GotXmlDto {
    private static GotXmlDto gotXmlhelp;
    private Map<EntityType, Map<String, String>> gotMap = new LinkedHashMap<EntityType, Map<String, String>>();

    private GotXmlDto() {
    }

    public int getTableCount() {
        return this.getEntityList(EntityType.Table).size();
    }

    public int getBusinessTableCount() {
        List<EntityNode> tables = this.getEntityList(EntityType.Table);
        int systemTableCount = (int)tables.stream().filter(entry -> entry.getName().toLowerCase().startsWith("sys")).count();
        return this.getTableCount() - systemTableCount;
    }

    public int getFormCount() {
        return this.getEntityList(EntityType.Form).size();
    }

    public static GotXmlDto getInstance() {
        if (gotXmlhelp == null) {
            gotXmlhelp = new GotXmlDto();
        }
        return gotXmlhelp;
    }

    public void init() {
        this.gotMap.clear();
        EntityType[] entityTypes = EntityType.values();
        int i = 0;
        while (i < entityTypes.length) {
            this.gotMap.put(entityTypes[i], new LinkedHashMap());
            ++i;
        }
    }

    public List<GOTNode> getGotXML(String path) {
        ArrayList<GOTNode> result = new ArrayList<GOTNode>();
        if (path.startsWith("GOT/")) {
            path = path.substring(4);
        }
        if (path.startsWith(".")) {
            path = path.substring(1);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.startsWith("DataDictionary/")) {
            path = path.substring("DataDictionary/".length());
        }
        List<Object> allNodes = new ArrayList();
        if (path.startsWith("Enums")) {
            allNodes = this.getEntityList(EntityType.Enum);
            path = path.substring("Enums".length());
        } else if (path.startsWith("Enum")) {
            allNodes = this.getEntityList(EntityType.Enum);
        } else if (path.startsWith("DataTypes")) {
            allNodes = this.getEntityList(EntityType.DataType);
            path = path.substring("DataTypes".length());
        } else if (path.startsWith("DataType")) {
            allNodes = this.getEntityList(EntityType.DataType);
        } else if (path.startsWith("Tables")) {
            allNodes = this.getEntityList(EntityType.Table);
            path = path.substring("Tables".length());
        } else if (path.startsWith("Table")) {
            allNodes = this.getEntityList(EntityType.Table);
            path = path.substring("Table".length());
        } else if (path.startsWith("MenuItems")) {
            allNodes = this.getEntityList(EntityType.MenuItem);
            path = path.substring("MenuItems".length());
        } else if (path.startsWith("MenuItem")) {
            allNodes = this.getEntityList(EntityType.MenuItem);
            path = path.substring("MenuItem".length());
        } else if (path.startsWith("Menus")) {
            allNodes = this.getEntityList(EntityType.Menu);
            path = path.substring("Menus".length());
        } else if (path.startsWith("Menu")) {
            allNodes = this.getEntityList(EntityType.Menu);
            path = path.substring("Menu".length());
        } else if (path.startsWith("Forms")) {
            allNodes = this.getEntityList(EntityType.Form);
            path = path.substring("Forms".length());
        } else if (path.startsWith("Form")) {
            allNodes = this.getEntityList(EntityType.Form);
            path = path.substring("Form".length());
        } else if (path.startsWith("Reports")) {
            allNodes = this.getEntityList(EntityType.Report);
            path = path.substring("Reports".length());
        } else if (path.startsWith("Report")) {
            allNodes = this.getEntityList(EntityType.Report);
            path = path.substring("Report".length());
        } else if (path.startsWith("Classes")) {
            allNodes = this.getEntityList(EntityType.Class);
            path = path.substring("Classes".length());
        } else if (path.startsWith("Class")) {
            allNodes = this.getEntityList(EntityType.Class);
            path = path.substring("Class".length());
        } else {
            throw new RuntimeException("\u975e\u6cd5\u7684\u8282\u70b9\u89e3\u6790\u8def\u5f84\uff1a" + path);
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            for (EntityNode entityNode : allNodes) {
                result.add((GOTNode)entityNode);
            }
        } else if (path.contains("]") && (path.startsWith("Enum[") || path.startsWith("DataType[") || path.startsWith("Table[") || path.startsWith("Menu[") || path.startsWith("MenuItem[") || path.startsWith("Form[") || path.startsWith("Report[") || path.startsWith("Class["))) {
            path = path.trim();
            String string = path.substring(path.indexOf("[") + 1, path.indexOf("]"));
            String childPath = path.substring(path.indexOf("]") + 1);
            if (string.contains("or")) {
                String[] stringArray = string.split("or");
                block1: for (EntityNode entityNode : allNodes) {
                    String[] stringArray2 = stringArray;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String expression = stringArray2[n2];
                        if (this.analysisXpath(entityNode, expression)) {
                            if (StringUtils.isNotBlank((CharSequence)childPath)) {
                                result.addAll(entityNode.selectNodes(childPath));
                                continue block1;
                            }
                            result.add((GOTNode)entityNode);
                            continue block1;
                        }
                        ++n2;
                    }
                }
            } else if (string.contains("and")) {
                String[] stringArray = string.split("and");
                for (EntityNode entityNode : allNodes) {
                    boolean flag = true;
                    String[] stringArray3 = stringArray;
                    int n = stringArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String expression = stringArray3[n3];
                        if (!this.analysisXpath(entityNode, expression)) {
                            flag = false;
                            break;
                        }
                        ++n3;
                    }
                    if (!flag) continue;
                    if (StringUtils.isNotBlank((CharSequence)childPath)) {
                        result.addAll(entityNode.selectNodes(childPath));
                        continue;
                    }
                    result.add((GOTNode)entityNode);
                }
            } else {
                for (EntityNode entityNode : allNodes) {
                    if (!this.analysisXpath(entityNode, string)) continue;
                    if (StringUtils.isNotBlank((CharSequence)childPath)) {
                        result.addAll(entityNode.selectNodes(childPath));
                    } else {
                        result.add((GOTNode)entityNode);
                    }
                    break;
                }
            }
        } else {
            for (EntityNode entityNode : allNodes) {
                result.addAll(entityNode.selectNodes(path));
            }
        }
        return result;
    }

    private boolean analysisXpath(EntityNode entityNode, String expression) {
        expression = expression.trim();
        String attr = expression.substring(expression.indexOf("@") + 1, expression.indexOf("="));
        String value = expression.substring(expression.indexOf("'") + 1, expression.lastIndexOf("'"));
        return value.equals(entityNode.getAttributeValue(attr));
    }

    @Deprecated
    public List<Element> currentElements(EntityType entityType) {
        List<EntityNode> entityList = this.getEntityList(entityType);
        return entityList.stream().map(e -> e.toElement()).collect(Collectors.toList());
    }

    @Deprecated
    public Element getEntity(String entityId) {
        EntityNode entity = this.getEntityById(entityId);
        if (entity != null) {
            return entity.toElement();
        }
        return null;
    }

    @Deprecated
    public Element getCurrentElement(TreeItem treeItem) {
        if (treeItem == null || treeItem.isDisposed()) {
            return null;
        }
        String elementId = treeItem.getData("elementId") == null ? null : treeItem.getData("elementId").toString();
        String elementEntityId = treeItem.getData("elementEntityId") == null ? null : treeItem.getData("elementEntityId").toString();
        String elementName = treeItem.getData("elementName").toString();
        if (elementEntityId == null) {
            Element root = GOTXMLHelper.createElement(elementName);
            return root;
        }
        if (elementEntityId.equals(elementId)) {
            return this.getEntity(elementEntityId.toString());
        }
        Element entityEle = this.getEntity(elementEntityId.toString());
        if (entityEle == null) {
            return null;
        }
        if (elementId != null) {
            String xpath = "//" + elementName + "[@id='" + elementId + "']";
            List elements = entityEle.selectNodes(xpath);
            for (Element element : elements) {
                if (!element.attributeValue("id").equals(elementId)) continue;
                return element;
            }
        } else {
            String xpath = "//" + elementName;
            List elements = entityEle.selectNodes(xpath);
            for (Element element : elements) {
                TreeItem parent = treeItem.getParentItem();
                Element parentParent = element.getParent();
                while (parent.getData("elementId") == null) {
                    parent = parent.getParentItem();
                    parentParent = parentParent.getParent();
                }
                if (!parent.getData("elementId").toString().equals(parentParent.attributeValue("id"))) continue;
                return element;
            }
        }
        return null;
    }

    public void updateEntityElement(Element element) {
        String entityId = element.attributeValue("id");
        if (entityId != null) {
            if (element.attribute("saved") == null) {
                element.addAttribute("saved", "0");
            }
            EntityType entityType = this.getEntityTypeById(entityId);
            Map<String, String> map = this.gotMap.get(entityType);
            map.put(entityId, element.asXML());
            this.gotMap.put(entityType, map);
            return;
        }
        throw new Error("\u66f4\u65b0\u8282\u70b9\u4e0d\u662f\u5b9e\u4f53\u8282\u70b9\uff1a" + element.getName());
    }

    public void updateEntityElement(GOTEntity element) {
        try {
            String entityId = element.getId();
            if (!element.hasAttribute("saved")) {
                element.setAttributeValue("saved", "0");
            }
            EntityType entityType = this.getEntityTypeById(entityId);
            Map<String, String> map = this.gotMap.get(entityType);
            map.put(entityId, element.asXML());
            this.gotMap.put(entityType, map);
        }
        catch (Exception exception) {
            throw new Error("\u66f4\u65b0\u5b9e\u4f53\u8282\u70b9\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a" + element.getName());
        }
    }

    @Deprecated
    public void addEntityElement(Element element) {
        this.updateEntityElement(element);
    }

    @Deprecated
    public void deleteEntityElement(Element element) {
        String entityId = element.attributeValue("id");
        EntityType entityType = this.getEntityTypeById(entityId);
        Map<String, String> temps = this.gotMap.get(entityType);
        temps.remove(entityId);
        this.gotMap.put(entityType, temps);
    }

    public String getUnsaveText() {
        String text = "";
        for (EntityType key : this.gotMap.keySet()) {
            Map<String, String> map = this.gotMap.get(key);
            if (map.values().size() <= 0) continue;
            text = String.valueOf(text) + key.name() + "[" + map.values().size() + "]";
        }
        return text;
    }

    public List<String> typesNameList(String enyityId) {
        EntityType entityType = this.getEntityTypeById(enyityId);
        List<EntityNode> tables = this.getEntityList(entityType);
        return tables.stream().filter(t -> !t.getId().equals(enyityId)).map(t -> t.getName()).collect(Collectors.toList());
    }

    public Map<String, String> typesNameIdList(String enyityId) {
        EntityType entityType = this.getEntityTypeById(enyityId);
        List<EntityNode> tables = this.getEntityList(entityType);
        return tables.stream().filter(t -> !t.getId().equals(enyityId)).collect(Collectors.toMap(t -> t.getId(), t -> t.getName()));
    }

    private EntityType getEntityTypeById(String entityId) {
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return null;
        }
        if (entityId.contains(".")) {
            entityId = entityId.substring(entityId.lastIndexOf(".") + 1);
        }
        if (entityId.startsWith("10")) {
            return EntityType.Enum;
        }
        if (entityId.startsWith("20")) {
            return EntityType.DataType;
        }
        if (entityId.startsWith("30")) {
            return EntityType.Table;
        }
        if (entityId.startsWith("40")) {
            return EntityType.Form;
        }
        if (entityId.startsWith("50")) {
            return EntityType.MenuItem;
        }
        if (entityId.startsWith("60")) {
            return EntityType.Menu;
        }
        if (entityId.startsWith("73")) {
            return EntityType.Report;
        }
        if (entityId.startsWith("80")) {
            return EntityType.Class;
        }
        return null;
    }

    public EntityNode getEntityById(String entityId) {
        EntityType entityType = this.getEntityTypeById(entityId);
        return this.getEntityByIdAndType(entityType, entityId);
    }

    public GOTEntity getGOTEntityById(String entityId) {
        EntityType entityType = this.getEntityTypeById(entityId);
        if (entityType == null) {
            return null;
        }
        Map<String, String> map = this.gotMap.get(entityType);
        if (map != null && map.containsKey(entityId)) {
            return GOTEntity.parse(map.get(entityId));
        }
        return GOTEntity.parse(LoadXmlCore.gotServices.getEntity(entityId).toString());
    }

    public EntityNode getEntityByIdAndType(EntityType entityType, String entityId) {
        if (entityType == null) {
            return null;
        }
        Map<String, String> map = this.gotMap.get(entityType);
        if (map != null && map.containsKey(entityId)) {
            return EntityNode.parse((String)map.get(entityId));
        }
        return LoadXmlCore.gotServices.getEntity(entityId);
    }

    public EntityNode getEntityByName(EntityType entityType, String name) {
        Optional<EntityNode> findAny = this.getEntityList(entityType).stream().filter(n -> n.getName().equals(name)).findAny();
        if (findAny.isPresent()) {
            return findAny.get();
        }
        return null;
    }

    public List<EntityNode> getServiceEntitys(EntityType entityType, boolean order) {
        List entityLists = LoadXmlCore.gotServices.getEntity(entityType);
        if (!order) {
            return entityLists;
        }
        Comparator<EntityNode> comparator = null;
        if (EntityType.Menu.equals((Object)entityType)) {
            final List menuOrders = LoadXmlCore.gotServices.getMenuOrder();
            if (menuOrders.size() > 0) {
                comparator = new Comparator<EntityNode>(){

                    @Override
                    public int compare(EntityNode o1, EntityNode o2) {
                        int o1Index = menuOrders.indexOf(o1.getId());
                        int o2Index = menuOrders.indexOf(o2.getId());
                        if (o1Index == -1) {
                            return 1;
                        }
                        if (o2Index == -1) {
                            return 1;
                        }
                        return o1Index - o2Index;
                    }
                };
            }
        } else {
            comparator = new Comparator<EntityNode>(){

                @Override
                public int compare(EntityNode o1, EntityNode o2) {
                    if (GOTUtil.button_pre) {
                        return o1.getName().compareToIgnoreCase(o2.getName());
                    }
                    return LoadXML.fmt(o1.getName(), 1).compareToIgnoreCase(LoadXML.fmt(o2.getName(), 1));
                }
            };
        }
        if (comparator != null) {
            return entityLists.stream().sorted(comparator).collect(Collectors.toList());
        }
        return entityLists;
    }

    public List<EntityNode> getEntityList(EntityType entityType) {
        List<EntityNode> entityLists = this.getServiceEntitys(entityType, false);
        Map<String, EntityNode> entitys = entityLists.stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
        Map<String, String> map = this.gotMap.get(entityType);
        if (map != null) {
            for (String entityId : map.keySet()) {
                entitys.put(entityId, EntityNode.parse((String)map.get(entityId)));
            }
        }
        return new ArrayList<EntityNode>(entitys.values());
    }

    public List<GOTEntity> getGOTEntityList(EntityType entityType) {
        List<EntityNode> entityLists = this.getServiceEntitys(entityType, false);
        Map<String, GOTEntity> entitys = entityLists.stream().collect(Collectors.toMap(e -> e.getId(), e -> GOTEntity.parse(e.toString())));
        Map<String, String> map = this.gotMap.get(entityType);
        if (map != null) {
            for (String entityId : map.keySet()) {
                entitys.put(entityId, GOTEntity.parse(map.get(entityId)));
            }
        }
        return new ArrayList<GOTEntity>(entitys.values());
    }

    public boolean ifInUnsaveMap(String entityId) {
        EntityType entityType = this.getEntityTypeById(entityId);
        Map<String, String> map = this.gotMap.get(entityType);
        return map != null && map.containsKey(entityId);
    }

    public List<EntityNode> getUnsaveEntitys() {
        return this.gotMap.values().stream().flatMap(map -> map.values().stream()).map(e -> EntityNode.parse((String)e)).filter(e -> e != null).collect(Collectors.toList());
    }

    public void saveEntity(String entityId) {
        EntityType entityType = this.getEntityTypeById(entityId);
        Map<String, String> temps = this.gotMap.get(entityType);
        temps.remove(entityId);
        this.gotMap.put(entityType, temps);
    }

    public Element getCurrentElements(String entityType) {
        if (entityType.equals("Enums")) {
            Element root = GOTXMLHelper.createElement("Enums");
            this.addNode(root, EntityType.Enum);
            return root;
        }
        if (entityType.equals("Tables")) {
            Element root = GOTXMLHelper.createElement("Tables");
            this.addNode(root, EntityType.Table);
            return root;
        }
        if (entityType.equals("DataTypes")) {
            Element root = GOTXMLHelper.createElement("DataTypes");
            this.addNode(root, EntityType.DataType);
            return root;
        }
        if (entityType.equals("Menus")) {
            Element root = GOTXMLHelper.createElement("Menus");
            this.addNode(root, EntityType.Menu);
            return root;
        }
        if (entityType.equals("MenuItems")) {
            Element root = GOTXMLHelper.createElement("MenuItems");
            this.addNode(root, EntityType.MenuItem);
            return root;
        }
        if (entityType.equals("Forms")) {
            Element root = GOTXMLHelper.createElement("Forms");
            this.addNode(root, EntityType.Form);
            return root;
        }
        if (entityType.equals("Reports")) {
            Element root = GOTXMLHelper.createElement("Reports");
            this.addNode(root, EntityType.Report);
            return root;
        }
        if (entityType.equals("Classs") || entityType.equals("Classes")) {
            Element root = GOTXMLHelper.createElement("Classes");
            this.addNode(root, EntityType.Class);
            return root;
        }
        return null;
    }

    private void addNode(Element node, EntityType entityType) {
        List<EntityNode> entityList = this.getEntityList(entityType);
        for (EntityNode entity : entityList) {
            node.add(entity.toElement());
        }
    }
}

