/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.ui;

import gongqi.gdt.designer.utils.SWTUtils;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class NodeRelationErrorDialog {
    private Shell shell;
    private String title;
    private List<Map<String, String>> errorInfos;

    public NodeRelationErrorDialog(String title, List<Map<String, String>> errorInfos) {
        this.errorInfos = errorInfos;
        this.title = title;
    }

    private void createContent() {
        Display display = Display.getCurrent();
        this.shell = new Shell(display.getActiveShell(), 208);
        this.shell.setText(this.title);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(SWTUtils.zoom(800), SWTUtils.zoom(400));
        Rectangle bounds = Display.getDefault().getPrimaryMonitor().getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        Table detailTable = new Table((Composite)this.shell, 67588);
        detailTable.setHeaderVisible(true);
        detailTable.setLinesVisible(true);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        formData.bottom = new FormAttachment(100, -5);
        detailTable.setLayoutData((Object)formData);
        TableColumn entityColumn = new TableColumn(detailTable, 16384, 0);
        entityColumn.setText("\u5b9e\u4f53");
        entityColumn.setWidth(SWTUtils.zoom(230));
        TableColumn innerColumn = new TableColumn(detailTable, 16384, 1);
        innerColumn.setText("\u5185\u90e8\u8282\u70b9");
        innerColumn.setWidth(SWTUtils.zoom(230));
        TableColumn propertyColumn = new TableColumn(detailTable, 16384, 2);
        propertyColumn.setText("\u5c5e\u6027");
        propertyColumn.setWidth(SWTUtils.zoom(80));
        TableColumn descriptionColumn = new TableColumn(detailTable, 16384, 3);
        descriptionColumn.setText("\u63cf\u8ff0");
        descriptionColumn.setWidth(SWTUtils.zoom(220));
        for (Map<String, String> errorInfo : this.errorInfos) {
            String entity = errorInfo.get("entity");
            String inner = errorInfo.get("inner");
            String property = errorInfo.get("property");
            String description = errorInfo.get("description");
            TableItem item = new TableItem(detailTable, 0);
            item.setText(new String[]{entity, inner, property, description});
        }
    }

    public void open() {
        this.createContent();
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

